/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;

public class PmmPriceAuditDenyOp
extends AbstractOperationServicePlugIn {
    private static final String ENTRYENTITY = "entryentity";

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Date currDate = TimeServiceHelper.now();
        String confirm = "disagree";
        ArrayList<Long> allBillid = new ArrayList<Long>(16);
        for (DynamicObject item : e.getDataEntities()) {
            allBillid.add(item.getLong("id"));
        }
        this.updatePrice(confirm, allBillid, currDate);
    }

    private void updatePrice(String confirm, List<Long> allBillid, Date currDate) {
        OperationResult saveResult;
        DynamicObject[] bills;
        HashMap<String, DynamicObject> prodAuditMap = new HashMap<String, DynamicObject>();
        ArrayList<Object> prodList = new ArrayList<Object>(16);
        QFilter billidFilter = new QFilter("id", "in", allBillid);
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"pmm_priceaudit", (String)"id,billno,billstatus,suggestion,cfmstatus,cfmdate,cfm,entryentity.goods,entryentity.class,entryentity.shopprice,entryentity.taxprice,entryentity.price,entryentity.taxrate", (QFilter[])new QFilter[]{billidFilter})) {
            DynamicObject[] entries = bill.getDynamicObjectCollection(ENTRYENTITY);
            bill.set("cfm", (Object)RequestContext.get().getUserId());
            bill.set("cfmdate", (Object)currDate);
            bill.set("cfmstatus", (Object)"B");
            if (confirm.equals("agree")) {
                bill.set("cfmstatus", (Object)"B");
            } else if (confirm.equals("back")) {
                bill.set("cfmstatus", (Object)"D");
                bill.set("billstatus", (Object)"A");
            } else if (confirm.equals("disagree")) {
                bill.set("cfmstatus", (Object)"D");
            }
            for (DynamicObject entry : entries) {
                prodList.add(entry.getDynamicObject("goods").getPkValue());
                prodAuditMap.put(entry.getDynamicObject("goods").getString("number"), entry);
            }
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
        QFilter fileter = new QFilter("id", "in", prodList);
        QFilter[] filters = new QFilter[]{fileter};
        DynamicObject[] goodObjs = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)selectFields, (QFilter[])filters);
        if (goodObjs.length < 1) {
            return;
        }
        if (confirm.equals("agree")) {
            for (DynamicObject good : goodObjs) {
                good.set("taxprice", ((DynamicObject)prodAuditMap.get(good.getString("number"))).get("taxprice"));
                good.set("price", ((DynamicObject)prodAuditMap.get(good.getString("number"))).get("price"));
                good.set("shopprice", ((DynamicObject)prodAuditMap.get(good.getString("number"))).get("shopprice"));
                good.set("adjustdate", (Object)currDate);
                good.set("taxrate", ((DynamicObject)prodAuditMap.get(good.getString("number"))).get("taxrate"));
            }
        }
        if ((saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"pmm_prodmanage", (DynamicObject[])goodObjs, (OperateOption)OperateOption.create())).isSuccess()) {
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"save", (String)"pmm_priceaudit", (DynamicObject[])bills, (OperateOption)OperateOption.create());
        }
    }
}

