/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.pmm.opplugin.validator.PmmPriceReqSubmitValidator;

public class PmmPriceRequestSubmitPlugin
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        if (objs.length == 0) {
            return;
        }
        if ("submit".equalsIgnoreCase(key)) {
            for (DynamicObject obj : objs) {
                this.updatePriceChange(obj);
                Long id = obj.getLong("id");
                if (id != 0L) continue;
                objs[0].set("cfmstatus", (Object)"A");
                return;
            }
        }
    }

    public void setCfmstatus(String entMetaDataConStant, List ids) {
        DynamicObject[] sups;
        QFilter filter = new QFilter("id", "in", (Object)ids);
        QFilter[] filters = new QFilter[]{filter};
        for (DynamicObject sup : sups = BusinessDataServiceHelper.load((String)entMetaDataConStant, (String)"cfmstatus", (QFilter[])filters)) {
            sup.set("cfmstatus", (Object)"A");
        }
        SaveServiceHelper.save((DynamicObject[])sups);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PmmPriceReqSubmitValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("goods");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("number");
    }

    private void updatePriceChange(DynamicObject obj) {
        DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject entry = (DynamicObject)col.get(i);
            DynamicObject prod = entry.getDynamicObject("goods");
            BigDecimal oldtaxprice = entry.getBigDecimal("taxprice_old");
            BigDecimal oldprice = entry.getBigDecimal("price_old");
            QFilter prodid = new QFilter("id", "=", prod.getPkValue());
            DynamicObject prodmanage = BusinessDataServiceHelper.loadSingle((String)"ent_prodmanage", (String)"id,taxprice,price,shopprice,taxrate", (QFilter[])new QFilter[]{prodid});
            if (oldtaxprice.compareTo(prodmanage.getBigDecimal("taxprice")) == 0 && oldprice.compareTo(prodmanage.getBigDecimal("price")) == 0) continue;
            entry.set("taxprice_old", (Object)prodmanage.getBigDecimal("taxprice"));
            entry.set("price_old", (Object)prodmanage.getBigDecimal("price"));
            entry.set("shopprice_old", (Object)prodmanage.getBigDecimal("shopprice"));
            entry.set("taxrate", (Object)prodmanage.getBigDecimal("taxrate"));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
            Object id = e.getDataEntities()[0].get("id");
            WorkflowServiceHelper.tryTriggerProcess((String)id.toString(), (String)"submit", (String)"pmm_priceaudit", null);
        }
        DynamicObject[] objs = e.getDataEntities();
        ArrayList<Long> ids = new ArrayList<Long>((int)((double)objs.length / 0.75));
        for (DynamicObject obj : objs) {
            this.updatePriceChange(obj);
            long id = obj.getLong("id");
            if (id == 0L) {
                objs[0].set("cfmstatus", (Object)"A");
                return;
            }
            ids.add(id);
        }
        this.setCfmstatus("ent_pricerequest", ids);
    }
}

