/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.pmm.business.model.product.ProdMatMapping;
import kd.scm.pmm.business.service.impl.ProdMatMappingServiceImpl;
import kd.scm.pmm.business.service.impl.ProdPoolCommandServiceImpl;

public class PmmProAuditAcceptOp
extends AbstractOperationServicePlugIn {
    private static final String ENTRYENTITY = "entryentity";

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills;
        Date currDate = TimeServiceHelper.now();
        ArrayList<Object> prodList = new ArrayList<Object>(16);
        ArrayList<Long> allBillid = new ArrayList<Long>(16);
        for (DynamicObject item : e.getDataEntities()) {
            allBillid.add(item.getLong("id"));
        }
        QFilter billidFilter = new QFilter("id", "in", allBillid);
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"pmm_prodaudit", (String)"id,billno,biztype,billstatus,cfmstatus,cfm,cfmdate,suggestion,entryentity.goods,entryentity.material,entryentity.class,entryentity.shopprice,entryentity.taxprice,entryentity.price,entryentity.entryresult,entryentity.note", (QFilter[])new QFilter[]{billidFilter})) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(ENTRYENTITY);
            int agreeNum = 0;
            for (DynamicObject entry : entries) {
                if ("1".equals(entry.getString("entryresult"))) {
                    ++agreeNum;
                }
                if (entry.getDynamicObject("goods") == null) continue;
                Object goodid = entry.getDynamicObject("goods").getPkValue();
                prodList.add(goodid);
            }
            if (agreeNum == entries.size()) {
                bill.set("cfmstatus", (Object)"B");
            } else if (agreeNum > 0) {
                bill.set("cfmstatus", (Object)"C");
            } else {
                bill.set("cfmstatus", (Object)"D");
            }
            bill.set("cfm", (Object)RequestContext.get().getUserId());
            bill.set("cfmdate", (Object)currDate);
        }
        QFilter fileter = new QFilter("id", "in", prodList);
        QFilter[] filters = new QFilter[]{fileter};
        DynamicObjectCollection goodObjs = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number", (QFilter[])filters);
        if (goodObjs.size() < 1) {
            return;
        }
        if (this.checkHasSameNumber(goodObjs)) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])bills);
        this.updateProdInfo(bills);
        ProdPoolCommandServiceImpl prodPoolCommandService = new ProdPoolCommandServiceImpl();
        prodPoolCommandService.prodAuditCfm(allBillid);
    }

    private boolean checkHasSameNumber(DynamicObjectCollection goodObjs) {
        Set numbers = goodObjs.stream().map(goodObj -> goodObj.getString("number")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("number", "in", numbers);
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number", (QFilter[])qFilter.toArray());
        HashSet<String> numberAccount = new HashSet<String>(prods.size());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject prod : prods) {
            if (numberAccount.contains(prod.getString("number"))) {
                String message = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5728\u5546\u54c1\u7ba1\u7406\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PmmProAuditAcceptOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                if (MalOrderUtil.getDefaultMalVersion()) {
                    message = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5728\u81ea\u5efa\u5546\u54c1\u6c60\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PmmProAuditAcceptOp_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                }
                sb.append(String.format(message, prod.getString("number")));
                continue;
            }
            numberAccount.add(prod.getString("number"));
        }
        if (sb.length() > 0) {
            throw new KDBizException(sb.toString());
        }
        return false;
    }

    private void updateProdInfo(DynamicObject[] bills) {
        HashMap<Long, Long> prodIdAndCategoryIdMap = new HashMap<Long, Long>();
        HashMap<Long, Long> prodIdAndMaterialIdMap = new HashMap<Long, Long>();
        HashSet<ProdMatMapping> newProdMatMappingSet = new HashSet<ProdMatMapping>();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject entry : entryEntity) {
                DynamicObject goods = entry.getDynamicObject("goods");
                if (goods == null || !"1".equals(entry.getString("entryresult"))) continue;
                prodIdAndCategoryIdMap.put(goods.getLong("id"), entry.getDynamicObject("class").getLong("id"));
                if (entry.getDynamicObject("material") == null) continue;
                prodIdAndMaterialIdMap.put(goods.getLong("id"), entry.getDynamicObject("material").getLong("id"));
                newProdMatMappingSet.add(new ProdMatMapping(Long.valueOf(goods.getLong("id")), Long.valueOf(entry.getDynamicObject("material").getLong("id"))));
            }
        }
        ProdMatMappingServiceImpl prodMatMappingService = new ProdMatMappingServiceImpl();
        Set prodMatMappings = prodMatMappingService.queryProdsByMatId(prodIdAndCategoryIdMap.keySet());
        newProdMatMappingSet.removeAll(prodMatMappings);
        prodMatMappingService.saveProdMatMapping(newProdMatMappingSet);
        this.updateProdCategory(prodIdAndCategoryIdMap, prodIdAndMaterialIdMap);
    }

    private void updateProdCategory(Map<Long, Long> prodIdAndCategoryIdMap, Map<Long, Long> prodIdAndMaterialIdMap) {
        DynamicObject[] goodObjs;
        if (prodIdAndCategoryIdMap.isEmpty()) {
            return;
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
        QFilter fileter = new QFilter("id", "in", prodIdAndCategoryIdMap.keySet());
        QFilter[] filters = new QFilter[]{fileter};
        for (DynamicObject prod : goodObjs = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)selectFields, (QFilter[])filters)) {
            prod.set("category", (Object)prodIdAndCategoryIdMap.get(prod.getLong("id")));
            if (prodIdAndMaterialIdMap.get(prod.getLong("id")) == null) continue;
            prod.set("materiel", (Object)prodIdAndMaterialIdMap.get(prod.getLong("id")));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodmanage", (DynamicObject[])goodObjs, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            String errorInfoDetails = ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo());
            throw new KDBizException(errorInfoDetails);
        }
    }
}

