/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.malcore.enums.MallStatusEnum;

public class PmmProMatMappingDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PmmProMatMappingDeleteOp.class);
    public static final String GOODS = "goods";
    public static final String CATEGORY = "category";
    public static final String MATERIAL = "material";
    public static final String PRODMATMAPPING = "prodmatmapping";
    public static final String PMM_PRODMATMAPPING = "pmm_prodmatmapping";
    public static final String PRODMATMAPPINGSTATUS = "prodmatmappingstatus";
    public static final String PRODMATMAPPINGTYPE = "prodmatmappingtype";
    public static final String PMM_PRODMANAGE = "pmm_prodmanage";
    private static final long ES_GOODS_ID = 1560871593289408512L;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(GOODS);
        fieldKeys.add(CATEGORY);
        fieldKeys.add(MATERIAL);
        fieldKeys.add("ecgoods");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<Long, DynamicObject> saveDynHashMap = new HashMap<Long, DynamicObject>();
        ArrayList<Long> goodsList = new ArrayList<Long>(dataEntities.length * 2);
        ArrayList<Long> categoryList = new ArrayList<Long>(dataEntities.length * 2);
        HashSet<Long> publishProdIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dynamicObject2 : dataEntities) {
            this.getIdList(goodsList, categoryList, dynamicObject2);
        }
        String properties = "id,prodmatmapping,prodmatmappingstatus,category,prodmatmappingtype";
        DynamicObject[] goodsDyn = BusinessDataServiceHelper.load((String)PMM_PRODMANAGE, (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "in", goodsList)});
        DynamicObject[] categoriesDyn = BusinessDataServiceHelper.load((String)PMM_PRODMANAGE, (String)properties, (QFilter[])new QFilter[]{new QFilter(CATEGORY, "in", categoryList)});
        this.synGoodsManageMapping(goodsDyn, categoriesDyn, saveDynHashMap, publishProdIds);
        Collection<DynamicObject> values = saveDynHashMap.values();
        int size = values.size();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(values);
        DynamicObject[] saveDyn = dynamicObjects.toArray(new DynamicObject[size]);
        SaveServiceHelper.update((DynamicObject[])saveDyn);
        QFilter qFilterProdPool = new QFilter(GOODS, "in", publishProdIds);
        qFilterProdPool.and("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal());
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id", (QFilter[])qFilterProdPool.toArray());
        List prodPoolIds = prodPools.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        if (!prodPoolIds.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"soldpublish", (String)"pmm_prodpool", (Object[])prodPoolIds.toArray(), (OperateOption)option));
        }
    }

    private void getIdList(List<Long> goodsList, List<Long> categoryList, DynamicObject dynamicObject) {
        DynamicObject good = dynamicObject.getDynamicObject(GOODS);
        DynamicObject category = dynamicObject.getDynamicObject(CATEGORY);
        if (good != null) {
            goodsList.add((Long)good.getPkValue());
        } else if (category != null) {
            categoryList.add((Long)category.getPkValue());
        }
    }

    private void synGoodsManageMapping(DynamicObject[] goodsDyn, DynamicObject[] categoriesDyn, Map<Long, DynamicObject> saveDynHashMap, Set<Long> publishProdIds) {
        if (categoriesDyn != null && categoriesDyn.length > 0) {
            for (DynamicObject dynamicObject : categoriesDyn) {
                this.synGoodsSortManageMapping(dynamicObject, saveDynHashMap, publishProdIds);
            }
        }
        if (goodsDyn != null) {
            DynamicObjectCollection categoryMapping;
            ArrayList<Long> categoryMappingList = new ArrayList<Long>(goodsDyn.length * 2);
            HashMap<Long, List> categoryGoodMap = new HashMap<Long, List>(goodsDyn.length * 2);
            for (DynamicObject good : goodsDyn) {
                if (saveDynHashMap.containsKey((Long)good.getPkValue())) {
                    this.cleanProdMapping(good, saveDynHashMap, publishProdIds);
                    continue;
                }
                DynamicObject category = good.getDynamicObject(CATEGORY);
                if (category == null) continue;
                Long categoryId = (Long)category.getPkValue();
                categoryMappingList.add(categoryId);
                List goodsList = categoryGoodMap.computeIfAbsent(categoryId, k -> new ArrayList());
                goodsList.add(good);
            }
            if (!categoryMappingList.isEmpty() && (categoryMapping = QueryServiceHelper.query((String)PMM_PRODMATMAPPING, (String)"id,category", (QFilter[])new QFilter[]{new QFilter(CATEGORY, "in", categoryMappingList)})) != null) {
                for (DynamicObject category : categoryMapping) {
                    List goodsList = (List)categoryGoodMap.get(category.getLong(CATEGORY));
                    for (DynamicObject goods : goodsList) {
                        goods.set(PRODMATMAPPING, (Object)category.getLong("id"));
                        goods.set(PRODMATMAPPINGTYPE, (Object)CATEGORY);
                        saveDynHashMap.put(goods.getLong("id"), goods);
                        publishProdIds.add(goods.getLong("id"));
                    }
                    categoryGoodMap.remove(category.getLong(CATEGORY));
                }
            }
            if (categoryGoodMap.size() > 0) {
                for (Map.Entry entry : categoryGoodMap.entrySet()) {
                    List dynamicObjectList = (List)entry.getValue();
                    for (DynamicObject dynamicObject : dynamicObjectList) {
                        this.cleanProdMapping(dynamicObject, saveDynHashMap, publishProdIds);
                    }
                }
            }
        }
    }

    private void synGoodsSortManageMapping(DynamicObject prodmanageDyn, Map<Long, DynamicObject> saveDynHashMap, Set<Long> publishProdIds) {
        Long dynId = (Long)prodmanageDyn.getPkValue();
        String prodmatmappingtype = prodmanageDyn.getString(PRODMATMAPPINGTYPE);
        if ("prod".equals(prodmatmappingtype)) {
            saveDynHashMap.put(dynId, prodmanageDyn);
            return;
        }
        this.cleanProdMapping(prodmanageDyn, saveDynHashMap, publishProdIds);
    }

    private void cleanProdMapping(DynamicObject dynamicObject, Map<Long, DynamicObject> saveDynHashMap, Set<Long> publishProdIds) {
        dynamicObject.set(PRODMATMAPPING, (Object)0L);
        dynamicObject.set(PRODMATMAPPINGSTATUS, (Object)"0");
        dynamicObject.set(PRODMATMAPPINGTYPE, (Object)"");
        saveDynHashMap.put((Long)dynamicObject.getPkValue(), dynamicObject);
        publishProdIds.add(dynamicObject.getLong("id"));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.clearEcGoodsByMapping(e);
    }

    private void clearEcGoodsByMapping(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> removeMappingIds = new HashSet<Long>(16);
        for (DynamicObject info : dataEntities) {
            removeMappingIds.add(info.getLong("id"));
        }
        if (removeMappingIds.size() > 0) {
            DynamicObject[] pmm_mallgoods;
            QFilter qFilter = new QFilter(PRODMATMAPPING, "in", removeMappingIds);
            for (DynamicObject info : pmm_mallgoods = BusinessDataServiceHelper.load((String)"pmm_mallgoods", (String)"prodmatmapping,material,id", (QFilter[])qFilter.toArray())) {
                info.set("prodmatmapping_id", null);
                info.set("material_id", null);
            }
            if (pmm_mallgoods.length > 0) {
                SaveServiceHelper.save((DynamicObject[])pmm_mallgoods);
            }
        }
    }
}

