/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.pmm.opplugin.validator.PmmProMatMappingSaveValidator;

public class PmmProMatMappingSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog((String)PmmProMatMappingSaveOp.class.getName());
    public static final String GOODS = "goods";
    public static final String CATEGORY = "category";
    public static final String MATERIAL = "material";
    public static final String PRODMATMAPPING = "prodmatmapping";
    public static final String PMM_PRODMATMAPPING = "pmm_prodmatmapping";
    public static final String PMM_PRODMANAGE = "pmm_prodmanage";
    public static final String PRODMATMAPPINGSTATUS = "prodmatmappingstatus";
    public static final String PRODMATMAPPINGTYPE = "prodmatmappingtype";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(GOODS);
        fieldKeys.add(CATEGORY);
        fieldKeys.add(MATERIAL);
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("material.id");
        fieldKeys.add("material.number");
        fieldKeys.add("material.name");
        fieldKeys.add("platform");
        fieldKeys.add("ecgoods.source");
        fieldKeys.add("goods.source");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PmmProMatMappingSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        HashSet<Long> ecGoodsIds = new HashSet<Long>(e.getDataEntities().length);
        for (DynamicObject dyn : e.getDataEntities()) {
            long l = dyn.getLong("ecgoods_id");
            if (l != 0L) {
                ecGoodsIds.add(l);
            }
            long goodsId = dyn.getLong("goods_id");
            if (l != 0L || goodsId != 0L) continue;
            dyn.set("platform", (Object)"");
        }
        if (!ecGoodsIds.isEmpty()) {
            ArrayList<Object> allEcGoodsDyns = new ArrayList<Object>(e.getDataEntities().length);
            Map ecGoodsDynsHasSyncMap = BusinessDataServiceHelper.loadFromCache((Object[])ecGoodsIds.toArray(), (String)PMM_PRODMANAGE);
            allEcGoodsDyns.addAll(ecGoodsDynsHasSyncMap.values());
            DynamicObject[] goodsDynsJustSync = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"MallGoodsService", (String)"syncEcGoodsToGoodsManageWithResult", (Object[])new Object[]{ecGoodsIds});
            allEcGoodsDyns.addAll(Arrays.asList(goodsDynsJustSync));
            for (DynamicObject dynamicObject : allEcGoodsDyns) {
                for (DynamicObject dyn : e.getDataEntities()) {
                    if (dyn.getLong("ecgoods_id") != dynamicObject.getLong("id")) continue;
                    dyn.set(GOODS, (Object)dynamicObject);
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        long currentUserId = UserServiceHelper.getCurrentUserId();
        Date now = TimeServiceHelper.now();
        HashMap<Long, Long> prodAndMatMappingMap = new HashMap<Long, Long>(1024);
        HashMap<Long, Long> categoryAndMatMap = new HashMap<Long, Long>(1024);
        HashMap<Long, DynamicObject> idAndDynMap = new HashMap<Long, DynamicObject>(dataEntities.length);
        for (DynamicObject dynamicObject2 : dataEntities) {
            idAndDynMap.put(dynamicObject2.getLong("id"), dynamicObject2);
            dynamicObject2.set("modifier", (Object)currentUserId);
            dynamicObject2.set("modifytime", (Object)now);
        }
        String properties = "id,goods,category,material";
        DynamicObjectCollection oldDyns = QueryServiceHelper.query((String)PMM_PRODMATMAPPING, (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "in", idAndDynMap.keySet())});
        Map<Long, DynamicObject> oldId2MappingDynMap = oldDyns.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
        for (Map.Entry entry : idAndDynMap.entrySet()) {
            this.getMappingChange((DynamicObject)entry.getValue(), oldId2MappingDynMap.get(entry.getKey()), categoryAndMatMap, prodAndMatMappingMap);
        }
        QFilter qFilter = new QFilter(CATEGORY, "in", categoryAndMatMap.keySet());
        qFilter.or("id", "in", prodAndMatMappingMap.keySet());
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)PMM_PRODMANAGE, (String)"id,materiel,materiel.id,materiel.number,materiel.name,source,category,prodmatmapping,prodmatmappingstatus,prodmatmappingtype", (QFilter[])qFilter.toArray());
        HashMap<Long, List> categoryAndProdsMap = new HashMap<Long, List>(dynamicObjectArray.length);
        HashSet<Long> publishProdIds = new HashSet<Long>(dynamicObjectArray.length);
        for (DynamicObject prod : dynamicObjectArray) {
            long newMaterialId;
            DynamicObject mapping;
            long prodId = prod.getLong("id");
            long categoryId = prod.getLong("category_id");
            long oldMatMaterialId = 0L;
            if (prod.getDynamicObject(PRODMATMAPPING) != null) {
                oldMatMaterialId = prod.getDynamicObject(PRODMATMAPPING).getLong("materielfield_id");
            }
            if (!(prodAndMatMappingMap.get(prodId) != null && (Long)prodAndMatMappingMap.get(prodId) != 0L || categoryAndMatMap.get(categoryId) != null && (Long)categoryAndMatMap.get(categoryId) != 0L)) {
                if (!"prod".equals(prod.getString(PRODMATMAPPINGTYPE))) {
                    prod.set(PRODMATMAPPING, (Object)0L);
                    prod.set(PRODMATMAPPINGSTATUS, (Object)"0");
                    prod.set(PRODMATMAPPINGTYPE, (Object)"");
                    publishProdIds.add(prod.getLong("id"));
                }
                if (prodAndMatMappingMap.get(prodId) == null || (Long)prodAndMatMappingMap.get(prodId) != 0L || categoryAndMatMap.get(categoryId) != null) continue;
                List updateProds = categoryAndProdsMap.computeIfAbsent(prod.getLong("category_id"), k -> new ArrayList());
                updateProds.add(prod);
                continue;
            }
            if (prodAndMatMappingMap.get(prodId) != null && (Long)prodAndMatMappingMap.get(prodId) != 0L) {
                mapping = (DynamicObject)idAndDynMap.get(prodAndMatMappingMap.get(prodId));
                newMaterialId = mapping.getLong("material_id");
                if (oldMatMaterialId != newMaterialId) {
                    publishProdIds.add(prod.getLong("id"));
                }
                prod.set(PRODMATMAPPING, prodAndMatMappingMap.get(prodId));
                prod.set(PRODMATMAPPINGSTATUS, (Object)"1");
                prod.set(PRODMATMAPPINGTYPE, (Object)"prod");
                prod.set("materiel", (Object)newMaterialId);
                mapping.set("platform", (Object)prod.getString("source"));
                continue;
            }
            if ("prod".equals(prod.getString(PRODMATMAPPINGTYPE))) continue;
            mapping = (DynamicObject)idAndDynMap.get(categoryAndMatMap.get(categoryId));
            newMaterialId = mapping.getLong("material_id");
            if (prod.getDynamicObject(PRODMATMAPPING) != null && prod.getDynamicObject(PRODMATMAPPING).getLong("materielfield_id") != newMaterialId) {
                publishProdIds.add(prod.getLong("id"));
            }
            prod.set(PRODMATMAPPING, categoryAndMatMap.get(categoryId));
            prod.set(PRODMATMAPPINGSTATUS, (Object)"1");
            prod.set(PRODMATMAPPINGTYPE, (Object)CATEGORY);
        }
        if (!categoryAndProdsMap.isEmpty()) {
            QFilter categoryQFilter = new QFilter(CATEGORY, "in", categoryAndProdsMap.keySet());
            DynamicObjectCollection categoryMappings = QueryServiceHelper.query((String)PMM_PRODMATMAPPING, (String)properties, (QFilter[])categoryQFilter.toArray());
            for (DynamicObject categoryMapping : categoryMappings) {
                List updateProds = (List)categoryAndProdsMap.get(categoryMapping.getLong(CATEGORY));
                for (DynamicObject prod : updateProds) {
                    long newMaterialId = categoryMapping.getLong(MATERIAL);
                    if (prod.getDynamicObject(PRODMATMAPPING) != null && prod.getDynamicObject(PRODMATMAPPING).getLong("materielfield_id") != newMaterialId) {
                        publishProdIds.add(prod.getLong("id"));
                    }
                    prod.set(PRODMATMAPPING, categoryMapping.getPkValue());
                    prod.set(PRODMATMAPPINGSTATUS, (Object)"1");
                    prod.set(PRODMATMAPPINGTYPE, (Object)CATEGORY);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
        QFilter qFilterProdPool = new QFilter(GOODS, "in", publishProdIds);
        qFilterProdPool.and("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal());
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id", (QFilter[])qFilterProdPool.toArray());
        List prodPoolIds = prodPools.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        if (!prodPoolIds.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"soldpublish", (String)"pmm_prodpool", (Object[])prodPoolIds.toArray(), (OperateOption)option));
        }
    }

    private void getMappingChange(DynamicObject newDyn, DynamicObject oldDyn, Map<Long, Long> categoryAndMatMap, Map<Long, Long> prodAndMatMappingMap) {
        long oldGoodsId = 0L;
        long oldCategoryId = 0L;
        if (null != oldDyn) {
            oldGoodsId = oldDyn.getLong(GOODS);
            oldCategoryId = oldDyn.getLong(CATEGORY);
        }
        DynamicObject goods = newDyn.getDynamicObject(GOODS);
        DynamicObject category = newDyn.getDynamicObject(CATEGORY);
        if (oldGoodsId != 0L && goods == null) {
            prodAndMatMappingMap.put(oldGoodsId, 0L);
        }
        if (oldCategoryId != 0L && category == null) {
            categoryAndMatMap.put(oldCategoryId, 0L);
        }
        if (goods != null) {
            prodAndMatMappingMap.put(goods.getLong("id"), newDyn.getLong("id"));
        } else if (category != null) {
            categoryAndMatMap.put(category.getLong("id"), newDyn.getLong("id"));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.writeEcGoodsByMapping(e);
    }

    private void writeEcGoodsByMapping(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<Long, String> ecGoodsMap = new HashMap<Long, String>(16);
        HashSet<Long> removeMappingIds = new HashSet<Long>(16);
        for (DynamicObject info : dataEntities) {
            String platform = info.getString("platform");
            long ecgoodsId = info.getLong("ecgoods_id");
            String materialId = info.getString("material_id");
            String id = info.getString("id");
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
                ecGoodsMap.put(ecgoodsId, id + "_" + materialId);
            }
            if (!StringUtils.isEmpty((CharSequence)platform)) continue;
            removeMappingIds.add(info.getLong("id"));
        }
        if (ecGoodsMap.size() > 0 || removeMappingIds.size() > 0) {
            DynamicObject[] pmm_mallgoods;
            QFilter qFilter = new QFilter("id", "in", ecGoodsMap.keySet());
            qFilter.or(new QFilter(PRODMATMAPPING, "in", removeMappingIds));
            for (DynamicObject info : pmm_mallgoods = BusinessDataServiceHelper.load((String)"pmm_mallgoods", (String)"prodmatmapping,material,id", (QFilter[])qFilter.toArray())) {
                long ecGoodsId = info.getLong("id");
                long prodMatMappingId = info.getLong("prodmatmapping.id");
                if (removeMappingIds.contains(prodMatMappingId)) {
                    info.set("prodmatmapping_id", null);
                    info.set("material_id", null);
                    continue;
                }
                if (null == ecGoodsMap.get(ecGoodsId)) continue;
                String[] keys = ((String)ecGoodsMap.get(ecGoodsId)).split("_");
                info.set("prodmatmapping_id", (Object)keys[0]);
                info.set("material_id", (Object)keys[1]);
            }
            if (pmm_mallgoods.length > 0) {
                SaveServiceHelper.save((DynamicObject[])pmm_mallgoods);
            }
        }
    }
}

