/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.malcore.enums.MallStatusEnum;

public class PmmProdPoolAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PmmProdPoolAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("goods.id");
        fieldKeys.add("protocol.id");
        fieldKeys.add("mallstatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.addProdEntry(dataEntities);
    }

    private void addProdEntry(DynamicObject[] prodPoolDynArray) {
        OperationResult operationResult;
        HashMap<Long, List> prodIdAndPoolsMap = new HashMap<Long, List>(prodPoolDynArray.length);
        for (DynamicObject prodPoolDyn : prodPoolDynArray) {
            List prodPools = prodIdAndPoolsMap.computeIfAbsent(prodPoolDyn.getLong("goods_id"), k -> new ArrayList(prodPoolDynArray.length));
            prodPools.add(prodPoolDyn);
        }
        DynamicObject[] prodDynArray = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"id,status,isprotocolprod,protocolentry.prodpool,protocolentry.protocol", (QFilter[])new QFilter[]{new QFilter("id", "in", prodIdAndPoolsMap.keySet())});
        ArrayList<Long> deleteProdPoolIdList = new ArrayList<Long>(prodDynArray.length);
        for (DynamicObject prodDyn : prodDynArray) {
            List prodPoolDynList = (List)prodIdAndPoolsMap.get(prodDyn.getLong("id"));
            for (DynamicObject prodPoolDyn : prodPoolDynList) {
                DynamicObjectCollection prodProtocolEntry = prodDyn.getDynamicObjectCollection("protocolentry");
                if (prodPoolDyn.getDynamicObject("protocol") != null && !prodProtocolEntry.isEmpty() && ((DynamicObject)prodProtocolEntry.get(0)).getDynamicObject("protocol") == null) {
                    deleteProdPoolIdList.add(((DynamicObject)prodProtocolEntry.get(0)).getLong("prodpool_id"));
                    prodProtocolEntry.remove(0);
                }
                DynamicObject newProdProtocolEntry = prodProtocolEntry.addNew();
                newProdProtocolEntry.set("prodpool", (Object)prodPoolDyn);
                DynamicObject protocol = prodPoolDyn.getDynamicObject("protocol");
                if (protocol != null) {
                    prodDyn.set("isprotocolprod", (Object)Boolean.TRUE);
                }
                newProdProtocolEntry.set("protocol", (Object)protocol);
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodDynArray);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        if (!deleteProdPoolIdList.isEmpty() && !(operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"pmm_prodpool", (Object[])deleteProdPoolIdList.toArray(), (OperateOption)option)).isSuccess()) {
            logger.warn(ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.uploadedProdSoldPublish(dataEntities);
    }

    private void uploadedProdSoldPublish(DynamicObject[] prodPoolDynArray) {
        ArrayList<Long> prodSoldProdIds = new ArrayList<Long>(prodPoolDynArray.length);
        for (DynamicObject dynamicObject : prodPoolDynArray) {
            String mallStatus = dynamicObject.getString("mallstatus");
            if (!MallStatusEnum.SOLD.getVal().equals(mallStatus)) continue;
            prodSoldProdIds.add(dynamicObject.getLong("id"));
        }
        if (prodSoldProdIds.isEmpty()) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"sold", (String)"pmm_prodpool", (Object[])prodSoldProdIds.toArray(), (OperateOption)option));
    }
}

