/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.enums.SaleStatusEnum;

public class PmmProdPoolSaleStatusSetOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("salestatus");
        fieldKeys.add("isgoodvisible");
        fieldKeys.add("entryentity.orgname");
        fieldKeys.add("protocol");
        fieldKeys.add("protocolentry");
        fieldKeys.add("mallstatus");
        fieldKeys.add("goods");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] prods;
        DynamicObject[] dynamicObjects = e.getDataEntities();
        HashMap<Long, Boolean> protocolIsGoodsVisibleMap = new HashMap<Long, Boolean>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String mallStatus = dynamicObject.getString("mallstatus");
            if (!MallStatusEnum.UNSOLD.getVal().equals(mallStatus) && !MallStatusEnum.SOLD.getVal().equals(mallStatus) || dynamicObject.getDynamicObject("protocol") == null) continue;
            protocolIsGoodsVisibleMap.put(dynamicObject.getDynamicObject("protocol").getLong("id"), Boolean.FALSE);
        }
        DynamicObjectCollection protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)"id,isgoodvisible,entryentity.orgname orgname,differentarea", (QFilter[])new QFilter[]{new QFilter("id", "in", protocolIsGoodsVisibleMap.keySet())});
        HashMap<Long, List> protocolsOrgListMap = new HashMap<Long, List>(protocols.size());
        for (DynamicObject protocol : protocols) {
            if (protocol.getBoolean("differentarea")) continue;
            protocolIsGoodsVisibleMap.put(protocol.getLong("id"), protocol.getBoolean("isgoodvisible"));
            List orgList = protocolsOrgListMap.computeIfAbsent(protocol.getLong("id"), s -> new ArrayList(protocols.size()));
            orgList.add(protocol.getLong("orgname"));
        }
        HashMap<String, List<Long>> protocols_OrgListMap = new HashMap<String, List<Long>>(protocols.size());
        QFilter qFilter = new QFilter("id", "in", protocolIsGoodsVisibleMap.keySet());
        String selectors = "id,entryentity1.id,entryentity1.purplanid.entryentity.org purorg,differentarea";
        DynamicObjectCollection protocolCol = QueryServiceHelper.query((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray());
        for (DynamicObject[] row : protocolCol) {
            String key = row.getString("id") + row.getString("entryentity1.id");
            Long protocolId = row.getLong("id");
            if (null != protocolsOrgListMap.get(protocolId)) {
                protocols_OrgListMap.put(key, (List<Long>)protocolsOrgListMap.get(protocolId));
                continue;
            }
            List<Long> orgIds = new ArrayList<Long>(1024);
            if (null != protocols_OrgListMap.get(key)) {
                orgIds = (List)protocols_OrgListMap.get(key);
            }
            orgIds.add(row.getLong("purorg"));
            protocols_OrgListMap.put(key, orgIds);
        }
        HashSet<Long> prodIds = new HashSet<Long>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String mallStatus = dynamicObject.getString("mallstatus");
            if (!MallStatusEnum.UNSOLD.getVal().equals(mallStatus) && !MallStatusEnum.SOLD.getVal().equals(mallStatus)) continue;
            dynamicObject.set("salestatus", (Object)this.getSaleStatus(dynamicObject, protocolIsGoodsVisibleMap, protocols_OrgListMap));
            DynamicObject goods = dynamicObject.getDynamicObject("goods");
            if (goods == null) continue;
            prodIds.add(goods.getLong("id"));
        }
        Date now = TimeServiceHelper.now();
        qFilter = new QFilter("id", "in", prodIds);
        for (DynamicObject prod : prods = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"uploaddate", (QFilter[])qFilter.toArray())) {
            prod.set("uploaddate", (Object)now);
        }
        SaveServiceHelper.save((DynamicObject[])prods);
    }

    private String getSaleStatus(DynamicObject dynamicObject, Map<Long, Boolean> protocolIsGoodsVisibleMap, Map<String, List<Long>> protocolsOrgListMap) {
        String saleStatus;
        long protocolID;
        boolean isGoodVisible = dynamicObject.getBoolean("isgoodvisible");
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        long l = protocolID = dynamicObject.getDynamicObject("protocol") == null ? 0L : dynamicObject.getDynamicObject("protocol").getLong("id");
        if (isGoodVisible) {
            saleStatus = SaleStatusEnum.SALE.getVal();
        } else if (entryEntity.isEmpty()) {
            saleStatus = SaleStatusEnum.UNSALE.getVal();
        } else if (protocolID == 0L) {
            saleStatus = SaleStatusEnum.PARTSALE.getVal();
        } else {
            Boolean protocolIsGoodVisible = protocolIsGoodsVisibleMap.get(protocolID);
            if (protocolIsGoodVisible.booleanValue()) {
                saleStatus = SaleStatusEnum.PARTSALE.getVal();
            } else {
                String protocolEntryId = dynamicObject.getDynamicObject("protocolentry") == null ? "0" : dynamicObject.getDynamicObject("protocolentry").getString("id");
                String key = dynamicObject.getDynamicObject("protocol").getString("id") + protocolEntryId;
                List<Long> protocolOrgIDSet = protocolsOrgListMap.get(key);
                saleStatus = null != protocolOrgIDSet && entryEntity.size() == protocolOrgIDSet.size() ? SaleStatusEnum.SALE.getVal() : SaleStatusEnum.PARTSALE.getVal();
            }
        }
        return saleStatus;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> prodPoolIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            prodPoolIds.add(dataEntity.getLong("id"));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"soldpublish", (String)"pmm_prodpool", (Object[])prodPoolIds.toArray(), (OperateOption)option));
    }
}

