/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.malcore.enums.MallStatusEnum;

public class PmmProdSpuSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("number");
        filds.add("spuskumapentry");
        filds.add("spuskumapentry.goods");
        filds.add("spuskumapentry.goods.id");
        filds.add("spuskumapentry.skuname");
        filds.add("spuskumapentry.taxprice");
        filds.add("spuskumapentry.taxrateid");
        filds.add("spuskumapentry.taxrateid.taxrate");
        filds.add("spuskumapentry.price");
        filds.add("spuskumapentry.thumbnail");
        filds.add("spuskumapentry.picture1");
        filds.add("spuskumapentry.picture2");
        filds.add("spuskumapentry.picture3");
        filds.add("spuskumapentry.picture4");
        filds.add("spuskumapentry.content");
        filds.add("spuskumapentry.specification");
        filds.add("spuskumapentry.packinglist");
        filds.add("spuskumapentry.guarantee");
        filds.add("spuskumapentry.content_tag");
        filds.add("spuskumapentry.specification_tag");
        filds.add("spuskumapentry.packinglist_tag");
        filds.add("spuskumapentry.guarantee_tag");
        filds.add("spuskumapentry.spuatrdetailentry.id");
        filds.add("spuskumapentry.spuatrdetailentry.saleprodattributeid.id");
        filds.add("spuskumapentry.spuatrdetailentry.saleprodattributeid.number");
        filds.add("spuskumapentry.spuatrdetailentry.saleprodattributevalueid.id");
        filds.add("spuskumapentry.spuatrdetailentry.saleprodattributevalueid.number");
        filds.add("spuskumapentry.seq");
        filds.add("spuskumapentry.skunumber");
        filds.add("baseattributeentry");
        filds.add("baseattributeentry.prodattribute");
        filds.add("baseattributeentry.prodattribute.id");
        filds.add("baseattributeentry.prodattributevalue");
        filds.add("baseattributeentry.prodattributevalue.id");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String source;
        super.endOperationTransaction(e);
        OperateOption option = this.getOption();
        if (option.containsVariable("source") && "pmm_prodmanage".equals(source = option.getVariableValue("source"))) {
            Map<Long, DynamicObject> spuMap = this.getProdSkuMap(e);
            this.writeSkuEntry(e, spuMap);
        }
    }

    private void writeSkuEntry(EndOperationTransactionArgs e, Map<Long, DynamicObject> spuMap) {
        DynamicObject[] pmm_spus;
        OperateOption option = this.getOption();
        String goodsIdstr = option.getVariableValue("goodsId");
        if (StringUtils.isEmpty((CharSequence)goodsIdstr)) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject row : dataEntities) {
            idSet.add(row.getLong("id"));
        }
        QFilter qFilter = new QFilter("id", "in", idSet);
        String selectors = "id,spuskumapentry.seq,spuskumapentry.id,spuskumapentry.skunumber,spuskumapentry.goods,confirmstatus,entryresult";
        for (DynamicObject spu : pmm_spus = BusinessDataServiceHelper.load((String)"pmm_spu", (String)selectors, (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection spuskumapentry = spu.getDynamicObjectCollection("spuskumapentry");
            boolean isExistsGoods = false;
            for (DynamicObject row : spuskumapentry) {
                if (null == row.get("goods")) continue;
                isExistsGoods = true;
                break;
            }
            for (DynamicObject row : spuskumapentry) {
                DynamicObject goods;
                int seq;
                if (!isExistsGoods && (seq = row.getInt("seq")) == 1 && null != (goods = spuMap.get(Long.parseLong(goodsIdstr)))) {
                    row.set("goods", (Object)goods);
                    row.set("skunumber", (Object)goods.getString("number"));
                    row.set("confirmstatus", (Object)"B");
                    row.set("entryresult", (Object)"1");
                    continue;
                }
                long entryId = row.getLong("id");
                DynamicObject goods2 = spuMap.get(entryId);
                if (null == goods2) continue;
                row.set("goods", (Object)goods2);
                row.set("skunumber", (Object)goods2.getString("number"));
                row.set("confirmstatus", (Object)"B");
                row.set("entryresult", (Object)"1");
            }
        }
        if (pmm_spus.length > 0) {
            SaveServiceHelper.save((DynamicObject[])pmm_spus);
        }
    }

    private Map<Long, DynamicObject> getProdSkuMap(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<Long, DynamicObject> spuMap = new HashMap<Long, DynamicObject>(16);
        if (dataEntities.length > 0) {
            DynamicObject dataEntity = dataEntities[0];
            OperateOption option = this.getOption();
            String goodsIdstr = option.getVariableValue("goodsId");
            String operate = option.getVariableValue("operate");
            if (StringUtils.isEmpty((CharSequence)goodsIdstr)) {
                return spuMap;
            }
            HashSet<Long> goodsIdSet = new HashSet<Long>(16);
            long goodsId = Long.parseLong(goodsIdstr);
            goodsIdSet.add(goodsId);
            DynamicObjectCollection spuskumapentry = dataEntity.getDynamicObjectCollection("spuskumapentry");
            for (DynamicObject row : spuskumapentry) {
                if (null == row.get("goods")) continue;
                goodsIdSet.add(row.getLong("goods.id"));
            }
            QFilter qFilter = new QFilter("id", "in", goodsIdSet);
            String selctors = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
            selctors = DynamicObjectUtil.getEntrySelectfields((String)selctors, (String)"pmm_prodmanage", (String)"prodattributeentry", (boolean)false);
            DynamicObject[] pmm_prodmanages = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)selctors, (QFilter[])qFilter.toArray());
            HashMap<Long, DynamicObject> prodMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject row : pmm_prodmanages) {
                prodMap.put(row.getLong("id"), row);
            }
            QFilter qFilter1 = new QFilter("goods.id", "in", prodMap.keySet());
            QFilter malStatusQf = new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal());
            qFilter1.and(malStatusQf);
            DynamicObjectCollection prodpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods.id", (QFilter[])qFilter1.toArray());
            HashSet<Long> soldGoodIds = new HashSet<Long>(16);
            for (DynamicObject row : prodpools) {
                soldGoodIds.add(row.getLong("goods.id"));
            }
            DynamicObject curProdInfo = (DynamicObject)prodMap.get(goodsId);
            if (null == curProdInfo) {
                return spuMap;
            }
            ArrayList<DynamicObject> prodInfos = new ArrayList<DynamicObject>(16);
            Map<Long, Map<Long, Long>> spuAtrMap = this.getSpuAtrMap(spuskumapentry);
            boolean isExistsGoods = false;
            for (DynamicObject row : spuskumapentry) {
                if (null == row.get("goods")) continue;
                isExistsGoods = true;
                break;
            }
            for (DynamicObject row : spuskumapentry) {
                int seq;
                DynamicObject info = null;
                if (!isExistsGoods && 1 == (seq = row.getInt("seq"))) {
                    info = this.updateGoods(curProdInfo, row, curProdInfo, soldGoodIds);
                    this.writeAttrSkuBySpu(row, info, spuAtrMap, dataEntity);
                    info.set("spunumber", (Object)dataEntity.getString("number"));
                    spuMap.put(row.getLong("id"), info);
                    prodInfos.add(info);
                    continue;
                }
                info = null != row.get("goods") ? this.updateGoods((DynamicObject)prodMap.get(row.getLong("goods.id")), row, curProdInfo, soldGoodIds) : this.addGoods(row, curProdInfo);
                this.writeAttrSkuBySpu(row, info, spuAtrMap, dataEntity);
                info.set("spunumber", (Object)dataEntity.getString("number"));
                spuMap.put(row.getLong("id"), info);
                prodInfos.add(info);
            }
            ArrayList<DynamicObject> needSaveSkus = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> needSaveOPSkus = new ArrayList<DynamicObject>(16);
            for (DynamicObject info : prodInfos) {
                if (0L == info.getLong("id") || "A".equals(info.getString("status"))) {
                    needSaveOPSkus.add(info);
                    continue;
                }
                needSaveSkus.add(info);
            }
            if (needSaveSkus.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])needSaveSkus.toArray(new DynamicObject[0]));
            }
            if (needSaveOPSkus.size() > 0) {
                OperateOption prodOp = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                if ("submit".equals(operate)) {
                    try (TXHandle txHandle = TX.requiresNew();){
                        OperationResult submitOperationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"pmm_prodmanage", (DynamicObject[])needSaveOPSkus.toArray(new DynamicObject[0]), (OperateOption)prodOp);
                        if (!submitOperationResult.isSuccess()) {
                            throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)submitOperationResult.getAllErrorOrValidateInfo()));
                        }
                        txHandle.commit();
                    }
                } else {
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodmanage", (DynamicObject[])needSaveOPSkus.toArray(new DynamicObject[0]), (OperateOption)prodOp);
                    if (!operationResult.isSuccess()) {
                        throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
                    }
                }
            }
        }
        return spuMap;
    }

    private Map<Long, Map<Long, Long>> getSpuAtrMap(DynamicObjectCollection spuskumapentry) {
        HashSet<Long> spuAtrEntryIds = new HashSet<Long>(16);
        for (DynamicObject row : spuskumapentry) {
            DynamicObjectCollection spuatrdetailentry = row.getDynamicObjectCollection("spuatrdetailentry");
            for (DynamicObject attrRow : spuatrdetailentry) {
                spuAtrEntryIds.add(attrRow.getLong("id"));
            }
        }
        QFilter atrQf = new QFilter("spuskumapentry.spuatrdetailentry.id", "in", spuAtrEntryIds);
        String atrSelectors = "spuskumapentry.spuatrdetailentry.id,spuskumapentry.spuatrdetailentry.saleprodattributeid.id saleprodattributeid,spuskumapentry.spuatrdetailentry.saleprodattributevalueid.id saleprodattributevalueid";
        DynamicObjectCollection pmmSpus = QueryServiceHelper.query((String)"pmm_spu", (String)atrSelectors, (QFilter[])atrQf.toArray());
        HashMap<Long, Map<Long, Long>> spuAtrMap = new HashMap<Long, Map<Long, Long>>(16);
        for (DynamicObject spu : pmmSpus) {
            long entryId = spu.getLong("spuskumapentry.spuatrdetailentry.id");
            HashMap<Long, Long> map = new HashMap<Long, Long>(16);
            map.put(spu.getLong("saleprodattributeid"), spu.getLong("saleprodattributevalueid"));
            spuAtrMap.put(entryId, map);
        }
        return spuAtrMap;
    }

    private void writeAttrSkuBySpu(DynamicObject row, DynamicObject info, Map<Long, Map<Long, Long>> spuAtrMap, DynamicObject spuInfo) {
        DynamicObject prodAttr;
        DynamicObjectCollection spuatrdetailentry = row.getDynamicObjectCollection("spuatrdetailentry");
        DynamicObjectCollection prodattributeentry = info.getDynamicObjectCollection("prodattributeentry");
        prodattributeentry.clear();
        int seq = 1;
        DynamicObjectCollection baseattributeentry = spuInfo.getDynamicObjectCollection("baseattributeentry");
        for (DynamicObject baseRow : baseattributeentry) {
            prodAttr = prodattributeentry.addNew();
            prodAttr.set("prodattribute_id", (Object)baseRow.getLong("prodattribute.id"));
            prodAttr.set("prodattributevalue_id", (Object)baseRow.getLong("prodattributevalue.id"));
            prodAttr.set("seq", (Object)seq);
            ++seq;
        }
        for (DynamicObject attrRow : spuatrdetailentry) {
            if (null == spuAtrMap.get(attrRow.getLong("id"))) continue;
            prodAttr = prodattributeentry.addNew();
            Map<Long, Long> atrMap = spuAtrMap.get(attrRow.getLong("id"));
            for (Map.Entry<Long, Long> map : atrMap.entrySet()) {
                prodAttr.set("prodattribute_id", (Object)map.getKey());
                prodAttr.set("prodattributevalue_id", (Object)map.getValue());
                prodAttr.set("seq", (Object)seq);
                ++seq;
            }
        }
    }

    private DynamicObject addGoods(DynamicObject row, DynamicObject curProdInfo) {
        DynamicObject prod = (DynamicObject)OrmUtils.clone((IDataEntityBase)curProdInfo, (boolean)false, (boolean)true);
        prod.getDataEntityType().getProperties();
        Map prodMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)prod);
        List allProdProsList = (List)prodMap.get("allProList");
        Map allSpuProsMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)row);
        List allSpuEntryProsList = (List)allSpuProsMap.get("allProList");
        prod.set("number", null);
        prod.set("barcode", null);
        prod.set("creator", (Object)RequestContext.get().getCurrUserId());
        prod.set("createtime", null);
        prod.set("modifier", null);
        prod.set("modifytime", null);
        prod.set("auditor", null);
        prod.set("auditdate", null);
        for (String pro : allSpuEntryProsList) {
            if ("skunumber".equals(pro)) {
                if (StringUtils.isEmpty((CharSequence)row.getString(pro))) continue;
                prod.set("number", row.get(pro));
            }
            if (!allProdProsList.contains(pro)) continue;
            prod.set(pro, row.get(pro));
        }
        if (null != row.getDynamicObject("taxrateid")) {
            prod.set("taxrate", (Object)row.getBigDecimal("taxrateid.taxrate"));
        }
        prod.set("name", (Object)row.getString("skuname"));
        prod.set("origin", (Object)"2");
        prod.set("status", (Object)"A");
        prod.set("enable", (Object)"1");
        return prod;
    }

    private DynamicObject updateGoods(DynamicObject prod, DynamicObject row, DynamicObject curProdInfo, Set<Long> soldGoodIds) {
        String updatefield;
        OperateOption option;
        prod.set("name", (Object)row.getString("skuname"));
        Map prodMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)prod);
        List allProdProsList = (List)prodMap.get("allProList");
        Map allSpuProsMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)row);
        List allSpuEntryProsList = (List)allSpuProsMap.get("allProList");
        for (String pro : allSpuEntryProsList) {
            if ("skunumber".equals(pro) && StringUtils.isEmpty((CharSequence)row.getString(pro)) || !allProdProsList.contains(pro)) continue;
            prod.set(pro, row.get(pro));
        }
        if (null != row.getDynamicObject("taxrateid")) {
            prod.set("taxrate", (Object)row.getBigDecimal("taxrateid.taxrate"));
        }
        if ((option = this.getOption()).containsVariable("updatefield") && "all".equals(updatefield = option.getVariableValue("updatefield")) && !soldGoodIds.contains(prod.getLong("id"))) {
            prod.set("unit", curProdInfo.get("unit"));
            prod.set("brand", curProdInfo.get("brand"));
            prod.set("keyword", curProdInfo.get("keyword"));
            prod.set("materiel", curProdInfo.get("materiel"));
            prod.set("asstunit", curProdInfo.get("asstunit"));
        }
        return prod;
    }
}

