/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;

public class PmmProtocolAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog((String)PmmProtocolAuditOp.class.getName());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("issrm");
        e.getFieldKeys().add("protocolstatus");
        e.getFieldKeys().add("confirmstatus");
        e.getFieldKeys().add("partyb");
        e.getFieldKeys().add("partyb.bizpartner");
        e.getFieldKeys().add("partyb.group");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("entryentity.orgname");
        e.getFieldKeys().add("purmode");
        e.getFieldKeys().add("invaliddate");
        e.getFieldKeys().add("effectdate");
        e.getFieldKeys().add("prosource");
        e.getFieldKeys().add("differentarea");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Date now = TimeServiceHelper.now();
        for (DynamicObject obj : dataEntities) {
            obj.set("protocolstatus", (Object)"A");
            Date invaliddate = obj.getDate("invaliddate");
            Date effectdate = obj.getDate("effectdate");
            String prosource = obj.getString("prosource");
            if (!obj.getBoolean("issrm") && ("2".equals(prosource) || effectdate.before(now) && (null == invaliddate || null != invaliddate && DateUtil.string2date((String)DateUtil.getFormatEndDate((Date)invaliddate), (String)"yyyy-MM-dd HH:mm:ss").after(now)))) {
                obj.set("protocolstatus", (Object)"B");
            }
            if (!obj.getBoolean("issrm") && !"2".equals(prosource) && DateUtil.string2date((String)DateUtil.getFormatEndDate((Date)invaliddate), (String)"yyyy-MM-dd HH:mm:ss").before(now)) {
                obj.set("protocolstatus", (Object)"C");
            }
            if (obj.getBoolean("issrm")) {
                obj.set("confirmstatus", (Object)"B");
            } else {
                obj.set("confirmstatus", (Object)"A");
            }
            if (!"1".equals(obj.getString("purmode"))) continue;
            DynamicObjectCollection entryentity = obj.getDynamicObjectCollection("entryentity");
            entryentity.clear();
            obj.set("entryentity", (Object)entryentity);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        HashMap<Long, Long> pro_supMap = new HashMap<Long, Long>(1024);
        HashMap<Long, DynamicObject> pro_orgMap = new HashMap<Long, DynamicObject>(1024);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> supplierIDs = new HashSet<Long>(1024);
        for (DynamicObject info : dataEntities) {
            if (null != info.getDynamicObject("partyb")) {
                supplierIDs.add(info.getDynamicObject("partyb").getLong("id"));
            }
            pro_supMap.put(info.getLong("id"), info.getDynamicObject("partyb").getLong("id"));
            pro_orgMap.put(info.getLong("id"), info.getDynamicObject("org"));
        }
        QFilter qFilter = new QFilter("id", "in", supplierIDs);
        qFilter.and(new QFilter("mallstatus", "!=", (Object)"B"));
        String sectlor = "mallstatus,malldate,bizpartner,group";
        DynamicObject[] malsuppliers = BusinessDataServiceHelper.load((String)"bd_malsupplier", (String)sectlor, (QFilter[])qFilter.toArray());
        Date currDate = TimeServiceHelper.now();
        HashSet<Long> mallstatusSup = new HashSet<Long>(1024);
        HashMap<Long, DynamicObject> supID_DynMap = new HashMap<Long, DynamicObject>(1024);
        for (DynamicObject sup : malsuppliers) {
            sup.set("mallstatus", (Object)"B");
            sup.set("malldate", (Object)currDate);
            mallstatusSup.add(sup.getLong("id"));
            supID_DynMap.put(sup.getLong("id"), sup);
        }
        ArrayList<DynamicObject> proauditCols = new ArrayList<DynamicObject>(1024);
        for (Map.Entry supMap : pro_supMap.entrySet()) {
            Long supplierId = (Long)supMap.getValue();
            Long protocolID = (Long)supMap.getKey();
            if (!mallstatusSup.contains(supplierId)) continue;
            DynamicObject org = (DynamicObject)pro_orgMap.get(protocolID);
            DynamicObject supplier = (DynamicObject)supID_DynMap.get(supplierId);
            DynamicObject dynamicObject = this.setSuprequestData(supplier, org);
            proauditCols.add(dynamicObject);
        }
        if (proauditCols.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ishasright", "true");
            OperationResult saveResullt = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_supplieraudit", (DynamicObject[])proauditCols.toArray(new DynamicObject[0]), (OperateOption)option);
            if (!saveResullt.isSuccess()) {
                String msg = ExceptionUtil.getErrorInfoDetails((List)saveResullt.getAllErrorOrValidateInfo());
                log.error(msg);
            } else if (malsuppliers.length > 0) {
                SaveServiceHelper.save((DynamicObject[])malsuppliers);
            }
        }
        this.createPurplan(dataEntities);
    }

    private void createPurplan(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> needCreateDyn = new ArrayList<DynamicObject>(1024);
        HashSet<Long> protocolIds = new HashSet<Long>(1024);
        for (DynamicObject row : dataEntities) {
            if (row.getBoolean("differentarea")) continue;
            needCreateDyn.add(row);
            protocolIds.add(row.getLong("id"));
        }
        if (protocolIds.size() > 0) {
            log.info("protocolIds=" + SerializationUtils.toJsonString(protocolIds));
            QFilter qFilter = new QFilter("protocol.id", "in", protocolIds);
            DeleteServiceHelper.delete((String)"pmm_purchaseplan", (QFilter[])qFilter.toArray());
        }
        if (needCreateDyn.size() > 0) {
            ArrayList<DynamicObject> needSaveDyn = new ArrayList<DynamicObject>(1024);
            for (DynamicObject info : needCreateDyn) {
                String purmode = info.getString("purmode");
                DynamicObjectCollection entryCol = info.getDynamicObjectCollection("entryentity");
                DynamicObject purPlan = BusinessDataServiceHelper.newDynamicObject((String)"pmm_purchaseplan");
                String name = "";
                if (purmode.equals("1")) {
                    name = ResManager.loadKDString((String)"\u96c6\u56e2\u96c6\u91c7\u65b9\u6848", (String)"PmmProtocolAuditOp_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                }
                if (purmode.equals("2")) {
                    name = ResManager.loadKDString((String)"\u533a\u57df\u96c6\u91c7\u65b9\u6848", (String)"PmmProtocolAuditOp_3", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                }
                if (purmode.equals("3")) {
                    name = ResManager.loadKDString((String)"\u516c\u53f8\u81ea\u91c7\u65b9\u6848", (String)"PmmProtocolAuditOp_4", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                }
                purPlan.set("name", (Object)name);
                purPlan.set("protocol", (Object)info);
                purPlan.set("enable", (Object)"1");
                DynamicObjectCollection purPlacEntrys = purPlan.getDynamicObjectCollection("entryentity");
                purPlacEntrys.clear();
                for (DynamicObject row : entryCol) {
                    Long orgId = row.getLong("orgname.id");
                    DynamicObject entryInfo = purPlacEntrys.addNew();
                    entryInfo.set("org_id", (Object)orgId);
                }
                needSaveDyn.add(purPlan);
            }
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("isStrict", "false");
            saveOption.setVariableValue("ishasright", "true");
            OperationResult saveResullt = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_purchaseplan", (DynamicObject[])needSaveDyn.toArray(new DynamicObject[0]), (OperateOption)saveOption);
            if (!saveResullt.isSuccess()) {
                log.error(ExceptionUtil.getErrorInfoDetails((List)saveResullt.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u91c7\u4e70\u65b9\u6848\u4fdd\u5b58\u5931\u8d25,\u539f\u56e0\uff1a", (String)"PmmProtocolAuditOp_5", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                throw new KDBizException(msg + saveResullt.getMessage());
            }
        }
    }

    private DynamicObject setSuprequestData(DynamicObject supplier, DynamicObject org) {
        DynamicObject supplieraudit = ORM.create().newDynamicObject("pmm_supplieraudit");
        this.setSupDefultValue(supplieraudit, supplier);
        supplieraudit.set("org", (Object)org);
        return supplieraudit;
    }

    private void setSupDefultValue(DynamicObject model, DynamicObject supplier) {
        model.set("supplier", (Object)supplier);
        model.set("biztype", (Object)1);
        model.set("bizpartner", supplier.get("bizpartner"));
        model.set("group", supplier.get("group"));
        model.set("billdate", (Object)TimeServiceHelper.now());
        model.set("reason", (Object)ResManager.loadKDString((String)"\u534f\u8bae\u751f\u6210", (String)"PmmProtocolAuditOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        model.set("origin", (Object)"3");
        model.set("billstatus", (Object)"C");
        model.set("cfmstatus", (Object)"B");
        model.set("suggestion", (Object)ResManager.loadKDString((String)"\u540c\u610f", (String)"PmmProtocolAuditOp_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
    }
}

