/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DateUtil;

public class PmmProtocolEffectOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("invaliddate");
        e.getFieldKeys().add("effectdate");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] pmm_protocols;
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> idSet = new HashSet<Long>(1024);
        Date now = TimeServiceHelper.now();
        for (DynamicObject info : dataEntities) {
            Date invaliddate = info.getDate("invaliddate");
            Date effectdate = info.getDate("effectdate");
            if (!effectdate.before(now) || null != invaliddate && (null == invaliddate || !DateUtil.string2date((String)DateUtil.getFormatEndDate((Date)invaliddate), (String)"yyyy-MM-dd HH:mm:ss").after(now))) continue;
            idSet.add(info.getLong("id"));
        }
        QFilter qFilter = new QFilter("id", "in", idSet);
        String selectors = "protocolstatus,billno";
        for (DynamicObject info : pmm_protocols = BusinessDataServiceHelper.load((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray())) {
            info.set("protocolstatus", (Object)"B");
        }
        if (pmm_protocols.length > 0) {
            SaveServiceHelper.save((DynamicObject[])pmm_protocols);
        }
    }
}

