/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pmm.opplugin.validator.PmmProtocolMaterialValidator;
import kd.scm.pmm.opplugin.validator.PmmProtocolSaveValidator;
import kd.scm.pmm.opplugin.validator.PmmProtocolUniqueValidator;

public class PmmProtocolSaveOp
extends AbstractOperationServicePlugIn {
    private Map<Long, String> srcProtocolIDsMap = new HashMap<Long, String>(1024);
    private Set<String> tarProtocolBillno = new HashSet<String>(1024);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("effectdate");
        e.getFieldKeys().add("invaliddate");
        e.getFieldKeys().add("purmode");
        e.getFieldKeys().add("entryentity.orgname");
        e.getFieldKeys().add("entryentity.orgname.name");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("partyb");
        e.getFieldKeys().add("continueprobillno");
        e.getFieldKeys().add("entryentity1.material");
        e.getFieldKeys().add("entryentity1.materialname");
        e.getFieldKeys().add("entryentity1.purplanid");
        e.getFieldKeys().add("entryentity1.purorg");
        e.getFieldKeys().add("entryentity1.purorg.name");
        e.getFieldKeys().add("entryentity1.priceeffectdate");
        e.getFieldKeys().add("entryentity1.priceinvaliddate");
        e.getFieldKeys().add("entryentity1.seq");
        e.getFieldKeys().add("continueprobillno");
        e.getFieldKeys().add("differentarea");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PmmProtocolSaveValidator());
        e.addValidator((AbstractValidator)new PmmProtocolMaterialValidator());
        e.addValidator((AbstractValidator)new PmmProtocolUniqueValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject info : dataEntities = e.getDataEntities()) {
            DynamicObject srcProtocol = info.getDynamicObject("continueprobillno");
            if (null == info.getDynamicObject("continueprobillno")) continue;
            this.srcProtocolIDsMap.put(srcProtocol.getLong("id"), info.getString("billno"));
            this.tarProtocolBillno.add(info.getString("billno"));
            info.set("continueprobillno", null);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] pmm_protocols;
        QFilter qFilter;
        super.afterExecuteOperationTransaction(e);
        HashMap<String, Long> tarBillno_IDMap = new HashMap<String, Long>(1024);
        if (this.tarProtocolBillno.size() > 0) {
            qFilter = new QFilter("billno", "in", this.tarProtocolBillno);
            pmm_protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)"id,billno", (QFilter[])qFilter.toArray());
            for (DynamicObject info : pmm_protocols) {
                tarBillno_IDMap.put(info.getString("billno"), info.getLong("id"));
            }
        }
        if (this.srcProtocolIDsMap.size() > 0) {
            qFilter = new QFilter("id", "in", this.srcProtocolIDsMap.keySet());
            for (DynamicObject info : pmm_protocols = BusinessDataServiceHelper.load((String)"pmm_protocol", (String)"id,continueprobillno", (QFilter[])qFilter.toArray())) {
                String srcBillno;
                Object continueprobillno;
                if (!this.srcProtocolIDsMap.containsKey(info.getLong("id")) || null == (continueprobillno = tarBillno_IDMap.get(srcBillno = this.srcProtocolIDsMap.get(info.getLong("id"))))) continue;
                info.set("continueprobillno", continueprobillno);
            }
            if (pmm_protocols.length > 0) {
                SaveServiceHelper.save((DynamicObject[])pmm_protocols);
            }
        }
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ent_protocolentry_bd").getDynamicObjectType());
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ent_priceprotocol_bd").getDynamicObjectType());
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"pmm_protocol_bd").getDynamicObjectType());
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"pmm_protocolentry_bd").getDynamicObjectType());
        this.updatePurPlanDyn(e.getDataEntities());
    }

    private void updatePurPlanDyn(DynamicObject[] dataEntities) {
        HashSet<Long> purPlanIds = new HashSet<Long>(1024);
        HashMap<Long, Long> purPlanId_protocolIdMap = new HashMap<Long, Long>(1024);
        for (DynamicObject info : dataEntities) {
            if (!info.getBoolean("differentarea")) continue;
            DynamicObjectCollection entryCol = info.getDynamicObjectCollection("entryentity1");
            for (DynamicObject row : entryCol) {
                if (null == row.getDynamicObject("purplanid")) continue;
                purPlanIds.add(row.getDynamicObject("purplanid").getLong("id"));
                purPlanId_protocolIdMap.put(row.getDynamicObject("purplanid").getLong("id"), info.getLong("id"));
            }
        }
        if (purPlanIds.size() > 0) {
            DynamicObject[] pmm_purchaseplan;
            QFilter qFilter = new QFilter("id", "in", purPlanIds);
            String sectlors = "id,protocol";
            for (DynamicObject info : pmm_purchaseplan = BusinessDataServiceHelper.load((String)"pmm_purchaseplan", (String)sectlors, (QFilter[])qFilter.toArray())) {
                Long id = info.getLong("id");
                if (null == purPlanId_protocolIdMap.get(id)) continue;
                Long protococlId = (Long)purPlanId_protocolIdMap.get(id);
                info.set("protocol_id", (Object)protococlId);
            }
            if (pmm_purchaseplan.length > 0) {
                SaveServiceHelper.save((DynamicObject[])pmm_purchaseplan);
            }
        }
    }
}

