/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PmmSupplierAuditSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("supplier");
        fieldKeys.add("supplier.linkman");
        fieldKeys.add("supplier.bizpartner_phone");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        HashSet<Long> supplierIdSet = new HashSet<Long>(dynamicObjects.length);
        for (DynamicObject obj : dynamicObjects) {
            supplierIdSet.add(obj.getLong("supplier_id"));
        }
        Map bdSuppliers = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,linkman,bizpartner_phone", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIdSet)});
        DynamicObject[] supplierGroupDetailArray = BusinessDataServiceHelper.load((String)"bd_suppliergroupdetail", (String)"id,standard,group,supplier", (QFilter[])new QFilter[]{new QFilter("supplier", "in", supplierIdSet)});
        HashMap<Long, Long> supplierIDAndGroupIdDynMap = new HashMap<Long, Long>(supplierGroupDetailArray.length);
        for (DynamicObject supplierGroupDetail : supplierGroupDetailArray) {
            DynamicObject standard = supplierGroupDetail.getDynamicObject("standard");
            if (!"JBFLBZ".equals(standard.getString("number"))) continue;
            supplierIDAndGroupIdDynMap.put(supplierGroupDetail.getDynamicObject("supplier").getLong("id"), supplierGroupDetail.getDynamicObject("group").getLong("id"));
        }
        for (DynamicObject bill : dynamicObjects) {
            Long groupId;
            if (bill.getString("billno") == null || StringUtils.isEmpty((CharSequence)bill.getString("billno")) || StringUtils.isBlank((CharSequence)bill.getString("billno"))) {
                bill.set("billno", bill.getPkValue());
            }
            if ((groupId = (Long)supplierIDAndGroupIdDynMap.get(bill.getLong("supplier_id"))) != null) {
                bill.set("group", (Object)groupId);
            }
            DynamicObject bdSupplier = (DynamicObject)bdSuppliers.get(bill.getLong("supplier_id"));
            bill.set("linkman", (Object)bdSupplier.getString("linkman"));
            bill.set("phone", (Object)bdSupplier.getString("bizpartner_phone"));
        }
    }
}

