/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.event;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.JsonEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pmm.business.service.impl.PmmGoodsMonitorServiceImpl;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceParam;

public class PmmEcGoodsPriceMonitorEventService
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(PmmEcGoodsPriceMonitorEventService.class);

    public Object handleEvent(KDBizEvent evt) {
        JsonEvent jsonEvent = null;
        if (evt instanceof JsonEvent) {
            jsonEvent = (JsonEvent)evt;
        }
        if (jsonEvent == null) {
            logger.info("PmmEcGoodsPriceMonitorEventService: evt == null");
            return evt.getEventId();
        }
        String dataSource = evt.getSource();
        List parmas = (List)SerializationUtils.fromJsonString((String)dataSource, List.class);
        if (parmas.size() == 0) {
            return evt.getEventId();
        }
        Map dataMap = (Map)parmas.get(0);
        if (null == dataMap.get("goodsIds")) {
            return evt.getEventId();
        }
        List goodsIds = (List)dataMap.get("goodsIds");
        String type = "";
        type = null == dataMap.get("type") ? "2" : String.valueOf(dataMap.get("type"));
        if (goodsIds.size() == 0) {
            return evt.getEventId();
        }
        HashSet<Long> removeGoodsIds = new HashSet<Long>(16);
        if (!"1".equals(type)) {
            String ecProductOpStr = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"ec_product_op");
            boolean ecProductOp = Boolean.parseBoolean(ecProductOpStr);
            if (ecProductOp) {
                logger.info("ecProductOp == null");
                return evt.getEventId();
            }
            QFilter logQFilter = new QFilter("goodsid", "in", (Object)goodsIds);
            boolean isExistPmmGoodsrulelog = QueryServiceHelper.exists((String)"pmm_goodsrulelog", (QFilter[])logQFilter.toArray());
            if (isExistPmmGoodsrulelog) {
                logger.info("isExistPmmGoodsrulelog == true");
                return evt.getEventId();
            }
            QFilter qFilter = new QFilter("mallgoods.id", "in", (Object)goodsIds);
            DynamicObjectCollection logInfos = QueryServiceHelper.query((String)"pbd_mallgoods_pricelog", (String)"mallgoods.id", (QFilter[])qFilter.toArray());
            for (DynamicObject row : logInfos) {
                removeGoodsIds.add(row.getLong("mallgoods.id"));
            }
        }
        QFilter qFilter = new QFilter("mallgoods.id", "in", (Object)goodsIds);
        DynamicObjectCollection malgoodsPrices = QueryServiceHelper.query((String)"pbd_mallgoods_price", (String)"mallgoods.source,mallgoods.id,price,mallprice", (QFilter[])qFilter.toArray());
        PmmGoodsMonitorServiceImpl monitorService = new PmmGoodsMonitorServiceImpl();
        for (DynamicObject row : malgoodsPrices) {
            MonitorRuleServiceParam param = new MonitorRuleServiceParam();
            long goodsId = row.getLong("mallgoods.id");
            if (removeGoodsIds.contains(row.getLong("mallgoods.id"))) continue;
            param.setGoodsId(goodsId);
            param.setPlatform(row.getString("mallgoods.source"));
            param.setTaxPrice(row.getBigDecimal("price"));
            param.setShopPirce(row.getBigDecimal("mallprice"));
            monitorService.isMatchMonitorRule(param);
        }
        return evt.getEventId();
    }
}

