/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pmm.business.service.impl.PmmGoodsMonitorServiceImpl;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceParam;

public class PmmEcProdAuditAuditEventService
implements IEventServicePlugin {
    public Object handleEvent(KDBizEvent e) {
        if (!(e instanceof EntityEvent)) {
            return e.getEventId();
        }
        EntityEvent event = (EntityEvent)e;
        List businesskeys = event.getBusinesskeys();
        if (businesskeys.size() == 0) {
            return e.getEventId();
        }
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (String id : businesskeys) {
            idSet.add(Long.parseLong(id));
        }
        QFilter qFilter = new QFilter("id", "in", idSet);
        DynamicObjectCollection pmmEcProdAudits = QueryServiceHelper.query((String)"pmm_ecprodaudit", (String)"entryentity.goods,entryentity.srcbillid,entryentity.srcbilltype,biztype", (QFilter[])qFilter.toArray());
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        HashSet<Long> upGoodsIds = new HashSet<Long>(16);
        HashSet<Long> goodsRuleLogIds = new HashSet<Long>(16);
        HashMap<Long, String> goodsStatusMap = new HashMap<Long, String>(16);
        HashSet<Long> goodsRuleLogDownIds = new HashSet<Long>(16);
        for (DynamicObject row : pmmEcProdAudits) {
            String srcBillId = row.getString("entryentity.srcbillid");
            long goodsId = row.getLong("entryentity.goods");
            String srcBillType = row.getString("entryentity.srcbilltype");
            String biztype = row.getString("biztype");
            if ("pmm_goodsrulelog".equals(srcBillType) && !StringUtils.isEmpty((CharSequence)srcBillId)) {
                goodsRuleLogIds.add(Long.parseLong(srcBillId));
                if ("2".equals(biztype)) {
                    goodsRuleLogDownIds.add(Long.parseLong(srcBillId));
                }
            } else if (0L != goodsId) {
                goodsIds.add(goodsId);
                goodsStatusMap.put(goodsId, biztype);
            }
            if (!"1".equals(biztype)) continue;
            upGoodsIds.add(goodsId);
        }
        this.dealGoodsRulelog(goodsIds, goodsRuleLogIds, goodsRuleLogDownIds, goodsStatusMap);
        this.dealPriceMonitor(upGoodsIds);
        return e.getEventId();
    }

    private void dealPriceMonitor(Set<Long> goodsIds) {
        QFilter qFilter = new QFilter("mallgoods.id", "in", goodsIds);
        DynamicObjectCollection logInfos = QueryServiceHelper.query((String)"pbd_mallgoods_price", (String)"mallgoods.source,mallgoods.id,price,mallprice", (QFilter[])qFilter.toArray());
        if (logInfos.size() == 0) {
            return;
        }
        PmmGoodsMonitorServiceImpl monitorService = new PmmGoodsMonitorServiceImpl();
        for (DynamicObject row : logInfos) {
            MonitorRuleServiceParam param = new MonitorRuleServiceParam();
            param.setGoodsId(row.getLong("mallgoods.id"));
            param.setPlatform(row.getString("mallgoods.source"));
            param.setTaxPrice(row.getBigDecimal("price"));
            param.setShopPirce(row.getBigDecimal("mallprice"));
            monitorService.isMatchMonitorRule(param);
        }
    }

    private void dealGoodsRulelog(Set<Long> goodsIds, Set<Long> goodsRuleLogIds, Set<Long> goodsRuleLogDownIds, Map<Long, String> goodsStatusMap) {
        DynamicObject[] pmm_goodsrulelogs;
        QFilter qFilter = new QFilter("goodsid", "in", goodsIds);
        qFilter.or(new QFilter("id", "in", goodsRuleLogIds));
        QFilter dealStatusQFilter = new QFilter("dealstatus", "=", (Object)"A");
        qFilter.and(dealStatusQFilter);
        for (DynamicObject info : pmm_goodsrulelogs = BusinessDataServiceHelper.load((String)"pmm_goodsrulelog", (String)"remark,result,goodsid,dealstatus,id", (QFilter[])qFilter.toArray())) {
            long id = info.getLong("id");
            long goodsid = info.getLong("goodsid");
            if (goodsRuleLogIds.contains(id)) {
                info.set("dealstatus", (Object)"B");
                if (!goodsRuleLogDownIds.contains(id)) continue;
                info.set("result", (Object)"2");
                continue;
            }
            if (!goodsIds.contains(goodsid)) continue;
            info.set("dealstatus", (Object)"C");
            String bizType = goodsStatusMap.get(goodsid);
            String msg = ResManager.loadKDString((String)"\u56e0\u5546\u57ce\u7aef\u53d1\u8d77\u5546\u54c1\u4e0b\u67b6\uff0c\u4f5c\u5e9f\u76d1\u63a7\u65e5\u5fd7", (String)"PmmEcProdAuditAuditEventService_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            if ("1".equals(bizType)) {
                msg = ResManager.loadKDString((String)"\u56e0\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u8c03\u6574\uff0c\u672a\u8fbe\u5230\u9608\u503c/\u751f\u6210\u65b0\u7684\u76d1\u63a7\u65e5\u5fd7\uff0c\u4f5c\u5e9f\u76d1\u63a7\u65e5\u5fd7", (String)"PmmEcProdAuditAuditEventService_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            }
            info.set("remark", (Object)msg);
        }
        if (pmm_goodsrulelogs.length > 0) {
            SaveServiceHelper.save((DynamicObject[])pmm_goodsrulelogs);
        }
    }
}

