/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.scm.pmm.opplugin.upgrade.PmmCommentOrgUpgradeService;

public class PmmInventoryLockQtyUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PmmCommentOrgUpgradeService.class);
    private static int Page_Index_Max = 5000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog("start upgrade inventory lock qty");
            boolean upgradeResult = this.upgrade(dbKey, pProcessInfo);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog("end upgrade inventory lock qty");
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            logger.warn("end upgrade inventory lock qty", (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean upgrade(String dbKey, StringBuilder pProcessInfo) {
        Long ids;
        int i;
        Object inventoryDyn3;
        Object inventoryDyn22;
        DBRoute dbRoute = new DBRoute(dbKey);
        String inventorySql = "select fgoodsid,fqty from t_mal_inventory";
        HashMap<Long, BigDecimal> goodsIdAndQtyMap = new HashMap<Long, BigDecimal>();
        ArrayList<Long> goodsIds = new ArrayList<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmInventoryLockQtyUpgradeService", (DBRoute)DBRoute.of((String)"pur"), (String)inventorySql);){
            for (Object inventoryDyn22 : dataSet) {
                goodsIdAndQtyMap.put(inventoryDyn22.getLong("fgoodsid"), inventoryDyn22.getBigDecimal("fqty"));
                goodsIds.add(inventoryDyn22.getLong("fgoodsid"));
            }
        }
        if (goodsIdAndQtyMap.isEmpty()) {
            pProcessInfo.append("goodsIdAndQtyMap Empty");
            return true;
        }
        String malOrderSql = "select fid from t_mal_order where fbillstatus = 'B'";
        ArrayList<Long> malOrderIds = new ArrayList<Long>();
        DataSet dataSet = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmInventoryLockQtyUpgradeService", (DBRoute)DBRoute.of((String)"pur"), (String)malOrderSql);
        inventoryDyn22 = null;
        try {
            for (Object inventoryDyn3 : dataSet) {
                malOrderIds.add(inventoryDyn3.getLong("fid"));
            }
        }
        catch (Throwable throwable) {
            inventoryDyn22 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (inventoryDyn22 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)inventoryDyn22).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (malOrderIds.isEmpty()) {
            pProcessInfo.append("malOrderIds Empty");
            return true;
        }
        StringBuilder malOrderEntrySql = new StringBuilder("select fgoodsid,fqty from t_mal_orderentry where fid in (");
        for (i = 0; i < malOrderIds.size(); ++i) {
            ids = (Long)malOrderIds.get(i);
            malOrderEntrySql.append(ids);
            if (i == malOrderIds.size() - 1) continue;
            malOrderEntrySql.append(",");
        }
        malOrderEntrySql.append(") and fgoodsid in (");
        for (i = 0; i < goodsIds.size(); ++i) {
            ids = (Long)goodsIds.get(i);
            malOrderEntrySql.append(ids);
            if (i == goodsIds.size() - 1) continue;
            malOrderEntrySql.append(",");
        }
        malOrderEntrySql.append(")");
        HashMap<Long, BigDecimal> malOrderGoodsIdsAndQty = new HashMap<Long, BigDecimal>();
        DataSet dataSet2 = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmInventoryLockQtyUpgradeService", (DBRoute)DBRoute.of((String)"pur"), (String)malOrderEntrySql.toString());
        inventoryDyn3 = null;
        try {
            for (Row malOrder : dataSet2) {
                BigDecimal qty = malOrderGoodsIdsAndQty.getOrDefault(malOrder.getLong("fgoodsid"), BigDecimal.ZERO);
                qty = qty.add(malOrder.getBigDecimal("fqty"));
                malOrderGoodsIdsAndQty.put(malOrder.getLong("fgoodsid"), qty);
            }
        }
        catch (Throwable throwable) {
            inventoryDyn3 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet2 != null) {
                if (inventoryDyn3 != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)inventoryDyn3).addSuppressed(throwable);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        if (malOrderGoodsIdsAndQty.isEmpty()) {
            pProcessInfo.append("malOrderGoodsIdsAndQty Empty");
            return true;
        }
        ArrayList updateParamList = new ArrayList();
        malOrderGoodsIdsAndQty.forEach((goodsId, lockedQty) -> {
            Object[] updateParam = new Object[3];
            BigDecimal qty = (BigDecimal)goodsIdAndQtyMap.get(goodsId);
            BigDecimal availableQty = qty.subtract((BigDecimal)lockedQty);
            updateParam[0] = lockedQty;
            updateParam[1] = availableQty;
            updateParam[2] = goodsId;
            updateParamList.add(updateParam);
        });
        int pageSize = updateParamList.size() / Page_Index_Max;
        if (updateParamList.size() % Page_Index_Max != 0) {
            ++pageSize;
        }
        pProcessInfo.append("pageSize ").append(pageSize);
        for (int pageIndex = 0; pageIndex < pageSize; ++pageIndex) {
            List<Object> updateParamSubList = (pageIndex + 1) * Page_Index_Max > updateParamList.size() ? updateParamList.subList(pageIndex * Page_Index_Max, updateParamList.size()) : updateParamList.subList(pageIndex * Page_Index_Max, (pageIndex + 1) * Page_Index_Max);
            if (updateParamSubList.isEmpty()) continue;
            this.updateInventoryTable(dbRoute, updateParamSubList);
        }
        return true;
    }

    private void updateInventoryTable(DBRoute dbRoute, List<Object[]> updateParamSubList) {
        String insertSql = "update t_mal_inventory set flockedqty = ?,favailableqty = ? where fgoodsid = ?";
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, updateParamSubList);
    }
}

