/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PmmProdOrgUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PmmProdOrgUpgradeService.class);
    private static int Page_Index_Max = 5000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5546\u54c1\u7ba1\u7406\u521b\u5efa\u7ec4\u7ec7\u5347\u7ea7\u3002", (String)"PmmProdOrgUpgradeService_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(dbKey, pProcessInfo);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(ResManager.loadKDString((String)"\u6267\u884c\u5546\u54c1\u7ba1\u7406\u521b\u5efa\u7ec4\u7ec7\u5347\u7ea7\u7ed3\u675f\u3002", (String)"PmmProdOrgUpgradeService_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u6267\u884c\u5546\u54c1\u7ba1\u7406\u521b\u5efa\u7ec4\u7ec7\u5347\u7ea7\u5f02\u5e38\u3002", (String)"PmmProdOrgUpgradeService_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            logger.warn(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean upgrade(String dbKey, StringBuilder pProcessInfo) {
        DBRoute dbRoute = new DBRoute(dbKey);
        ArrayList<Long> prod_a_list = new ArrayList<Long>();
        String prod_a_Sql = "select fid from t_mal_prod_a where fcreateorgid = 0 order by fid";
        try (DataSet dataSet = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmProdOrgUpgradeService", (DBRoute)DBRoute.of((String)"pur"), (String)prod_a_Sql);){
            for (Row row : dataSet) {
                prod_a_list.add(row.getLong("fid"));
            }
        }
        if (prod_a_list.isEmpty()) {
            return true;
        }
        int pageSize = prod_a_list.size() / Page_Index_Max;
        if (prod_a_list.size() % Page_Index_Max != 0) {
            ++pageSize;
        }
        for (int pageIndex = 0; pageIndex < pageSize; ++pageIndex) {
            List<Long> prod_a_list_sub = (pageIndex + 1) * Page_Index_Max > prod_a_list.size() ? prod_a_list.subList(pageIndex * Page_Index_Max, prod_a_list.size()) : prod_a_list.subList(pageIndex * Page_Index_Max, (pageIndex + 1) * Page_Index_Max);
            if (prod_a_list_sub.isEmpty()) continue;
            this.batchDeal(prod_a_list_sub, pProcessInfo, dbRoute);
        }
        return true;
    }

    private void batchDeal(List<Long> prod_a_list_sub, StringBuilder pProcessInfo, DBRoute dbRoute) {
        StringBuilder prod_sql = new StringBuilder("select fid,fsupplierid from t_mal_prod where fid in (");
        for (int i = 0; i < prod_a_list_sub.size(); ++i) {
            Long prodId = prod_a_list_sub.get(i);
            prod_sql.append(prodId);
            if (i == prod_a_list_sub.size() - 1) continue;
            prod_sql.append(",");
        }
        prod_sql.append(") AND fsupplierid != 0 AND fsource = '1'");
        ArrayList<Long> prod_list = new ArrayList<Long>(Page_Index_Max * 2);
        ArrayList<Long> prodIdBatchList = new ArrayList<Long>(Page_Index_Max * 2);
        try (DataSet dataSet = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmProdOrgUpgradeService", (DBRoute)DBRoute.of((String)"pur"), (String)prod_sql.toString());){
            for (Row row : dataSet) {
                prod_list.add(row.getLong("fsupplierid"));
                prodIdBatchList.add(row.getLong("fid"));
            }
        }
        if (prod_list.isEmpty()) {
            return;
        }
        StringBuilder supEnter_sql = new StringBuilder("select forgid,fsupplierid from t_mal_supenter where fcfmstatus = 'B' AND fsupplierid in (");
        for (int i = 0; i < prod_list.size(); ++i) {
            Long supId = (Long)prod_list.get(i);
            supEnter_sql.append(supId);
            if (i == prod_list.size() - 1) continue;
            supEnter_sql.append(",");
        }
        supEnter_sql.append(")");
        HashMap<Long, Long> supAndOrgMap = new HashMap<Long, Long>(64);
        try (DataSet dataSet = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmProdOrgUpgradeService", (DBRoute)DBRoute.of((String)"pur"), (String)supEnter_sql.toString());){
            for (Row row : dataSet) {
                supAndOrgMap.put(row.getLong("fsupplierid"), row.getLong("forgid"));
            }
        }
        if (supAndOrgMap.isEmpty()) {
            return;
        }
        pProcessInfo.append("update prodId size:").append(prodIdBatchList.size()).append("\n");
        this.updateSql(supAndOrgMap, dbRoute, pProcessInfo, prodIdBatchList);
    }

    private void updateSql(Map<Long, Long> supAndOrgMap, DBRoute dbRoute, StringBuilder pProcessInfo, List<Long> prodIdBatchSubList) {
        StringBuilder prodSql = new StringBuilder("select fid from t_mal_prod where fsupplierid = ? AND fid in (");
        for (int i = 0; i < prodIdBatchSubList.size(); ++i) {
            Long id = prodIdBatchSubList.get(i);
            prodSql.append(id);
            if (i == prodIdBatchSubList.size() - 1) continue;
            prodSql.append(",");
        }
        prodSql.append(")");
        for (Map.Entry<Long, Long> entry : supAndOrgMap.entrySet()) {
            Long supplier = entry.getKey();
            Long org = entry.getValue();
            pProcessInfo.append("update supplier:").append(supplier).append("\n");
            pProcessInfo.append("update org:").append(org).append("\n");
            this.executeUpdateSql(prodSql, supplier, org, dbRoute);
        }
    }

    private void executeUpdateSql(StringBuilder prodSql, Long supplier, Long org, DBRoute dbRoute) {
        Object[] prodParams = new Object[]{supplier};
        ArrayList<Long> updateIds = new ArrayList<Long>(Page_Index_Max * 2);
        try (DataSet dataSet = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmProdOrgUpgradeService", (DBRoute)DBRoute.of((String)"pur"), (String)prodSql.toString(), (Object[])prodParams);){
            for (Row row : dataSet) {
                updateIds.add(row.getLong("fid"));
            }
        }
        StringBuilder updateSql = new StringBuilder("update t_mal_prod_a set fcreateorgid = ? where fid in (");
        for (int i = 0; i < updateIds.size(); ++i) {
            Long id = (Long)updateIds.get(i);
            updateSql.append(id);
            if (i == updateIds.size() - 1) continue;
            updateSql.append(",");
        }
        updateSql.append(") AND fcreateorgid = 0");
        Object[] param = new Object[]{org};
        DB.execute((DBRoute)dbRoute, (String)updateSql.toString(), (Object[])param);
    }
}

