/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PmmCategoryUnionSaveValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> ecIds = new HashSet<Long>(16);
        HashSet<Long> allMdrClassId = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            if (info.getDynamicObjectCollection("mulecclass").size() > 0) continue;
            ecIds.add(info.getLong("ecclass.id"));
            allMdrClassId.add(info.getLong("ecclass.id"));
            allMdrClassId.add(info.getLong("selfclass.id"));
        }
        if (ecIds.size() > 0) {
            String selfNumber;
            String ecNumber;
            long ecId;
            DynamicObject info;
            Set<Long> standardIds = this.getStandardSet();
            Map<String, DynamicObject> platFormMap = this.getPlatFormSet();
            Map<Long, Long> mdrClassMap = this.getMdrClassMap(allMdrClassId);
            Map<Long, Long> ecCategoryMap = this.getEcCategoryMap(ecIds);
            HashMap<Long, Integer> ecIdsMap = new HashMap<Long, Integer>(16);
            for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                String msg;
                info = extendedDataEntity.getDataEntity();
                ecId = info.getLong("ecclass.id");
                long ecStandard = info.getLong("ecclass.standard.id");
                ecNumber = info.getString("ecclass.number");
                selfNumber = info.getString("selfclass.number");
                String platform = info.getString("platform");
                String ecStatus = info.getString("ecclass.status");
                String ecEnable = info.getString("ecclass.enable");
                String ecLevel = info.getString("ecclass.level");
                String selfStatus = info.getString("selfclass.status");
                String selfEnable = info.getString("selfclass.enable");
                String selfLevel = info.getString("selfclass.level");
                if (null != ecStatus && !ecStatus.equals("C")) {
                    String msg2 = ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u7f16\u7801{0}\u672a\u6838\u51c6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PmmCategoryUnionSaveValidator_6", (String)"scm-pmm-opplugin", (Object[])new Object[]{ecNumber});
                    this.addErrorMessage(extendedDataEntity, msg2);
                    continue;
                }
                if (null != selfStatus && !selfStatus.equals("C")) {
                    String msg3 = ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u7f16\u7801{0}\u672a\u6838\u51c6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PmmCategoryUnionSaveValidator_6", (String)"scm-pmm-opplugin", (Object[])new Object[]{selfNumber});
                    this.addErrorMessage(extendedDataEntity, msg3);
                    continue;
                }
                if (null != ecEnable && !ecEnable.equals("1")) {
                    String msg4 = ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u7f16\u7801\u201c{0}\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PmmCategoryUnionSaveValidator_7", (String)"scm-pmm-opplugin", (Object[])new Object[]{ecNumber});
                    this.addErrorMessage(extendedDataEntity, msg4);
                    continue;
                }
                if (null != selfEnable && !selfEnable.equals("1")) {
                    String msg5 = ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u7f16\u7801\u201c{0}\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PmmCategoryUnionSaveValidator_7", (String)"scm-pmm-opplugin", (Object[])new Object[]{selfNumber});
                    this.addErrorMessage(extendedDataEntity, msg5);
                    continue;
                }
                if (null != ecLevel && !ecLevel.equals("3")) {
                    String msg6 = ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u7f16\u7801{0}\u975e\u4e09\u7ea7\u5546\u54c1\u5206\u7c7b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PmmCategoryUnionSaveValidator_8", (String)"scm-pmm-opplugin", (Object[])new Object[]{ecNumber});
                    this.addErrorMessage(extendedDataEntity, msg6);
                    continue;
                }
                if (null != selfLevel && !selfLevel.equals("3")) {
                    String msg7 = ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u7f16\u7801{0}\u975e\u4e09\u7ea7\u5546\u54c1\u5206\u7c7b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PmmCategoryUnionSaveValidator_8", (String)"scm-pmm-opplugin", (Object[])new Object[]{selfNumber});
                    this.addErrorMessage(extendedDataEntity, msg7);
                    continue;
                }
                int count = 1;
                if (ecIdsMap.containsKey(ecId)) {
                    ++count;
                }
                ecIdsMap.put(ecId, count);
                if (!platFormMap.containsKey(platform)) {
                    msg = ResManager.loadKDString((String)"\u7535\u5546\u5e73\u53f0\u8fd8\u672a\u5f00\u901a,\u8bf7\u5f00\u901a\u3002", (String)"PmmCategoryUnionSaveValidator_4", (String)"scm-pmm-opplugin", (Object[])new Object[]{ecNumber});
                    this.addErrorMessage(extendedDataEntity, msg);
                    continue;
                }
                DynamicObject dynamicObject = platFormMap.get(platform);
                long standard = dynamicObject.getLong("standard.id");
                if (ecStandard != standard) {
                    String msg8 = ResManager.loadKDString((String)"\u7535\u5546\u5206\u7c7b\u201c{0}\u201d\u5728\u201c{1}\u201d\u5206\u7c7b\u6807\u51c6\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PmmCategoryUnionSaveValidator_5", (String)"scm-pmm-opplugin", (Object[])new Object[]{ecNumber, dynamicObject.getString("name")});
                    this.addErrorMessage(extendedDataEntity, msg8);
                    continue;
                }
                if (null == ecCategoryMap.get(ecId) || ecCategoryMap.get(ecId).longValue() == info.getLong("id")) continue;
                msg = ResManager.loadKDString((String)"\u7535\u5546\u5206\u7c7b\u201c{0}\u201d\u5df2\u5173\u8054\u81ea\u5efa\u5206\u7c7b\uff0c\u65e0\u6cd5\u5173\u8054\u5176\u4ed6\u81ea\u5efa\u5206\u7c7b\u3002", (String)"PmmCategoryUnionSaveValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[]{ecNumber});
                this.addErrorMessage(extendedDataEntity, msg);
            }
            for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                String msg;
                info = extendedDataEntity.getDataEntity();
                ecId = info.getLong("ecclass.id");
                long selfId = info.getLong("selfclass.id");
                ecNumber = info.getString("ecclass.number");
                selfNumber = info.getString("selfclass.number");
                if (ecIdsMap.get(ecId) != null && (Integer)ecIdsMap.get(ecId) > 1) {
                    msg = ResManager.loadKDString((String)"\u7535\u5546\u5206\u7c7b\u201c{0}\u201d\u5173\u8054\u7684\u81ea\u5efa\u5206\u7c7b\u5b58\u5728\u591a\u6761\u6570\u636e\uff0c\u8bf7\u4fdd\u8bc1\u4e00\u4e2a\u7535\u5546\u5206\u7c7b\u53ea\u80fd\u5173\u8054\u4e00\u4e2a\u81ea\u5efa\u5206\u7c7b\u3002", (String)"PmmCategoryUnionSaveValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[]{ecNumber});
                    this.addErrorMessage(extendedDataEntity, msg);
                }
                if (null != mdrClassMap.get(ecId) && !standardIds.contains(mdrClassMap.get(ecId))) {
                    msg = ResManager.loadKDString((String)"\u7535\u5546\u5206\u7c7b\u7f16\u7801\u201c{0}\u201d\u5728\u7535\u5546\u5206\u7c7b\u6807\u51c6\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"PmmCategoryUnionSaveValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[]{ecNumber});
                    this.addErrorMessage(extendedDataEntity, msg);
                }
                if (null == mdrClassMap.get(selfId) || mdrClassMap.get(selfId) == Long.parseLong("944841720602823680")) continue;
                msg = ResManager.loadKDString((String)"\u81ea\u5efa\u5206\u7c7b\u7f16\u7801\u201c{0}\u201d\u5728\u81ea\u5efa\u5206\u7c7b\u6807\u51c6\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"PmmCategoryUnionSaveValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[]{selfNumber});
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }

    private Map<Long, Long> getMdrClassMap(Set<Long> allMdrClassId) {
        HashMap<Long, Long> mdrClasssMap = new HashMap<Long, Long>(16);
        QFilter qFilter = new QFilter("id", "in", allMdrClassId);
        DynamicObjectCollection infoCol = QueryServiceHelper.query((String)"mdr_goodsclass", (String)"id,standard.id", (QFilter[])qFilter.toArray());
        for (DynamicObject info : infoCol) {
            long classId = info.getLong("id");
            long standard = info.getLong("standard.id");
            mdrClasssMap.put(classId, standard);
        }
        return mdrClasssMap;
    }

    private Map<Long, Long> getEcCategoryMap(Set<Long> ecIds) {
        QFilter qFilter = new QFilter("ecclass.id", "in", ecIds);
        DynamicObjectCollection infoCol = QueryServiceHelper.query((String)"pmm_categoryunion", (String)"id,selfclass.id,ecclass.id", (QFilter[])qFilter.toArray());
        HashMap<Long, Long> ecMap = new HashMap<Long, Long>(16);
        for (DynamicObject info : infoCol) {
            long id = info.getLong("id");
            long ecId = info.getLong("ecclass.id");
            ecMap.put(ecId, id);
        }
        return ecMap;
    }

    private DynamicObjectCollection getStandardDyos() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        return QueryServiceHelper.query((String)"pmm_ecadmit", (String)"standard.id,platform,name", (QFilter[])new QFilter[]{qFilter}, (String)"platform desc");
    }

    private Map<String, DynamicObject> getPlatFormSet() {
        DynamicObjectCollection standardDyos = this.getStandardDyos();
        HashMap<String, DynamicObject> platIds = new HashMap<String, DynamicObject>(16);
        for (DynamicObject row : standardDyos) {
            platIds.put(row.getString("platform"), row);
        }
        return platIds;
    }

    private Set<Long> getStandardSet() {
        DynamicObjectCollection standardDyos = this.getStandardDyos();
        HashSet<Long> stardIds = new HashSet<Long>(16);
        for (DynamicObject row : standardDyos) {
            stardIds.add(row.getLong("standard.id"));
        }
        return stardIds;
    }
}

