/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.AESUtil;
import kd.scm.common.util.MalOrderUtil;

public class PmmEcadmitSaveValidator
extends AbstractValidator {
    private static Log log = LogFactory.getLog(PmmEcadmitSaveValidator.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String PLAYTFORM = "platform";
    private static final String ENTRY_MALLACCOUNT = "mallaccount";
    private static final String ENTRY_MALL_MA = "mallpwd";
    private static final String ENTRY_COMPANYORG = "companyorg";

    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject entry;
            int i;
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            String platform = dynamicObject.getString(PLAYTFORM);
            if (MalOrderUtil.getDefaultMalVersion() && platform.equals(EcPlatformEnum.ECPLATFORM_JD.getVal())) {
                String invoceOrgCode = dynamicObject.getString("invoiceorgcode");
                String email = dynamicObject.getString("emalemail");
                if (StringUtils.isEmpty((CharSequence)invoceOrgCode)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\uff08\u4eac\u4e1c\uff09\u5f00\u7968\u673a\u6784\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmmEcadmitSaveValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)email)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\uff08\u4eac\u4e1c\uff09\u6307\u5b9a\u7535\u5546\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmmEcadmitSaveValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (CollectionUtils.isEmpty((Collection)dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u884c\u6388\u6743\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmmEcadmitSaveValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                return;
            }
            if (Stream.of(EcPlatformEnum.ECPLATFORM_SUNING.getVal(), EcPlatformEnum.ECPLATFORM_XFS.getVal()).anyMatch(source -> StringUtils.equals((CharSequence)source, (CharSequence)platform))) {
                return;
            }
            HashMap<String, Integer> entryMap = new HashMap<String, Integer>(1024);
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
            for (i = 0; i < entryEntity.size(); ++i) {
                entry = (DynamicObject)entryEntity.get(i);
                Long org = (Long)entry.get("companyorg_id");
                if (null == org || org == 0L) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u884c\u6388\u6743\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmmEcadmitSaveValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[0]), i + 1));
                    return;
                }
                if (null != entryMap.get(entry.getString(ENTRY_MALLACCOUNT))) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u884c\u7684\u8d26\u53f7\u548c\u5206\u5f55%2$s\u884c\u7684\u8d26\u53f7\u662f\u76f8\u540c\u7684\u3002", (String)"PmmEcadmitSaveValidator_4", (String)"scm-pmm-opplugin", (Object[])new Object[0]), entry.getString(ENTRY_MALLACCOUNT), i + 1));
                    return;
                }
                entryMap.put(entry.getString(ENTRY_MALLACCOUNT), entry.getInt("seq"));
            }
            for (i = 0; i < entryEntity.size(); ++i) {
                entry = (DynamicObject)entryEntity.get(i);
                String pw = entry.getString(ENTRY_MALL_MA);
                String mallaccount = entry.getString(ENTRY_MALLACCOUNT);
                if (!EcPlatformEnum.ECPLATFORM_ZKH.getVal().equals(platform) && StringUtils.isBlank((CharSequence)pw)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"PmmEcadmitSaveValidator_5", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isBlank((CharSequence)mallaccount)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5e73\u53f0\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmmEcadmitSaveValidator_6", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    return;
                }
                String encryption = "";
                try {
                    AESUtil.decryptToStringNew((String)pw);
                    continue;
                }
                catch (Exception e) {
                    try {
                        encryption = AESUtil.encryptToStringNew((String)pw);
                        entry.set(ENTRY_MALL_MA, (Object)encryption);
                        continue;
                    }
                    catch (Exception e1) {
                        log.info("$$$$$$" + e.getMessage());
                        throw new KDException(new ErrorCode("errorargs", ResManager.loadKDString((String)"\u5bc6\u7801\u52a0\u5bc6\u5f02\u5e38", (String)"PmmEcadmitSaveValidator_7", (String)"scm-pmm-opplugin", (Object[])new Object[0])), new Object[]{e1.getMessage()});
                    }
                }
            }
        }
    }
}

