/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.MalOrderUtil;

public class PmmGoodsBarcodeValidator
extends AbstractValidator {
    public void validate() {
        HashSet<String> barcodeset = new HashSet<String>(1024);
        HashSet<Long> supIdSet = new HashSet<Long>(1024);
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        if (!defaultMalVersion) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("barcode"))) continue;
            barcodeset.add(dynamicObject.getString("barcode"));
            if (null == dynamicObject.get("supplier")) {
                supIdSet.add(dynamicObject.getLong("supplier_id"));
                continue;
            }
            supIdSet.add(dynamicObject.getLong("supplier.id"));
        }
        if (barcodeset.size() > 0) {
            HashMap barcodeMap = new HashMap(1024);
            QFilter qFilter = new QFilter("barcode", "in", barcodeset);
            qFilter.and(new QFilter("supplier.id", "in", supIdSet));
            DynamicObjectCollection pmmProds = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,supplier,number,origin,barcode", (QFilter[])qFilter.toArray());
            if (pmmProds.size() > 0) {
                for (DynamicObject row : pmmProds) {
                    String barcode = row.getString("barcode");
                    if (StringUtils.isEmpty((CharSequence)barcode)) continue;
                    List<Object> prods = new ArrayList<DynamicObject>(1024);
                    if (null != barcodeMap.get(barcode)) {
                        prods = (List)barcodeMap.get(barcode);
                    }
                    prods.add(row);
                    barcodeMap.put(barcode, prods);
                }
                if (barcodeMap.size() > 0) {
                    block2: for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                        DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
                        String barcode = dynamicObject.getString("barcode");
                        long id = dynamicObject.getLong("id");
                        long supId = 0L;
                        supId = null == dynamicObject.get("supplier") ? dynamicObject.getLong("supplier_id") : dynamicObject.getLong("supplier.id");
                        if (null == barcodeMap.get(barcode)) continue;
                        List prods = (List)barcodeMap.get(barcode);
                        for (DynamicObject row : prods) {
                            long tarSupId = row.getLong("supplier");
                            String origin = row.getString("origin");
                            long tarId = row.getLong("id");
                            if (id == tarId || supId != tarSupId) continue;
                            if ("2".equals(origin)) {
                                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u6761\u5f62\u7801\u7684\u5546\u54c1\u201c{0}\u201d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"PmmGoodsBarcodeValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getString("number")}));
                                continue block2;
                            }
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u6761\u5f62\u7801\u7684\u5546\u54c1\u201c{0}\u201d\uff0c\u8bf7\u8054\u7cfb\u4f9b\u5e94\u5546\u67e5\u8be2\u5904\u7406\u3002", (String)"PmmGoodsBarcodeValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getString("number")}));
                            continue block2;
                        }
                    }
                }
            }
            HashMap<String, String> prodchangeMap = new HashMap<String, String>(1024);
            QFilter changeQFilter = new QFilter("entryentity.fieldname", "=", (Object)"barcode");
            changeQFilter.and(new QFilter("supplier.id", "in", supIdSet));
            changeQFilter.and(new QFilter("entryentity.newvalue", "in", barcodeset));
            changeQFilter.and(new QFilter("cfmstatus", "=", (Object)"A").or(new QFilter("cfmstatus", "=", (Object)"")));
            DynamicObjectCollection pmmProdChanges = QueryServiceHelper.query((String)"pmm_prodchange_manage", (String)"billno,supplier,entryentity.newvalue", (QFilter[])changeQFilter.toArray());
            if (pmmProdChanges.size() > 0) {
                for (DynamicObject row : pmmProdChanges) {
                    prodchangeMap.put(row.getString("supplier") + row.getString("entryentity.newvalue"), row.getString("billno"));
                }
            }
            if (prodchangeMap.size() > 0) {
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
                    if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("barcode"))) continue;
                    String barcode = dynamicObject.getString("barcode");
                    String supplierId = "";
                    supplierId = null == dynamicObject.get("supplier") ? dynamicObject.getString("supplier_id") : dynamicObject.getString("supplier.id");
                    String changeBillno = (String)prodchangeMap.get(supplierId + barcode);
                    if (null == changeBillno) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\u6761\u5f62\u7801\u201c{0}\u201d\u4e0e\u5546\u54c1\u53d8\u66f4\u5355\u201c{1}\u201d\u7ef4\u62a4\u7684\u6761\u5f62\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmmGoodsBarcodeValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[]{barcode, changeBillno}));
                }
            }
        }
    }
}

