/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.ParamUtil;

public class PmmGoodsRuleLogOperateDownValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        ArrayList<String> platforms = new ArrayList<String>(16);
        HashSet<Long> goodsPoolIds = new HashSet<Long>(16);
        boolean isContinue = true;
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String dealstatus = dataEntity.getString("dealstatus");
            String goodsnum = dataEntity.getString("goodsnum");
            if (!"A".equals(dealstatus)) {
                String msg = ResManager.loadKDString((String)"\u5546\u54c1{0}\u5df2\u5904\u7406\uff0c\u65e0\u9700\u518d\u53d1\u8d77\u624b\u5de5\u4e0b\u67b6\u3002", (String)"PmmGoodsRuleLogOperateDownValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[]{goodsnum});
                if ("C".equals(dealstatus)) {
                    msg = ResManager.loadKDString((String)"\u5546\u54c1{0}\u5df2\u4f5c\u5e9f\uff0c\u65e0\u9700\u518d\u53d1\u8d77\u624b\u5de5\u4e0b\u67b6\u3002", (String)"PmmGoodsRuleLogOperateDownValidator_4", (String)"scm-pmm-opplugin", (Object[])new Object[]{goodsnum});
                }
                this.addErrorMessage(extendedDataEntity, msg);
                isContinue = false;
            }
            goodsIds.add(Long.parseLong(dataEntity.getString("goodsid")));
            platforms.add(dataEntity.getString("platform"));
            supplierIds.add(dataEntity.getLong("supplier.id"));
            goodsPoolIds.add(dataEntity.getLong("goodspool.id"));
        }
        if (!isContinue) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            String msg;
            if (new HashSet(platforms).size() > 1) {
                msg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u7535\u5546\u4e00\u8d77\u4e0b\u67b6\u3002", (String)"PmmGoodsRuleLogOperateDownValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(extendedDataEntity, msg);
                isContinue = false;
                break;
            }
            if (supplierIds.size() <= 1) continue;
            msg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u4f9b\u5e94\u5546\u4e00\u8d77\u4e0b\u67b6\u3002", (String)"PmmGoodsRuleLogOperateDownValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, msg);
            isContinue = false;
            break;
        }
        if (!isContinue) {
            return;
        }
        if (platforms.size() == 1 && supplierIds.size() == 1) {
            String ecProductOpStr;
            boolean ecProductOp;
            String platForm = (String)platforms.get(0);
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platForm) && !(ecProductOp = Boolean.parseBoolean(ecProductOpStr = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"ec_product_op")))) {
                String msg = ResManager.loadKDString((String)"\u7535\u5546\u5546\u54c1\u72b6\u6001\u81ea\u52a8\u4ece\u7b2c\u4e09\u65b9\u540c\u6b65\uff0c\u4e0d\u652f\u6301\u624b\u5de5\u4e0b\u67b6\uff0c\u5982\u9700\u4eba\u5de5\u4ecb\u5165\uff0c\u8bf7\u5148\u542f\u7528\u201c\u7535\u5546\u5546\u54c1\u8fd0\u8425\u201d\u53c2\u6570\u3002", (String)"PmmGoodsRuleLogOperateDownValidator_5", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntities[0], msg);
                return;
            }
            QFilter qFilter = null;
            String fromId = "";
            String seletor = "";
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platForm)) {
                qFilter = new QFilter("id", "in", goodsIds);
                fromId = "pbd_mallgoods";
                seletor = "id,statusinfo.ecstatus ecstatus,statusinfo.mallstatus mallstatus";
            } else {
                qFilter = new QFilter("id", "in", goodsPoolIds);
                fromId = "pmm_prodpool";
                seletor = "id,mallstatus,salestatus,protocolentry,protocol";
            }
            HashSet<Long> noMatchIds = new HashSet<Long>();
            DynamicObjectCollection goodsInfos = QueryServiceHelper.query((String)fromId, (String)seletor, (QFilter[])qFilter.toArray());
            for (DynamicObject info : goodsInfos) {
                String mallstatus;
                if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platForm)) {
                    mallstatus = info.getString("mallstatus");
                    String ecstatus = info.getString("ecstatus");
                    if ((!"0".equals(mallstatus) || !"1".equals(ecstatus)) && !"0".equals(ecstatus)) continue;
                    noMatchIds.add(info.getLong("id"));
                    continue;
                }
                mallstatus = info.getString("mallstatus");
                if (!"C".equals(mallstatus)) continue;
                noMatchIds.add(info.getLong("id"));
            }
            for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                String goodsid = dataEntity.getString("goodsid");
                String goodsnum = dataEntity.getString("goodsnum");
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platForm)) {
                    goodsid = dataEntity.getString("goodspool.id");
                }
                if (StringUtils.isEmpty((CharSequence)goodsid) || !noMatchIds.contains(Long.parseLong(goodsid))) continue;
                String msg = ResManager.loadKDString((String)"\u5546\u54c1{0}\u5df2\u4e0b\u67b6\uff0c\u65e0\u9700\u518d\u53d1\u8d77\u624b\u5de5\u4e0b\u67b6\u3002", (String)"PmmGoodsRuleLogOperateDownValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[]{goodsnum});
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }
}

