/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.pmm.common.util.PmmGoodsUtil;

public class PmmOrgPackageSelectionToOrderValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("source");
        set.add("goods");
        set.add("qty");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    public void validate() {
        void var8_10;
        ArrayList malMatGoodsInitParams = new ArrayList(32);
        OperateOption option = this.getOption();
        HashSet<Object> selectedGoodsIdsSet = new HashSet();
        if (option.containsVariable("selectedGoodsIds")) {
            String selectedGoodsIds = option.getVariableValue("selectedGoodsIds");
            String[] selectedGoodsIdsArr = selectedGoodsIds.split(",");
            selectedGoodsIdsSet = new HashSet<String>(Arrays.asList(selectedGoodsIdsArr));
        }
        ArrayList<Long> selfGoodsIds = new ArrayList<Long>(this.dataEntities.length << 2);
        ArrayList<Long> ecGoodsIds = new ArrayList<Long>(this.dataEntities.length << 2);
        ExtendedDataEntity[] extendedDataEntityArray = this.getDataEntities();
        int n = extendedDataEntityArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            ExtendedDataEntity extDyn = extendedDataEntityArray[var8_10];
            DynamicObjectCollection entryCol = extDyn.getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                DynamicObject goodsDyn = entry.getDynamicObject("goods");
                if (goodsDyn == null || !selectedGoodsIdsSet.isEmpty() && !selectedGoodsIdsSet.contains(goodsDyn.getString("id"))) continue;
                Long goodsId = goodsDyn.getLong("masterid");
                String source = entry.getString("source");
                if (StringUtils.isNotBlank((CharSequence)source)) {
                    if ("pmm_prodmanage".equals(source)) {
                        selfGoodsIds.add(goodsId);
                    } else {
                        ecGoodsIds.add(goodsId);
                    }
                }
                HashMap<String, Object> malMatGoodsInitParam = new HashMap<String, Object>();
                malMatGoodsInitParam.put("goodsId", goodsId);
                malMatGoodsInitParam.put("number", goodsDyn.getString("number"));
                malMatGoodsInitParam.put("qty", entry.getBigDecimal("qty"));
                malMatGoodsInitParam.put("orgId", RequestContext.get().getOrgId());
                malMatGoodsInitParams.add(malMatGoodsInitParam);
            }
            ++var8_10;
        }
        Map goodsDynMap = PmmGoodsUtil.getGoodsDynMap(selfGoodsIds, ecGoodsIds);
        for (Map map : malMatGoodsInitParams) {
            Long goodsId = (Long)map.get("goodsId");
            DynamicObject goodsDyn = (DynamicObject)goodsDynMap.get(goodsId);
            if (goodsDyn == null) continue;
            map.put("platform", goodsDyn.getString("platform"));
        }
        if (!malMatGoodsInitParams.isEmpty()) {
            HashMap<String, Constable> malPlaceOrderValidateOption = new HashMap<String, Constable>(8);
            malPlaceOrderValidateOption.put("maxSupplierCount", Integer.valueOf(10));
            malPlaceOrderValidateOption.put("validateStock", Boolean.valueOf(true));
            Map map = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"MalPlaceOrderMService", (String)"validateGoods", (Object[])new Object[]{malMatGoodsInitParams, RequestContext.get().getOrgId(), malPlaceOrderValidateOption});
            if (!ObjectUtils.isEmpty((Object)map) && !ObjectUtils.isEmpty(map.get("errorInfos"))) {
                throw new KDBizException(String.join((CharSequence)(";" + System.lineSeparator()), (List)map.get("errorInfos")));
            }
        }
    }
}

