/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.malcore.enums.MallStatusEnum;

public class PmmProdAuditProtocolUniqueValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<Long> goodsIdList = new ArrayList<Long>(1024);
        ArrayList<Long> protocolIdList = new ArrayList<Long>(1024);
        ArrayList<Long> requestIdList = new ArrayList<Long>(1024);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = rowDataEntity.getDataEntity();
            DynamicObject protocol = dataEntity.getDynamicObject("protocolid");
            String biztype = dataEntity.getString("biztype");
            if ("2".equals(biztype) || protocol == null) continue;
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entrys) {
                DynamicObject goods = row.getDynamicObject("goods");
                if (null == goods) continue;
                goodsIdList.add(goods.getLong("id"));
                protocolIdList.add(protocol.getLong("id"));
                requestIdList.add(dataEntity.getLong("id"));
            }
        }
        Map<Long, List<String>> requestConflictKeysMap = this.getPurRequestConflictKeysMap(protocolIdList, this.getDataEntities());
        if (goodsIdList.size() > 0) {
            Map<Long, Map<String, Object>> protocolId_DynMap = this.getProtocolDynMap(protocolIdList);
            HashMap<String, List<Date>> poolId_DatesMap = new HashMap<String, List<Date>>(1024);
            HashMap<String, List<Long>> poolId_orgsMap = new HashMap<String, List<Long>>(1024);
            HashMap<Long, DynamicObject> goodsMap = new HashMap<Long, DynamicObject>(1024);
            HashMap<Long, String> org_nameMap = new HashMap<Long, String>(1024);
            HashMap<String, List<Long>> protocoLId_EnableorgsMap = new HashMap<String, List<Long>>(1024);
            this.dealDataByGoodsIds(goodsIdList, poolId_DatesMap, poolId_orgsMap, goodsMap, org_nameMap, protocoLId_EnableorgsMap);
            this.validatorPordRequest(requestIdList, goodsIdList, protocolIdList);
            for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
                DynamicObject protocol;
                DynamicObject dataEntity = rowDataEntity.getDataEntity();
                String biztype = dataEntity.getString("biztype");
                if ("2".equals(biztype) || (protocol = dataEntity.getDynamicObject("protocolid")) == null) continue;
                Map<String, Object> protocolDataMap = protocolId_DynMap.get(protocol.getLong("id"));
                Date effectdate = (Date)protocolDataMap.get("effectdate");
                Date invaliddate = (Date)protocolDataMap.get("invaliddate");
                HashSet<Long> orgIDSet = (HashSet<Long>)protocolDataMap.get("orgs");
                String purmode = (String)protocolDataMap.get("purmode");
                boolean differentarea = protocol.getBoolean("differentarea");
                DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
                block3: for (DynamicObject row : entrys) {
                    DynamicObject goods = row.getDynamicObject("goods");
                    if (differentarea) {
                        Long protocolentryId = row.getDynamicObject("protocolentry").getLong("id");
                        Map entryOrgs = (Map)protocolDataMap.get("entryOrgs");
                        orgIDSet = (Set)entryOrgs.get(protocolentryId);
                        if (null != goods) {
                            String curPurPlanId = row.getDynamicObject("protocolentry").getString("purplanid.id");
                            String key = goods.getString("id") + curPurPlanId;
                            List<String> conflictKeysMap = requestConflictKeysMap.get(dataEntity.getLong("id"));
                            if (null != conflictKeysMap && conflictKeysMap.contains(key)) {
                                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4e0d\u540c\u91c7\u4e70\u65b9\u6848\u5173\u8054\u7684\u76f8\u540c\u7ec4\u7ec7\u4e2d\u5546\u54c1\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"PmmProdAuditProtocolUniqueValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                            }
                        }
                    }
                    if (null == goods) continue;
                    long goodsId = goods.getLong("id");
                    DynamicObject pool = (DynamicObject)goodsMap.get(goodsId);
                    if (null != protocoLId_EnableorgsMap.get(protocol.getString("id"))) {
                        orgIDSet = new HashSet<Long>((Collection)protocoLId_EnableorgsMap.get(protocol.getString("id")));
                    }
                    for (Map.Entry map : poolId_DatesMap.entrySet()) {
                        String poolid_goodsId = (String)map.getKey();
                        List dateList = (List)map.getValue();
                        Date proEffectdate = (Date)dateList.get(0);
                        Date proInvaliddate = (Date)dateList.get(1);
                        String[] poolids = poolid_goodsId.split("_");
                        if (!poolids[1].equals(String.valueOf(goodsId))) continue;
                        String poolId = poolids[0];
                        List orgs = (List)poolId_orgsMap.get(poolId);
                        Set<Long> diffOrgIds = this.getDiffOrgId(orgIDSet, orgs);
                        if (null == proEffectdate || null == proInvaliddate || null != proEffectdate && effectdate.after(proInvaliddate) || null != invaliddate && invaliddate.before(proEffectdate) || !"1".equals(purmode) && diffOrgIds.size() <= 0) continue;
                        this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u53f7{0}\uff0c\u8be5\u751f\u6548\u671f\u95f4\u5df2\u5173\u8054\u534f\u8bae{1}\uff0c\u4e0d\u652f\u6301\u5173\u8054\u591a\u4e2a\u3002", (String)"PmmProdAuditProtocolUniqueValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[]{pool.getString("goods.number"), pool.getString("protocol.billno")}));
                        continue block3;
                    }
                }
            }
        }
    }

    private Map<Long, List<String>> getPurRequestConflictKeysMap(List<Long> protocolIdList, ExtendedDataEntity[] dataEntities) {
        HashMap purPlanMap = new HashMap(1024);
        if (protocolIdList.size() > 0) {
            QFilter qFilter1 = new QFilter("protocol.id", "in", protocolIdList);
            String selectors = "id,entryentity.org,protocol";
            DynamicObjectCollection pmmPurPlans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)selectors, (QFilter[])qFilter1.toArray());
            for (DynamicObject row : pmmPurPlans) {
                List<Long> orgIds = new ArrayList<Long>(1024);
                if (null != purPlanMap.get(row.getLong("id"))) {
                    orgIds = (List)purPlanMap.get(row.getLong("id"));
                }
                orgIds.add(row.getLong("entryentity.org"));
                purPlanMap.put(row.getLong("id"), orgIds);
            }
        }
        HashMap<Long, List<String>> requestId_keyMap = new HashMap<Long, List<String>>(1024);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
            DynamicObject protocol = dataEntity.getDynamicObject("protocolid");
            String biztype = dataEntity.getString("biztype");
            if (protocol == null || !protocol.getBoolean("differentarea") || "2".equals(biztype)) continue;
            ArrayList<String> keys = new ArrayList<String>(1024);
            ArrayList<String> conflictKeys = new ArrayList<String>(1024);
            for (DynamicObject row : entrys) {
                DynamicObject goods = row.getDynamicObject("goods");
                if (null == goods) continue;
                Long curPurPlanId = row.getDynamicObject("protocolentry").getLong("purplanid.id");
                List orgIds = (List)purPlanMap.get(curPurPlanId);
                for (Long orgId : orgIds) {
                    String key = goods.getString("id") + String.valueOf(orgId);
                    if (keys.contains(key)) {
                        conflictKeys.add(goods.getString("id") + String.valueOf(curPurPlanId));
                        continue;
                    }
                    keys.add(goods.getString("id") + String.valueOf(orgId));
                }
            }
            requestId_keyMap.put(dataEntity.getLong("id"), conflictKeys);
        }
        return requestId_keyMap;
    }

    private void validatorPordRequest(List<Long> requestIdList, List<Long> goodsIdList, List<Long> protocolIdList) {
        Map<Long, List<Long>> protocolId_GoodsIdMap = this.getProtocolByRequest(requestIdList, goodsIdList);
        HashMap protocolId_conflictGoodsIdMap = new HashMap(1024);
        HashMap protocolEntryId_GoodsIdMap = new HashMap(1024);
        if (protocolId_GoodsIdMap.size() > 0) {
            DynamicObject protocol;
            String biztype;
            DynamicObject dataEntity;
            ArrayList<Long> protocolIDs = new ArrayList<Long>(protocolId_GoodsIdMap.keySet());
            protocolIDs.addAll(protocolIdList);
            Map<Long, Map<String, Object>> protocolId_DynMap = this.getProtocolDynMap(protocolIDs);
            Map<Long, DynamicObject> protocolId_RequestDynMap = this.getProdRequestDynMap(protocolIDs);
            HashMap<Long, Object> requestId_conflictReqMap = new HashMap<Long, Object>(1024);
            for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
                dataEntity = rowDataEntity.getDataEntity();
                biztype = dataEntity.getString("biztype");
                if ("2".equals(biztype) || (protocol = dataEntity.getDynamicObject("protocolid")) == null) continue;
                Map<String, Object> protocolDataMap = protocolId_DynMap.get(protocol.getLong("id"));
                Date effectdate = (Date)protocolDataMap.get("effectdate");
                Date invaliddate = (Date)protocolDataMap.get("invaliddate");
                Set orgIDSet = (Set)protocolDataMap.get("orgs");
                String purmode = (String)protocolDataMap.get("purmode");
                HashMap<String, Set> protocolEntry_entryOrgs = new HashMap<String, Set>(1024);
                HashMap protocolEntry_IdMap = new HashMap(1024);
                for (Map.Entry<Long, List<Long>> entry : protocolId_GoodsIdMap.entrySet()) {
                    DynamicObject req = protocolId_RequestDynMap.get(protocol.getLong("id"));
                    if (null != req && requestIdList.contains(req.getLong("id"))) continue;
                    Map<String, Object> tarProtocolDataMap = protocolId_DynMap.get(entry.getKey());
                    Date tarEffectdate = (Date)tarProtocolDataMap.get("effectdate");
                    Date date = (Date)tarProtocolDataMap.get("invaliddate");
                    if (null == tarProtocolDataMap.get("entryOrgs")) continue;
                    Map entryOrgs = (Map)tarProtocolDataMap.get("entryOrgs");
                    for (Map.Entry entryOrgsMap : entryOrgs.entrySet()) {
                        if (null != effectdate && tarEffectdate.after(invaliddate) || null != date && date.before(effectdate) || null == protocolEntryId_GoodsIdMap.get(entryOrgsMap.getKey())) continue;
                        Set orgs = (Set)entryOrgsMap.getValue();
                        String key = entryOrgsMap.getKey() + "_" + protocolEntryId_GoodsIdMap.get(entryOrgsMap.getKey());
                        protocolEntry_entryOrgs.put(key, orgs);
                        protocolId_DynMap.remove(entry.getKey());
                        protocolEntry_IdMap.put(entryOrgsMap.getKey(), entry.getKey());
                    }
                }
                DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
                block3: for (DynamicObject row : entrys) {
                    if (null == row.get("goods")) continue;
                    String goodsid = row.getDynamicObject("goods").getString("id");
                    if (null != protocolDataMap.get("entryOrgs")) {
                        Long protocolentryId = row.getDynamicObject("protocolentry").getLong("id");
                        Map map = (Map)protocolDataMap.get("entryOrgs");
                        orgIDSet = (Set)map.get(protocolentryId);
                    }
                    for (Map.Entry entry : protocolEntry_entryOrgs.entrySet()) {
                        Set<Long> diffOrgIds = this.getDiffOrgId(orgIDSet, new ArrayList<Long>((Collection)entry.getValue()));
                        if (!"1".equals(purmode) && diffOrgIds.size() <= 0 || !((String)entry.getKey()).contains(goodsid)) continue;
                        Long protocolId = (Long)protocolEntry_IdMap.get(Long.parseLong(((String)entry.getKey()).split("_")[0]));
                        requestId_conflictReqMap.put(dataEntity.getLong("id"), protocolEntry_IdMap.get(Long.parseLong(((String)entry.getKey()).split("_")[0])));
                        Set<Long> conflickGoodsId = new HashSet<Long>(1024);
                        if (null != protocolId_conflictGoodsIdMap.get(protocolId)) {
                            conflickGoodsId = (Set)protocolId_conflictGoodsIdMap.get(protocolId);
                        }
                        conflickGoodsId.add(Long.parseLong(goodsid));
                        protocolId_conflictGoodsIdMap.put(protocolId, conflickGoodsId);
                        break;
                    }
                    for (Map.Entry<Object, Object> entry : protocolId_GoodsIdMap.entrySet()) {
                        DynamicObject req = protocolId_RequestDynMap.get(protocol.getLong("id"));
                        if (null != req && requestIdList.contains(req.getLong("id")) || protocolId_DynMap.size() == 0 || null == protocolId_DynMap.get(entry.getKey())) continue;
                        Map<String, Object> tarProtocolDataMap = protocolId_DynMap.get(entry.getKey());
                        Date tarEffectdate = (Date)tarProtocolDataMap.get("effectdate");
                        Date tarInvaliddate = (Date)tarProtocolDataMap.get("invaliddate");
                        Set tarOrgIDSet = (Set)tarProtocolDataMap.get("orgs");
                        Set<Long> diffOrgIds = this.getDiffOrgId(orgIDSet, new ArrayList<Long>(tarOrgIDSet));
                        if (null == effectdate || null == invaliddate || null != effectdate && tarEffectdate.after(invaliddate) || null != tarInvaliddate && tarInvaliddate.before(effectdate) || diffOrgIds.size() <= 0) continue;
                        requestId_conflictReqMap.put(dataEntity.getLong("id"), entry.getKey());
                        Set<Long> conflickGoodsId = new HashSet<Long>(1024);
                        if (null != protocolId_conflictGoodsIdMap.get(entry.getKey())) {
                            conflickGoodsId = (Set)protocolId_conflictGoodsIdMap.get(entry.getKey());
                        }
                        conflickGoodsId.add(Long.parseLong(goodsid));
                        protocolId_conflictGoodsIdMap.put(entry.getKey(), conflickGoodsId);
                        continue block3;
                    }
                }
            }
            for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
                dataEntity = rowDataEntity.getDataEntity();
                biztype = dataEntity.getString("biztype");
                if ("2".equals(biztype) || (protocol = dataEntity.getDynamicObject("protocolid")) == null) continue;
                DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entrys) {
                    DynamicObject goods = row.getDynamicObject("goods");
                    if (null == goods) continue;
                    long id = dataEntity.getLong("id");
                    long goodsId = goods.getLong("id");
                    if (null == requestId_conflictReqMap.get(id)) continue;
                    Long l = (Long)requestId_conflictReqMap.get(id);
                    Set goodIds = (Set)protocolId_conflictGoodsIdMap.get(l);
                    DynamicObject reqDyn = protocolId_RequestDynMap.get(l);
                    if (!goodIds.contains(goodsId)) continue;
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u53f7{0}\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u672a\u5ba1\u6279\u7684\u4e0a\u67b6\u7533\u8bf7{1}\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u7533\u8bf7\u3002", (String)"PmmProdAuditProtocolUniqueValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[]{goods.getString("number"), reqDyn.getString("billno")}));
                }
            }
        }
    }

    private Map<Long, DynamicObject> getProdRequestDynMap(ArrayList<Long> protocolIds) {
        HashMap<Long, DynamicObject> prodRequestDynMap = new HashMap<Long, DynamicObject>(1024);
        QFilter filter = new QFilter("protocolid.id", "in", protocolIds);
        QFilter statusFilter = new QFilter("cfmstatus", "=", (Object)"A");
        statusFilter.or(new QFilter("billstatus", "=", (Object)"A"));
        filter.and("biztype", "=", (Object)"1");
        filter.and(statusFilter);
        String prodSectlors = "id,protocolid,billno";
        DynamicObjectCollection prodDynColl = QueryServiceHelper.query((String)"ent_prodrequest", (String)prodSectlors, (QFilter[])new QFilter[]{filter});
        for (DynamicObject prod : prodDynColl) {
            prodRequestDynMap.put(prod.getLong("protocolid"), prod);
        }
        return prodRequestDynMap;
    }

    private Map<Long, List<Long>> getProtocolByRequest(List<Long> requestIdList, List<Long> goodsIdList) {
        QFilter filter = new QFilter("entryentity.goods.id", "in", goodsIdList);
        QFilter statusFilter = new QFilter("cfmstatus", "=", (Object)"A");
        statusFilter.or(new QFilter("billstatus", "=", (Object)"A"));
        filter.and(statusFilter);
        filter.and(new QFilter("biztype", "=", (Object)"1"));
        String prodSectlors = "id,entryentity.goods.id,protocolid,billno";
        DynamicObjectCollection prodDynColl = QueryServiceHelper.query((String)"ent_prodrequest", (String)prodSectlors, (QFilter[])new QFilter[]{filter});
        HashMap<Long, List<Long>> protocolId_GoodsIdMap = new HashMap<Long, List<Long>>(1024);
        for (DynamicObject prod : prodDynColl) {
            Long protocolId = prod.getLong("protocolid");
            Long goodsId = prod.getLong("entryentity.goods.id");
            if (null == protocolId || protocolId.equals(0L) || null == goodsId || goodsId.equals(0L)) continue;
            List<Long> goodsIds = new ArrayList<Long>(1024);
            if (null != protocolId_GoodsIdMap.get(protocolId)) {
                goodsIds = (List)protocolId_GoodsIdMap.get(protocolId);
            }
            goodsIds.add(goodsId);
            protocolId_GoodsIdMap.put(protocolId, goodsIds);
        }
        return protocolId_GoodsIdMap;
    }

    private void dealDataByGoodsIds(List<Long> goodsIdList, Map<String, List<Date>> poolId_DatesMap, Map<String, List<Long>> poolId_orgsMap, Map<Long, DynamicObject> goodsMap, Map<Long, String> org_nameMap, Map<String, List<Long>> protocoLId_EnableorgsMap) {
        QFilter filter = new QFilter("goods.id", "in", goodsIdList);
        QFilter protocolStatus = new QFilter("protocol.protocolstatus", "=", (Object)"A");
        protocolStatus.or(new QFilter("protocol.protocolstatus", "=", (Object)"B"));
        QFilter malstatus = new QFilter("mallstatus", "=", (Object)"A");
        malstatus.or(new QFilter("mallstatus", "=", (Object)"B"));
        malstatus.or(new QFilter("mallstatus", "=", (Object)"C"));
        QFilter salestatus = new QFilter("salestatus", "=", (Object)"A");
        salestatus.or(new QFilter("salestatus", "=", (Object)"C"));
        salestatus.or(new QFilter("salestatus", "=", (Object)"D"));
        filter.and(protocolStatus).and(malstatus).and(salestatus);
        String prodSectlors = "id,goods.id,mallstatus,goods.number,protocol.billno,protocol.id,protocol.invaliddate,protocol.effectdate,entryentity.orgname,entryentity.orgname.name";
        DynamicObjectCollection prodDynColl = QueryServiceHelper.query((String)"pmm_prodpool", (String)prodSectlors, (QFilter[])new QFilter[]{filter});
        for (DynamicObject row : prodDynColl) {
            if (MallStatusEnum.SOLDOUT.getVal().equals(row.getString("mallstatus"))) {
                String protocolId = row.getString("protocol.id");
                List<Object> orgList = new ArrayList();
                if (null != protocoLId_EnableorgsMap.get(protocolId)) {
                    orgList = protocoLId_EnableorgsMap.get(protocolId);
                }
                if (0L != row.getLong("entryentity.orgname")) {
                    orgList.add(row.getLong("entryentity.orgname"));
                }
                protocoLId_EnableorgsMap.put(protocolId, orgList);
                continue;
            }
            String poolId = row.getString("id") + '_' + row.getString("goods.id");
            ArrayList<Date> dateList = new ArrayList<Date>(1024);
            dateList.add(row.getDate("protocol.effectdate"));
            dateList.add(row.getDate("protocol.invaliddate"));
            poolId_DatesMap.put(poolId, dateList);
            List<Long> orgList = new ArrayList<Long>();
            if (null != poolId_orgsMap.get(row.getString("id"))) {
                orgList = poolId_orgsMap.get(row.getString("id"));
            }
            orgList.add(row.getLong("entryentity.orgname"));
            poolId_orgsMap.put(row.getString("id"), orgList);
            goodsMap.put(row.getLong("goods.id"), row);
            org_nameMap.put(row.getLong("entryentity.orgname"), row.getString("entryentity.orgname.name"));
        }
    }

    private Map<Long, Map<String, Object>> getProtocolDynMap(List<Long> protocolIdList) {
        HashMap<Long, Map<String, Object>> protocolId_DynMap = new HashMap<Long, Map<String, Object>>(1024);
        HashSet<Long> differentareaProtocolIds = new HashSet<Long>(1024);
        String selectors = "id,effectdate,invaliddate,purmode,entryentity.orgname,differentarea";
        QFilter qFilter = new QFilter("id", "in", protocolIdList);
        DynamicObjectCollection pmmProtocols = QueryServiceHelper.query((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray());
        for (DynamicObject row : pmmProtocols) {
            Long id = row.getLong("id");
            if (row.getBoolean("differentarea")) {
                differentareaProtocolIds.add(id);
            }
            Date effectdate = row.getDate("effectdate");
            Date invaliddate = row.getDate("invaliddate");
            Map<String, Date> dataMap = new HashMap(1024);
            Set<Long> orgIDSet = new HashSet(1024);
            if (null != protocolId_DynMap.get(id)) {
                dataMap = (Map)protocolId_DynMap.get(id);
                orgIDSet = (Set)dataMap.get("orgs");
            }
            if (!"1".equals(row.getString("purmode")) && row.getLong("entryentity.orgname") != 0L) {
                orgIDSet.add(row.getLong("entryentity.orgname"));
            }
            dataMap.put("effectdate", effectdate);
            dataMap.put("invaliddate", invaliddate);
            dataMap.put("orgs", (Date)((Object)orgIDSet));
            dataMap.put("purmode", (Date)((Object)row.getString("purmode")));
            protocolId_DynMap.put(id, dataMap);
        }
        if (differentareaProtocolIds.size() > 0) {
            qFilter = new QFilter("id", "in", differentareaProtocolIds);
            selectors = "id,effectdate,invaliddate,purmode,entryentity1.id,entryentity1.purplanid,entryentity1.purorg,differentarea";
            pmmProtocols = QueryServiceHelper.query((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray());
            HashMap purPlanId_OrgsMap = new HashMap(1024);
            HashMap<Long, Long> entryId_purPlanIdMap = new HashMap<Long, Long>(1024);
            HashMap protocolId_entrysMap = new HashMap(1024);
            for (DynamicObject row : pmmProtocols) {
                Long id = row.getLong("id");
                Long entryId = row.getLong("entryentity1.id");
                List<Long> entrys = new ArrayList<Long>(1024);
                if (null != protocolId_entrysMap.get(id)) {
                    entrys = (List)protocolId_entrysMap.get(id);
                }
                entrys.add(entryId);
                protocolId_entrysMap.put(id, entrys);
                Long purplanid = row.getLong("entryentity1.purplanid");
                Long purorg = row.getLong("entryentity1.purorg");
                Set<Long> orgIds = new HashSet<Long>(1024);
                if (null != purPlanId_OrgsMap.get(purplanid)) {
                    orgIds = (Set)purPlanId_OrgsMap.get(purplanid);
                }
                orgIds.add(purorg);
                purPlanId_OrgsMap.put(purplanid, orgIds);
                entryId_purPlanIdMap.put(entryId, purplanid);
            }
            for (Map.Entry map : protocolId_DynMap.entrySet()) {
                Map value = (Map)map.getValue();
                if (!differentareaProtocolIds.contains(map.getKey())) continue;
                List protocolEntryIds = (List)protocolId_entrysMap.get(map.getKey());
                HashMap<Long, Set> newValueMap = new HashMap<Long, Set>(1024);
                for (Long entryId : protocolEntryIds) {
                    Long purPlanId = (Long)entryId_purPlanIdMap.get(entryId);
                    Set orgIds = (Set)purPlanId_OrgsMap.get(purPlanId);
                    newValueMap.put(entryId, orgIds);
                }
                value.put("entryOrgs", newValueMap);
                protocolId_DynMap.put((Long)map.getKey(), value);
            }
        }
        return protocolId_DynMap;
    }

    private String getOrgName(Set<Long> diffOrgIds, Map<Long, String> org_nameMap) {
        StringBuilder strBuffer = new StringBuilder();
        for (Long id : diffOrgIds) {
            strBuffer.append(org_nameMap.get(id)).append(';');
        }
        return strBuffer.substring(0, strBuffer.toString().length() - 1);
    }

    private Set<Long> getDiffOrgId(Set<Long> srcOrgs, List<Long> tarOrgs) {
        HashSet<Long> differOrgIds = new HashSet<Long>(1024);
        if (tarOrgs.size() == 0 || tarOrgs.contains(0L) && tarOrgs.size() == 1) {
            return srcOrgs;
        }
        for (Long id : srcOrgs) {
            if (!tarOrgs.contains(id)) continue;
            differOrgIds.add(id);
        }
        return differOrgIds;
    }
}

