/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PmmProdAuditSubmitValidator
extends AbstractValidator {
    public void validate() {
        HashMap<String, Object> prodNumbers = new HashMap<String, Object>();
        HashMap<Long, Object> prodIdAndDynMap = new HashMap<Long, Object>();
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                DynamicObject goods = entry.getDynamicObject("goods");
                if (goods == null || !dataEntity.getString("billstatus").equals("A")) continue;
                prodNumbers.put(goods.getString("number"), extendedDataEntity);
                prodIdAndDynMap.put(goods.getLong("id"), extendedDataEntity);
            }
        }
        QFilter prodQFilter = new QFilter("number", "in", prodNumbers.keySet());
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"number", (QFilter[])prodQFilter.toArray());
        HashSet<String> numberCheck = new HashSet<String>(prods.size());
        for (DynamicObject prod : prods) {
            String number = prod.getString("number");
            if (numberCheck.contains(number)) {
                String message = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5728\u81ea\u5efa\u5546\u54c1\u6c60\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PmmProdAuditSubmitValidator_12", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage((ExtendedDataEntity)prodNumbers.get(number), String.format(message, number));
                continue;
            }
            numberCheck.add(number);
        }
        QFilter qFilterProdChg = new QFilter("prod", "in", prodIdAndDynMap.keySet());
        qFilterProdChg.and(new QFilter("billstatus", "=", (Object)"B").or("cfmstatus", "=", (Object)"A"));
        DynamicObjectCollection prodChgs = QueryServiceHelper.query((String)"pmm_prodchange_manage", (String)"prod.id prod,prod.number prodnumber", (QFilter[])qFilterProdChg.toArray());
        for (DynamicObject prodChg : prodChgs) {
            String message = ResManager.loadKDString((String)"\u5546\u54c1%s\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"PmmProdAuditSubmitValidator_11", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            this.addErrorMessage((ExtendedDataEntity)prodIdAndDynMap.get(prodChg.getLong("prod")), String.format(message, prodChg.getString("prodnumber")));
        }
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject goods;
            String protocolStatus;
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            DynamicObject protocol = dynamicObject.getDynamicObject("protocolid");
            if (null != protocol && ("C".equals(protocolStatus = protocol.getString("protocolstatus")) || "D".equals(protocolStatus))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u534f\u8bae\u5df2\u5931\u6548/\u7ec8\u6b62\uff0c\u4e0a\u67b6\u7533\u8bf7\u5355\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"PmmProdAuditSubmitValidator_8", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entryCOl = dynamicObject.getDynamicObjectCollection("entryentity");
            boolean isEmptyGoods = true;
            for (DynamicObject row : entryCOl) {
                goods = row.getDynamicObject("goods");
                if (null == goods) continue;
                isEmptyGoods = false;
            }
            if (isEmptyGoods) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u5546\u54c1\u4fe1\u606f\u3002", (String)"PmmProdAuditSubmitValidator_4", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                continue;
            }
            for (DynamicObject row : entryCOl) {
                goods = row.getDynamicObject("goods");
                int seq = row.getInt("seq");
                String pricetype = row.getString("pricetype");
                if ("B".equals(pricetype)) {
                    DynamicObjectCollection subEntry = row.getDynamicObjectCollection("subentryentity");
                    boolean isExistLad = true;
                    for (DynamicObject subrow : subEntry) {
                        if (subrow.getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) != 0) continue;
                        isExistLad = false;
                        break;
                    }
                    if (subEntry.size() == 0 || !isExistLad) {
                        this.addErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6ca1\u6709\u8bbe\u7f6e\u9636\u68af\u4ef7\u3002", (String)"PmmProdAuditSubmitValidator_9", (String)"scm-pmm-opplugin", (Object[])new Object[0]), seq));
                        continue;
                    }
                }
                DynamicObject goodClass = row.getDynamicObject("class");
                DynamicObject protocolentry = row.getDynamicObject("protocolentry");
                Date priceEffectDate = row.getDate("priceeffectdate");
                Date priceInvalidDate = row.getDate("priceinvaliddate");
                if (null == protocolentry) {
                    if (null == goods) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5546\u54c1\u660e\u7ec6\u201d\u7b2c{0}\u884c\u201c\u5546\u54c1\u7f16\u7801\u201d\u3002", (String)"PmmProdAuditSubmitValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq")}));
                    }
                    if (null == goodClass) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5546\u54c1\u660e\u7ec6\u201d\u7b2c{0}\u884c\u201c\u5546\u54c1\u5206\u7c7b\u201d\u3002", (String)"PmmProdAuditSubmitValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq")}));
                    }
                }
                if (goods != null && row.getBigDecimal("taxprice").compareTo(BigDecimal.ZERO) == 0) {
                    String message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5546\u54c1\u660e\u7ec6\u201d\u7b2c{0}\u884c\u201c\u7ed3\u7b97\u4ef7\u201d\u3002", (String)"PmmProdAuditSubmitValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq")});
                    this.addErrorMessage(extendedDataEntity, message);
                }
                if (null != goods && null == priceEffectDate && protocol != null) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5546\u54c1\u660e\u7ec6\u201d\u7b2c{0}\u884c\u201c\u4ef7\u683c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"PmmProdAuditSubmitValidator_6", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq")}));
                }
                if (null != goods && null == priceInvalidDate && protocol != null) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5546\u54c1\u660e\u7ec6\u201d\u7b2c{0}\u884c\u201c\u4ef7\u683c\u5931\u6548\u65e5\u671f\u201d\u3002", (String)"PmmProdAuditSubmitValidator_7", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq")}));
                }
                if (null != goods && (null == goods.get("thumbnail") || StringUtils.isEmpty((CharSequence)goods.getString("thumbnail")))) {
                    String name = goods.getString("name");
                    String number = goods.getString("number");
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(name).append('(').append(number).append(')');
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\uff1a{0}\u9700\u5b8c\u5584\u5546\u54c1\u4e3b\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PmmProdAuditSubmitValidator_5", (String)"scm-pmm-opplugin", (Object[])new Object[]{stringBuilder.toString()}));
                }
                if (null != row.getDynamicObject("goods")) continue;
            }
        }
    }
}

