/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.pmm.business.model.protocol.ProtocolInfo;
import kd.scm.pmm.business.validator.PmmProtocolValidatorService;

public class PmmProtocolUniqueValidator
extends AbstractValidator {
    private static String KEY_ALL = "A";
    private static String KEY_PART = "B";
    private static String KEY_AREA = "C";

    public void validate() {
        Set<Long> supIdSet = this.getSupplierIdSet(this.getDataEntities());
        if (supIdSet.size() > 0) {
            this.doValidate(supIdSet);
        }
    }

    private void doValidate(Set<Long> supIdSet) {
        PmmProtocolValidatorService service = new PmmProtocolValidatorService();
        ArrayList protocolInfoList = service.getProtocolList(supIdSet);
        Map protocolGroupInfos = service.getProtocolGroupInfosByPurMode((List)protocolInfoList);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            String purmode = dynamicObject.getString("purmode");
            boolean differentarea = dynamicObject.getBoolean("differentarea");
            if (purmode.equals("1")) {
                this.checkAllOrgProtocol(protocolGroupInfos, extendedDataEntity);
                continue;
            }
            if (purmode.equals("2") && differentarea) {
                this.checkAreaProtocol(protocolGroupInfos, extendedDataEntity);
                continue;
            }
            this.checkPartOrgProtocol(protocolGroupInfos, extendedDataEntity);
        }
    }

    private void checkAreaProtocol(Map<String, ArrayList<ProtocolInfo>> protocolGroupInfos, ExtendedDataEntity extendedDataEntity) {
        String msg;
        DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
        DynamicObjectCollection materialEntrys = dynamicObject.getDynamicObjectCollection("entryentity1");
        HashSet<Long> materialSet = new HashSet<Long>(1024);
        HashSet<Long> orgSet = new HashSet<Long>(1024);
        ArrayList<String> srcOrgId_materialIds = new ArrayList<String>(1024);
        StringBuilder strBuffer = new StringBuilder();
        for (DynamicObject row : materialEntrys) {
            if (null != row.getDynamicObject("material")) {
                long materialId = row.getDynamicObject("material").getLong("id");
                materialSet.add(row.getDynamicObject("material").getLong("id"));
                strBuffer.setLength(0);
                strBuffer.append(row.getDynamicObject("purorg").getLong("id")).append('_').append(materialId);
                srcOrgId_materialIds.add(strBuffer.toString());
            }
            if (null == row.getDynamicObject("purorg") || 0L == row.getDynamicObject("purorg").getLong("id")) continue;
            orgSet.add(row.getDynamicObject("purorg").getLong("id"));
        }
        PmmProtocolValidatorService service = new PmmProtocolValidatorService();
        ArrayList protocolInfoAllOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_ALL), dynamicObject);
        ArrayList protocolInfoPartOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_PART), dynamicObject);
        ArrayList protocolInfoAreas = service.filterProtocol(protocolGroupInfos.get(KEY_AREA), dynamicObject);
        boolean isExit = false;
        if (protocolInfoAllOrgs.size() > 0) {
            for (ProtocolInfo info : protocolInfoAllOrgs) {
                Set<Long> diffMaterialIdSet;
                if (info.getMaterialIds() == null || info.getMaterialIds().size() == 0) {
                    String msg2 = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5df2\u5b58\u5728\u5168\u96c6\u56e2\u5171\u4eab\u7684\u534f\u8bae({0})\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                    this.addErrorMessage(extendedDataEntity, msg2);
                    isExit = true;
                    break;
                }
                if (info.getMaterialIds() == null || info.getMaterialIds().size() <= 0 || (diffMaterialIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds())).size() <= 0) continue;
                msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u5168\u96c6\u56e2\u5171\u4eab\u4e14\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                this.addErrorMessage(extendedDataEntity, msg);
                isExit = true;
                break;
            }
            if (isExit) {
                return;
            }
        }
        if (protocolInfoPartOrgs.size() > 0) {
            for (ProtocolInfo info : protocolInfoPartOrgs) {
                List<String> tarOrgId_materialIds;
                List<String> diffOrgMaterials;
                strBuffer.setLength(0);
                strBuffer.append(this.getDateString(info.getEffectdate())).append('-').append(this.getDateString(info.getInvaliddate()));
                Set<Long> diffOrgIdSet = this.getDiffIdSet(orgSet, info.getOrgIds());
                if (diffOrgIdSet.size() <= 0) continue;
                if (null == info.getMaterialIds() || info.getMaterialIds().size() == 0) {
                    Map orgId_orgNameMap = info.getOrgId_orgNameMap();
                    for (Long orgId : diffOrgIdSet) {
                        String msg3 = ResManager.loadKDString((String)"{0}\u5728{1}\u671f\u95f4\u5185\u5b58\u5728\u4ea4\u53c9\u534f\u8bae\u201c{2}\u201d", (String)"PmmProtocolUniqueValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[]{orgId_orgNameMap.get(orgId), strBuffer, info.getProtocolBillNo()});
                        this.addErrorMessage(extendedDataEntity, msg3);
                    }
                    isExit = true;
                    break;
                }
                if (null == info.getMaterialIds() || info.getMaterialIds().size() <= 0 || (diffOrgMaterials = this.getDiffOrgMaterialSet(srcOrgId_materialIds, tarOrgId_materialIds = this.getOrgIdMaterialIds(new HashSet<Long>(info.getMaterialIds()), new HashSet<Long>(info.getOrgIds())))).size() <= 0) continue;
                String msg4 = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u6309\u7ec4\u7ec7\u9694\u79bb\u53ca\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                this.addErrorMessage(extendedDataEntity, msg4);
                isExit = true;
                break;
            }
            if (isExit) {
                return;
            }
        }
        if (protocolInfoAreas.size() > 0) {
            for (ProtocolInfo info : protocolInfoAreas) {
                List<String> diffOrgMaterials = this.getDiffOrgMaterialSet(srcOrgId_materialIds, info.getOrgId_materialIds());
                if (diffOrgMaterials.size() <= 0) continue;
                msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u6309\u7ec4\u7ec7\u9694\u79bb\u53ca\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                this.addErrorMessage(extendedDataEntity, msg);
                break;
            }
        }
    }

    private List<String> getOrgIdMaterialIds(Set<Long> materialSet, Set<Long> orgSet) {
        StringBuilder strBuffer = new StringBuilder();
        ArrayList<String> srcOrgId_materialIds = new ArrayList<String>(1024);
        for (Long materialId : materialSet) {
            for (Long orgId : orgSet) {
                strBuffer.setLength(0);
                strBuffer.append(orgId).append('_').append(materialId);
                srcOrgId_materialIds.add(strBuffer.toString());
            }
        }
        return srcOrgId_materialIds;
    }

    private List<String> getDiffOrgMaterialSet(List<String> srcOrgId_materialIds, List<String> orgId_materialIds) {
        ArrayList<String> diffMaterialIds = new ArrayList<String>(1024);
        if (null == orgId_materialIds || orgId_materialIds.size() == 0) {
            return srcOrgId_materialIds;
        }
        for (String key : srcOrgId_materialIds) {
            if (!orgId_materialIds.contains(key)) continue;
            diffMaterialIds.add(key);
        }
        return diffMaterialIds;
    }

    private void checkPartOrgProtocol(Map<String, ArrayList<ProtocolInfo>> protocolGroupInfos, ExtendedDataEntity extendedDataEntity) {
        DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
        DynamicObjectCollection materialEntrys = dynamicObject.getDynamicObjectCollection("entryentity1");
        HashSet<Long> materialSet = new HashSet<Long>(1024);
        for (DynamicObject row : materialEntrys) {
            if (null == row.getDynamicObject("material")) continue;
            materialSet.add(row.getDynamicObject("material").getLong("id"));
        }
        DynamicObjectCollection orgEntrys = dynamicObject.getDynamicObjectCollection("entryentity");
        HashSet<Long> orgIdSet = new HashSet<Long>(1024);
        for (DynamicObject row : orgEntrys) {
            if (null == row.getDynamicObject("orgname")) continue;
            orgIdSet.add(row.getDynamicObject("orgname").getLong("id"));
        }
        PmmProtocolValidatorService service = new PmmProtocolValidatorService();
        ArrayList protocolInfoAllOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_ALL), dynamicObject);
        ArrayList protocolInfoPartOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_PART), dynamicObject);
        ArrayList protocolInfoAreas = service.filterProtocol(protocolGroupInfos.get(KEY_AREA), dynamicObject);
        boolean isExit = false;
        if (protocolInfoAllOrgs.size() > 0) {
            for (Object info : protocolInfoAllOrgs) {
                Set<Long> diffMaterialIdSet;
                if (materialSet.size() == 0 || null == info.getMaterialIds() || info.getMaterialIds().size() == 0) {
                    String msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5df2\u5b58\u5728\u5168\u96c6\u56e2\u5171\u4eab\u7684\u534f\u8bae({0})\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                    this.addErrorMessage(extendedDataEntity, msg);
                    isExit = true;
                    break;
                }
                if (materialSet.size() <= 0 || (diffMaterialIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds())).size() <= 0) continue;
                String msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u5168\u96c6\u56e2\u5171\u4eab\u4e14\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                this.addErrorMessage(extendedDataEntity, msg);
                isExit = true;
                break;
            }
            if (isExit) {
                return;
            }
        }
        StringBuilder strBuffer = new StringBuilder();
        if (protocolInfoPartOrgs.size() > 0) {
            for (ProtocolInfo info : protocolInfoPartOrgs) {
                Object msg;
                String msg2;
                Long orgId;
                Map orgId_orgNameMap;
                List orgIds = info.getOrgIds();
                Set<Long> diffOrgIdSet = this.getDiffIdSet(orgIdSet, orgIds);
                strBuffer.setLength(0);
                strBuffer.append(this.getDateString(info.getEffectdate())).append('-').append(this.getDateString(info.getInvaliddate()));
                if (diffOrgIdSet.size() <= 0) continue;
                if (materialSet.size() > 0) {
                    if (null == info.getMaterialIds() || info.getMaterialIds().size() == 0) {
                        orgId_orgNameMap = info.getOrgId_orgNameMap();
                        Iterator iterator = diffOrgIdSet.iterator();
                        while (iterator.hasNext()) {
                            orgId = (Long)iterator.next();
                            msg2 = ResManager.loadKDString((String)"{0}\u5728{1}\u671f\u95f4\u5185\u5b58\u5728\u4ea4\u53c9\u534f\u8bae\u201c{2}\u201d", (String)"PmmProtocolUniqueValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[]{orgId_orgNameMap.get(orgId), strBuffer, info.getProtocolBillNo()});
                            this.addErrorMessage(extendedDataEntity, msg2);
                        }
                        isExit = true;
                        break;
                    }
                    Set<Long> diffMaterialIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds());
                    if (diffMaterialIdSet.size() <= 0) continue;
                    msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u6309\u7ec4\u7ec7\u9694\u79bb\u53ca\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                    this.addErrorMessage(extendedDataEntity, (String)msg);
                    isExit = true;
                    break;
                }
                orgId_orgNameMap = info.getOrgId_orgNameMap();
                msg = diffOrgIdSet.iterator();
                while (msg.hasNext()) {
                    orgId = (Long)msg.next();
                    msg2 = ResManager.loadKDString((String)"{0}\u5728{1}\u671f\u95f4\u5185\u5b58\u5728\u4ea4\u53c9\u534f\u8bae\u201c{2}\u201d", (String)"PmmProtocolUniqueValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[]{orgId_orgNameMap.get(orgId), strBuffer, info.getProtocolBillNo()});
                    this.addErrorMessage(extendedDataEntity, msg2);
                }
                isExit = true;
                break;
            }
            if (isExit) {
                return;
            }
        }
        if (protocolInfoAreas.size() > 0) {
            String msg;
            if (materialSet.size() == 0) {
                for (ProtocolInfo info : protocolInfoAreas) {
                    List orgId_materialIds = info.getOrgId_materialIds();
                    for (String key : orgId_materialIds) {
                        String orgId = key.split("_")[0];
                        if (!orgIdSet.contains(Long.parseLong(orgId))) continue;
                        msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5df2\u5b58\u5728\u6309\u7ec4\u7ec7\u9694\u79bb\u7684\u534f\u8bae({0})\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_4", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                        this.addErrorMessage(extendedDataEntity, msg);
                        isExit = true;
                        break;
                    }
                    if (!isExit) continue;
                    break;
                }
            }
            if (materialSet.size() > 0) {
                List<String> srcOrgId_materialIds = this.getOrgIdMaterialIds(materialSet, orgIdSet);
                for (ProtocolInfo info : protocolInfoAreas) {
                    List orgId_materialIds = info.getOrgId_materialIds();
                    for (String key : srcOrgId_materialIds) {
                        if (!orgId_materialIds.contains(key)) continue;
                        msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u6309\u7ec4\u7ec7\u9694\u79bb\u53ca\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                        this.addErrorMessage(extendedDataEntity, msg);
                        isExit = true;
                        break;
                    }
                    if (!isExit) continue;
                    break;
                }
            }
        }
    }

    private void checkAllOrgProtocol(Map<String, ArrayList<ProtocolInfo>> protocolGroupInfos, ExtendedDataEntity extendedDataEntity) {
        String msg;
        String msg2;
        DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
        DynamicObjectCollection materialEntrys = dynamicObject.getDynamicObjectCollection("entryentity1");
        HashSet<Long> materialSet = new HashSet<Long>(1024);
        for (DynamicObject row : materialEntrys) {
            if (null == row.getDynamicObject("material")) continue;
            materialSet.add(row.getDynamicObject("material").getLong("id"));
        }
        PmmProtocolValidatorService service = new PmmProtocolValidatorService();
        ArrayList protocolInfoAllOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_ALL), dynamicObject);
        ArrayList protocolInfoPartOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_PART), dynamicObject);
        ArrayList protocolInfoAreas = service.filterProtocol(protocolGroupInfos.get(KEY_AREA), dynamicObject);
        boolean isExit = false;
        if (protocolInfoAllOrgs.size() > 0) {
            for (Object info : protocolInfoAllOrgs) {
                Set<Long> diffMaterialIdSet;
                if (materialSet.size() == 0 || null == info.getMaterialIds() || info.getMaterialIds().size() == 0) {
                    msg2 = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5df2\u5b58\u5728\u5168\u96c6\u56e2\u5171\u4eab\u7684\u534f\u8bae({0})\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                    this.addErrorMessage(extendedDataEntity, msg2);
                    isExit = true;
                    break;
                }
                if (materialSet.size() <= 0 || (diffMaterialIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds())).size() <= 0) continue;
                msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_5", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                this.addErrorMessage(extendedDataEntity, msg);
                isExit = true;
                break;
            }
            if (isExit) {
                return;
            }
        }
        if (protocolInfoPartOrgs.size() > 0 || protocolInfoAreas.size() > 0) {
            if (materialSet.size() == 0) {
                StringBuilder msgBuilder = new StringBuilder();
                for (ProtocolInfo info : protocolInfoPartOrgs) {
                    msgBuilder.append(info.getProtocolBillNo()).append(';');
                }
                for (ProtocolInfo info : protocolInfoAreas) {
                    msgBuilder.append(info.getProtocolBillNo()).append(';');
                }
                if (msgBuilder.length() > 0) {
                    String msg3 = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5df2\u5b58\u5728\u6309\u7ec4\u7ec7\u9694\u79bb\u7684\u534f\u8bae({0})\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_4", (String)"scm-pmm-opplugin", (Object[])new Object[]{msgBuilder.subSequence(0, msgBuilder.length() - 1)});
                    this.addErrorMessage(extendedDataEntity, msg3);
                    return;
                }
            } else {
                Set<Long> diffIdSet;
                for (Object info : protocolInfoPartOrgs) {
                    if (null == info.getMaterialIds() || info.getMaterialIds().size() == 0) {
                        msg2 = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5df2\u5b58\u5728\u6309\u7ec4\u7ec7\u9694\u79bb\u7684\u534f\u8bae({0})\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_4", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                        this.addErrorMessage(extendedDataEntity, msg2);
                        isExit = true;
                        break;
                    }
                    diffIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds());
                    if (diffIdSet.size() <= 0) continue;
                    msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_5", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                    this.addErrorMessage(extendedDataEntity, msg);
                    isExit = true;
                    break;
                }
                if (isExit) {
                    return;
                }
                for (Object info : protocolInfoAreas) {
                    diffIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds());
                    if (diffIdSet.size() <= 0) continue;
                    msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolUniqueValidator_5", (String)"scm-pmm-opplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                    this.addErrorMessage(extendedDataEntity, msg);
                    break;
                }
            }
        }
    }

    private Set<Long> getDiffIdSet(Set<Long> srcMaterialIdSet, List<Long> tarMaterials) {
        HashSet<Long> diffMaterialIds = new HashSet<Long>(1024);
        if (null == tarMaterials || tarMaterials.size() == 0) {
            return srcMaterialIdSet;
        }
        for (Long id : srcMaterialIdSet) {
            if (!tarMaterials.contains(id)) continue;
            diffMaterialIds.add(id);
        }
        return diffMaterialIds;
    }

    private Set<Long> getSupplierIdSet(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> supIdSet = new HashSet<Long>(1024);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            if (null != dynamicObject.getDynamicObject("partyb")) {
                supIdSet.add(dynamicObject.getDynamicObject("partyb").getLong("id"));
            }
            if (null == dynamicObject.get("partyb_id")) continue;
            supIdSet.add(dynamicObject.getLong("partyb_id"));
        }
        return supIdSet;
    }

    private String getDateString(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate.format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
    }
}

