/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.service.IPmmProtocolService;

public class PmmProtocolServiceImpl
implements IPmmProtocolService {
    private static Log log = LogFactory.getLog(PmmProtocolServiceImpl.class);

    public Map<String, Object> updateProtocolStatus(Map<String, Object> paramMap) throws Exception {
        log.info("updateProtocolStatus\u4f9b\u5e94\u94fe\u53c2\u6570" + paramMap);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(1024);
        dataMap.put("status", "all");
        dataMap.put("errmsg", "");
        String optype = String.valueOf(paramMap.get("optype"));
        List bills = (List)paramMap.get("bills");
        String conSelectors = "id,billno,protocolstatus,billstatus";
        QFilter conQFilter = new QFilter("srcid", "in", (Object)bills);
        DynamicObject[] cons = BusinessDataServiceHelper.load((String)"pmm_protocol", (String)conSelectors, (QFilter[])conQFilter.toArray());
        switch (optype) {
            case "bizinvalid": 
            case "bizterminate": {
                this.doUpdateProtocilStatus(cons, optype, dataMap);
                break;
            }
        }
        return dataMap;
    }

    private void doUpdateProtocilStatus(DynamicObject[] cons, String optype, Map<String, Object> dataMap) {
        ArrayList<DynamicObject> needWriteDyn = new ArrayList<DynamicObject>(1024);
        HashSet<Long> submitDyn = new HashSet<Long>(1024);
        HashSet<Long> saveDyn = new HashSet<Long>(1024);
        for (DynamicObject info : cons) {
            if ("C".equals(info.getString("billstatus"))) {
                needWriteDyn.add(info);
            }
            if ("A".equals(info.getString("billstatus"))) {
                saveDyn.add(info.getLong("id"));
            }
            if (!"B".equals(info.getString("billstatus"))) continue;
            submitDyn.add(info.getLong("id"));
        }
        HashSet<Long> bizinvalidSet = new HashSet<Long>(1024);
        HashSet<Long> bizterminateSet = new HashSet<Long>(1024);
        if (needWriteDyn.size() > 0) {
            for (DynamicObject info : needWriteDyn) {
                if ("bizinvalid".equals(optype)) {
                    bizinvalidSet.add(info.getLong("id"));
                }
                if (!"bizterminate".equals(optype)) continue;
                bizterminateSet.add(info.getLong("id"));
            }
            log.info("bizinvalidSet=" + SerializationUtils.toJsonString(bizinvalidSet));
            log.info("bizterminateSet=" + SerializationUtils.toJsonString(bizterminateSet));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ishasright", "true");
        if (bizinvalidSet.size() > 0) {
            this.doOperate("invalid", option, dataMap, bizinvalidSet);
        }
        if (bizterminateSet.size() > 0) {
            this.doOperate("protocolend", option, dataMap, bizterminateSet);
        }
        if (submitDyn.size() > 0) {
            OperationResult unauditResullt = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"pmm_protocol", (Object[])submitDyn.toArray(), (OperateOption)option);
            String errmsg = null;
            if (!unauditResullt.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)unauditResullt.getAllErrorOrValidateInfo()));
                errmsg = ExceptionUtil.getErrorInfoDetails((List)unauditResullt.getAllErrorOrValidateInfo());
                dataMap.put("status", "part");
                dataMap.put("errmsg", errmsg);
            } else {
                this.doOperate("delete", option, dataMap, submitDyn);
            }
        }
        if (saveDyn.size() > 0) {
            this.doOperate("delete", option, dataMap, saveDyn);
        }
    }

    private void doOperate(String optiopntype, OperateOption option, Map<String, Object> dataMap, Set<Long> idSet) {
        OperationResult deleteResullt = OperationServiceHelper.executeOperate((String)optiopntype, (String)"pmm_protocol", (Object[])idSet.toArray(), (OperateOption)option);
        String errmsg = null;
        if (!deleteResullt.isSuccess()) {
            log.info(optiopntype + "----" + ExceptionUtil.getErrorInfoDetails((List)deleteResullt.getAllErrorOrValidateInfo()));
            errmsg = ExceptionUtil.getErrorInfoDetails((List)deleteResullt.getAllErrorOrValidateInfo());
            dataMap.put("status", "part");
            dataMap.put("errmsg", errmsg);
        }
    }
}

