/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.helper.datahandle.utils.ExceptionWrapper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.service.PmmEcIscSchemaManageService;

public class PmmEcIscSchemaManageServiceImpl
implements PmmEcIscSchemaManageService {
    private static final Log log = LogFactory.getLog((String)PmmEcIscSchemaManageServiceImpl.class.getName());

    public void updateEcIscSchema(String filePath) {
        try {
            InputStream in = PmmEcIscSchemaManageServiceImpl.class.getResourceAsStream(filePath);
            ZipInputStream zipInputStream = new ZipInputStream(in, Charset.forName("GBK"));
            this.decompressionFileAndImport(zipInputStream);
        }
        catch (Exception e) {
            log.info("EcIscSchemaImportAction.doExecute\u6267\u884c\u5bfc\u5165\u96c6\u6210\u65b9\u6848\u5f02\u5e38:" + ExceptionUtil.getStackTrace((Throwable)e));
            ExceptionWrapper.wrapExceptions((boolean)false, (String)ResManager.loadKDString((String)"EcIscSchemaImportAction.doExecute\u6267\u884c\u5bfc\u5165\u96c6\u6210\u65b9\u6848\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u53f0\u65e5\u5fd7\u3002", (String)"EcIscSchemaImportAction_1", (String)"scm-pmm-mservice", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompressionFileAndImport(ZipInputStream inputStream) throws IOException {
        ByteArrayOutputStream buffer = null;
        try {
            ZipEntry nextEntry = inputStream.getNextEntry();
            while (nextEntry != null) {
                String name = nextEntry.getName();
                if (!name.endsWith("/")) {
                    int n;
                    byte[] bytes = new byte[1024];
                    buffer = new ByteArrayOutputStream();
                    while ((n = inputStream.read(bytes)) != -1) {
                        buffer.write(bytes, 0, n);
                    }
                    byte[] be = buffer.toByteArray();
                    String str = new String(be, StandardCharsets.UTF_8);
                    this.realImport(str);
                }
                inputStream.closeEntry();
                nextEntry = inputStream.getNextEntry();
            }
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
            if (null != buffer) {
                buffer.close();
            }
        }
    }

    private void realImport(String str) {
        DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"importResourceWithPattern", (Object[])new Object[]{str, true});
    }
}

