/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pmm.business.model.product.ProdMatMapping;
import kd.scm.pmm.business.service.impl.ProdMatMappingServiceImpl;
import kd.scm.pmm.service.IPmmMatMappingService;

public class PmmMatMappingServiceImpl
implements IPmmMatMappingService {
    public Map<Long, Long> syncProdMaterialMapping(Map<Long, Long> goodsIdMaterialIdMap) {
        if (goodsIdMaterialIdMap == null || goodsIdMaterialIdMap.isEmpty()) {
            return new HashMap<Long, Long>();
        }
        HashSet<ProdMatMapping> prodMatMappings = new HashSet<ProdMatMapping>(goodsIdMaterialIdMap.size());
        for (Map.Entry<Long, Long> entry : goodsIdMaterialIdMap.entrySet()) {
            prodMatMappings.add(new ProdMatMapping(entry.getKey(), entry.getValue()));
        }
        ProdMatMappingServiceImpl prodMatMappingService = new ProdMatMappingServiceImpl();
        return prodMatMappingService.saveProdMatMappingWithRes(prodMatMappings);
    }

    public Map<Long, List<Long>> getMaterialIdsByGoodsCategoryMapping(Long goodsCategoryId) {
        return new ProdMatMappingServiceImpl().getMaterialIdsByGoodsCategoryMapping(goodsCategoryId);
    }

    public Map<Long, Long> queryProdMaterialMapping(List<Map<String, Object>> goodsMappingArgs) {
        LinkedHashMap<Long, Long> res = new LinkedHashMap<Long, Long>(goodsMappingArgs.size() << 2);
        ArrayList<Long> goodsIds = new ArrayList<Long>(goodsMappingArgs.size());
        ArrayList<String> protocolNos = new ArrayList<String>(goodsMappingArgs.size());
        HashMap<Long, List<Long>> categoryIdToGoodsIdsMap = new HashMap<Long, List<Long>>(goodsMappingArgs.size() << 2);
        HashMap<Long, List<Long>> purTypeIdToGoodsIdsMap = new HashMap<Long, List<Long>>(goodsMappingArgs.size() << 2);
        for (Map<String, Object> arg : goodsMappingArgs) {
            Long goodsId = (Long)arg.get("goodsId");
            Long categoryId = (Long)arg.get("categoryId");
            Long purTypeId = (Long)arg.get("purchaseTypeId");
            String protocolNo = (String)arg.get("protocolNo");
            if (StringUtils.isNotBlank((CharSequence)protocolNo)) {
                protocolNos.add(protocolNo);
            }
            if (goodsId == null) continue;
            goodsIds.add(goodsId);
            if (categoryId != null) {
                List categoryOfGoodsIds = categoryIdToGoodsIdsMap.computeIfAbsent(categoryId, s -> new ArrayList());
                categoryOfGoodsIds.add(goodsId);
            }
            if (purTypeId == null) continue;
            List purTypeOfGoodsIds = purTypeIdToGoodsIdsMap.computeIfAbsent(purTypeId, s -> new ArrayList());
            purTypeOfGoodsIds.add(goodsId);
        }
        res.putAll(this.queryFromProdMatMapping(goodsIds, categoryIdToGoodsIdsMap, purTypeIdToGoodsIdsMap));
        res.putAll(this.queryFromProdAudit(goodsIds, protocolNos));
        return res;
    }

    private Map<Long, Long> queryFromProdAudit(List<Long> goodsIds, List<String> protocolNos) {
        HashMap<Long, Long> res = new HashMap<Long, Long>(goodsIds.size() << 2);
        QFilter qFilter = new QFilter("entryentity.goods", "in", goodsIds);
        qFilter.and(new QFilter("protocolid.billno", "in", protocolNos));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("entryentity.entryresult", "=", (Object)"1"));
        String selectFields = "entryentity.material.id,entryentity.goods.id,protocolid.billno";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pmm_prodaudit", (String)selectFields, (QFilter[])qFilter.toArray(), null);){
            ds.forEach(row -> {
                long materialId = row.getLong("entryentity.material.id");
                long goodsId = row.getLong("entryentity.goods.id");
                if (materialId != 0L) {
                    res.put(goodsId, materialId);
                }
            });
        }
        return res;
    }

    private Map<Long, Long> queryFromProdMatMapping(List<Long> goodsIds, Map<Long, List<Long>> categoryIdToGoodsIdsMap, Map<Long, List<Long>> purTypeIdToGoodsIdsMap) {
        HashMap<Long, Long> categoryAndMaterialMap = new HashMap<Long, Long>(goodsIds.size());
        HashMap<Long, Long> purTypeAndMaterialMap = new HashMap<Long, Long>(goodsIds.size());
        HashMap<Long, Long> res = new HashMap<Long, Long>();
        QFilter prodfilters = new QFilter("goods", "in", goodsIds);
        prodfilters.or("category", "in", categoryIdToGoodsIdsMap.keySet());
        prodfilters.or("purchasetype", "in", purTypeIdToGoodsIdsMap.keySet());
        String selectedFields = "goods.id,material.id,category.id,purchasetype.id";
        try (DataSet prodMappingDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pmm_prodmatmapping", (String)selectedFields, (QFilter[])new QFilter[]{prodfilters}, (String)"modifytime desc");){
            prodMappingDs.forEach(row -> {
                Long goodsId = row.getLong("goods.id");
                Long purchaseTypeId = row.getLong("purchasetype.id");
                Long categoryId = row.getLong("category.id");
                Long materialId = row.getLong("material.id");
                if (categoryId != 0L) {
                    categoryAndMaterialMap.put(categoryId, materialId);
                }
                if (purchaseTypeId != 0L) {
                    purTypeAndMaterialMap.put(purchaseTypeId, materialId);
                }
                if (goodsId != 0L) {
                    res.put(goodsId, materialId);
                }
            });
        }
        categoryAndMaterialMap.forEach((category, material) -> {
            List categoryOfGoodsIds = (List)categoryIdToGoodsIdsMap.get(category);
            for (Long goodsId : categoryOfGoodsIds) {
                res.computeIfAbsent(goodsId, k -> material);
            }
        });
        purTypeAndMaterialMap.forEach((purType, material) -> {
            List purTypeOfGoodsIds = (List)purTypeIdToGoodsIdsMap.get(purType);
            for (Long goodsId : purTypeOfGoodsIds) {
                res.computeIfAbsent(goodsId, k -> material);
            }
        });
        return res;
    }
}

