/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service.ecinit;

import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.service.ecinit.EcInitResultManager;
import kd.scm.pmm.service.ecinit.EcInitializeContext;
import kd.scm.pmm.service.ecinit.IEcInitializeAction;
import kd.scm.pmm.service.ecinit.utils.ExceptionWrapper;

public abstract class AbstractEcInitializeAction
implements IEcInitializeAction {
    private static final Log log = LogFactory.getLog(AbstractEcInitializeAction.class);
    private EcInitializeContext context;
    private Long subTaskId;
    private EcInitResultManager resultManager;

    @Override
    public final void execute() {
        this.doExecute();
    }

    public abstract void doExecute();

    public EcInitializeContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(EcInitializeContext context) {
        this.context = context;
    }

    public Long getSubTaskId() {
        return this.subTaskId;
    }

    @Override
    public void setSubTaskId(Long subTaskId) {
        this.subTaskId = subTaskId;
    }

    public EcInitResultManager getResultManager() {
        return this.resultManager;
    }

    @Override
    public void setResultManager(EcInitResultManager resultManager) {
        this.resultManager = resultManager;
    }

    public String getDirPathPrefix() {
        String dirName = this.context.getTaskConfig().getString("sourcename");
        return "/kd/scm/pmm/" + dirName;
    }

    public void checkFilePath(String path, String msg) {
        URL url = AbstractEcInitializeAction.class.getResource(path);
        if (null == url) {
            throw new KDBizException(msg);
        }
    }

    public String getEcTypeName() {
        String ecType = this.context.getTaskConfig().getString("platform");
        return EcPlatformEnum.fromVal((String)ecType).getName();
    }

    public OperationResult doOperationByDataEntities(String entity, String opKey, DynamicObject[] dataEntities, OperateOption option) {
        OperationResult opResult = OperationServiceHelper.executeOperate((String)opKey, (String)entity, (DynamicObject[])dataEntities, (OperateOption)option);
        if (null != opResult && !opResult.isSuccess()) {
            String err = ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo());
            log.info("AbstractEcInitializeAction.doOperationByDataEntities\u6267\u884c\u64cd\u4f5c\uff1a" + opKey + "\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + err);
            ExceptionWrapper.wrapExceptions(this.getContext().isIgnoreException(), MessageFormat.format(ResManager.loadKDString((String)"{0}\u6267\u884c{1}\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0\uff1a{2}", (String)"AbstractEcInitializeAction_0", (String)"scm-pmm-mservice", (Object[])new Object[0]), EntityMetadataCache.getDataEntityType((String)entity).getDisplayName(), opKey, opResult.getMessage() + err));
        }
        return opResult;
    }

    public OperationResult doOperationByIds(String entity, String opKey, Object[] ids, OperateOption option) {
        OperationResult opResult = OperationServiceHelper.executeOperate((String)opKey, (String)entity, (Object[])ids, (OperateOption)option);
        if (null != opResult && !opResult.isSuccess()) {
            String err = ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo());
            log.info("AbstractEcInitializeAction.doOperationByIds\u6267\u884c\u64cd\u4f5c\uff1a" + opKey + "\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + err);
            ExceptionWrapper.wrapExceptions(this.getContext().isIgnoreException(), MessageFormat.format(ResManager.loadKDString((String)"{0}\u6267\u884c{1}\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0\uff1a{2}", (String)"AbstractEcInitializeAction_0", (String)"scm-pmm-mservice", (Object[])new Object[0]), EntityMetadataCache.getDataEntityType((String)entity).getDisplayName(), opKey, opResult.getMessage() + err));
        }
        return opResult;
    }

    public OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        return option;
    }

    protected void monitorServiceFlow(String serviceFlowNumber, int wiatTime, String expStr) {
        boolean flag = true;
        boolean success = false;
        int times = 0;
        try {
            Long instanceId = ApiAccessor.invokeServiceFlow((String)serviceFlowNumber);
            while (flag) {
                Thread.sleep(wiatTime * 1000);
                Map flowResultMap = ApiAccessor.getServiceFlowState((Long)instanceId);
                String state = Parser.toString(flowResultMap.get("state"));
                if (StringUtils.equals((CharSequence)"Complete", (CharSequence)state) || StringUtils.equals((CharSequence)"Terminated", (CharSequence)state)) {
                    flag = false;
                    success = true;
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"Failed", (CharSequence)state)) continue;
                if (times <= 3) {
                    ApiAccessor.retryServiceFlow((Long)instanceId);
                    ++times;
                    continue;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u76d1\u63a7\u5f02\u5e38\uff1a", (String)"AbstractEcInitializeAction_1", (String)"scm-pmm-mservice", (Object[])new Object[0]);
            ExceptionWrapper.wrapExceptions(this.getContext().isIgnoreException(), msg + ExceptionUtil.getStackTrace((Throwable)e));
        }
        if (!success) {
            ExceptionWrapper.wrapExceptions(this.getContext().isIgnoreException(), expStr);
        }
    }
}

