/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service.ecinit.action;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pmm.common.enums.TaskStatusEnum;
import kd.scm.pmm.service.ecinit.AbstractEcInitializeAction;
import kd.scm.pmm.service.ecinit.EcInitResult;

public class EcDtsDataSyncConfigPresetAction
extends AbstractEcInitializeAction {
    private static final Log log = LogFactory.getLog(EcDtsDataSyncConfigPresetAction.class);
    private static final String DATASYNCADDRESS = "datasyncaddress";
    private static final String DATA_SYNC_CONFIG = "data_sync_config";
    private static final String DEFUALT_REGION_VALUE = "pur";
    private static final String DESTINATIONTYPE_VALUE = "fulltext";
    private static final String DESTINATIONTYPE = "destinationtype";
    private static final String REGION = "region";
    private static final String MAPPINGRULE = "mappingrule";
    private static final String PUR_SELFMAL_ES = "pur_selfmal_es";
    private static final String PUR_MAL_ES = "pur_mal_es";
    private static final String BUSINESSTYPE = "businesstype";

    @Override
    public void doExecute() {
        log.info("EcDtsDataSyncConfigPresetAction.doExecute:\u6570\u636e\u540c\u6b65\u914d\u7f6e\u9879\u9884\u7f6e\u5f00\u59cb");
        EcInitResult ecInitResult = this.getResultManager().getEcInitResult();
        ecInitResult.upateEcInitResultDetail(this.getSubTaskId(), TaskStatusEnum.TASK_DOING.getValue());
        String region = this.createDataSyncAddrIfNotExisit();
        this.createPbdGoodsConfig(region);
        this.createPbdMalGoodsConfig(region);
        ecInitResult.upateEcInitResult(3, TaskStatusEnum.TASK_DOING.getValue());
        ecInitResult.upateEcInitResultDetail(this.getSubTaskId(), TaskStatusEnum.TASK_SUCCESS.getValue());
        log.info("EcDtsDataSyncConfigPresetAction.doExecute:\u6570\u636e\u540c\u6b65\u914d\u7f6e\u9879\u9884\u7f6e\u7ed3\u675f");
    }

    private String createDataSyncAddrIfNotExisit() {
        QFilter filter = new QFilter(DESTINATIONTYPE, "=", (Object)DESTINATIONTYPE_VALUE).and(new QFilter(REGION, "=", (Object)DEFUALT_REGION_VALUE));
        if (!QueryServiceHelper.exists((String)DATASYNCADDRESS, (QFilter[])new QFilter[]{filter})) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)DATASYNCADDRESS);
            obj.set(DESTINATIONTYPE, (Object)DESTINATIONTYPE_VALUE);
            obj.set(REGION, (Object)DEFUALT_REGION_VALUE);
            obj.set("addressproperties", (Object)" ");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            return DEFUALT_REGION_VALUE;
        }
        DynamicObject dyo = QueryServiceHelper.queryOne((String)DATASYNCADDRESS, (String)"id,region", (QFilter[])new QFilter[]{filter});
        return dyo.getString(REGION);
    }

    private void createPbdGoodsConfig(String region) {
        QFilter filter = new QFilter(MAPPINGRULE, "=", (Object)PUR_SELFMAL_ES).and(new QFilter(BUSINESSTYPE, "=", (Object)"pursearch"));
        if (!QueryServiceHelper.exists((String)DATA_SYNC_CONFIG, (QFilter[])new QFilter[]{filter})) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)DATA_SYNC_CONFIG);
            obj.set(BUSINESSTYPE, (Object)"pursearch");
            obj.set(DESTINATIONTYPE, (Object)DESTINATIONTYPE_VALUE);
            obj.set(REGION, (Object)region);
            obj.set("entitynumber", (Object)"pbd_goods");
            obj.set("entityfields", (Object)",id,number,model,mallstatus,thumbnail,source,supplier,category,shopprice,brand,");
            obj.set(MAPPINGRULE, (Object)PUR_SELFMAL_ES);
            obj.set("enable", (Object)"1");
            this.doOperationByDataEntities(DATA_SYNC_CONFIG, "save", new DynamicObject[]{obj}, this.getOperateOption());
        }
    }

    private void createPbdMalGoodsConfig(String region) {
        QFilter filter = new QFilter(MAPPINGRULE, "=", (Object)PUR_MAL_ES).and(new QFilter(BUSINESSTYPE, "=", (Object)"pursearch"));
        if (!QueryServiceHelper.exists((String)DATA_SYNC_CONFIG, (QFilter[])new QFilter[]{filter})) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)DATA_SYNC_CONFIG);
            obj.set(BUSINESSTYPE, (Object)"pursearch");
            obj.set(DESTINATIONTYPE, (Object)DESTINATIONTYPE_VALUE);
            obj.set(REGION, (Object)region);
            obj.set("entitynumber", (Object)"pbd_mallgoods");
            obj.set("entityfields", (Object)",id,number,name,group,model,brandid,source,mainpic,");
            obj.set(MAPPINGRULE, (Object)PUR_MAL_ES);
            obj.set("enable", (Object)"1");
            this.doOperationByDataEntities(DATA_SYNC_CONFIG, "save", new DynamicObject[]{obj}, this.getOperateOption());
        }
    }
}

