/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service.ecinit.sqlimport.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.service.ecinit.sqlimport.SqlImportService;

public class SqlImportServiceImpl
implements SqlImportService {
    private static final Log log = LogFactory.getLog(SqlImportServiceImpl.class);

    @Override
    public boolean excuteSqlFileByFilePath(String filePath, DBRoute dbRoute) {
        String sqlStr = "";
        try {
            sqlStr = this.readAllFileLines(filePath);
        }
        catch (Exception e) {
            log.info("SqlImportServiceImpl.excuteSqlFileByFilePath\u6267\u884c\u5f02\u5e38:" + ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(ResManager.loadKDString((String)"SqlImportServiceImpl.excuteSqlFileByFilePath\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u53f0\u65e5\u5fd7\u3002", (String)"SqlImportServiceImpl_0", (String)"scm-pmm-mservice", (Object[])new Object[0]));
        }
        return this.excuteSql(dbRoute, sqlStr);
    }

    @Override
    public boolean batchExcuteSqlFileByFilePath(int batchRowSize, String filePath, DBRoute dbRoute) {
        boolean resFlag = true;
        return resFlag;
    }

    private String readAllFileLines(String filePath) throws IOException {
        StringBuilder str = new StringBuilder();
        try (InputStream in = SqlImportServiceImpl.class.getResourceAsStream(filePath);
             InputStreamReader inReader = new InputStreamReader(in, "utf-8");
             BufferedReader reader = new BufferedReader(inReader);){
            String tempstring = null;
            while ((tempstring = reader.readLine()) != null) {
                str.append(tempstring);
            }
        }
        return str.toString();
    }

    private void saveClose(Closeable o) {
        if (null != o) {
            try {
                o.close();
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u6d41\u5f02\u5e38:" + ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    @Override
    public boolean batchExcuteSqlFileByZipFile(int batchRowSize, String filePath, DBRoute dbRoute) {
        boolean resFlag = true;
        StringBuilder str = new StringBuilder();
        BufferedReader reader = null;
        ByteArrayOutputStream zos = null;
        ZipInputStream zipInputStream = null;
        InputStream in = null;
        int i = 0;
        int len = -1;
        byte[] b = new byte[10240];
        try {
            in = SqlImportServiceImpl.class.getResourceAsStream(filePath);
            zipInputStream = new ZipInputStream(in, Charset.forName("utf-8"));
            ZipEntry nextEntry = zipInputStream.getNextEntry();
            while (nextEntry != null) {
                String name = nextEntry.getName();
                if (name.endsWith("/")) continue;
                zos = new ByteArrayOutputStream();
                while ((len = zipInputStream.read(b)) > -1) {
                    zos.write(b, 0, len);
                }
                reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(zos.toByteArray()), "utf-8"));
                String tempstring = null;
                while ((tempstring = reader.readLine()) != null) {
                    str.append(tempstring);
                    if (++i != batchRowSize) continue;
                    resFlag = this.excuteSql(dbRoute, str.toString());
                    i = 0;
                    str.setLength(0);
                }
                resFlag = this.excuteSql(dbRoute, str.toString());
                i = 0;
                zipInputStream.closeEntry();
                nextEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            log.info("SqlImportServiceImpl.batchExcuteSqlFileByZipFile\u6267\u884c\u5f02\u5e38:" + ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(ResManager.loadKDString((String)"SqlImportServiceImpl.batchExcuteSqlFileByZipFile\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u53f0\u65e5\u5fd7\u3002", (String)"SqlImportServiceImpl_3", (String)"scm-pmm-mservice", (Object[])new Object[0]));
        }
        finally {
            if (null != reader) {
                this.saveClose(reader);
            }
            if (null != zos) {
                this.saveClose(zos);
            }
            if (null != zipInputStream) {
                this.saveClose(zipInputStream);
            }
            if (null != in) {
                this.saveClose(in);
            }
        }
        return resFlag;
    }

    private boolean excuteSql(DBRoute dbRoute, String sqlStr) {
        return DB.execute((DBRoute)dbRoute, (String)sqlStr);
    }
}

