/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service.event;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.malcore.enums.MallStatusEnum;

public class PmmSupplierDisableSoldOutGoodsPlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(PmmSupplierDisableSoldOutGoodsPlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        logger.info("bd_supplier.disable.soldOutGoodsPlugin start");
        logger.info("EntityEventNumber:" + evt.getEventNumber() + ", EntityEventId" + evt.getEventId());
        EntityEvent entityEvent = null;
        if (evt instanceof EntityEvent) {
            entityEvent = (EntityEvent)evt;
        }
        if (entityEvent == null) {
            logger.info("bd_supplier.disable.soldOutGoodsPlugin: evt == null");
            return evt.getEventId();
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(entityEvent.getBusinesskeys().size());
        for (String businessKey : entityEvent.getBusinesskeys()) {
            pkIds.add(Long.valueOf(businessKey));
        }
        this.soldOutGoods(pkIds);
        return evt.getEventId();
    }

    private void soldOutGoods(List<Long> pkIds) {
        QFilter qFilter = new QFilter("supplier", "in", pkIds);
        qFilter.and(new QFilter("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.UNSOLD.getVal()).or("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()));
        DynamicObjectCollection pmmProdManageArray = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,protocolentry.prodpool prodpool", (QFilter[])qFilter.toArray());
        ArrayList<Long> prodPools = new ArrayList<Long>(pmmProdManageArray.size());
        for (DynamicObject dyo : pmmProdManageArray) {
            prodPools.add(dyo.getLong("prodpool"));
        }
        logger.info("\u8be5\u4f9b\u5e94\u5546\u4e0b\u7684\u5546\u54c1\u6c60\u6570\u91cf\uff1a" + prodPools.size());
        if (prodPools.isEmpty()) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"download", (String)"pmm_prodpool", (Object[])prodPools.toArray(), (OperateOption)option);
        if (operationResult.isSuccess()) {
            logger.info("\u4f9b\u5e94\u5546\u4e0b\u6240\u6709\u5546\u54c1\u4e0b\u67b6\u6210\u529f" + operationResult.getSuccessPkIds());
        } else {
            StringBuilder message = new StringBuilder();
            for (IOperateInfo operateInfo : operationResult.getAllErrorOrValidateInfo()) {
                message.append(operateInfo.getMessage());
            }
            logger.info("\u4f9b\u5e94\u5546\u4e0b\u6240\u6709\u5546\u54c1\u4e0b\u67b6\u5931\u8d25" + message);
        }
        logger.info("bd_supplier.disable.soldOutGoodsPlugin end");
    }
}

