/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.model.mainpageconfig;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.pmm.business.model.mainpageconfig.Banner;
import kd.scm.pmm.business.model.mainpageconfig.BottomBox;
import kd.scm.pmm.business.model.mainpageconfig.CardBody;
import kd.scm.pmm.business.model.mainpageconfig.CardOption;
import kd.scm.pmm.business.model.mainpageconfig.Category;
import kd.scm.pmm.business.model.mainpageconfig.CategoryGoods;
import kd.scm.pmm.business.model.mainpageconfig.ComponentType;
import kd.scm.pmm.business.model.mainpageconfig.Enterprise;
import kd.scm.pmm.business.model.mainpageconfig.Floors;
import kd.scm.pmm.business.model.mainpageconfig.Goods;
import kd.scm.pmm.business.model.mainpageconfig.Link;
import kd.scm.pmm.business.model.mainpageconfig.Logo;
import kd.scm.pmm.business.model.mainpageconfig.MalSwiper;
import kd.scm.pmm.business.model.mainpageconfig.NavMenuData;
import kd.scm.pmm.business.model.mainpageconfig.ScenesCardDataInfo;
import kd.scm.pmm.business.model.mainpageconfig.ScenesCardGoodsInfo;
import kd.scm.pmm.business.model.mainpageconfig.ScenesCategoryGoodsDataInfo;
import kd.scm.pmm.business.model.mainpageconfig.Store;
import kd.scm.pmm.business.model.mainpageconfig.SwiperOption;
import kd.scm.pmm.business.model.mainpageconfig.SwiperSlide;
import kd.scm.pmm.business.model.product.PmmProdObtain;
import kd.scm.pmm.business.model.product.ProductObtainResult;
import kd.scm.pmm.business.service.PmmBusinessServiceFactory;
import kd.scm.pmm.business.service.PmmProductObtainService;

public class MainPageConfig {
    private static final Log log = LogFactory.getLog((String)MainPageConfig.class.getName());
    private static final String THEME_COLOR = "themeColor";
    private final DynamicObject dyn;
    private Map<String, Long> componentNameToIdMap;
    private Map<Object, String> idToComponentNameMap;
    private final String userThemeColor = String.valueOf(UserServiceHelper.getUserThemeNumAndVerNew((Long)RequestContext.get().getCurrUserId()).get("color"));

    public MainPageConfig(Long id) {
        this.dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"pmm_compconfig");
        this.initComponentNameIdMap();
    }

    public MainPageConfig(DynamicObject dyn) {
        this.dyn = dyn;
        this.initComponentNameIdMap();
    }

    private void initComponentNameIdMap() {
        this.componentNameToIdMap = new HashMap<String, Long>(16);
        this.idToComponentNameMap = new HashMap<Object, String>(16);
        DynamicObjectCollection entryCol = this.dyn.getDynamicObjectCollection("entryentity");
        ArrayList<Long> componentIds = new ArrayList<Long>();
        for (DynamicObject entry : entryCol) {
            componentIds.add(entry.getLong("component.id"));
        }
        Map componentDynMap = BusinessDataServiceHelper.loadFromCache((Object[])componentIds.toArray(), (String)"pmm_component");
        componentDynMap.forEach((id, componentDyn) -> {
            this.componentNameToIdMap.put(componentDyn.getString("group.compobject.number"), componentDyn.getLong("id"));
            this.idToComponentNameMap.put(componentDyn.get("id"), componentDyn.getString("group.compobject.number"));
        });
    }

    public Logo getLogo() {
        DynamicObject logoDyn;
        Logo logo = new Logo();
        Long logoId = this.componentNameToIdMap.get("pmm_logo");
        if (logoId != null && (logoDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)logoId, (String)"pmm_logo")) != null) {
            logo.setImgUrl(MainPageConfig.getPictureUrl(logoDyn.getString("picture")));
            logo.setBrowserIconUrl(MainPageConfig.getPictureUrl(logoDyn.getString("tabimg")));
        }
        return logo;
    }

    public List<NavMenuData> getNavMenuDataList() {
        DynamicObjectCollection categoryEntryCol = this.dyn.getDynamicObjectCollection("categoryentry");
        HashMap<String, String> standardSourceMap = new HashMap<String, String>();
        HashMap<String, NavMenuData> navMenuDataMap = new HashMap<String, NavMenuData>(categoryEntryCol.size() << 2);
        for (DynamicObject categoryEntry : categoryEntryCol) {
            NavMenuData parentMenuData;
            String parentId = categoryEntry.getString("category.parent.id");
            String id = categoryEntry.getString("category.id");
            String categoryNumber = categoryEntry.getString("category.number");
            int level = categoryEntry.getInt("category.level");
            int sort = categoryEntry.getInt("sort");
            String longNumber = categoryEntry.getString("category.longnumber");
            String name = categoryEntry.getString("category.name");
            NavMenuData navMenuData2 = new NavMenuData();
            navMenuData2.setNumber(categoryNumber);
            navMenuData2.setLevel(level);
            navMenuData2.setLongNumber(longNumber);
            navMenuData2.setSort(sort);
            navMenuData2.setName(name);
            navMenuData2.setId(id);
            String standardId = categoryEntry.getString("category.standard.id");
            String source = (String)standardSourceMap.get(standardId);
            if (StringUtils.isBlank((CharSequence)source)) {
                source = EcApiUtil.getSource((String)standardId);
                standardSourceMap.put(standardId, source);
            }
            navMenuData2.setSource(source);
            navMenuData2.setParentid(parentId);
            if (level <= 2) {
                navMenuDataMap.put(id, navMenuData2);
            }
            if ((parentMenuData = (NavMenuData)navMenuDataMap.get(parentId)) == null) continue;
            List<NavMenuData> children = parentMenuData.getChildren();
            if (children == null) {
                children = new ArrayList<NavMenuData>();
                parentMenuData.setChildren(children);
            }
            children.add(navMenuData2);
        }
        ArrayList<NavMenuData> navMenuDatas = new ArrayList<NavMenuData>(navMenuDataMap.size());
        navMenuDataMap.forEach((entryId, navMenuData) -> {
            if (navMenuData.getLevel() == 1) {
                navMenuDatas.add((NavMenuData)navMenuData);
                if (navMenuData.getChildren() != null) {
                    Collections.sort(navMenuData.getChildren());
                }
            }
        });
        Collections.sort(navMenuDatas);
        return navMenuDatas;
    }

    public String getSource() {
        return this.dyn.getString("goodsclass");
    }

    public MalSwiper getMalSwiper() {
        MalSwiper malSwiper = new MalSwiper();
        Long carouselId = this.componentNameToIdMap.get("pmm_carousel");
        if (carouselId != null) {
            DynamicObject malSwiperDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)carouselId, (String)"pmm_carousel");
            malSwiper.setBannerUrl(MainPageConfig.getPictureUrl(malSwiperDyn.getString("banner")));
            ArrayList<SwiperSlide> swiperSlides = new ArrayList<SwiperSlide>();
            malSwiper.setSwiperSlide(swiperSlides);
            SwiperOption swiperOption = new SwiperOption();
            swiperOption.setAutoplay(malSwiperDyn.getBoolean("isautoplay"));
            swiperOption.setDelay(malSwiperDyn.getInt("delay"));
            malSwiper.setOption(swiperOption);
            DynamicObjectCollection malSwiperEntryCol = malSwiperDyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject malSwiperEntry : malSwiperEntryCol) {
                SwiperSlide swiperSlide = new SwiperSlide();
                swiperSlide.setImgSrc(MainPageConfig.getPictureUrl(malSwiperEntry.getString("picture")));
                String productObtainId = malSwiperEntry.getString("entry_product_obtain.id");
                if (StringUtils.isNotBlank((CharSequence)productObtainId)) {
                    swiperSlide.setUrl(this.getProdObtainToSearchUrl(productObtainId));
                } else {
                    swiperSlide.setUrl(malSwiperEntry.getString("url"));
                }
                swiperSlide.setTitle(malSwiperEntry.getString("pic_title"));
                swiperSlide.setDesc(malSwiperEntry.getString("pic_desc"));
                swiperSlide.setTitleColor(malSwiperEntry.getString("font_color"));
                swiperSlide.setDescColor(malSwiperEntry.getString("desc_color"));
                swiperSlides.add(swiperSlide);
            }
        }
        return malSwiper;
    }

    public BottomBox getBottomBox() {
        DynamicObject pmmLinkDyn;
        BottomBox bottomBox = new BottomBox();
        bottomBox.setEnterprise(this.getEnterprice());
        Long pmmLink = this.componentNameToIdMap.get("pmm_link");
        if (pmmLink != null && (pmmLinkDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)pmmLink, (String)"pmm_link")) != null) {
            ArrayList<Link> links = new ArrayList<Link>();
            DynamicObjectCollection entryentity = pmmLinkDyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                Link link = new Link();
                link.setName(entry.getString("title"));
                link.setUrl(entry.getString("url"));
                links.add(link);
            }
            bottomBox.setLink(links);
        }
        return bottomBox;
    }

    private Enterprise getEnterprice() {
        DynamicObjectCollection entryentityCol;
        DynamicObject enterpriceDyn;
        Enterprise enterprise = new Enterprise();
        Long pmmEnterprise = this.componentNameToIdMap.get("pmm_enterprise");
        if (pmmEnterprise != null && (enterpriceDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)pmmEnterprise, (String)"pmm_enterprise")) != null && !(entryentityCol = enterpriceDyn.getDynamicObjectCollection("entryentity")).isEmpty()) {
            enterprise.setIntroduce(((DynamicObject)entryentityCol.get(0)).getString("information"));
        }
        return enterprise;
    }

    /*
     * WARNING - void declaration
     */
    public Floors getFloors(int start, int size) {
        void var19_21;
        Floors floors = new Floors();
        DynamicObjectCollection entryCol = this.dyn.getDynamicObjectCollection("entryentity");
        ArrayList<Object> componentIdList = new ArrayList<Object>();
        for (DynamicObject entry : entryCol) {
            if (!"pmm_floor".equals(this.idToComponentNameMap.get(entry.get("component.id")))) continue;
            componentIdList.add(entry.get("component.id"));
        }
        Date now = TimeServiceHelper.now();
        QFilter validDateRangeFilter = new QFilter("valid_date_start", "<=", (Object)now).and("valid_date_end", ">=", (Object)now);
        Map floorDynMap = BusinessDataServiceHelper.loadFromCache((String)"pmm_floor", (QFilter[])new QFilter[]{new QFilter("id", "in", componentIdList).and(validDateRangeFilter)});
        floors.setTotal(floorDynMap.size());
        HashSet<Long> floorFirstComponentIdSet = new HashSet<Long>(componentIdList.size());
        LinkedHashMap<Long, List> floolIdCardBodyMap = new LinkedHashMap<Long, List>(size);
        int current = 0;
        int curflow = 0;
        long currentFloorId = 0L;
        boolean showScenesCard = false;
        boolean hasScenesCard = false;
        int scenesflow = 0;
        for (Object e : componentIdList) {
            List<CategoryGoods> categoryGoods;
            ProductObtainResult acquisitionResult;
            ++curflow;
            DynamicObject componentDyn = (DynamicObject)floorDynMap.get(e);
            if (componentDyn == null) continue;
            String showWay = componentDyn.getString("show_way");
            if (ComponentType.GOODS_LIST_SIX.getVal().equals(showWay) || ComponentType.GOODS_LIST_EIGHT.getVal().equals(showWay) || ComponentType.GOODS_LIST_SEVEN.getVal().equals(showWay)) {
                if (curflow > start && curflow < start + size + 1 && !showScenesCard && !hasScenesCard) {
                    showScenesCard = true;
                    scenesflow = curflow;
                }
                hasScenesCard = true;
                continue;
            }
            long floorId = componentDyn.getLong("group.id");
            if (currentFloorId != floorId) {
                floorFirstComponentIdSet.add(componentDyn.getLong("id"));
                currentFloorId = floorId;
            }
            if (current < start) {
                ++current;
                continue;
            }
            if (current >= start + size) continue;
            ++current;
            CardBody cardBody = new CardBody();
            Long prodcutObtainId = componentDyn.getLong("product_obtain.id");
            cardBody.setComponent(showWay);
            cardBody.setId(e.toString());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (ComponentType.GOODS_LIST_THREE.getVal().equals(showWay)) {
                acquisitionResult = PmmBusinessServiceFactory.serviceOf(PmmProductObtainService.class).obtain(new PmmProdObtain(prodcutObtainId));
                categoryGoods = MainPageConfig.getCategoryGoods(acquisitionResult, this.showPrice());
                hashMap.put("categoryGoods", categoryGoods);
                hashMap.put("cardOption", this.getCardOption(componentDyn));
            } else if (ComponentType.GOODS_LIST_TWO.getVal().equals(showWay)) {
                acquisitionResult = PmmBusinessServiceFactory.serviceOf(PmmProductObtainService.class).obtain(new PmmProdObtain(prodcutObtainId));
                hashMap.put("cardTitle", this.getCardTitle(componentDyn));
                hashMap.put("categoryGoods", MainPageConfig.getCategoryGoods(acquisitionResult, this.showPrice()));
            } else if (ComponentType.GOODS_LIST_FOUR.getVal().equals(showWay)) {
                hashMap.put("cardTitle", this.getCardTitle(componentDyn));
                hashMap.put("storeList", this.getStores(componentDyn));
            } else if (ComponentType.GOODS_LIST_ONE.getVal().equals(showWay)) {
                acquisitionResult = PmmBusinessServiceFactory.serviceOf(PmmProductObtainService.class).obtain(new PmmProdObtain(prodcutObtainId));
                hashMap.put("goodsGroup", this.getGoodsGroup(acquisitionResult));
                hashMap.put("cardOption", this.getCardOption(componentDyn));
                categoryGoods = MainPageConfig.getCategoryGoods(acquisitionResult, this.showPrice());
                hashMap.put("banner", JSON.toJSON((Object)this.getBanner(componentDyn, categoryGoods)));
            } else if (ComponentType.GOODS_LIST_FIVE.getVal().equals(showWay)) {
                acquisitionResult = PmmBusinessServiceFactory.serviceOf(PmmProductObtainService.class).obtain(new PmmProdObtain(prodcutObtainId));
                hashMap.put("cardOption", this.getCardOption(componentDyn));
                categoryGoods = MainPageConfig.getCategoryGoods(acquisitionResult, this.showPrice());
                hashMap.put("categoryGoods", categoryGoods);
                hashMap.put("goodsList", this.getGoodsList(acquisitionResult, this.showPrice()));
                hashMap.put("banner", JSON.toJSON((Object)this.getBanner(componentDyn, categoryGoods)));
            }
            cardBody.setData(hashMap);
            List cardBodyList = floolIdCardBodyMap.getOrDefault(floorId, new ArrayList());
            cardBodyList.add(cardBody);
            floolIdCardBodyMap.put(floorId, cardBodyList);
        }
        CardBody scenesCardInfo = null;
        Object var19_19 = null;
        if (showScenesCard) {
            HashSet<Long> scenarioschemeids = new HashSet<Long>();
            HashMap<Long, String> show_wayMap = new HashMap<Long, String>();
            HashMap<Long, String> componentNameMap = new HashMap<Long, String>();
            HashMap<Long, Long> componentidMap = new HashMap<Long, Long>();
            ArrayList<Long> componentidList = new ArrayList<Long>(8);
            for (Object e : componentIdList) {
                DynamicObject componentDyn = (DynamicObject)floorDynMap.get(e);
                if (componentDyn == null) continue;
                String showWay = componentDyn.getString("show_way");
                if (!ComponentType.GOODS_LIST_SIX.getVal().equals(showWay) && !ComponentType.GOODS_LIST_EIGHT.getVal().equals(showWay) && !ComponentType.GOODS_LIST_SEVEN.getVal().equals(showWay)) continue;
                scenarioschemeids.add(componentDyn.getLong("scenarioscheme.id"));
                show_wayMap.put(componentDyn.getLong("id"), showWay);
                componentNameMap.put(componentDyn.getLong("id"), componentDyn.getString("name"));
                componentidMap.put(componentDyn.getLong("id"), componentDyn.getLong("scenarioscheme.id"));
                componentidList.add(componentDyn.getLong("id"));
            }
            if (scenarioschemeids.size() > 0 && (scenesCardInfo = this.getCjcg(scenarioschemeids, show_wayMap, componentNameMap, componentidMap, componentidList)) != null) {
                CardBody cardBody = new CardBody();
                cardBody.setComponent(ComponentType.MODULE_TITLE.getVal());
                HashMap<String, String> data2 = new HashMap<String, String>();
                data2.put("title", ResManager.loadKDString((String)"\u573a\u666f\u91c7\u8d2d", (String)"MainPageConfig_1", (String)"scm-pmm-business", (Object[])new Object[0]));
                cardBody.setData(data2);
            }
        }
        int curindex = start;
        ArrayList<CardBody> cardBodies = new ArrayList<CardBody>();
        for (Map.Entry cardBodyEntry : floolIdCardBodyMap.entrySet()) {
            Long cardBodyId;
            if (curindex == scenesflow - 1 && scenesCardInfo != null) {
                cardBodies.add((CardBody)var19_21);
                cardBodies.add(scenesCardInfo);
                ++curindex;
            }
            if (floorFirstComponentIdSet.contains(cardBodyId = Long.valueOf(((CardBody)((List)cardBodyEntry.getValue()).get(0)).getId()))) {
                CardBody titleCardBody = new CardBody();
                titleCardBody.setComponent(ComponentType.MODULE_TITLE.getVal());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("title", ((DynamicObject)floorDynMap.get(cardBodyId)).getString("group.name"));
                titleCardBody.setData(hashMap);
                cardBodies.add(titleCardBody);
            }
            cardBodies.addAll((Collection)cardBodyEntry.getValue());
            ++curindex;
        }
        if (scenesCardInfo != null) {
            cardBodies.add((CardBody)var19_21);
            cardBodies.add(scenesCardInfo);
        }
        floors.setCardBodies(cardBodies);
        return floors;
    }

    private List<Goods> getGoodsList(ProductObtainResult acquisitionResult, boolean showPrice) {
        ArrayList<Goods> goodsList = new ArrayList<Goods>(acquisitionResult.getGoodsObjMap().size());
        for (Map.Entry<Long, Map<String, Object>> goodsEntry : acquisitionResult.getGoodsObjMap().entrySet()) {
            Goods goods = MainPageConfig.getGoods(goodsEntry.getValue(), showPrice);
            goodsList.add(goods);
        }
        return goodsList;
    }

    private Banner getBanner(DynamicObject componentDyn, List<CategoryGoods> categoryGoodsList) {
        Banner banner = new Banner();
        DynamicObjectCollection entryentityCol = componentDyn.getDynamicObjectCollection("entryentity");
        if (!entryentityCol.isEmpty()) {
            banner.setTitle(((DynamicObject)entryentityCol.get(0)).getString("pic_title"));
            banner.setSubTitle(((DynamicObject)entryentityCol.get(0)).getString("pic_desc"));
            banner.setTitleColor(this.getColor(((DynamicObject)entryentityCol.get(0)).getString("font_color")));
            banner.setSubTitleColor(this.getColor(((DynamicObject)entryentityCol.get(0)).getString("desc_color")));
            banner.setTagColor(this.getColor(((DynamicObject)entryentityCol.get(0)).getString("tag_color")));
        }
        if (!((DynamicObject)entryentityCol.get(0)).getBoolean("notshowcategory")) {
            ArrayList<Category> categories = new ArrayList<Category>(categoryGoodsList.size());
            categoryGoodsList.forEach(categoryGoods -> categories.add(categoryGoods.getCategory()));
            banner.setCategories(categories);
        }
        return banner;
    }

    private List<Goods> getGoodsGroup(ProductObtainResult acquisitionResult) {
        ArrayList<Goods> goodsGroup = new ArrayList<Goods>(acquisitionResult.getGoodsObjMap().size());
        for (Map.Entry<Long, Map<String, Object>> goodsEntry : acquisitionResult.getGoodsObjMap().entrySet()) {
            if (!MainPageConfig.checkGoodsInfoValid(goodsEntry.getValue())) continue;
            Goods goods = MainPageConfig.getGoods(goodsEntry.getValue(), this.showPrice());
            goodsGroup.add(goods);
        }
        return goodsGroup;
    }

    private List<Store> getStores(DynamicObject componentDyn) {
        DynamicObjectCollection componentEntryCol = componentDyn.getDynamicObjectCollection("entryentity");
        ArrayList<Store> storeList = new ArrayList<Store>(componentEntryCol.size());
        for (DynamicObject componentEntry : componentEntryCol) {
            Store store = new Store();
            store.setCardTitle(componentEntry.getString("pic_title"));
            String fontColor = this.getColor(componentEntry.getString("font_color"));
            store.setCardTitleColor(fontColor);
            String descriptionColor = this.getColor(componentEntry.getString("desc_color"));
            store.setDescriptionColor(descriptionColor);
            store.setDescription(componentEntry.getString("pic_desc"));
            store.setStoreId(componentEntry.getString("id"));
            store.setStoreImgPath(MainPageConfig.getPictureUrl(componentEntry.getString("picture")));
            String productObtainId = componentEntry.getString("entry_product_obtain.id");
            if (StringUtils.isNotBlank((CharSequence)productObtainId)) {
                store.setUrl(this.getProdObtainToSearchUrl(productObtainId));
                store.setProductObtainId(Long.valueOf(productObtainId));
            } else {
                store.setUrl(componentEntry.getString("url"));
            }
            storeList.add(store);
        }
        return storeList;
    }

    private String getColor(String colorStr) {
        if (THEME_COLOR.equals(colorStr)) {
            return this.userThemeColor;
        }
        return colorStr;
    }

    private static String getPictureUrl(String pictureUrl) {
        if (StringUtils.isBlank((CharSequence)pictureUrl)) {
            return pictureUrl;
        }
        String url = pictureUrl.contains("http") || pictureUrl.contains("https") ? pictureUrl : UrlService.getImageFullUrl((String)pictureUrl);
        url = url.contains("?") ? url + "&accountId=" + RequestContext.get().getAccountId() : url + "?accountId=" + RequestContext.get().getAccountId();
        return url;
    }

    private String getCardTitle(DynamicObject componentDyn) {
        return componentDyn.getString("name");
    }

    public static List<CategoryGoods> getCategoryGoods(ProductObtainResult acquisitionResult, boolean showPrice) {
        HashMap<Object, List> categoryToGoodsListMap = new HashMap<Object, List>(acquisitionResult.getGoodsObjMap().size());
        for (Map.Entry<Long, Map<String, Object>> goodsEntry : acquisitionResult.getGoodsObjMap().entrySet()) {
            if (!MainPageConfig.checkGoodsInfoValid(goodsEntry.getValue())) continue;
            Object categoryId = goodsEntry.getValue().get("classid");
            List goodsList = categoryToGoodsListMap.getOrDefault(categoryId, new ArrayList());
            categoryToGoodsListMap.put(categoryId, goodsList);
            Goods goods = MainPageConfig.getGoods(goodsEntry.getValue(), showPrice);
            goodsList.add(goods);
        }
        ArrayList<CategoryGoods> categoryGoodsList = new ArrayList<CategoryGoods>(categoryToGoodsListMap.size());
        for (Map.Entry categoryToGoodsListEntry : categoryToGoodsListMap.entrySet()) {
            CategoryGoods categoryGoods = new CategoryGoods();
            List goodsList = (List)categoryToGoodsListEntry.getValue();
            if (goodsList.isEmpty()) continue;
            categoryGoods.setId(String.valueOf(categoryToGoodsListEntry.getKey()));
            categoryGoods.setGoodsList(goodsList);
            categoryGoods.setCategory(MainPageConfig.getCategory(acquisitionResult.getGoodsObjMap().get(Long.valueOf(((Goods)goodsList.get(0)).getProductId()))));
            categoryGoodsList.add(categoryGoods);
        }
        return categoryGoodsList;
    }

    private CardOption getCardOption(DynamicObject componentDyn) {
        CardOption cardOption = new CardOption();
        DynamicObjectCollection componentEntryCol = componentDyn.getDynamicObjectCollection("entryentity");
        Object color = UserServiceHelper.getUserThemeNumAndVerNew((Long)RequestContext.get().getCurrUserId()).get("color");
        if (!componentEntryCol.isEmpty()) {
            cardOption.setLeftImg(MainPageConfig.getPictureUrl(((DynamicObject)componentEntryCol.get(0)).getString("picture")));
            String productObtainId = componentDyn.getString("product_obtain.id");
            cardOption.setProductObtainId(componentDyn.getLong("product_obtain.id"));
            cardOption.setMoreUrl(this.getProdObtainToSearchUrl(productObtainId));
            String entryProductObtainId = ((DynamicObject)componentEntryCol.get(0)).getString("entry_product_obtain.id");
            String fontColor = ((DynamicObject)componentEntryCol.get(0)).getString("font_color");
            if (THEME_COLOR.equals(fontColor)) {
                fontColor = String.valueOf(color);
            }
            cardOption.setFontColor(fontColor);
            if (StringUtils.isNotBlank((CharSequence)entryProductObtainId)) {
                cardOption.setProductObtainId(Long.valueOf(entryProductObtainId));
                cardOption.setUrl(this.getProdObtainToSearchUrl(entryProductObtainId));
            } else {
                cardOption.setUrl(((DynamicObject)componentEntryCol.get(0)).getString("url"));
            }
            cardOption.setTitle(componentDyn.getString("name"));
        }
        return cardOption;
    }

    private String getProdObtainToSearchUrl(String productObtainId) {
        return UrlService.getDomainContextUrl() + "/index.html?formId=mal_newsearch_v1&productObtainId=" + productObtainId + "&accountId=" + RequestContext.get().getAccountId();
    }

    private static Category getCategory(Map<String, Object> goodsInfoFromEs) {
        Category res = new Category();
        res.setId(String.valueOf(goodsInfoFromEs.get("classid")));
        String classLongnumber = String.valueOf(goodsInfoFromEs.get("classlongnumber"));
        res.setLevel(classLongnumber.split("\\.").length);
        res.setLongNumber(classLongnumber);
        res.setName(String.valueOf(goodsInfoFromEs.get("classname")));
        res.setNumber(String.valueOf(goodsInfoFromEs.get("classnumber")));
        res.setSource(String.valueOf(goodsInfoFromEs.get("source")));
        return res;
    }

    private static Goods getGoods(Map<String, Object> goodsInfoFromEs, boolean showPrice) {
        Goods goods = new Goods();
        goods.setProductId(goodsInfoFromEs.get("goodsid").toString());
        goods.setProductnumber(goodsInfoFromEs.get("number").toString());
        goods.setSource(goodsInfoFromEs.get("source").toString());
        goods.setProductName(goodsInfoFromEs.get("name").toString());
        if (showPrice) {
            if (goodsInfoFromEs.get("price") != null) {
                goods.setShopPrice(new BigDecimal(goodsInfoFromEs.get("price").toString()));
            } else {
                goods.setShopPrice(BigDecimal.ZERO);
            }
        }
        goods.setProductImgPath(MainPageConfig.getPictureUrl(String.valueOf(goodsInfoFromEs.get("thumbnail"))));
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goods.getSource())) {
            goods.setSupplier(String.valueOf(goodsInfoFromEs.get("suppliername")));
        } else {
            goods.setSupplier(String.valueOf(goodsInfoFromEs.get("source_name")));
        }
        goods.setContract(new String[]{String.valueOf(goodsInfoFromEs.get("centralpurtype_name"))});
        return goods;
    }

    private static boolean checkGoodsInfoValid(Map<String, Object> goodsInfoFromEs) {
        Object name = goodsInfoFromEs.get("name");
        return !StringUtils.isBlank((Object)name);
    }

    public boolean showPrice() {
        return this.dyn.getBoolean("show_price");
    }

    public CardBody getCjcg(Set<Long> scenarioschemeids, Map<Long, String> show_wayMap, Map<Long, String> componentNameMap, Map<Long, Long> componentIdMap, List<Long> componentidList) {
        CardBody scenesCardInfo = new CardBody();
        DynamicObjectCollection orgs = BaseDataServiceHelper.getAllUseOrg((String)"pmm_scenarioscheme");
        long curOrg = RequestContext.get().getOrgId();
        boolean iscontainsOrg = false;
        for (DynamicObject org : orgs) {
            if (org.getLong("id") != curOrg) continue;
            iscontainsOrg = true;
            break;
        }
        if (!iscontainsOrg) {
            return null;
        }
        QFilter fiter = new QFilter("id", "in", scenarioschemeids);
        QFilter orgfilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmm_scenarioscheme", (Long)RequestContext.get().getOrgId());
        Map scenarioschemelistMap = BusinessDataServiceHelper.loadFromCache((String)"pmm_scenarioscheme", (QFilter[])new QFilter[]{orgfilter, fiter});
        Collection scenarioschemelist = scenarioschemelistMap.values();
        ArrayList<ScenesCardDataInfo> cardList = new ArrayList<ScenesCardDataInfo>(scenarioschemelist.size());
        DynamicObject info = null;
        for (Long componentid : componentidList) {
            PmmProdObtain PmmProdObtain2 = new PmmProdObtain(componentIdMap.get(componentid));
            ProductObtainResult acquisitionResult = PmmBusinessServiceFactory.serviceOf(PmmProductObtainService.class).obtain(PmmProdObtain2);
            Set<Long> goodsSet = acquisitionResult.getGoodsObjMap().keySet();
            info = (DynamicObject)scenarioschemelistMap.get(componentIdMap.get(componentid));
            if (info == null) continue;
            DynamicObjectCollection tagentrys = info.getDynamicObjectCollection("tag_entryentity");
            HashMap<Long, DynamicObject> tagentryMap = new HashMap<Long, DynamicObject>(tagentrys.size());
            for (DynamicObject tagentry : tagentrys) {
                tagentryMap.put(tagentry.getLong("tag.id"), tagentry);
            }
            ScenesCardDataInfo sceneseDataInfo = new ScenesCardDataInfo();
            String show_way = show_wayMap.get(componentid);
            if (show_way != null) {
                sceneseDataInfo.setComponent(show_way);
            }
            Map dataMap = new HashMap(2);
            String componentName = componentNameMap.get(componentid);
            dataMap = "GoodsListSeven".equalsIgnoreCase(show_way) ? this.getScenesCategoryGoodsDataInfo(info, componentName, tagentryMap, goodsSet) : this.getScenesCardDataInfo(info, tagentryMap, componentName, goodsSet);
            sceneseDataInfo.setTitle(componentName);
            sceneseDataInfo.setImgpath(MainPageConfig.getPictureUrl(info.getString("scenarioimg")));
            sceneseDataInfo.setSceneId(info.getString("id"));
            sceneseDataInfo.setId(componentid.toString());
            sceneseDataInfo.setData(dataMap);
            cardList.add(sceneseDataInfo);
        }
        if (scenarioschemelist.size() > 0) {
            scenesCardInfo.setData(cardList);
            scenesCardInfo.setComponent("ScenesCard");
            SecureRandom random = new SecureRandom();
            int size = 16;
            byte[] bytes = new byte[size];
            random.nextBytes(bytes);
            scenesCardInfo.setId(Integer.toString(random.nextInt()));
            return scenesCardInfo;
        }
        return null;
    }

    private Map getScenesCategoryGoodsDataInfo(DynamicObject info, String componentName, Map tagentryMap, Set<Long> goodsSet) {
        List goodsList = new ArrayList(goodsSet.size());
        DynamicObjectCollection goodsEntrys = info.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> goodsMap = this.getGoodsMap(goodsEntrys);
        HashMap tagGoodsMap = new HashMap(16);
        for (DynamicObject goodsEntry : goodsEntrys) {
            if (!goodsSet.contains(goodsEntry.get("goods.id"))) continue;
            goodsList = tagGoodsMap.containsKey(goodsEntry.getLong("scenariotag.id")) ? (List)tagGoodsMap.get(goodsEntry.getLong("scenariotag.id")) : new ArrayList(goodsSet.size());
            ScenesCardGoodsInfo card = this.getScenesCardGoodsInfo(goodsEntry, tagentryMap, goodsMap);
            goodsList.add(card);
            tagGoodsMap.put(goodsEntry.getLong("scenariotag.id"), goodsList);
        }
        ArrayList<ScenesCategoryGoodsDataInfo> categoryGoodsList = new ArrayList<ScenesCategoryGoodsDataInfo>(16);
        ScenesCategoryGoodsDataInfo scenesCategoryGoodsDataInfo = new ScenesCategoryGoodsDataInfo();
        DynamicObjectCollection tagentrys = info.getDynamicObjectCollection("tag_entryentity");
        for (DynamicObject tagentry : tagentrys) {
            if (tagGoodsMap.get(tagentry.get("tag.id")) == null || ((List)tagGoodsMap.get(tagentry.get("tag.id"))).size() == 0) continue;
            scenesCategoryGoodsDataInfo = new ScenesCategoryGoodsDataInfo();
            HashMap<String, String> category = new HashMap<String, String>(4);
            category.put("name", (String)tagentry.getDynamicObject("tag").get("name"));
            category.put("id", tagentry.get("tag.id").toString());
            category.put("left", (String)tagentry.get("left"));
            category.put("top", (String)tagentry.get("top"));
            scenesCategoryGoodsDataInfo.setCategory(category);
            scenesCategoryGoodsDataInfo.setGoodsList((List)tagGoodsMap.get(tagentry.get("tag.id")));
            categoryGoodsList.add(scenesCategoryGoodsDataInfo);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put("title", componentName);
        dataMap.put("categoryGoods", categoryGoodsList);
        return dataMap;
    }

    private Map getScenesCardDataInfo(DynamicObject info, Map tagentryMap, String componentName, Set<Long> goodsSet) {
        ArrayList<ScenesCardGoodsInfo> goodsList = new ArrayList<ScenesCardGoodsInfo>(goodsSet.size());
        DynamicObjectCollection goodsEntrys = info.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> goodsMap = this.getGoodsMap(goodsEntrys);
        ArrayList<String> goodsids = new ArrayList<String>(goodsEntrys.size());
        for (DynamicObject goodsEntry : goodsEntrys) {
            if (goodsids.contains(goodsEntry.getString("goods.id"))) continue;
            ScenesCardGoodsInfo card = this.getScenesCardGoodsInfo(goodsEntry, tagentryMap, goodsMap);
            goodsList.add(card);
            goodsids.add(goodsEntry.getString("goods.id"));
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put("title", componentName);
        dataMap.put("goodsList", goodsList);
        return dataMap;
    }

    private ScenesCardGoodsInfo getScenesCardGoodsInfo(DynamicObject goodsEntry, Map<Long, DynamicObject> tagentryMap, Map<Long, DynamicObject> goodsMap) {
        DynamicObject tagentry;
        String source;
        ScenesCardGoodsInfo card = new ScenesCardGoodsInfo();
        card.setProductId(goodsEntry.getString("goods.id"));
        card.setProductName(goodsEntry.getDynamicObject("goods").getString("name"));
        if (goodsEntry.getDynamicObject("goods") != null) {
            card.setProductnumber(goodsEntry.getDynamicObject("goods").getString("number"));
        }
        if ((source = goodsEntry.getString("source")).equals("pmm_prodmanage")) {
            card.setSource("1");
        }
        if (tagentryMap.containsKey(goodsEntry.getLong("scenariotag.id")) && (tagentry = tagentryMap.get(goodsEntry.getLong("scenariotag.id"))) != null) {
            card.setTagName(tagentry.getDynamicObject("tag").getString("name"));
            card.setLeft(tagentry.getString("left"));
            card.setTop(tagentry.getString("top"));
        }
        card.setTagId(goodsEntry.getString("scenariotag.id"));
        DynamicObject goods = goodsMap.get(goodsEntry.getLong("goods.id"));
        if (goods != null) {
            HashMap<String, String> sourceToSupplierNameMap = new HashMap<String, String>(16);
            card.setProductImgPath(MainPageConfig.getPictureUrl(goods.getString("thumbnail")));
            card.setShopPrice(goods.getBigDecimal("shopprice"));
            card.setSupplier(goodsEntry.getString("supplier"));
            if ("pmm_prodmanage".equals(goodsEntry.get("source"))) {
                card.setSupplier(goods.getString("supplier.name"));
            } else {
                String malsource;
                String supplierName = (String)sourceToSupplierNameMap.get(goods.getString("mallgoods.source"));
                if (StringUtils.isBlank((CharSequence)supplierName) && StringUtils.isNotBlank((CharSequence)(malsource = goods.getString("mallgoods.source")))) {
                    card.setSource(malsource);
                    supplierName = EcApiUtil.getMalName((String)malsource);
                    sourceToSupplierNameMap.put(source, supplierName);
                }
                card.setSupplier(supplierName);
            }
        }
        return card;
    }

    private Map<Long, DynamicObject> getGoodsMap(DynamicObjectCollection goods_entryentitys) {
        ArrayList<Long> selfGoodsIds = new ArrayList<Long>(goods_entryentitys.size());
        ArrayList<Long> ecGoodsIds = new ArrayList<Long>(goods_entryentitys.size());
        for (DynamicObject entry : goods_entryentitys) {
            Long goodsId = entry.getLong("goods.id");
            String source = entry.getString("source");
            if (!StringUtils.isNotBlank((CharSequence)source)) continue;
            if ("pmm_prodmanage".equals(source)) {
                selfGoodsIds.add(goodsId);
                continue;
            }
            ecGoodsIds.add(goodsId);
        }
        HashMap<Long, DynamicObject> goodsMap = new HashMap<Long, DynamicObject>(64);
        if (!selfGoodsIds.isEmpty()) {
            DynamicObjectCollection selfGoodsEntryCol = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,name,unit.name,supplier.name,thumbnail,shopprice ", (QFilter[])new QFilter[]{new QFilter("id", "in", selfGoodsIds)});
            for (DynamicObject selfGoodsEntry : selfGoodsEntryCol) {
                goodsMap.put(selfGoodsEntry.getLong("id"), selfGoodsEntry);
            }
        }
        if (!ecGoodsIds.isEmpty()) {
            DynamicObjectCollection ecGoodsPriceEntryCol = QueryServiceHelper.query((String)"pbd_mallgoods_price", (String)"mallgoods.id id, mallgoods.name name,mallgoods.mainpic thumbnail,mallgoods.source,price shopprice", (QFilter[])new QFilter[]{new QFilter("mallgoods", "in", ecGoodsIds)});
            for (DynamicObject malGoodsEntry : ecGoodsPriceEntryCol) {
                goodsMap.put(malGoodsEntry.getLong("id"), malGoodsEntry);
            }
        }
        return goodsMap;
    }
}

