/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.model.prodpool;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.malcore.enums.ProdEffectStatusEnum;
import kd.scm.pmm.business.model.prodpool.LadderPrice;

public class ProdPool {
    private Long productId;
    private String name;
    private BigDecimal taxPrice;
    private Long taxRateID;
    private BigDecimal taxRate;
    private BigDecimal price;
    private Long unit;
    private Long createOrgID;
    private Long auditOrgID;
    private Long protocolEntryID = 0L;
    private String platform;
    private Date effectDate;
    private Date invalidDate;
    private String centralPurType;
    private Boolean isGoodVisible;
    private Long protocolId;
    private List<Long> orgIdList;
    private String protocolStatus;
    private String effectStatus;
    private List<LadderPrice> ladderPrices;
    private BigDecimal minOrderQty;
    private int leadtime;
    private Long purPlanId;

    public Long getPurPlanId() {
        return this.purPlanId;
    }

    public void setPurPlanId(Long purPlanId) {
        this.purPlanId = purPlanId;
    }

    public List<LadderPrice> getLadderPrices() {
        return this.ladderPrices;
    }

    public void setLadderPrices(List<LadderPrice> ladderPrices) {
        this.ladderPrices = ladderPrices;
    }

    public BigDecimal getMinOrderQty() {
        return this.minOrderQty;
    }

    public void setMinOrderQty(BigDecimal minOrderQty) {
        this.minOrderQty = minOrderQty;
    }

    public int getLeadtime() {
        return this.leadtime;
    }

    public void setLeadtime(int leadtime) {
        this.leadtime = leadtime;
    }

    public Long getProductId() {
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getTaxPrice() {
        return this.taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public Long getTaxRateID() {
        return this.taxRateID;
    }

    public void setTaxRateID(Long taxRateID) {
        this.taxRateID = taxRateID;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getUnit() {
        return this.unit;
    }

    public void setUnit(Long unit) {
        this.unit = unit;
    }

    public Long getCreateOrgID() {
        return this.createOrgID;
    }

    public void setCreateOrgID(Long createOrgID) {
        this.createOrgID = createOrgID;
    }

    public Long getAuditOrgID() {
        return this.auditOrgID;
    }

    public void setAuditOrgID(Long auditOrgID) {
        this.auditOrgID = auditOrgID;
    }

    public Long getProtocolEntryID() {
        if (this.protocolEntryID == null) {
            return 0L;
        }
        return this.protocolEntryID;
    }

    public void setProtocolEntryID(Long protocolEntryID) {
        this.protocolEntryID = protocolEntryID;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Date getEffectDate() {
        return this.effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Date getInvalidDate() {
        return this.invalidDate;
    }

    public void setInvalidDate(Date invalidDate) {
        this.invalidDate = invalidDate;
    }

    public Boolean getIsGoodVisible() {
        return this.isGoodVisible;
    }

    public String getCentralPurType() {
        return this.centralPurType;
    }

    public void setCentralPurType(String centralPurType) {
        this.centralPurType = centralPurType;
    }

    public void setIsGoodVisible(Boolean isGoodVisible) {
        this.isGoodVisible = isGoodVisible;
    }

    public Long getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(Long protocolId) {
        this.protocolId = protocolId;
    }

    public List<Long> getOrgIdList() {
        return this.orgIdList;
    }

    public void setOrgIdList(List<Long> orgIdList) {
        this.orgIdList = orgIdList;
    }

    public Boolean getGoodVisible() {
        return this.isGoodVisible;
    }

    public void setGoodVisible(Boolean goodVisible) {
        this.isGoodVisible = goodVisible;
    }

    public String getProtocolStatus() {
        return this.protocolStatus;
    }

    public void setProtocolStatus(String protocolStatus) {
        this.protocolStatus = protocolStatus;
    }

    public String getEffectStatus() {
        return this.effectStatus;
    }

    public void setEffectStatus(String effectStatus) {
        this.effectStatus = effectStatus;
    }

    public String getStatusByEffectDate() {
        Date now = DateUtil.string2date((String)TimeServiceHelper.formatToday(), (String)"yyyy-MM-dd");
        if (this.invalidDate == null || !this.invalidDate.before(now)) {
            if (this.effectDate == null || !this.effectDate.after(now)) {
                return ProdEffectStatusEnum.EFFECTIVE.getVal();
            }
            return ProdEffectStatusEnum.INEFFECTIVE.getVal();
        }
        return ProdEffectStatusEnum.INVALID.getVal();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ProdPool) {
            ProdPool prodPool = (ProdPool)obj;
            if (this.longCompare(this.protocolId, prodPool.protocolId) && this.longCompare(this.productId, prodPool.productId) && this.longCompare(this.protocolEntryID, prodPool.protocolEntryID)) {
                return true;
            }
        }
        return false;
    }

    private boolean longCompare(Long long1, Long long2) {
        if (long1 == null && long2 == null) {
            return true;
        }
        return long1 != null && long1.equals(long2);
    }

    public int hashCode() {
        int result = 17;
        result = (int)((long)(31 * result) + this.protocolId);
        result = (int)((long)(31 * result) + this.productId);
        result = (int)((long)(31 * result) + this.protocolEntryID);
        return result;
    }
}

