/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.es.storage.EsResultVo;
import kd.scm.common.es.storage.EsSearchParam;
import kd.scm.common.extension.ScmExtensionFactory;
import kd.scm.malcore.domain.GoodsSameRule;
import kd.scm.malcore.util.MalConfigUtil;
import kd.scm.pmm.business.model.product.PmmProdObtain;
import kd.scm.pmm.business.service.PmmBusinessServiceFactory;
import kd.scm.pmm.business.service.PmmProductObtainService;
import kd.sdk.scm.pmm.extpoint.IOperateMonitorRuleService;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceParam;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceResult;

public class PmmGoodsSameRuleService {
    private static final Log log = LogFactory.getLog(PmmGoodsSameRuleService.class);
    private static final long SAMERULEID = 1893437194405041152L;

    public List<MonitorRuleServiceResult> isGoodsMatchSameCompareRule(MonitorRuleServiceParam param) {
        this.dealParam(param);
        ArrayList<MonitorRuleServiceResult> matchRuleRecords = new ArrayList<MonitorRuleServiceResult>(16);
        GoodsSameRule rule = this.getSameGoodsRuleEsFilterByGoodsId(param.getGoodsId(), param.getPlatform());
        DynamicObjectCollection sameComparerules = this.getSameComapreCols();
        if (rule.isGoodsMonitor() && sameComparerules.size() > 0) {
            DynamicObject info = (DynamicObject)sameComparerules.get(0);
            long pmmProdObtainId = info.getLong("productobtain");
            HashSet<Long> removeGoodsIds = new HashSet<Long>(16);
            if (0L != pmmProdObtainId) {
                EsSearchParam esSearchParam = PmmBusinessServiceFactory.serviceOf(PmmProductObtainService.class).getEsSearchParamByProdObtain(new PmmProdObtain(pmmProdObtainId));
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                paramMap.put("esFilterFields", esSearchParam.getEsFilterFields());
                paramMap.put("pageSize", esSearchParam.getPageSize());
                EsResultVo esResultVo = (EsResultVo)DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"IMalSearchService", (String)"search", (Object[])new Object[]{paramMap});
                if (null != esResultVo) {
                    List resultData = esResultVo.getResultData();
                    for (Map map : resultData) {
                        if (null == map.get("goodsid")) continue;
                        removeGoodsIds.add(Long.parseLong(String.valueOf(map.get("goodsid"))));
                    }
                }
            }
            if (removeGoodsIds.size() > 0 && removeGoodsIds.contains(param.getGoodsId())) {
                return matchRuleRecords;
            }
            boolean iscomparesameprice = info.getBoolean("iscomparesameprice");
            BigDecimal taxPrice = param.getTaxPrice();
            HashSet<Long> needCheckEntrys = new HashSet<Long>(16);
            if (iscomparesameprice) {
                for (DynamicObject row : sameComparerules) {
                    BigDecimal startPrice = row.getBigDecimal("samecompareentry.startprice");
                    if (null == startPrice) {
                        startPrice = BigDecimal.ZERO;
                    }
                    BigDecimal endPrice = row.getBigDecimal("samecompareentry.endprice");
                    if (taxPrice.compareTo(startPrice) < 0 || null != endPrice && endPrice.compareTo(BigDecimal.ZERO) != 0 && taxPrice.compareTo(endPrice) >= 0) continue;
                    needCheckEntrys.add(row.getLong("samecompareentry.id"));
                }
            }
            for (DynamicObject row : sameComparerules) {
                long enrtryId = row.getLong("samecompareentry.id");
                if (iscomparesameprice && !needCheckEntrys.contains(enrtryId)) continue;
                this.dealRuleEntry(row, param, matchRuleRecords);
            }
        }
        return matchRuleRecords;
    }

    private void dealParam(MonitorRuleServiceParam param) {
        if (0L == param.getGoodsId()) {
            return;
        }
        GoodsSameRule goodsSameRule = this.getSameGoodsRuleEsFilterByGoodsId(param.getGoodsId(), param.getPlatform());
        if (null != goodsSameRule && null != goodsSameRule.getEsFilterFields() && goodsSameRule.getEsFilterFields().size() > 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("esFilterFields", goodsSameRule.getEsFilterFields());
            paramMap.put("sort", "price_true");
            paramMap.put("pageSize", 1);
            EsResultVo esResultVo = (EsResultVo)DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"IMalSearchService", (String)"search", (Object[])new Object[]{paramMap});
            if (null != esResultVo && esResultVo.getResultData().size() > 0) {
                param.setSameGoodsMap((Map)esResultVo.getResultData().get(0));
            }
        }
    }

    private void dealRuleEntry(DynamicObject row, MonitorRuleServiceParam param, List<MonitorRuleServiceResult> matchRuleRecords) {
        String priceRuleNumber = row.getString("samecompareentry.pricerule.number");
        String thresholdtype = row.getString("samecompareentry.pricerule.thresholdtype");
        long priceruleId = row.getLong("samecompareentry.pricerule.id");
        String samethreshold = row.getString("samecompareentry.samethreshold");
        String controltype = row.getString("samecompareentry.controltype");
        boolean isSameAutodown = row.getBoolean("samecompareentry.issameautodown");
        BigDecimal val = null;
        if (!StringUtils.isEmpty((CharSequence)priceRuleNumber)) {
            MonitorRuleServiceResult matchMonitorRule;
            IOperateMonitorRuleService extension = (IOperateMonitorRuleService)ScmExtensionFactory.getExtensionFacotry(IOperateMonitorRuleService.class).getExtension(priceRuleNumber);
            if ("2".equals(thresholdtype)) {
                String replace = samethreshold.replace("%", "");
                if (StringUtils.isEmpty((CharSequence)replace)) {
                    return;
                }
                val = new BigDecimal(replace);
            }
            if ("3".equals(thresholdtype)) {
                if (StringUtils.isEmpty((CharSequence)samethreshold)) {
                    return;
                }
                val = new BigDecimal(samethreshold);
            }
            if (null != (matchMonitorRule = extension.isMatchMonitorRule(param, val)) && matchMonitorRule.isMatch()) {
                matchMonitorRule.setThreshold(samethreshold);
                matchMonitorRule.setRuleId(priceruleId);
                matchMonitorRule.setBizOperate(controltype);
                matchMonitorRule.setIsAutoDown(isSameAutodown);
                matchMonitorRule.setThresholdType(thresholdtype);
                matchRuleRecords.add(matchMonitorRule);
            }
        }
    }

    private DynamicObjectCollection getSameComapreCols() {
        QFilter qFilter = new QFilter("id", "=", (Object)1893437194405041152L);
        String selectors = "productobtain,iscomparesameprice,samecompareentry.id,samecompareentry.pricerule.id,samecompareentry.pricerule.thresholdtype,samecompareentry.pricerule.number,samecompareentry.startprice,samecompareentry.endprice,samecompareentry.pricerule,samecompareentry.samethreshold,samecompareentry.controltype,samecompareentry.issameautodown";
        return QueryServiceHelper.query((String)"pmm_samegoodsrule", (String)selectors, (QFilter[])qFilter.toArray());
    }

    public Map<Long, GoodsSameRule> batchGetSameGoodsRuleEsFilterByGoodsIds(Set<Long> goodsIds) {
        HashMap<Long, GoodsSameRule> goodsSameRuleMap = new HashMap<Long, GoodsSameRule>(16);
        log.info("batchGetSameGoodsRuleEsFilterByGoodsIds.goodsIds:" + SerializationUtils.toJsonString(goodsIds));
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>(16);
        DynamicObjectCollection sameGoodsrules = this.getSameGoodsCols();
        GoodsSameRule goodsSameRule = null;
        if (null != sameGoodsrules && sameGoodsrules.size() > 0) {
            goodsSameRule = new GoodsSameRule();
            goodsSameRule.setSimilar(((DynamicObject)sameGoodsrules.get(0)).getBoolean("issimilar"));
            goodsSameRule.setSamekind(((DynamicObject)sameGoodsrules.get(0)).getBoolean("issamekind"));
            goodsSameRule.setAutoCompare(((DynamicObject)sameGoodsrules.get(0)).getBoolean("isautocompare"));
            goodsSameRule.setGoodsMonitor(((DynamicObject)sameGoodsrules.get(0)).getBoolean("isgoodsmonitor"));
            if (!((DynamicObject)sameGoodsrules.get(0)).getBoolean("issamekind")) {
                for (Long goodsId : goodsIds) {
                    goodsSameRuleMap.put(goodsId, goodsSameRule);
                }
                log.info("batchGetSameGoodsRuleEsFilterByGoodsIds.goodsMap:" + SerializationUtils.toJsonString(goodsSameRuleMap));
                return goodsSameRuleMap;
            }
            EsFilterField allEsFilterField = null;
            HashMap entryMap = new HashMap(16);
            for (DynamicObject row : sameGoodsrules) {
                long entryId = row.getLong("entryentity.id");
                String esPropNumber = row.getString("entryentity.samerule.fbasedataid.number");
                List<String> propsList = new ArrayList<String>(16);
                if (null != entryMap.get(entryId)) {
                    propsList = (List)entryMap.get(entryId);
                }
                propsList.add(esPropNumber);
                entryMap.put(entryId, propsList);
            }
            EsFilterField goodsIdEsFilterField = new EsFilterField("goodsid", "in", goodsIds.toArray());
            EsSearchParam searchParam = new EsSearchParam();
            searchParam.setEsFilterFields(Collections.singletonList(goodsIdEsFilterField));
            searchParam.setPageSize(1);
            searchParam.setPageNum(0);
            EsResultVo esResultVo = (EsResultVo)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"PbdEsSearchService", (String)"search", (Object[])new Object[]{searchParam, MalConfigUtil.DEFAULT_ESCONFIGID});
            if (esResultVo.getTotalHits() > 0L) {
                List resultData = esResultVo.getResultData();
                for (Map esGoodsObj : resultData) {
                    for (Map.Entry map : entryMap.entrySet()) {
                        List pros = (List)map.getValue();
                        EsFilterField esFilterField = null;
                        for (String key : pros) {
                            Object value = esGoodsObj.get(key);
                            if (ObjectUtils.isEmpty(value)) continue;
                            if (null == esFilterField) {
                                esFilterField = new EsFilterField(key, "=", new Object[]{value});
                                continue;
                            }
                            esFilterField.and(new EsFilterField(key, "=", new Object[]{value}));
                        }
                        if (null == esFilterField) continue;
                        if (allEsFilterField == null) {
                            allEsFilterField = esFilterField;
                            continue;
                        }
                        allEsFilterField.or(esFilterField);
                    }
                    if (null == allEsFilterField) continue;
                    GoodsSameRule newGoodsSameRule = new GoodsSameRule();
                    newGoodsSameRule.setSimilar(((DynamicObject)sameGoodsrules.get(0)).getBoolean("issimilar"));
                    newGoodsSameRule.setSamekind(((DynamicObject)sameGoodsrules.get(0)).getBoolean("issamekind"));
                    newGoodsSameRule.setAutoCompare(((DynamicObject)sameGoodsrules.get(0)).getBoolean("isautocompare"));
                    newGoodsSameRule.setGoodsMonitor(((DynamicObject)sameGoodsrules.get(0)).getBoolean("isgoodsmonitor"));
                    esFilterFields.add(allEsFilterField);
                    newGoodsSameRule.setEsFilterFields(esFilterFields);
                    newGoodsSameRule.setSort(((DynamicObject)sameGoodsrules.get(0)).getString("goodssort"));
                    Object gid = esGoodsObj.get("goodsid");
                    if (ObjectUtils.isEmpty(gid)) continue;
                    goodsSameRuleMap.put(Long.parseLong(String.valueOf(gid)), newGoodsSameRule);
                }
            } else {
                for (Long goodsId : goodsIds) {
                    goodsSameRuleMap.put(goodsId, goodsSameRule);
                }
                log.info("batchGetSameGoodsRuleEsFilterByGoodsIds.goodsMap:" + SerializationUtils.toJsonString(goodsSameRuleMap));
                return goodsSameRuleMap;
            }
        }
        log.info("batchGetSameGoodsRuleEsFilterByGoodsIds.goodsSameRuleMap:" + SerializationUtils.toJsonString(goodsSameRuleMap));
        return goodsSameRuleMap;
    }

    public GoodsSameRule getSameGoodsRuleEsFilterByGoodsId(long goodsId, String source) {
        log.info("getSameGoodsRuleEsFilterByGoodsId.goodsId:" + goodsId);
        HashSet<Long> goodIds = new HashSet<Long>(16);
        goodIds.add(goodsId);
        GoodsSameRule goodsSameRule = null;
        Map<Long, GoodsSameRule> goodsSameRuleMap = this.batchGetSameGoodsRuleEsFilterByGoodsIds(goodIds);
        if (null != goodsSameRuleMap.get(goodsId)) {
            goodsSameRule = goodsSameRuleMap.get(goodsId);
        } else {
            DynamicObjectCollection sameGoodsrules = this.getSameGoodsCols();
            GoodsSameRule newGoodsSameRule = new GoodsSameRule();
            newGoodsSameRule.setSimilar(((DynamicObject)sameGoodsrules.get(0)).getBoolean("issimilar"));
            newGoodsSameRule.setSamekind(((DynamicObject)sameGoodsrules.get(0)).getBoolean("issamekind"));
            newGoodsSameRule.setAutoCompare(((DynamicObject)sameGoodsrules.get(0)).getBoolean("isautocompare"));
            newGoodsSameRule.setGoodsMonitor(((DynamicObject)sameGoodsrules.get(0)).getBoolean("isgoodsmonitor"));
            goodsSameRule = newGoodsSameRule;
        }
        log.info("getSameGoodsRuleEsFilterByGoodsId.goodsSameRule:" + SerializationUtils.toJsonString((Object)goodsSameRule));
        return goodsSameRule;
    }

    private DynamicObject getGoodsCols(StringBuilder stringBuilder, long goodsId, String source) {
        String goodsSelectors = stringBuilder.substring(0, stringBuilder.length() - 1);
        QFilter goodsQFilters = null;
        String formId = "";
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
            goodsQFilters = new QFilter("goods.id", "=", (Object)goodsId);
            formId = "pmm_prodpool";
        } else {
            goodsQFilters = new QFilter("mallgoods.id", "=", (Object)goodsId);
            formId = "pbd_mallgoods_status";
        }
        return QueryServiceHelper.queryOne((String)formId, (String)goodsSelectors, (QFilter[])goodsQFilters.toArray());
    }

    private DynamicObjectCollection getEsMappingPropertys(Set<String> esNumbers, String source) {
        QFilter esqFilter = new QFilter("number", "in", esNumbers);
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
            esqFilter.and(new QFilter("indexentity.number", "=", (Object)"pmm_prodpool"));
        } else {
            esqFilter.and(new QFilter("indexentity.number", "=", (Object)"pbd_mallgoods_status"));
        }
        String esSelectors = "mappingfield,number";
        return QueryServiceHelper.query((String)"pbd_esmapping_property", (String)esSelectors, (QFilter[])esqFilter.toArray());
    }

    private DynamicObjectCollection getSameGoodsCols() {
        QFilter qFilter = new QFilter("id", "=", (Object)1893437194405041152L);
        String selectors = "isautocompare,isgoodsmonitor,issimilar,issamekind,entryentity.id,goodssort,entryentity.samerule.fbasedataid.mappingfield mappingfield,entryentity.samerule.fbasedataid.id,entryentity.samerule.fbasedataid.number number,entryentity.samerule.fbasedataid.number";
        return QueryServiceHelper.query((String)"pmm_samegoodsrule", (String)selectors, (QFilter[])qFilter.toArray());
    }
}

