/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.malcore.domain.GoodsPriceHistoryRecord;

public class PmmSelfGoodsUpgradeService {
    private static Log logger = LogFactory.getLog(PmmSelfGoodsUpgradeService.class);
    private static int Page_Index_Max = 1000;

    public void selfGoodsUpgradeExecuteService(Date date) {
        logger.info("input date=" + date);
        logger.info("delete data start");
        this.deleteRecord(date);
        logger.info("delete data end");
        QFilter qFilter = new QFilter("cfmdate", "<=", (Object)date);
        String selectors = "entryentity.goods.id";
        ArrayList<Long> idList = new ArrayList<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PmmSelfGoodsUpgradeServiceImpl", (String)"pmm_prodaudit", (String)selectors, (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                idList.add(row.getLong("entryentity.goods.id"));
            }
        }
        logger.info("pmm_prodpool.count=" + idList.size());
        if (idList.size() > 0) {
            int pageSize = idList.size() / Page_Index_Max;
            if (idList.size() % Page_Index_Max != 0) {
                ++pageSize;
            }
            for (int pageIndex = 0; pageIndex < pageSize; ++pageIndex) {
                List<Long> updateIdList = (pageIndex + 1) * Page_Index_Max > idList.size() ? idList.subList(pageIndex * Page_Index_Max, idList.size()) : idList.subList(pageIndex * Page_Index_Max, (pageIndex + 1) * Page_Index_Max);
                this.upgrade(updateIdList, date);
            }
        }
    }

    private void deleteRecord(Date date) {
        QFilter qFilter = new QFilter("adjustdate", "<=", (Object)date);
        DeleteServiceHelper.delete((String)"pmm_newpricelog", (QFilter[])qFilter.toArray());
    }

    private void upgrade(List<Long> updateIdList, Date date) {
        List values;
        HashMap<String, List<GoodsPriceHistoryRecord>> priceMap = new HashMap<String, List<GoodsPriceHistoryRecord>>(16);
        Map<String, Long> prodPoolMap = this.getProdPoolMap(updateIdList);
        this.dealProdAuditPriceMap(updateIdList, priceMap, prodPoolMap, date);
        this.dealPriceAuditPriceMap(updateIdList, priceMap, prodPoolMap, date);
        for (Map.Entry map : priceMap.entrySet()) {
            values = (List)map.getValue();
            if (values.size() <= 1) continue;
            Collections.sort(values, new Comparator<GoodsPriceHistoryRecord>(){

                @Override
                public int compare(GoodsPriceHistoryRecord p1, GoodsPriceHistoryRecord p2) {
                    if (null != p2.getAdjustdate() && null != p1.getAdjustdate() && p2.getAdjustdate().before(p1.getAdjustdate())) {
                        return 1;
                    }
                    if (null != p2.getAdjustdate() && null != p1.getAdjustdate() && p2.getAdjustdate().after(p1.getAdjustdate())) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        for (Map.Entry map : priceMap.entrySet()) {
            values = (List)map.getValue();
            GoodsPriceHistoryRecord firstGoodsPriceHistoryRecord = (GoodsPriceHistoryRecord)values.get(0);
            firstGoodsPriceHistoryRecord.setLastPrice(firstGoodsPriceHistoryRecord.getLaestPrice());
            BigDecimal lastPrice = firstGoodsPriceHistoryRecord.getLastPrice();
            for (int i = 1; i < values.size(); ++i) {
                GoodsPriceHistoryRecord goodsPriceHistoryRecord = (GoodsPriceHistoryRecord)values.get(i);
                goodsPriceHistoryRecord.setLastPrice(lastPrice);
                lastPrice = goodsPriceHistoryRecord.getLaestPrice();
            }
        }
        this.doAddPriceHistoryRecords(priceMap);
    }

    private Map<String, Long> getProdPoolMap(List<Long> updateIdList) {
        QFilter qFilter = new QFilter("goods.id", "in", updateIdList);
        String selectors = "id,protocolentry,goods.id,protocol";
        HashMap<String, Long> prodPoolMap = new HashMap<String, Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PmmSelfGoodsUpgradeServiceImpl", (String)"pmm_prodpool", (String)selectors, (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String key = row.getString("goods.id") + row.getString("protocol") + row.getString("protocolentry");
                prodPoolMap.put(key, row.getLong("id"));
            }
        }
        return prodPoolMap;
    }

    private void doAddPriceHistoryRecords(Map<String, List<GoodsPriceHistoryRecord>> priceMap) {
        ArrayList<GoodsPriceHistoryRecord> goodsPriceHistoryRecords = new ArrayList<GoodsPriceHistoryRecord>(16);
        for (Map.Entry<String, List<GoodsPriceHistoryRecord>> map : priceMap.entrySet()) {
            goodsPriceHistoryRecords.addAll((Collection)map.getValue());
        }
        ArrayList<DynamicObject> goodsInfos = new ArrayList<DynamicObject>(16);
        goodsInfos.addAll(this.addGoodPriceDyn(goodsPriceHistoryRecords));
        if (goodsInfos.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_newpricelog", (DynamicObject[])goodsInfos.toArray(new DynamicObject[0]), (OperateOption)option);
            if (saveResult.getSuccessPkIds().size() != goodsInfos.size()) {
                logger.info("saveerror" + ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
            }
        }
    }

    private List<DynamicObject> addGoodPriceDyn(List<GoodsPriceHistoryRecord> goodsPriceHistoryRecords) {
        ArrayList<DynamicObject> addDyns = new ArrayList<DynamicObject>(16);
        for (GoodsPriceHistoryRecord goodsInfo : goodsPriceHistoryRecords) {
            if (StringUtils.isEmpty((CharSequence)goodsInfo.getNumber())) continue;
            DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"pmm_newpricelog");
            info.set("goodspool", (Object)goodsInfo.getGoodsPoolId());
            info.set("goods", (Object)goodsInfo.getGoodsId());
            if (goodsInfo.isLadPrice()) {
                info.set("pricetype", (Object)"B");
            } else {
                info.set("pricetype", (Object)"A");
            }
            info.set("curr", (Object)goodsInfo.getCurr());
            info.set("lastprice", (Object)(goodsInfo.getLastPrice() == null ? BigDecimal.ZERO : goodsInfo.getLastPrice()));
            info.set("srcentitybilltype", (Object)goodsInfo.getSrcBillType());
            info.set("srcbillid", (Object)goodsInfo.getSrcBillId());
            info.set("srcbillno", (Object)goodsInfo.getSrcBillNo());
            info.set("adjustdate", (Object)goodsInfo.getAdjustdate());
            info.set("remark", (Object)goodsInfo.getNote());
            info.set("auditorg", (Object)goodsInfo.getAuditorg());
            info.set("taxprice", (Object)goodsInfo.getTaxprice());
            info.set("shopprice", (Object)goodsInfo.getTaxprice());
            info.set("taxrateid", (Object)goodsInfo.getTaxrateid());
            info.set("taxrate", (Object)goodsInfo.getTaxrate());
            info.set("price", (Object)goodsInfo.getPrice());
            info.set("name", (Object)goodsInfo.getName());
            info.set("number", (Object)goodsInfo.getNumber());
            info.set("origin", (Object)goodsInfo.getOrigin());
            info.set("creator", (Object)goodsInfo.getCreatorId());
            info.set("createtime", (Object)goodsInfo.getCreateDate());
            info.set("auditor", (Object)goodsInfo.getAuditorId());
            info.set("auditdate", (Object)goodsInfo.getAuditDate());
            addDyns.add(info);
        }
        return addDyns;
    }

    private void dealPriceAuditPriceMap(List<Long> updateIdList, Map<String, List<GoodsPriceHistoryRecord>> priceMap, Map<String, Long> prodPoolMap, Date date) {
        QFilter reqQF = new QFilter("entryentity.goods", "in", updateIdList);
        reqQF.and(new QFilter("cfmstatus", "=", (Object)"B"));
        reqQF.and(new QFilter("cfmdate", "<=", (Object)date));
        String reqSlectors = "curr,creator,createtime,origin,id,billno,org,cfmdate,cfmstatus,cfm,entryentity.goods goods,entryentity.note note,entryentity.shopprice shopprice,entryentity.taxprice taxprice,entryentity.price price,entryentity.taxrate taxrate,entryentity.taxrateid taxrateid,entryentity.prodpool prodpool,entryentity.prodpool.protocol protocol,entryentity.pricetype pricetype,entryentity.prodpool.protocolentry protocolentry,entryentity.taxprice_old taxprice_old,entryentity.goods.number number,entryentity.goods.name name";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PmmSelfGoodsUpgradeServiceImpl_pmm_priceaudit", (String)"pmm_priceaudit", (String)reqSlectors, (QFilter[])reqQF.toArray(), null);){
            while (dataSet.hasNext()) {
                List<Object> goodsPriceHistoryRecords = new ArrayList(16);
                Row row = dataSet.next();
                long goods = row.getLong("goods");
                long protocolId = row.getLong("protocol");
                long protocolentryId = row.getLong("protocolentry");
                String key = row.getString("goods") + row.getString("protocol") + row.getString("protocolentry");
                if (null != priceMap.get(key)) {
                    goodsPriceHistoryRecords = priceMap.get(key);
                }
                GoodsPriceHistoryRecord goodsPriceHistoryRecord = new GoodsPriceHistoryRecord();
                if (null != prodPoolMap.get(key)) {
                    goodsPriceHistoryRecord.setGoodsPoolId(prodPoolMap.get(key).longValue());
                }
                goodsPriceHistoryRecord.setGoodsId(goods);
                goodsPriceHistoryRecord.setProtocolId(protocolId);
                goodsPriceHistoryRecord.setProtocolEntryId(protocolentryId);
                goodsPriceHistoryRecord.setAdjustdate(row.getDate("cfmdate"));
                goodsPriceHistoryRecord.setAuditorg(row.getLong("org").longValue());
                goodsPriceHistoryRecord.setSrcBillId(row.getString("id"));
                goodsPriceHistoryRecord.setSrcBillNo(row.getString("billno"));
                goodsPriceHistoryRecord.setOrigin(row.getString("origin"));
                goodsPriceHistoryRecord.setSrcBillType("pmm_priceaudit");
                goodsPriceHistoryRecord.setNote(row.getString("note"));
                goodsPriceHistoryRecord.setCreateDate(row.getDate("createtime"));
                goodsPriceHistoryRecord.setCreatorId(row.getLong("creator").longValue());
                goodsPriceHistoryRecord.setAuditDate(row.getDate("cfmdate"));
                goodsPriceHistoryRecord.setAuditorId(row.getLong("cfm").longValue());
                goodsPriceHistoryRecord.setLaestPrice(row.getBigDecimal("taxprice"));
                goodsPriceHistoryRecord.setCurr(row.getLong("curr").longValue());
                goodsPriceHistoryRecord.setNumber(row.getString("number"));
                goodsPriceHistoryRecord.setName(row.getString("name"));
                goodsPriceHistoryRecord.setTaxprice(row.getBigDecimal("taxprice"));
                goodsPriceHistoryRecord.setPrice(row.getBigDecimal("price"));
                goodsPriceHistoryRecord.setTaxrateid(row.getLong("taxrateid").longValue());
                goodsPriceHistoryRecord.setTaxrate(row.getBigDecimal("taxrate"));
                goodsPriceHistoryRecord.setLastPrice(row.getBigDecimal("taxprice_old"));
                if ("B".equals(row.getString("pricetype"))) {
                    goodsPriceHistoryRecord.setLadPrice(Boolean.TRUE.booleanValue());
                } else {
                    goodsPriceHistoryRecord.setLadPrice(Boolean.FALSE.booleanValue());
                }
                goodsPriceHistoryRecords.add(goodsPriceHistoryRecord);
                priceMap.put(key, goodsPriceHistoryRecords);
            }
        }
    }

    private void dealProdAuditPriceMap(List<Long> updateIdList, Map<String, List<GoodsPriceHistoryRecord>> priceMap, Map<String, Long> prodPoolMap, Date date) {
        QFilter reqQF = new QFilter("entryentity.goods", "in", updateIdList);
        reqQF.and(new QFilter("biztype", "=", (Object)"1"));
        reqQF.and(new QFilter("entryentity.entryresult", "=", (Object)"1"));
        reqQF.and(new QFilter("cfmdate", "<=", (Object)date));
        String reqSlectors = "entryentity.goods.id goods,protocolid,entryentity.protocolentry.id protocolentry,org,id,billno,origin,entryentity.note note,creator,createtime,cfmdate,cfm,entryentity.taxprice taxprice,entryentity.price price,curr,entryentity.goods.number number,entryentity.goods.name name,entryentity.goods.taxrateid taxrateid,entryentity.goods.taxrate taxrate,entryentity.pricetype pricetype";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PmmSelfGoodsUpgradeServiceImpl", (String)"pmm_prodaudit", (String)reqSlectors, (QFilter[])reqQF.toArray(), null);){
            while (dataSet.hasNext()) {
                List<Object> goodsPriceHistoryRecords = new ArrayList(16);
                Row row = dataSet.next();
                long goods = row.getLong("goods");
                long protocolId = row.getLong("protocolid");
                long protocolentryId = row.getLong("protocolentry");
                String key = row.getString("goods") + row.getString("protocolid") + row.getString("protocolentry");
                if (null != priceMap.get(key)) {
                    goodsPriceHistoryRecords = priceMap.get(key);
                }
                GoodsPriceHistoryRecord goodsPriceHistoryRecord = new GoodsPriceHistoryRecord();
                if (null != prodPoolMap.get(key)) {
                    goodsPriceHistoryRecord.setGoodsPoolId(prodPoolMap.get(key).longValue());
                }
                goodsPriceHistoryRecord.setGoodsId(goods);
                goodsPriceHistoryRecord.setProtocolId(protocolId);
                goodsPriceHistoryRecord.setProtocolEntryId(protocolentryId);
                goodsPriceHistoryRecord.setAdjustdate(row.getDate("cfmdate"));
                goodsPriceHistoryRecord.setAuditorg(row.getLong("org").longValue());
                goodsPriceHistoryRecord.setSrcBillId(row.getString("id"));
                goodsPriceHistoryRecord.setSrcBillNo(row.getString("billno"));
                goodsPriceHistoryRecord.setOrigin(row.getString("origin"));
                if (row.getString("origin").equals("1")) {
                    goodsPriceHistoryRecord.setSrcBillType("ent_prodrequest");
                } else {
                    goodsPriceHistoryRecord.setSrcBillType("pmm_prodaudit");
                }
                goodsPriceHistoryRecord.setNote(row.getString("note"));
                goodsPriceHistoryRecord.setCreateDate(row.getDate("createtime"));
                goodsPriceHistoryRecord.setCreatorId(row.getLong("creator").longValue());
                goodsPriceHistoryRecord.setAuditDate(row.getDate("cfmdate"));
                goodsPriceHistoryRecord.setAuditorId(row.getLong("cfm").longValue());
                goodsPriceHistoryRecord.setLaestPrice(row.getBigDecimal("taxprice"));
                goodsPriceHistoryRecord.setCurr(row.getLong("curr").longValue());
                goodsPriceHistoryRecord.setNumber(row.getString("number"));
                goodsPriceHistoryRecord.setName(row.getString("name"));
                goodsPriceHistoryRecord.setTaxprice(row.getBigDecimal("taxprice"));
                goodsPriceHistoryRecord.setPrice(row.getBigDecimal("price"));
                goodsPriceHistoryRecord.setTaxrateid(row.getLong("taxrateid").longValue());
                goodsPriceHistoryRecord.setTaxrate(row.getBigDecimal("taxrate"));
                if ("B".equals(row.getString("pricetype"))) {
                    goodsPriceHistoryRecord.setLadPrice(Boolean.TRUE.booleanValue());
                } else {
                    goodsPriceHistoryRecord.setLadPrice(Boolean.FALSE.booleanValue());
                }
                goodsPriceHistoryRecords.add(goodsPriceHistoryRecord);
                priceMap.put(key, goodsPriceHistoryRecords);
            }
        }
    }
}

