/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.malcore.domain.GoodsInventory;
import kd.scm.malcore.domain.GoodsInventoryHandleOrder;
import kd.scm.malcore.domain.GoodsInventoryHandleParam;
import kd.scm.malcore.domain.GoodsInventoryHandleResult;
import kd.scm.malcore.domain.GoodsInventoryHandleSku;
import kd.scm.pmm.business.service.GoodsInventoryService;
import kd.scm.pmm.common.enums.InventoryServiceType;

public class GoodsInventoryServiceImpl
implements GoodsInventoryService {
    private static final Log log = LogFactory.getLog(GoodsInventoryServiceImpl.class);

    @Override
    public List<GoodsInventory> queryGoodsInventory(List<GoodsInventoryHandleSku> skuList) {
        log.info("@@@PmmGoodsInventoryServiceImpl.queryGoodsInventory:start");
        ArrayList<GoodsInventory> result = new ArrayList<GoodsInventory>(skuList.size() * 2);
        List goodsIds = skuList.stream().map(GoodsInventoryHandleSku::getGoodsId).collect(Collectors.toList());
        QFilter qFilter = new QFilter("goods", "in", goodsIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pmm_inventory", (String)"goods,goods.unit goodsunit,unit,qty,lockedqty,availableqty", (QFilter[])qFilter.toArray(), null);){
            for (Row row : dataSet) {
                if (!row.getLong("unit").equals(row.getLong("goodsunit"))) continue;
                GoodsInventory goodsInventory = new GoodsInventory();
                goodsInventory.setGoodsId(row.getLong("goods"));
                goodsInventory.setCurrentQty(row.getBigDecimal("qty"));
                goodsInventory.setLockedQty(row.getBigDecimal("lockedqty"));
                goodsInventory.setAvailableQty(row.getBigDecimal("availableqty"));
                goodsInventory.setUnlimited(false);
                goodsIds.remove(row.getLong("goods"));
                result.add(goodsInventory);
            }
        }
        for (Long goodsId : goodsIds) {
            GoodsInventory goodsInventory = new GoodsInventory();
            goodsInventory.setGoodsId(goodsId);
            goodsInventory.setUnlimited(true);
            result.add(goodsInventory);
        }
        log.info("@@@PmmGoodsInventoryServiceImpl.queryGoodsInventory:end");
        return result;
    }

    @Override
    public GoodsInventoryHandleResult addGoodsLockInventoryQty(GoodsInventoryHandleParam goodsInventoryHandleParam) {
        log.info("@@@PmmGoodsInventoryServiceImpl.addGoodsLockInventoryQty:start");
        GoodsInventoryHandleResult goodsInventoryHandleResult = new GoodsInventoryHandleResult();
        List goodsInventoryHandleOrderList = goodsInventoryHandleParam.getGoodsInventoryHandleOrderList();
        Map<Long, GoodsInventoryHandleSku> goodsIdsAndQtyMap = this.getGoodsIdsAndQtyMap(goodsInventoryHandleOrderList);
        DynamicObject[] inventoryDynArray = BusinessDataServiceHelper.load((String)"pmm_inventory", (String)"goods,unit,qty,lockedqty,availableqty", (QFilter[])new QFilter[]{new QFilter("goods", "in", goodsIdsAndQtyMap.keySet())});
        Map<Long, DynamicObject> skuIdAndDynMap = this.getSkuIdAndDynMap(inventoryDynArray);
        ArrayList<DynamicObject> logNewDyn = new ArrayList<DynamicObject>(goodsInventoryHandleOrderList.size());
        for (GoodsInventoryHandleOrder goodsInventoryHandleOrder : goodsInventoryHandleOrderList) {
            List skuList = goodsInventoryHandleOrder.getSkuList();
            for (GoodsInventoryHandleSku sku : skuList) {
                DynamicObject inventoryDyn = skuIdAndDynMap.get(sku.getGoodsId());
                if (inventoryDyn == null) continue;
                inventoryDyn.set("lockedqty", (Object)inventoryDyn.getBigDecimal("lockedqty").add(sku.getQty()));
                inventoryDyn.set("availableqty", (Object)inventoryDyn.getBigDecimal("qty").subtract(inventoryDyn.getBigDecimal("lockedqty")));
                DynamicObject newInventoryLogDyn = this.getNewLogDyn(goodsInventoryHandleOrder, inventoryDyn, sku);
                newInventoryLogDyn.set("servicetype", (Object)InventoryServiceType.PREEMPTION.getVal());
                logNewDyn.add(newInventoryLogDyn);
            }
        }
        this.saveDyn(null, inventoryDynArray, logNewDyn);
        log.info("@@@PmmGoodsInventoryServiceImpl.addGoodsLockInventoryQty:end");
        return goodsInventoryHandleResult;
    }

    @Override
    public GoodsInventoryHandleResult cancelGoodsLockInventoryQty(GoodsInventoryHandleParam goodsInventoryHandleParam) {
        log.info("@@@PmmGoodsInventoryServiceImpl.cancelGoodsLockInventoryQty:start");
        GoodsInventoryHandleResult goodsInventoryHandleResult = new GoodsInventoryHandleResult();
        List goodsInventoryHandleOrderList = goodsInventoryHandleParam.getGoodsInventoryHandleOrderList();
        Map<Long, GoodsInventoryHandleSku> goodsIdsAndQtyMap = this.getGoodsIdsAndQtyMap(goodsInventoryHandleOrderList);
        DynamicObject[] inventoryDynArray = BusinessDataServiceHelper.load((String)"pmm_inventory", (String)"goods,unit,qty,lockedqty,availableqty", (QFilter[])new QFilter[]{new QFilter("goods", "in", goodsIdsAndQtyMap.keySet())});
        Map<Long, DynamicObject> skuIdAndDynMap = this.getSkuIdAndDynMap(inventoryDynArray);
        ArrayList<DynamicObject> logNewDyn = new ArrayList<DynamicObject>(goodsInventoryHandleOrderList.size());
        for (GoodsInventoryHandleOrder goodsInventoryHandleOrder : goodsInventoryHandleOrderList) {
            List skuList = goodsInventoryHandleOrder.getSkuList();
            for (GoodsInventoryHandleSku sku : skuList) {
                DynamicObject inventoryDyn = skuIdAndDynMap.get(sku.getGoodsId());
                if (inventoryDyn == null) continue;
                inventoryDyn.set("lockedqty", (Object)inventoryDyn.getBigDecimal("lockedqty").subtract(sku.getQty()));
                inventoryDyn.set("availableqty", (Object)inventoryDyn.getBigDecimal("qty").subtract(inventoryDyn.getBigDecimal("lockedqty")));
                DynamicObject newInventoryLogDyn = this.getNewLogDyn(goodsInventoryHandleOrder, inventoryDyn, sku);
                newInventoryLogDyn.set("servicetype", (Object)InventoryServiceType.RELEASE_PREEMPTION.getVal());
                logNewDyn.add(newInventoryLogDyn);
            }
        }
        this.saveDyn(null, inventoryDynArray, logNewDyn);
        log.info("@@@PmmGoodsInventoryServiceImpl.cancelGoodsLockInventoryQty:end");
        return goodsInventoryHandleResult;
    }

    @Override
    public GoodsInventoryHandleResult confirmGoodsLockInventoryQty(GoodsInventoryHandleParam goodsInventoryHandleParam) {
        log.info("@@@PmmGoodsInventoryServiceImpl.confirmGoodsLockInventoryQty:start");
        GoodsInventoryHandleResult goodsInventoryHandleResult = new GoodsInventoryHandleResult();
        List goodsInventoryHandleOrderList = goodsInventoryHandleParam.getGoodsInventoryHandleOrderList();
        Map<Long, GoodsInventoryHandleSku> goodsIdsAndQtyMap = this.getGoodsIdsAndQtyMap(goodsInventoryHandleOrderList);
        DynamicObject[] inventoryDynArray = BusinessDataServiceHelper.load((String)"pmm_inventory", (String)"goods,unit,qty,lockedqty,availableqty", (QFilter[])new QFilter[]{new QFilter("goods", "in", goodsIdsAndQtyMap.keySet())});
        Map<Long, DynamicObject> skuIdAndDynMap = this.getSkuIdAndDynMap(inventoryDynArray);
        ArrayList<DynamicObject> logNewDyn = new ArrayList<DynamicObject>(goodsInventoryHandleOrderList.size());
        for (GoodsInventoryHandleOrder goodsInventoryHandleOrder : goodsInventoryHandleOrderList) {
            List skuList = goodsInventoryHandleOrder.getSkuList();
            for (GoodsInventoryHandleSku sku : skuList) {
                DynamicObject inventoryDyn = skuIdAndDynMap.get(sku.getGoodsId());
                if (inventoryDyn == null) continue;
                inventoryDyn.set("lockedqty", (Object)inventoryDyn.getBigDecimal("lockedqty").subtract(sku.getQty()));
                inventoryDyn.set("qty", (Object)inventoryDyn.getBigDecimal("qty").subtract(sku.getQty()));
                inventoryDyn.set("availableqty", (Object)inventoryDyn.getBigDecimal("qty").subtract(inventoryDyn.getBigDecimal("lockedqty")));
                DynamicObject newInventoryLogDyn = this.getNewLogDyn(goodsInventoryHandleOrder, inventoryDyn, sku);
                newInventoryLogDyn.set("servicetype", (Object)InventoryServiceType.DEDUCTION.getVal());
                logNewDyn.add(newInventoryLogDyn);
            }
        }
        this.saveDyn(null, inventoryDynArray, logNewDyn);
        log.info("@@@PmmGoodsInventoryServiceImpl.confirmGoodsLockInventoryQty:end");
        return goodsInventoryHandleResult;
    }

    @Override
    public GoodsInventoryHandleResult addGoodsCurrentInventoryQty(GoodsInventoryHandleParam goodsInventoryHandleParam) {
        log.info("@@@PmmGoodsInventoryServiceImpl.addGoodsCurrentInventoryQty:start");
        GoodsInventoryHandleResult goodsInventoryHandleResult = new GoodsInventoryHandleResult();
        List goodsInventoryHandleOrderList = goodsInventoryHandleParam.getGoodsInventoryHandleOrderList();
        Map<Long, GoodsInventoryHandleSku> goodsIdsAndQtyMap = this.getGoodsIdsAndQtyMap(goodsInventoryHandleOrderList);
        DynamicObject[] inventoryDynArray = BusinessDataServiceHelper.load((String)"pmm_inventory", (String)"goods,unit,qty,lockedqty,availableqty,createtime", (QFilter[])new QFilter[]{new QFilter("goods", "in", goodsIdsAndQtyMap.keySet())});
        Map<Long, DynamicObject> skuIdAndDynMap = this.getSkuIdAndDynMap(inventoryDynArray);
        ArrayList<DynamicObject> logNewDyn = new ArrayList<DynamicObject>(goodsInventoryHandleOrderList.size());
        for (GoodsInventoryHandleOrder goodsInventoryHandleOrder : goodsInventoryHandleOrderList) {
            List skuList = goodsInventoryHandleOrder.getSkuList();
            for (GoodsInventoryHandleSku sku : skuList) {
                DynamicObject inventoryDyn = skuIdAndDynMap.get(sku.getGoodsId());
                if (inventoryDyn == null || !goodsInventoryHandleOrder.getAuditDate().after(inventoryDyn.getDate("createtime"))) continue;
                inventoryDyn.set("qty", (Object)inventoryDyn.getBigDecimal("qty").add(sku.getQty()));
                inventoryDyn.set("availableqty", (Object)inventoryDyn.getBigDecimal("qty").subtract(inventoryDyn.getBigDecimal("lockedqty")));
                DynamicObject newInventoryLogDyn = this.getNewLogDyn(goodsInventoryHandleOrder, inventoryDyn, sku);
                newInventoryLogDyn.set("servicetype", (Object)InventoryServiceType.RELEASE_DEDUCTION.getVal());
                logNewDyn.add(newInventoryLogDyn);
            }
        }
        this.saveDyn(null, inventoryDynArray, logNewDyn);
        log.info("@@@PmmGoodsInventoryServiceImpl.addGoodsCurrentInventoryQty:end");
        return goodsInventoryHandleResult;
    }

    @Override
    public GoodsInventoryHandleResult modifyGoodsCurrentInventoryQty(GoodsInventoryHandleParam goodsInventoryHandleParam) {
        log.info("@@@PmmGoodsInventoryServiceImpl.modifyGoodsCurrentInventoryQty:start");
        GoodsInventoryHandleResult goodsInventoryHandleResult = new GoodsInventoryHandleResult();
        List goodsInventoryHandleOrderList = goodsInventoryHandleParam.getGoodsInventoryHandleOrderList();
        Map<Long, GoodsInventoryHandleSku> goodsIdsAndQtyMap = this.getGoodsIdsAndQtyMap(goodsInventoryHandleOrderList);
        ArrayList<DynamicObject> newInventoryDynList = new ArrayList<DynamicObject>(goodsInventoryHandleOrderList.size());
        DynamicObject[] inventoryDynArray = BusinessDataServiceHelper.load((String)"pmm_inventory", (String)"goods,unit,qty,lockedqty,availableqty,createtime", (QFilter[])new QFilter[]{new QFilter("goods", "in", goodsIdsAndQtyMap.keySet())});
        Map<Long, DynamicObject> skuIdAndDynMap = this.getSkuIdAndDynMap(inventoryDynArray);
        ArrayList<DynamicObject> logNewDyn = new ArrayList<DynamicObject>(goodsInventoryHandleOrderList.size());
        for (GoodsInventoryHandleOrder goodsInventoryHandleOrder : goodsInventoryHandleOrderList) {
            List skuList = goodsInventoryHandleOrder.getSkuList();
            for (GoodsInventoryHandleSku sku : skuList) {
                DynamicObject inventoryDyn = skuIdAndDynMap.get(sku.getGoodsId());
                if (inventoryDyn == null) {
                    inventoryDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_inventory");
                    inventoryDyn.set("supplier_id", (Object)sku.getSupplier());
                    inventoryDyn.set("bizpartner_id", (Object)sku.getBizpartner());
                    inventoryDyn.set("goods_id", (Object)sku.getGoodsId());
                    inventoryDyn.set("goodsclass_id", (Object)sku.getCategory());
                    inventoryDyn.set("creator", (Object)UserServiceHelper.getCurrentUserId());
                    inventoryDyn.set("createtime", (Object)TimeServiceHelper.now());
                    newInventoryDynList.add(inventoryDyn);
                }
                inventoryDyn.set("unit_id", (Object)sku.getUnit());
                inventoryDyn.set("qty", (Object)sku.getQty());
                inventoryDyn.set("availableqty", (Object)inventoryDyn.getBigDecimal("qty").subtract(inventoryDyn.getBigDecimal("lockedqty")));
                DynamicObject newInventoryLogDyn = this.getNewLogDyn(goodsInventoryHandleOrder, inventoryDyn, sku);
                newInventoryLogDyn.set("servicetype", (Object)InventoryServiceType.MODIFY.getVal());
                logNewDyn.add(newInventoryLogDyn);
            }
        }
        this.saveDyn(newInventoryDynList, inventoryDynArray, logNewDyn);
        log.info("@@@PmmGoodsInventoryServiceImpl.modifyGoodsCurrentInventoryQty:end");
        return goodsInventoryHandleResult;
    }

    private Map<Long, GoodsInventoryHandleSku> getGoodsIdsAndQtyMap(List<GoodsInventoryHandleOrder> goodsInventoryHandleOrderList) {
        HashMap<Long, GoodsInventoryHandleSku> goodsIdsAndQtyMap = new HashMap<Long, GoodsInventoryHandleSku>(goodsInventoryHandleOrderList.size());
        for (GoodsInventoryHandleOrder goodsInventoryHandleOrder : goodsInventoryHandleOrderList) {
            List skuList = goodsInventoryHandleOrder.getSkuList();
            for (GoodsInventoryHandleSku sku : skuList) {
                GoodsInventoryHandleSku skus = goodsIdsAndQtyMap.getOrDefault(sku.getGoodsId(), new GoodsInventoryHandleSku());
                skus.setGoodsId(sku.getGoodsId());
                skus.setGoodsNumber(sku.getGoodsNumber());
                skus.setQty(sku.getQty().add(skus.getQty()));
                goodsIdsAndQtyMap.put(sku.getGoodsId(), skus);
            }
        }
        return goodsIdsAndQtyMap;
    }

    private Map<Long, DynamicObject> getSkuIdAndDynMap(DynamicObject[] inventoryDynArray) {
        HashMap<Long, DynamicObject> skuIdAndDynMap = new HashMap<Long, DynamicObject>(inventoryDynArray.length);
        for (DynamicObject dynamicObject : inventoryDynArray) {
            if (dynamicObject.getLong("unit_id") != dynamicObject.getDynamicObject("goods").getLong("unit_id")) continue;
            skuIdAndDynMap.put(dynamicObject.getLong("goods_id"), dynamicObject);
        }
        return skuIdAndDynMap;
    }

    private DynamicObject getNewLogDyn(GoodsInventoryHandleOrder goodsInventoryHandleOrder, DynamicObject inventoryDyn, GoodsInventoryHandleSku sku) {
        DynamicObject logDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_inventory_log");
        logDyn.set("entitybillno", (Object)goodsInventoryHandleOrder.getBillNo());
        logDyn.set("operationname", (Object)goodsInventoryHandleOrder.getOperationName());
        logDyn.set("entityname", (Object)goodsInventoryHandleOrder.getEntityName());
        logDyn.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        logDyn.set("createtime", (Object)TimeServiceHelper.now());
        logDyn.set("goods", (Object)inventoryDyn.getLong("goods_id"));
        logDyn.set("currentqty", (Object)inventoryDyn.getBigDecimal("qty"));
        logDyn.set("availableqty", (Object)inventoryDyn.getBigDecimal("availableqty"));
        logDyn.set("lockedqty", (Object)inventoryDyn.getBigDecimal("lockedqty"));
        logDyn.set("changeqty", (Object)sku.getQty());
        logDyn.set("unit", (Object)inventoryDyn.getLong("unit_id"));
        return logDyn;
    }

    private void saveDyn(List<DynamicObject> newInventoryDynList, DynamicObject[] inventoryDynArray, List<DynamicObject> logNewDyn) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        OperationResult operationResult = null;
        if (newInventoryDynList != null && !newInventoryDynList.isEmpty()) {
            operationResult = OperationServiceHelper.executeOperate((String)"addinventory", (String)"pmm_inventory", (DynamicObject[])newInventoryDynList.toArray(new DynamicObject[0]), (OperateOption)option);
            CommonUtil.check((OperationResult)operationResult);
        }
        if (inventoryDynArray.length > 0) {
            operationResult = OperationServiceHelper.executeOperate((String)"updateinventory", (String)"pmm_inventory", (DynamicObject[])inventoryDynArray, (OperateOption)option);
            CommonUtil.check((OperationResult)operationResult);
        }
        if (operationResult != null && operationResult.isSuccess()) {
            SaveServiceHelper.save((DynamicObject[])logNewDyn.toArray(new DynamicObject[0]));
        }
    }
}

