/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.pmm.business.model.mainpageconfig.BaseMainPageConfigInfo;
import kd.scm.pmm.business.model.mainpageconfig.BottomBox;
import kd.scm.pmm.business.model.mainpageconfig.Floors;
import kd.scm.pmm.business.model.mainpageconfig.LoginInfo;
import kd.scm.pmm.business.model.mainpageconfig.Logo;
import kd.scm.pmm.business.model.mainpageconfig.MainPageConfig;
import kd.scm.pmm.business.model.mainpageconfig.MalSwiper;
import kd.scm.pmm.business.model.mainpageconfig.NavMenuData;
import kd.scm.pmm.business.model.mainpageconfig.TabOption;
import kd.scm.pmm.business.model.mainpageconfig.UserInfo;
import kd.scm.pmm.business.service.MainPageConfigDomainService;

public class MainPageConfigDomainServiceImpl
implements MainPageConfigDomainService {
    @Override
    public Logo getLogo(MainPageConfig mainPageConfig) {
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("isonhomepage", "=", (Object)true);
        DynamicObject configDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_compconfig", (QFilter[])new QFilter[]{filter});
        if (configDyn != null) {
            return new MainPageConfig(configDyn).getLogo();
        }
        return mainPageConfig.getLogo();
    }

    @Override
    public List<TabOption> getTabOptions() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        Map configDynMap = BusinessDataServiceHelper.loadFromCache((String)"pmm_compconfig", (QFilter[])new QFilter[]{filter});
        ArrayList<TabOption> tabOptions = new ArrayList<TabOption>();
        configDynMap.forEach((id, configDyn) -> {
            TabOption tabOption = new TabOption();
            tabOption.setTitle(configDyn.getString("name"));
            tabOption.setValue(configDyn.getString("id"));
            tabOption.setRank(configDyn.getInt("rank"));
            tabOptions.add(tabOption);
        });
        Collections.sort(tabOptions);
        return tabOptions;
    }

    @Override
    public List<NavMenuData> getNavMenuData(MainPageConfig mainPageConfig) {
        return mainPageConfig.getNavMenuDataList();
    }

    @Override
    public BottomBox getBottomBox(MainPageConfig mainPageConfig) {
        return mainPageConfig.getBottomBox();
    }

    @Override
    public UserInfo getUserInfo() {
        DynamicObject orgDyn;
        UserInfo userInfo = new UserInfo();
        userInfo.setUserId(RequestContext.get().getCurrUserId());
        userInfo.setUserName(RequestContext.get().getUserName());
        userInfo.setUserIcon(MainPageConfigDomainServiceImpl.getCurrentUserAvatarPath());
        userInfo.setOrgId(RequestContext.get().getOrgId());
        UserServiceHelper.getUserTheme((Long)RequestContext.get().getCurrUserId());
        Object color = UserServiceHelper.getUserThemeNumAndVerNew((Long)RequestContext.get().getCurrUserId()).get("color");
        if (StringUtils.isNotBlank(color)) {
            userInfo.setThemeColor(String.valueOf(color));
        }
        if ((orgDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)userInfo.getOrgId(), (String)"bos_org")) != null) {
            userInfo.setOrgName(orgDyn.getString("name"));
        }
        return userInfo;
    }

    private static String getCurrentUserAvatarPath() {
        long userId = RequestContext.get().getCurrUserId();
        Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userId), (boolean)true);
        if (!CollectionUtils.isEmpty((Map)userAvatarPathMap)) {
            String imgURL = (String)userAvatarPathMap.get(userId);
            return StringUtils.isBlank((CharSequence)imgURL) ? "/images/pc/emotion/default_person_82_82.png" : imgURL;
        }
        return UrlService.getImageFullUrl((String)"/images/pc/emotion/default_person_82_82.png");
    }

    @Override
    public LoginInfo getLoginInfo() {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setLogin(RequestContext.get().getCurrUserId() > 0L);
        loginInfo.setAccountId(RequestContext.get().getAccountId());
        loginInfo.setAccountName(this.getAccountName());
        loginInfo.setTenantId(RequestContext.get().getTenantId());
        return loginInfo;
    }

    private String getAccountName() {
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        if (account != null) {
            return account.getAccountName();
        }
        return "";
    }

    @Override
    public Floors getFloors(MainPageConfig mainPageConfig, int start, int size) {
        Floors floors = new Floors();
        try {
            floors = mainPageConfig.getFloors(start, size);
        }
        catch (Exception e) {
            floors.setErrorInfo(ExceptionUtil.getStackTrace((Throwable)e));
        }
        return floors;
    }

    @Override
    public BaseMainPageConfigInfo getBaseMainPageConfig(MainPageConfig mainPageConfig) {
        BaseMainPageConfigInfo baseMainPageConfigInfo = new BaseMainPageConfigInfo();
        try {
            baseMainPageConfigInfo.setTabOption(this.getTabOptions());
            baseMainPageConfigInfo.setMenuData(this.getNavMenuData(mainPageConfig));
            Logo logo = this.getLogo(mainPageConfig);
            baseMainPageConfigInfo.setLogo(logo);
            baseMainPageConfigInfo.setMalSwiper(this.getMalSwiper(mainPageConfig));
            baseMainPageConfigInfo.setBottomBox(this.getBottomBox(mainPageConfig));
            baseMainPageConfigInfo.setLoginInfo(this.getLoginInfo());
            baseMainPageConfigInfo.setUserInfo(this.getUserInfo());
            baseMainPageConfigInfo.setCategoryStyle(this.getIsShowSecondInMain());
            baseMainPageConfigInfo.setBrowserIconUrl(logo.getBrowserIconUrl());
            baseMainPageConfigInfo.setShowPrice(mainPageConfig.showPrice());
            return baseMainPageConfigInfo;
        }
        catch (Exception e) {
            baseMainPageConfigInfo.setErrorInfo(ExceptionUtil.getStackTrace((Throwable)e));
            return baseMainPageConfigInfo;
        }
    }

    private String getIsShowSecondInMain() {
        String appId = "UUPIH+47DAK";
        String isShow = ParamUtil.getParam((String)appId, (String)"categorystyle");
        return StringUtils.isBlank((CharSequence)isShow) ? "0" : isShow;
    }

    @Override
    public MalSwiper getMalSwiper(MainPageConfig mainPageConfig) {
        return mainPageConfig.getMalSwiper();
    }
}

