/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.es.storage.EsResultVo;
import kd.scm.common.es.storage.EsSearchParam;
import kd.scm.common.extension.ScmExtensionFactory;
import kd.scm.pmm.business.model.product.PmmProdObtain;
import kd.scm.pmm.business.service.IPmmGoodsInfoChangeMonitorservice;
import kd.scm.pmm.business.service.PmmBusinessServiceFactory;
import kd.scm.pmm.business.service.PmmProductObtainService;
import kd.sdk.scm.pmm.extpoint.IOperateMonitorRuleService;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceParam;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceResult;

public class PmmGoodsInfoChangeMonitorserviceImpl
implements IPmmGoodsInfoChangeMonitorservice {
    private static final long SAMERULEID = 1893437194405041152L;

    @Override
    public List<MonitorRuleServiceResult> isMatchGoodsInfoChangeRule(MonitorRuleServiceParam param) {
        this.dealParam(param);
        ArrayList<MonitorRuleServiceResult> matchRuleRecords = new ArrayList<MonitorRuleServiceResult>(16);
        DynamicObjectCollection sameComparerules = this.getSameComapreCols();
        if (sameComparerules.size() > 0) {
            if (!((DynamicObject)sameComparerules.get(0)).getBoolean("isgoodsmonitor")) {
                return matchRuleRecords;
            }
            long pmmProdObtainId = ((DynamicObject)sameComparerules.get(0)).getLong("priceproductobtain");
            HashSet<Long> removeGoodsIds = new HashSet<Long>(16);
            if (0L != pmmProdObtainId) {
                EsSearchParam esSearchParam = PmmBusinessServiceFactory.serviceOf(PmmProductObtainService.class).getEsSearchParamByProdObtain(new PmmProdObtain(pmmProdObtainId));
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                paramMap.put("esFilterFields", esSearchParam.getEsFilterFields());
                paramMap.put("pageSize", esSearchParam.getPageSize());
                EsResultVo esResultVo = (EsResultVo)DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"IMalSearchService", (String)"search", (Object[])new Object[]{paramMap});
                if (null != esResultVo) {
                    List resultData = esResultVo.getResultData();
                    for (Map map : resultData) {
                        if (null == map.get("goodsid")) continue;
                        removeGoodsIds.add(Long.parseLong(String.valueOf(map.get("goodsid"))));
                    }
                }
            }
            if (removeGoodsIds.size() > 0 && removeGoodsIds.contains(param.getGoodsId())) {
                return matchRuleRecords;
            }
            boolean iscomparesameprice = ((DynamicObject)sameComparerules.get(0)).getBoolean("ispricesameprice");
            BigDecimal taxPrice = param.getTaxPrice();
            HashSet<Long> needCheckEntrys = new HashSet<Long>(16);
            if (iscomparesameprice) {
                for (DynamicObject row : sameComparerules) {
                    BigDecimal startPrice = row.getBigDecimal("pricemonitorentry.monitorstartprice");
                    if (null == startPrice) {
                        startPrice = BigDecimal.ZERO;
                    }
                    BigDecimal endPrice = row.getBigDecimal("pricemonitorentry.monitorendprice");
                    if (taxPrice.compareTo(startPrice) < 0 || null != endPrice && endPrice.compareTo(BigDecimal.ZERO) != 0 && taxPrice.compareTo(endPrice) >= 0) continue;
                    needCheckEntrys.add(row.getLong("pricemonitorentry.id"));
                }
            }
            for (DynamicObject row : sameComparerules) {
                long enrtryId = row.getLong("pricemonitorentry.id");
                if (iscomparesameprice && !needCheckEntrys.contains(enrtryId)) continue;
                this.dealRuleEntry(row, param, matchRuleRecords);
            }
        }
        return matchRuleRecords;
    }

    private void dealParam(MonitorRuleServiceParam param) {
        QFilter qFilter = null;
        String selectors = "";
        String formId = "";
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(param.getPlatform())) {
            qFilter = new QFilter("goods.id", "=", (Object)param.getGoodsId());
            qFilter.and(new QFilter("goodspool.id", "=", (Object)param.getGoodsPoolId()));
            selectors = "lastprice,taxprice,adjustdate";
            formId = "pmm_newpricelog";
        } else {
            qFilter = new QFilter("mallgoods.id", "=", (Object)param.getGoodsId());
            selectors = "mallgoods.priceinfo.price taxprice,price lastprice,modifytime adjustdate";
            formId = "pbd_mallgoods_pricelog";
        }
        if (StringUtils.isEmpty((CharSequence)formId)) {
            return;
        }
        DynamicObjectCollection goodPriceLogs = QueryServiceHelper.query((String)formId, (String)selectors, (QFilter[])qFilter.toArray());
        ArrayList priceLogList = new ArrayList(16);
        for (DynamicObject rowPriceLog : goodPriceLogs) {
            HashMap<String, Comparable<BigDecimal>> priceLogDetailMap = new HashMap<String, Comparable<BigDecimal>>(16);
            priceLogDetailMap.put("taxprice", rowPriceLog.getBigDecimal("taxprice"));
            priceLogDetailMap.put("lastprice", rowPriceLog.getBigDecimal("lastprice"));
            priceLogDetailMap.put("adjustdate", rowPriceLog.getDate("adjustdate"));
            priceLogList.add(priceLogDetailMap);
        }
        param.setPriceLogList(priceLogList);
    }

    private void dealRuleEntry(DynamicObject row, MonitorRuleServiceParam param, List<MonitorRuleServiceResult> matchRuleRecords) {
        String priceRuleNumber = row.getString("pricemonitorentry.monitorpricerule.number");
        String thresholdtype = row.getString("pricemonitorentry.monitorpricerule.thresholdtype");
        long priceruleId = row.getLong("pricemonitorentry.monitorpricerule.id");
        String samethreshold = row.getString("pricemonitorentry.monitorsamethreshold");
        String controltype = row.getString("pricemonitorentry.monitorcontroltype");
        boolean isSameAutodown = row.getBoolean("pricemonitorentry.monitorissameautodown");
        BigDecimal val = null;
        if (!StringUtils.isEmpty((CharSequence)priceRuleNumber)) {
            MonitorRuleServiceResult matchMonitorRule;
            IOperateMonitorRuleService extension = (IOperateMonitorRuleService)ScmExtensionFactory.getExtensionFacotry(IOperateMonitorRuleService.class).getExtension(priceRuleNumber);
            if ("2".equals(thresholdtype)) {
                String replace = samethreshold.replace("%", "");
                if (StringUtils.isEmpty((CharSequence)replace)) {
                    return;
                }
                val = new BigDecimal(replace);
            }
            if ("3".equals(thresholdtype)) {
                if (StringUtils.isEmpty((CharSequence)samethreshold)) {
                    return;
                }
                val = new BigDecimal(samethreshold);
            }
            if (null != (matchMonitorRule = extension.isMatchMonitorRule(param, val)) && matchMonitorRule.isMatch()) {
                matchMonitorRule.setThreshold(samethreshold);
                matchMonitorRule.setRuleId(priceruleId);
                matchMonitorRule.setBizOperate(controltype);
                matchMonitorRule.setIsAutoDown(isSameAutodown);
                matchMonitorRule.setThresholdType(thresholdtype);
                matchRuleRecords.add(matchMonitorRule);
            }
        }
    }

    private DynamicObjectCollection getSameComapreCols() {
        QFilter qFilter = new QFilter("id", "=", (Object)1893437194405041152L);
        String selectors = "isgoodsmonitor,priceproductobtain,ispricesameprice,pricemonitorentry.id,pricemonitorentry.monitorpricerule.id,pricemonitorentry.monitorpricerule.thresholdtype,pricemonitorentry.monitorpricerule.number,pricemonitorentry.monitorstartprice,pricemonitorentry.monitorendprice,pricemonitorentry.monitorpricerule,pricemonitorentry.monitorsamethreshold,pricemonitorentry.monitorcontroltype,pricemonitorentry.monitorissameautodown";
        return QueryServiceHelper.query((String)"pmm_samegoodsrule", (String)selectors, (QFilter[])qFilter.toArray());
    }
}

