/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.malcore.domain.GoodsPriceHistoryRecord;
import kd.scm.pmm.business.service.PmmGoodsPriceService;

public class PmmGoodsPriceServiceImpl
implements PmmGoodsPriceService {
    private static final Log log = LogFactory.getLog((String)PmmGoodsPriceServiceImpl.class.getName());

    @Override
    public void addGoodsPriceHistoryRecords(List<GoodsPriceHistoryRecord> goodsPriceHistoryRecords) {
        HashMap<String, GoodsPriceHistoryRecord> goodsMap = new HashMap<String, GoodsPriceHistoryRecord>(16);
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        for (GoodsPriceHistoryRecord info : goodsPriceHistoryRecords) {
            String key = String.valueOf(info.getGoodsId()) + String.valueOf(info.getProtocolId()) + String.valueOf(info.getProtocolEntryId());
            goodsMap.put(key, info);
            goodsIds.add(info.getGoodsId());
        }
        QFilter qFilter = new QFilter("goods.id", "in", goodsIds);
        String selectors = "protocol,protocolentry,goods.id,id,goods.taxprice,pricetype,goods.curr,taxprice,goods.name,goods.number,taxrateid,taxrate,price";
        DynamicObjectCollection pmmProdpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)selectors, (QFilter[])qFilter.toArray());
        for (DynamicObject row : pmmProdpools) {
            long goodsId = row.getLong("goods.id");
            long protocolentry = row.getLong("protocolentry");
            long protocol = row.getLong("protocol");
            String key = String.valueOf(goodsId) + String.valueOf(protocol) + String.valueOf(protocolentry);
            String pricetype = row.getString("pricetype");
            if (null == goodsMap.get(key)) continue;
            GoodsPriceHistoryRecord goodsPriceHistoryRecord = (GoodsPriceHistoryRecord)goodsMap.get(key);
            goodsPriceHistoryRecord.setCurr(row.getLong("goods.curr"));
            goodsPriceHistoryRecord.setNumber(row.getString("goods.number"));
            goodsPriceHistoryRecord.setName(row.getString("goods.name"));
            goodsPriceHistoryRecord.setLaestPrice(row.getBigDecimal("taxprice"));
            if (protocol != goodsPriceHistoryRecord.getProtocolId() || protocolentry != goodsPriceHistoryRecord.getProtocolEntryId()) continue;
            goodsPriceHistoryRecord.setGoodsPoolId(row.getLong("id"));
            goodsPriceHistoryRecord.setLaestPrice(row.getBigDecimal("taxprice"));
            if ("B".equals(pricetype)) {
                goodsPriceHistoryRecord.setLadPrice(Boolean.TRUE.booleanValue());
            } else {
                goodsPriceHistoryRecord.setLadPrice(Boolean.FALSE.booleanValue());
            }
            goodsPriceHistoryRecord.setTaxprice(row.getBigDecimal("taxprice"));
            goodsPriceHistoryRecord.setPrice(row.getBigDecimal("price"));
            goodsPriceHistoryRecord.setTaxrateid(row.getLong("taxrateid"));
            goodsPriceHistoryRecord.setTaxrate(row.getBigDecimal("taxrate"));
            goodsPriceHistoryRecord.setLaestPrice(row.getBigDecimal("taxprice"));
        }
        goodsPriceHistoryRecords.clear();
        for (Map.Entry map : goodsMap.entrySet()) {
            goodsPriceHistoryRecords.add((GoodsPriceHistoryRecord)map.getValue());
        }
        ArrayList<DynamicObject> goodsInfos = new ArrayList<DynamicObject>(16);
        goodsInfos.addAll(this.addGoodPriceDyn(goodsPriceHistoryRecords));
        if (goodsInfos.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_newpricelog", (DynamicObject[])goodsInfos.toArray(new DynamicObject[0]), (OperateOption)option);
            if (saveResult.getSuccessPkIds().size() != goodsInfos.size()) {
                log.info("saveerror" + ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
            }
        }
    }

    private List<DynamicObject> addGoodPriceDyn(List<GoodsPriceHistoryRecord> goodsPriceHistoryRecords) {
        ArrayList<DynamicObject> addDyns = new ArrayList<DynamicObject>(16);
        for (GoodsPriceHistoryRecord goodsInfo : goodsPriceHistoryRecords) {
            if (StringUtils.isEmpty((CharSequence)goodsInfo.getNumber())) continue;
            DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"pmm_newpricelog");
            info.set("goodspool", (Object)goodsInfo.getGoodsPoolId());
            info.set("goods", (Object)goodsInfo.getGoodsId());
            if (goodsInfo.isLadPrice()) {
                info.set("pricetype", (Object)"B");
            } else {
                info.set("pricetype", (Object)"A");
            }
            info.set("curr", (Object)goodsInfo.getCurr());
            info.set("lastprice", (Object)(goodsInfo.getLastPrice() == null ? BigDecimal.ZERO : goodsInfo.getLastPrice()));
            info.set("srcentitybilltype", (Object)goodsInfo.getSrcBillType());
            info.set("srcbillid", (Object)goodsInfo.getSrcBillId());
            info.set("srcbillno", (Object)goodsInfo.getSrcBillNo());
            info.set("adjustdate", (Object)goodsInfo.getAdjustdate());
            info.set("remark", (Object)goodsInfo.getNote());
            info.set("auditorg", (Object)goodsInfo.getAuditorg());
            info.set("taxprice", (Object)goodsInfo.getTaxprice());
            info.set("shopprice", (Object)goodsInfo.getTaxprice());
            info.set("taxrateid", (Object)goodsInfo.getTaxrateid());
            info.set("taxrate", (Object)goodsInfo.getTaxrate());
            info.set("price", (Object)goodsInfo.getPrice());
            info.set("name", (Object)goodsInfo.getName());
            info.set("number", (Object)goodsInfo.getNumber());
            info.set("origin", (Object)goodsInfo.getOrigin());
            info.set("creator", (Object)goodsInfo.getCreatorId());
            info.set("createtime", (Object)goodsInfo.getCreateDate());
            info.set("auditor", (Object)goodsInfo.getAuditorId());
            info.set("auditdate", (Object)goodsInfo.getAuditDate());
            addDyns.add(info);
        }
        return addDyns;
    }
}

