/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.malcore.domain.Sku;
import kd.scm.pmm.business.service.IPmmProdManageAuditService;

public class PmmProdManageAuditServiceImpl
implements IPmmProdManageAuditService {
    @Override
    public Map<String, Object> writeBackSpu(List<Sku> skuLists) {
        HashMap<String, Object> res = new HashMap<String, Object>(8);
        if (skuLists == null || skuLists.isEmpty()) {
            return res;
        }
        ArrayList<Sku> skuList = new ArrayList<Sku>(skuLists);
        StringBuilder error = new StringBuilder();
        ArrayList<String> spuList = new ArrayList<String>(skuList.size());
        HashMap<String, List> spuAndSkusMap = new HashMap<String, List>(skuList.size());
        HashSet<Long> goodsIdSet = new HashSet<Long>(16);
        for (Sku sku : skuList) {
            spuList.add(sku.getSpu());
            List skus = spuAndSkusMap.computeIfAbsent(sku.getSpu(), k -> new ArrayList());
            skus.add(sku);
            goodsIdSet.add(sku.getId());
        }
        Map<Long, DynamicObject> prodMap = this.getProdMap(goodsIdSet);
        QFilter qFilter = new QFilter("number", "in", spuList);
        String selctors = DynamicObjectUtil.getEntrySelectfields((String)"", (String)"pmm_spu", (String)"spuskumapentry", (boolean)false);
        DynamicObject[] spus = BusinessDataServiceHelper.load((String)"pmm_spu", (String)("id,number,orgfield,supplier,baseattributeentry.prodattributevalue,spuatrdetailentry.saleprodattributevalueid,spuskumapentry.goods," + selctors), (QFilter[])qFilter.toArray());
        for (DynamicObject spu : spus) {
            List skus = (List)spuAndSkusMap.remove(spu.getString("number"));
            this.removeSkuDifferentFromSpu(skus, spu, error);
            if (skus.isEmpty()) continue;
            this.setSkuToSkuEntryOrRemove(skus, spu, error, prodMap);
            for (Sku sku : skus) {
                error.append(ResManager.loadKDString((String)"{0}\uff1aSKU\u5546\u54c1\u89c4\u683c\u672a\u5305\u542bSPU\u5546\u54c1\u89c4\u683c\u3002", (String)"PmmProdManageAuditServiceImpl_0", (String)"scm-pmm-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
            }
        }
        for (Map.Entry entry : spuAndSkusMap.entrySet()) {
            List skus = (List)entry.getValue();
            for (Sku sku : skus) {
                error.append(ResManager.loadKDString((String)"{0}\uff1aSPU\u5df2\u88ab\u5220\u9664\u3002", (String)"EntProdManageAuditServiceImpl_5", (String)"scm-ent-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
            }
        }
        SaveServiceHelper.save((DynamicObject[])spus);
        if (error.length() > 0) {
            res.put("msg", error);
            ArrayList<DynamicObject> updateDyn = new ArrayList<DynamicObject>(16);
            for (Map.Entry<Long, DynamicObject> map : prodMap.entrySet()) {
                DynamicObject prod = map.getValue();
                prod.set("spunumber", (Object)" ");
                prod.set("mulmodel", (Object)false);
                updateDyn.add(prod);
            }
            if (updateDyn.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])updateDyn.toArray(new DynamicObject[0]));
            }
        }
        return res;
    }

    private Map<Long, DynamicObject> getProdMap(Set<Long> goodsIdSet) {
        QFilter qFilter = new QFilter("id", "in", goodsIdSet);
        String selctors = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
        selctors = DynamicObjectUtil.getEntrySelectfields((String)selctors, (String)"pmm_prodmanage", (String)"prodattributeentry", (boolean)false);
        DynamicObject[] pmm_prodmanages = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)selctors, (QFilter[])qFilter.toArray());
        HashMap<Long, DynamicObject> prodMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject row : pmm_prodmanages) {
            prodMap.put(row.getLong("id"), row);
        }
        return prodMap;
    }

    private void removeSkuDifferentFromSpu(List<Sku> skus, DynamicObject spu, StringBuilder error) {
        long spuOrgId = spu.getLong("orgfield_id");
        long spuSupId = spu.getLong("supplier_id");
        List<Long> spuBaseAttributeValues = spu.getDynamicObjectCollection("baseattributeentry").stream().map(entry -> entry.getLong("prodattributevalue_id")).collect(Collectors.toList());
        if (null == skus) {
            return;
        }
        Iterator<Sku> iterator = skus.iterator();
        while (iterator.hasNext()) {
            Sku sku = iterator.next();
            if (spuOrgId != sku.getCreateOrg()) {
                error.append(ResManager.loadKDString((String)"{0}\uff1aSKU\u7684\u91c7\u8d2d\u7ec4\u7ec7\u4e0eSPU\u5ba1\u6279\u7ec4\u7ec7\u4e0d\u4e00\u81f4\u3002", (String)"EntProdManageAuditServiceImpl_0", (String)"scm-ent-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
                iterator.remove();
                continue;
            }
            if (spuSupId != sku.getSupplier()) {
                error.append(ResManager.loadKDString((String)"{0}\uff1aSKU\u7684\u91c7\u8d2d\u7ec4\u7ec7\u4e0eSPU\u6240\u5c5e\u5546\u5bb6\u4e0d\u4e00\u81f4\u3002", (String)"EntProdManageAuditServiceImpl_1", (String)"scm-ent-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
                iterator.remove();
                continue;
            }
            if (this.skuCheckSpuBaseAttribute(spuBaseAttributeValues, sku.getBaseAttributeValues())) continue;
            error.append(ResManager.loadKDString((String)"{0}\uff1aSKU\u5546\u54c1\u89c4\u683c\u672a\u5305\u542bSPU\u5546\u54c1\u89c4\u683c\u3002", (String)"PmmProdManageAuditServiceImpl_0", (String)"scm-ent-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
            iterator.remove();
        }
    }

    private void setSkuToSkuEntryOrRemove(List<Sku> skus, DynamicObject spu, StringBuilder error, Map<Long, DynamicObject> prodMap) {
        Map prodProsMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)ORM.create().newDynamicObject("pmm_prodmanage"));
        List allProdProsList = (List)prodProsMap.get("allProList");
        DynamicObjectCollection spuskumapentry = spu.getDynamicObjectCollection("spuskumapentry");
        for (DynamicObject entry : spuskumapentry) {
            Map allSpuProsMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)entry);
            List allSpuEntryProsList = (List)allSpuProsMap.get("allProList");
            DynamicObjectCollection spuatrdetailentry = entry.getDynamicObjectCollection("spuatrdetailentry");
            List spuEntryAttributeValues = spuatrdetailentry.stream().map(k -> k.getLong("saleprodattributevalueid_id")).collect(Collectors.toList());
            Iterator<Sku> iterator = skus.iterator();
            while (iterator.hasNext()) {
                Sku sku = iterator.next();
                Set skuSaleAttributeValues = sku.getSaleAttributeValues();
                boolean isContain = true;
                if (spuEntryAttributeValues.size() == skuSaleAttributeValues.size()) {
                    for (Long spuEntryAttributeValue : spuEntryAttributeValues) {
                        if (skuSaleAttributeValues.contains(spuEntryAttributeValue)) continue;
                        isContain = false;
                        break;
                    }
                } else {
                    isContain = false;
                }
                if (!isContain) continue;
                if (entry.getDynamicObject("goods") != null && sku.getId().longValue() != entry.getLong("goods.id")) {
                    error.append(ResManager.loadKDString((String)"{0}\uff1a\u5173\u8054SKU\u5206\u5f55\u5df2\u5173\u8054\u5176\u4ed6SKU\u3002", (String)"EntProdManageAuditServiceImpl_3", (String)"scm-ent-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
                } else {
                    DynamicObject prodInfo = prodMap.get(sku.getId());
                    for (String goodsPros : allProdProsList) {
                        if (!allSpuEntryProsList.contains(goodsPros) || null == prodInfo) continue;
                        entry.set(goodsPros, prodInfo.get(goodsPros));
                    }
                    if (null != prodMap.get(sku.getId()) && null != prodInfo) {
                        entry.set("goods_id", (Object)sku.getId());
                        entry.set("skunumber", (Object)prodInfo.getString("number"));
                        entry.set("skuname", (Object)prodInfo.getString("name"));
                    }
                }
                iterator.remove();
            }
        }
    }

    private boolean skuCheckSpuBaseAttribute(List<Long> spuBaseAttributeValues, Set<Long> skuBaseAttributeValues) {
        for (Long spuBaseAttributeValue : spuBaseAttributeValues) {
            if (skuBaseAttributeValues.contains(spuBaseAttributeValue)) continue;
            return false;
        }
        return true;
    }
}

