/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pmm.business.service.IPmmSpuValidatorService;

public class PmmSpuValidatorServiceImpl
implements IPmmSpuValidatorService {
    @Override
    public Map<String, Object> submitHandleAndValid(DynamicObject[] spus, Map<Long, Integer> selectEntryIdAndRowIndexs) {
        HashMap<String, Object> res = new HashMap<String, Object>(8);
        int successNum = 0;
        int failNum = 0;
        StringBuilder msg = new StringBuilder();
        HashMap<Long, DynamicObject> skuAndSpuEntryMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> skuAndSpuMap = new HashMap<Long, DynamicObject>(64);
        HashMap<String, Map<Long, DynamicObject>> spu_entryMap = new HashMap<String, Map<Long, DynamicObject>>(16);
        for (DynamicObject spu : spus) {
            HashMap<Long, DynamicObject> spuEntryMap = new HashMap<Long, DynamicObject>(64);
            String number = spu.getString("number");
            DynamicObjectCollection spuskumapentry = spu.getDynamicObjectCollection("spuskumapentry");
            if ("1".equals(spu.getString("origin"))) {
                msg.append(ResManager.loadKDString((String)"{0}:\u4f9b\u5e94\u5546\u7ef4\u62a4\u7684\u5546\u54c1SPU\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PmmSpuValidatorServiceImpl_0", (String)"scm-pmm-business", (Object[])new Object[]{number})).append("\n");
                ++failNum;
                continue;
            }
            if (!this.checkSpuInfo(spu, msg)) {
                failNum = (int)((long)failNum + spuskumapentry.stream().filter(k -> selectEntryIdAndRowIndexs.isEmpty() || selectEntryIdAndRowIndexs.containsKey(k.getLong("id"))).count());
                continue;
            }
            for (DynamicObject entry : spuskumapentry) {
                long entryId = entry.getLong("id");
                if (!selectEntryIdAndRowIndexs.containsKey(entryId) && !selectEntryIdAndRowIndexs.isEmpty()) continue;
                if (!this.checkAttributeConsistency(spu, entry, msg, selectEntryIdAndRowIndexs)) {
                    ++failNum;
                    continue;
                }
                if ("C".equals(entry.getString("confirmstatus")) || "D".equals(entry.getString("confirmstatus"))) {
                    DynamicObject firstSpu = (DynamicObject)skuAndSpuMap.get(entry.getLong("goods_id"));
                    if (firstSpu != null) {
                        DynamicObject firstSpuEntry = (DynamicObject)spuEntryMap.remove(entry.getLong("goods_id"));
                        if (null != firstSpuEntry) {
                            ++failNum;
                            msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\uff0cSKU\u88ab\u591a\u4e2aSPU\u540c\u65f6\u5173\u8054\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u63d0\u4ea4\u3002", (String)"PmmSpuValidatorServiceImpl_1", (String)"scm-pmm-business", (Object[])new Object[]{firstSpu.getString("number"), selectEntryIdAndRowIndexs.get(firstSpuEntry.getLong("id")) + 1})).append("\n");
                        }
                        msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\uff0cSKU\u88ab\u591a\u4e2aSPU\u540c\u65f6\u5173\u8054\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u63d0\u4ea4\u3002", (String)"PmmSpuValidatorServiceImpl_1", (String)"scm-pmm-business", (Object[])new Object[]{number, selectEntryIdAndRowIndexs.get(entryId) + 1})).append("\n");
                        ++failNum;
                        continue;
                    }
                    spuEntryMap.put(entry.getLong("goods_id"), entry);
                    skuAndSpuMap.put(entry.getLong("goods_id"), spu);
                    continue;
                }
                if (!selectEntryIdAndRowIndexs.isEmpty()) {
                    msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\uff0c\u4ec5\u652f\u6301\u786e\u8ba4\u72b6\u6001\u4e3a\u5f85\u63d0\u4ea4/\u5df2\u9a73\u56de\u7684\u5206\u5f55\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"PmmSpuValidatorServiceImpl_2", (String)"scm-pmm-business", (Object[])new Object[]{number, selectEntryIdAndRowIndexs.get(entryId) + 1})).append("\n");
                }
                ++failNum;
            }
            spu_entryMap.put(number, spuEntryMap);
            skuAndSpuEntryMap.putAll(spuEntryMap);
        }
        this.checkSkuIsRelatingOtherBill(skuAndSpuEntryMap, skuAndSpuMap, selectEntryIdAndRowIndexs, msg);
        for (Map.Entry entry : skuAndSpuEntryMap.entrySet()) {
            DynamicObject entry2 = (DynamicObject)entry.getValue();
            Long prodId = (Long)entry.getKey();
            entry2.set("confirmstatus", (Object)"B");
            entry2.set("entryresult", (Object)"1");
            entry2.set("note", (Object)" ");
            if (null != skuAndSpuMap.get(prodId)) {
                ((DynamicObject)skuAndSpuMap.get(prodId)).set("status", (Object)BillStatusEnum.SUBMIT.getVal());
            }
            ++successNum;
        }
        this.writeSkuBySpu(spu_entryMap);
        res.put("successNum", successNum);
        res.put("failNum", failNum);
        res.put("msg", msg);
        return res;
    }

    private void writeSkuBySpu(Map<String, Map<Long, DynamicObject>> spu_entryMap) {
        HashMap<Long, String> goods_SpuNoMap = new HashMap<Long, String>(16);
        for (Map.Entry<String, Map<Long, DynamicObject>> objectEntry : spu_entryMap.entrySet()) {
            Map<Long, DynamicObject> entryMap = objectEntry.getValue();
            for (Map.Entry<Long, DynamicObject> map : entryMap.entrySet()) {
                DynamicObject entry = map.getValue();
                if (null == entry.get("goods")) continue;
                goods_SpuNoMap.put(entry.getLong("goods.id"), objectEntry.getKey());
            }
        }
        if (goods_SpuNoMap.size() > 0) {
            DynamicObject[] prods;
            QFilter qFilter = new QFilter("id", "in", goods_SpuNoMap.keySet());
            for (DynamicObject prod : prods = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"id,spunumber,mulmodel", (QFilter[])qFilter.toArray())) {
                if (null == goods_SpuNoMap.get(prod.getLong("id"))) continue;
                prod.set("spunumber", goods_SpuNoMap.get(prod.getLong("id")));
                prod.set("mulmodel", (Object)true);
            }
            if (prods.length > 0) {
                SaveServiceHelper.save((DynamicObject[])prods);
            }
        }
    }

    private boolean checkSpuInfo(DynamicObject spu, StringBuilder msg) {
        String number = spu.getString("number");
        String status = spu.getString("status");
        String enable = spu.getString("enable");
        if ("E".equals(status)) {
            msg.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"PmmSpuValidatorServiceImpl_3", (String)"scm-pmm-business", (Object[])new Object[0]), number)).append("\n");
            return false;
        }
        if ("0".equals(enable)) {
            msg.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5355\u636e\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"PmmSpuValidatorServiceImpl_4", (String)"scm-pmm-business", (Object[])new Object[0]), number)).append("\n");
            return false;
        }
        DynamicObjectCollection spuskumapentry = spu.getDynamicObjectCollection("spuskumapentry");
        DynamicObjectCollection baseattributeentry = spu.getDynamicObjectCollection("baseattributeentry");
        DynamicObjectCollection saleattributeentry = spu.getDynamicObjectCollection("saleattributeentry");
        if (this.checkSkuMap(spuskumapentry)) {
            msg.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5173\u8054SKU\u5206\u5f55\u6ca1\u6709\u53ef\u63d0\u4ea4\u7684\u5206\u5f55\u3002", (String)"PmmSpuValidatorServiceImpl_5", (String)"scm-pmm-business", (Object[])new Object[0]), number)).append("\n");
            return false;
        }
        if (baseattributeentry.size() == 0) {
            msg.append(ResManager.loadKDString((String)"{0}\uff1a\u8bf7\u586b\u5199\u57fa\u672c\u89c4\u683c\u5206\u5f55\u5fc5\u5f55\u9879\u3002", (String)"PmmSpuValidatorServiceImpl_6", (String)"scm-pmm-business", (Object[])new Object[]{number})).append("\n");
            return false;
        }
        if (saleattributeentry.size() == 0) {
            msg.append(ResManager.loadKDString((String)"{0}\uff1a\u8bf7\u586b\u5199\u9500\u552e\u89c4\u683c\u5206\u5f55\u5fc5\u5f55\u9879\u3002", (String)"PmmSpuValidatorServiceImpl_7", (String)"scm-pmm-business", (Object[])new Object[]{number})).append("\n");
            return false;
        }
        boolean isMsg = false;
        for (DynamicObject row : saleattributeentry) {
            DynamicObjectCollection saleatrvalueentry = row.getDynamicObjectCollection("saleatrvalueentry");
            if (saleatrvalueentry.size() != 0) continue;
            msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\u9500\u552e\u89c4\u683c\u5bf9\u5e94\u7684\u9500\u552e\u89c4\u683c\u503c\u4e3a\u7a7a\u3002", (String)"PmmSpuValidatorServiceImpl_8", (String)"scm-pmm-business", (Object[])new Object[]{number, row.getInt("seq")})).append("\n");
            isMsg = true;
        }
        if (isMsg) {
            return false;
        }
        if (spuskumapentry.size() == 0) {
            msg.append(ResManager.loadKDString((String)"{0}\uff1a\u8bf7\u586b\u5199\u5173\u8054SKU\u5206\u5f55\u5fc5\u5f55\u9879\u3002", (String)"PmmSpuValidatorServiceImpl_9", (String)"scm-pmm-business", (Object[])new Object[]{number})).append("\n");
            return false;
        }
        return true;
    }

    private boolean checkSkuMap(DynamicObjectCollection spuSkuMapCol) {
        for (DynamicObject spuDy : spuSkuMapCol) {
            DynamicObject goods = spuDy.getDynamicObject("goods");
            if (goods == null || !"C".equals(spuDy.getString("confirmstatus")) && !"D".equals(spuDy.getString("confirmstatus"))) continue;
            return false;
        }
        return true;
    }

    private boolean checkAttributeConsistency(DynamicObject spu, DynamicObject entry, StringBuilder msg, Map<Long, Integer> selectEntryIdAndRowIndexs) {
        int seq;
        DynamicObjectCollection baseattributeentry = spu.getDynamicObjectCollection("baseattributeentry");
        List spuAttributes = baseattributeentry.stream().map(e -> e.getString("prodattributevalue_id")).collect(Collectors.toList());
        entry.getDynamicObjectCollection("spuatrdetailentry").forEach(e -> spuAttributes.add(e.getString("saleprodattributevalueid_id")));
        DynamicObject sku = entry.getDynamicObject("goods");
        String number = spu.getString("number");
        int n = seq = selectEntryIdAndRowIndexs.isEmpty() || entry.getLong("id") == 0L ? entry.getInt("seq") : selectEntryIdAndRowIndexs.get(entry.getLong("id")) + 1;
        if (null == sku || !"C".equals(sku.getString("status")) || !"1".equals(sku.getString("enable"))) {
            msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\uff0c\u5173\u8054\u7684SKU\u672a\u5ba1\u6838\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u65b0\u589e\u6216\u5ba1\u6838SKU\u518d\u91cd\u65b0\u5173\u8054\u540e\u63d0\u4ea4\u91c7\u8d2d\u65b9\u3002", (String)"PmmSpuValidatorServiceImpl_10", (String)"scm-pmm-business", (Object[])new Object[]{number, seq})).append("\n");
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)sku.getString("spunumber")) && !sku.getString("spunumber").equals(spu.getString("number"))) {
            msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\uff0cSKU\u5df2\u5173\u8054SPU\uff0c\u4e0d\u80fd\u518d\u6b21\u5173\u8054\u3002", (String)"PmmSpuValidatorServiceImpl_11", (String)"scm-pmm-business", (Object[])new Object[]{number, seq})).append("\n");
            return false;
        }
        if (spu.getLong("group_id") != sku.getLong("category_id")) {
            msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\uff0cSKU\u4e0eSPU\u5546\u54c1\u5206\u7c7b\u4e0d\u4e00\u81f4\u3002", (String)"PmmSpuValidatorServiceImpl_13", (String)"scm-pmm-business", (Object[])new Object[]{number, seq})).append("\n");
            return false;
        }
        if (spu.getLong("supplier_id") != sku.getLong("supplier_id")) {
            msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\uff0cSKU\u4e0eSPU\u6240\u5c5e\u5546\u5bb6\u4e0d\u4e00\u81f4\u3002", (String)"PmmSpuValidatorServiceImpl_14", (String)"scm-pmm-business", (Object[])new Object[]{number, seq})).append("\n");
            return false;
        }
        DynamicObjectCollection skuAttributeEntries = sku.getDynamicObjectCollection("prodattributeentry");
        Set skuAttributes = skuAttributeEntries.stream().map(e -> e.getString("prodattributevalue_id")).collect(Collectors.toSet());
        for (String spuAttribute : spuAttributes) {
            if (skuAttributes.contains(spuAttribute)) continue;
            msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\uff0cSKU\u5546\u54c1\u89c4\u683c\u672a\u5305\u542bSPU\u5546\u54c1\u89c4\u683c\u3002", (String)"PmmSpuValidatorServiceImpl_15", (String)"scm-pmm-business", (Object[])new Object[]{number, seq})).append("\n");
            return false;
        }
        return true;
    }

    private void checkSkuIsRelatingOtherBill(Map<Long, DynamicObject> skuAndSpuEntryMap, Map<Long, DynamicObject> skuAndSpuMap, Map<Long, Integer> selectEntryIdAndRowIndexs, StringBuilder msg) {
        QFilter qFilter = new QFilter("spuskumapentry.goods", "in", skuAndSpuEntryMap.keySet());
        qFilter.and("spuskumapentry.confirmstatus", "=", (Object)"A");
        qFilter.and("status", "!=", (Object)"E");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ent_spu", (String)"number,spuskumapentry.goods goods,spuskumapentry.id", (QFilter[])qFilter.toArray(), (String)"number");){
            dataSet.forEach(row -> {
                DynamicObject spu = (DynamicObject)skuAndSpuMap.remove(row.getLong("goods"));
                if (!StringUtils.isEmpty((CharSequence)spu.getString("number")) && !spu.getString("number").equals(row.getString("number"))) {
                    DynamicObject entry = (DynamicObject)skuAndSpuEntryMap.remove(row.getLong("goods"));
                    long entryId = entry.getLong("id");
                    int rowIndex = selectEntryIdAndRowIndexs.isEmpty() || entry.getLong("id") == 0L ? entry.getInt("seq") : (Integer)selectEntryIdAndRowIndexs.get(entryId) + 1;
                    msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\uff0cSKU\u5df2\u88abSPU\u3010{2}\u3011\u5173\u8054\u4e14\u91c7\u8d2d\u65b9\u786e\u8ba4\u4e2d\u3002", (String)"PmmSpuValidatorServiceImpl_16", (String)"scm-pmm-business", (Object[])new Object[]{spu.getString("number"), rowIndex, row.getString("number")})).append("\n");
                }
            });
        }
        QFilter changeQFilter = new QFilter("prod", "in", skuAndSpuEntryMap.keySet());
        changeQFilter.and("billstatus", "in", Arrays.asList("B", "C"));
        changeQFilter.and("cfmstatus", "!=", (Object)"B");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ent_prodchange_manage", (String)"billno,prod.id goods,prod.number goodsnumber", (QFilter[])changeQFilter.toArray(), (String)"billno");){
            dataSet.forEach(row -> {
                DynamicObject entry = (DynamicObject)skuAndSpuEntryMap.remove(row.getLong("goods"));
                DynamicObject spu = (DynamicObject)skuAndSpuMap.remove(row.getLong("goods"));
                long entryId = entry.getLong("id");
                int rowIndex = selectEntryIdAndRowIndexs.isEmpty() || entry.getLong("id") == 0L ? entry.getInt("seq") : (Integer)selectEntryIdAndRowIndexs.get(entryId) + 1;
                msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\uff0cSKU\u3010{2}\u3011\u6b63\u5728\u53d8\u66f4\u4e2d\u3010{3}\u3011\uff0c\u65e0\u6cd5\u5173\u8054\uff0c\u8bf7\u5220\u9664\u3002", (String)"PmmSpuValidatorServiceImpl_17", (String)"scm-pmm-business", (Object[])new Object[]{spu.getString("number"), rowIndex, row.getString("goodsnumber"), row.getString("billno")})).append("\n");
            });
        }
    }

    @Override
    public void submitMessageShow(Map<String, Object> res, IFormView view, Map<Long, Integer> selectEntryIdAndRowIndexs) {
        int successNum = (Integer)res.get("successNum");
        int failNum = (Integer)res.get("failNum");
        StringBuilder msg = (StringBuilder)res.get("msg");
        if (successNum > 0 && (failNum == 0 || selectEntryIdAndRowIndexs.isEmpty())) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"PmmSpuValidatorServiceImpl_19", (String)"scm-pmm-business", (Object[])new Object[0]));
        } else if (successNum > 0 && failNum > 0) {
            view.showMessage(ResManager.loadKDString((String)"\u5171{0}\u6761\u5206\u5f55\uff0c\u63d0\u4ea4\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"PmmSpuValidatorServiceImpl_18", (String)"scm-pmm-business", (Object[])new Object[]{successNum + failNum, successNum, failNum}), msg.toString(), MessageTypes.Default);
        } else if (successNum == 0 && selectEntryIdAndRowIndexs.isEmpty() && msg.length() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5b58\u5728\u5f85\u63d0\u4ea4\u5206\u5f55\u7684\u5355\u636e\u3002", (String)"PmmSpuValidatorServiceImpl_20", (String)"scm-pmm-business", (Object[])new Object[0]));
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"PmmSpuValidatorServiceImpl_21", (String)"scm-pmm-business", (Object[])new Object[0]), msg.toString(), MessageTypes.Default);
        }
    }

    @Override
    public Map<String, Object> unSubmitHandleAndValid(DynamicObject[] spus, Map<Long, Integer> selectEntryIdAndRowIndexs) {
        HashMap<String, Object> res = new HashMap<String, Object>(8);
        int successNum = 0;
        int failNum = 0;
        StringBuilder msg = new StringBuilder();
        for (DynamicObject spu : spus) {
            if ("1".equals(spu.getString("origin"))) {
                msg.append(ResManager.loadKDString((String)"{0}:\u4f9b\u5e94\u5546\u7ef4\u62a4\u7684\u5546\u54c1SPU\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PmmSpuValidatorServiceImpl_22", (String)"scm-pmm-business", (Object[])new Object[]{spu.getString("number")})).append("\n");
                ++failNum;
                continue;
            }
            String status = spu.getString("status");
            String enable = spu.getString("enable");
            DynamicObjectCollection spuskumapentry = spu.getDynamicObjectCollection("spuskumapentry");
            if ("E".equals(status)) {
                msg.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"PmmSpuValidatorServiceImpl_23", (String)"scm-pmm-business", (Object[])new Object[0]), spu.getString("number"))).append("\n");
                failNum = (int)((long)failNum + spuskumapentry.stream().filter(k -> selectEntryIdAndRowIndexs.isEmpty() || selectEntryIdAndRowIndexs.containsKey(k.getLong("id"))).count());
                continue;
            }
            if ("0".equals(enable)) {
                msg.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5355\u636e\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"PmmSpuValidatorServiceImpl_24", (String)"scm-pmm-business", (Object[])new Object[0]), spu.getString("number"))).append("\n");
                failNum = (int)((long)failNum + spuskumapentry.stream().filter(k -> selectEntryIdAndRowIndexs.isEmpty() || selectEntryIdAndRowIndexs.containsKey(k.getLong("id"))).count());
                continue;
            }
            for (DynamicObject entry : spuskumapentry) {
                long entryId = entry.getLong("id");
                if (!selectEntryIdAndRowIndexs.isEmpty() && !selectEntryIdAndRowIndexs.containsKey(entryId)) continue;
                if ("A".equals(entry.getString("confirmstatus"))) {
                    entry.set("confirmstatus", (Object)"C");
                    ++successNum;
                    continue;
                }
                if (!selectEntryIdAndRowIndexs.isEmpty()) {
                    msg.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\uff0c\u4ec5\u652f\u6301\u786e\u8ba4\u72b6\u6001\u4e3a\u5f85\u786e\u8ba4\u7684\u5206\u5f55\u8fdb\u884c\u64a4\u9500\u3002", (String)"PmmSpuValidatorServiceImpl_25", (String)"scm-pmm-business", (Object[])new Object[]{spu.getString("number"), selectEntryIdAndRowIndexs.get(entryId) + 1})).append("\n");
                }
                ++failNum;
            }
            if (!this.checkEntryConfirmStatusAllChange(spu)) continue;
            spu.set("status", (Object)BillStatusEnum.SAVE.getVal());
        }
        res.put("successNum", successNum);
        res.put("failNum", failNum);
        res.put("msg", msg);
        return res;
    }

    private boolean checkEntryConfirmStatusAllChange(DynamicObject spu) {
        DynamicObjectCollection spuskumapentry = spu.getDynamicObjectCollection("spuskumapentry");
        for (DynamicObject entry : spuskumapentry) {
            String confirmstatus = entry.getString("confirmstatus");
            if ("C".equals(confirmstatus)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void unSubmitMessageShow(Map<String, Object> res, IFormView view, Map<Long, Integer> selectEntryIdAndRowIndexs) {
        int successNum = (Integer)res.get("successNum");
        int failNum = (Integer)res.get("failNum");
        StringBuilder msg = (StringBuilder)res.get("msg");
        if (successNum > 0 && (failNum == 0 || selectEntryIdAndRowIndexs.isEmpty()) || successNum == 0 && failNum == 0) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"PmmSpuValidatorServiceImpl_26", (String)"scm-pmm-business", (Object[])new Object[0]));
        } else if (successNum > 0 && failNum > 0) {
            view.showMessage(ResManager.loadKDString((String)"\u5171{0}\u6761\u5206\u5f55\uff0c\u64a4\u9500\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"PmmSpuValidatorServiceImpl_27", (String)"scm-pmm-business", (Object[])new Object[]{successNum + failNum, successNum, failNum}), msg.toString(), MessageTypes.Default);
        } else if (successNum == 0 && selectEntryIdAndRowIndexs.isEmpty() && msg.length() == 0 && failNum > 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5b58\u5728\u5f85\u786e\u8ba4\u5206\u5f55\u7684\u5355\u636e\u3002", (String)"PmmSpuValidatorServiceImpl_28", (String)"scm-pmm-business", (Object[])new Object[0]));
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25\u3002", (String)"PmmSpuValidatorServiceImpl_29", (String)"scm-pmm-business", (Object[])new Object[0]), msg.toString(), MessageTypes.Default);
        }
    }
}

