/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.constant.BillAssistConstant;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.business.model.product.ProdMatMapping;
import kd.scm.pmm.business.service.ProdMatMappingService;

public class ProdMatMappingServiceImpl
implements ProdMatMappingService {
    private static final Log log = LogFactory.getLog(ProdMatMappingServiceImpl.class);
    private static final String PMM_PRODMATMAPPING = "pmm_prodmatmapping";
    private static final String GOODS = "goods";
    private static final String MATERIAL = "material";

    @Override
    public Set<ProdMatMapping> queryProdsByMatId(Set<Long> productIds) {
        if (productIds.isEmpty()) {
            return new HashSet<ProdMatMapping>();
        }
        DynamicObjectCollection prodMatMappingDynColl = QueryServiceHelper.query((String)PMM_PRODMATMAPPING, (String)"id,goods,material", (QFilter[])new QFilter[]{new QFilter(GOODS, "in", productIds)});
        HashSet<ProdMatMapping> prodMatMappings = new HashSet<ProdMatMapping>(prodMatMappingDynColl.size());
        prodMatMappingDynColl.forEach(prodMatMappingDyn -> prodMatMappings.add(new ProdMatMapping(prodMatMappingDyn.getLong(GOODS), prodMatMappingDyn.getLong(MATERIAL))));
        StringBuilder logMesg = new StringBuilder();
        for (DynamicObject prodMatMappingDyn2 : prodMatMappingDynColl) {
            ProdMatMapping prodMatMapping = new ProdMatMapping(prodMatMappingDyn2.getLong(GOODS), prodMatMappingDyn2.getLong(MATERIAL));
            logMesg.append("ProdMatMappingServiceImpl:queryProdsByMatId:").append(prodMatMapping.toString()).append(System.lineSeparator());
            prodMatMappings.add(prodMatMapping);
        }
        log.info(logMesg.toString());
        return prodMatMappings;
    }

    @Override
    public void saveProdMatMapping(Set<ProdMatMapping> prodMatMappings) {
        this.saveProdMatMappingWithRes(prodMatMappings);
    }

    @Override
    public Map<Long, Long> saveProdMatMappingWithRes(Set<ProdMatMapping> prodMatMappings) {
        String errorInfoDetails;
        if (prodMatMappings.isEmpty()) {
            return new HashMap<Long, Long>();
        }
        HashMap<Long, Long> res = new HashMap<Long, Long>(prodMatMappings.size());
        HashMap<Long, ProdMatMapping> prodIdAndMappingMap = new HashMap<Long, ProdMatMapping>(prodMatMappings.size());
        prodMatMappings.forEach(prodMatMapping -> prodIdAndMappingMap.put(prodMatMapping.getProductId(), (ProdMatMapping)prodMatMapping));
        ArrayList<DynamicObject> newDynList = new ArrayList<DynamicObject>(prodMatMappings.size());
        ArrayList<DynamicObject> newDynList2 = new ArrayList<DynamicObject>(prodMatMappings.size());
        DynamicObject[] mappingDynArray = BusinessDataServiceHelper.load((String)PMM_PRODMATMAPPING, (String)DynamicObjectUtil.getSelectfields((String)PMM_PRODMATMAPPING, (boolean)false), (QFilter[])new QFilter[]{new QFilter(GOODS, "in", prodIdAndMappingMap.keySet())}, (String)"modifytime desc");
        log.info("@@@saveProdMatMappingWithRes:mappingDynArray.length:" + mappingDynArray.length);
        StringBuilder logSb = new StringBuilder("materialMapping:");
        for (DynamicObject mappingDyn : mappingDynArray) {
            ProdMatMapping prodMatMapping2 = (ProdMatMapping)prodIdAndMappingMap.get(mappingDyn.getLong("goods_id"));
            if (prodMatMapping2 == null) continue;
            mappingDyn.set("material_id", (Object)prodMatMapping2.getMaterialId());
            mappingDyn.set("category", null);
            mappingDyn.set("purchasetype", null);
            prodIdAndMappingMap.remove(mappingDyn.getLong("goods_id"));
            newDynList.add(mappingDyn);
            res.put(mappingDyn.getLong("goods_id"), mappingDyn.getLong("id"));
            logSb.append("update:").append("goodsId:").append(mappingDyn.getLong("goods_id")).append("materialId:").append(mappingDyn.getLong("id"));
        }
        Map<Long, DynamicObject> prodDynMap = this.getProdDynMap(prodIdAndMappingMap);
        long[] pks = DBServiceHelper.genLongIds((String)PMM_PRODMATMAPPING, (int)prodIdAndMappingMap.size());
        int count = 0;
        StringBuilder logMesg = new StringBuilder();
        for (Map.Entry entry : prodIdAndMappingMap.entrySet()) {
            ProdMatMapping prodMatMapping3 = (ProdMatMapping)entry.getValue();
            logMesg.append("ProdMatMappingServiceImpl:saveProdMatMapping:").append(prodMatMapping3.toString()).append(System.lineSeparator());
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)PMM_PRODMATMAPPING);
            newDynamicObject.set("id", (Object)pks[count]);
            DynamicObject goodsDyn = prodDynMap.get(prodMatMapping3.getProductId());
            newDynamicObject.set(GOODS, (Object)goodsDyn);
            newDynamicObject.set("platform", (Object)goodsDyn.getString("source"));
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsDyn.getString("source"))) {
                newDynamicObject.set("ecgoods_id", (Object)goodsDyn.getLong("id"));
            }
            newDynamicObject.set("material_id", (Object)prodMatMapping3.getMaterialId());
            newDynamicObject.set("radiogroupfield", (Object)"1");
            newDynamicObject.set("category", null);
            newDynamicObject.set("purchasetype", null);
            newDynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            newDynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            newDynamicObject.set("billdate", (Object)TimeServiceHelper.now());
            newDynamicObject.set("createtime", (Object)TimeServiceHelper.now());
            newDynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
            newDynList2.add(newDynamicObject);
            res.put((Long)entry.getKey(), pks[count]);
            logSb.append("add:").append("goodsId:").append(entry.getKey()).append("materialId:").append(pks[count]);
            ++count;
        }
        logMesg.append((CharSequence)logSb);
        log.info(logMesg.toString());
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)PMM_PRODMATMAPPING, (DynamicObject[])newDynList.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationResult operationResult1 = OperationServiceHelper.executeOperate((String)"save", (String)PMM_PRODMATMAPPING, (DynamicObject[])newDynList2.toArray(new DynamicObject[0]), (OperateOption)option);
        if (!operationResult.isSuccess()) {
            errorInfoDetails = ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo());
            log.info("ProdMatMappingServiceImpl:\u5546\u54c1\u7269\u6599\u6620\u5c04\u5931\u8d25\uff1a" + errorInfoDetails);
            throw new KDBizException(errorInfoDetails);
        }
        log.info("ProdMatMappingServiceImpl:\u5546\u54c1\u7269\u6599\u6620\u5c04\u6210\u529f:" + SerializationUtils.toJsonString((Object)operationResult.getSuccessPkIds()));
        if (!operationResult1.isSuccess()) {
            errorInfoDetails = ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo());
            log.info("ProdMatMappingServiceImpl:\u5546\u54c1\u7269\u6599\u6620\u5c04\u5931\u8d25\uff1a" + errorInfoDetails);
            throw new KDBizException(errorInfoDetails);
        }
        log.info("ProdMatMappingServiceImpl:\u5546\u54c1\u7269\u6599\u6620\u5c04\u6210\u529f:" + SerializationUtils.toJsonString((Object)operationResult.getSuccessPkIds()));
        return res;
    }

    private Map<Long, DynamicObject> getProdDynMap(Map<Long, ProdMatMapping> prodIdAndMappingMap) {
        DynamicObject[] prodDynArray;
        HashMap<Long, DynamicObject> prodDynMap = new HashMap<Long, DynamicObject>(prodIdAndMappingMap.size());
        for (DynamicObject prod : prodDynArray = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"id,prodmatmapping,prodmatmappingstatus,prodmatmappingtype,source", (QFilter[])new QFilter[]{new QFilter("id", "in", prodIdAndMappingMap.keySet())})) {
            prodDynMap.put(prod.getLong("id"), prod);
        }
        return prodDynMap;
    }

    @Override
    public Map<Long, List<Long>> getMaterialIdsByGoodsCategoryMapping(Long goodsCategoryId) {
        HashMap<Long, List<Long>> goodsCategoryIdsAndMaterialIdsMap = new HashMap<Long, List<Long>>(8);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"pmm_categorymatmapping", (String)"materialgroup", (QFilter[])new QFilter[]{new QFilter("goodscategory", "=", (Object)goodsCategoryId)});
        if (dynamicObject == null) {
            return goodsCategoryIdsAndMaterialIdsMap;
        }
        long materialCategoryId = dynamicObject.getLong("materialgroup");
        QFilter qFilter = new QFilter("group", "=", (Object)materialCategoryId);
        qFilter.and("standard", "=", (Object)BillAssistConstant.MATERIAL_STANDARD_ID);
        ArrayList<Long> materials = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialgroupdetail", (String)"material,group,standard", (QFilter[])qFilter.toArray(), null);){
            for (Row row : dataSet) {
                materials.add(row.getLong(MATERIAL));
            }
        }
        goodsCategoryIdsAndMaterialIdsMap.put(goodsCategoryId, materials);
        return goodsCategoryIdsAndMaterialIdsMap;
    }
}

