/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.enums.ProdEffectStatusEnum;
import kd.scm.malcore.enums.SaleStatusEnum;
import kd.scm.pmm.business.model.prodpool.LadderPrice;
import kd.scm.pmm.business.model.prodpool.ProdPool;
import kd.scm.pmm.business.service.ProdPoolCommandService;

public class ProdPoolCommandServiceImpl
implements ProdPoolCommandService {
    private static Log log = LogFactory.getLog(ProdPoolCommandServiceImpl.class);

    @Override
    public void prodAuditCfm(List<Long> prodAuditId) {
        log.info("=====ProdPoolCommandServiceImpl.prodAuditCfm start=====");
        log.info("ProdPoolCommandServiceImpl.prodAuditCfm prodAuditId:" + SerializationUtils.toJsonString(prodAuditId));
        QFilter qFilter = new QFilter("id", "in", prodAuditId);
        DynamicObjectCollection prodAuditDynColl = QueryServiceHelper.query((String)"pmm_prodaudit", (String)"origin,id,billno,protocolid.id protocolid,protocolid.effectdate effectdate,protocolid.invaliddate invaliddate,protocolid.protocolstatus protocolstatus,biztype,entryentity.goods.id goods,entryentity.goods.taxrateid taxrateid,entryentity.goods.taxprice,entryentity.goods.taxrate taxrate,entryentity.goods.name goodsname,entryentity.note note,entryentity.taxprice taxprice,entryentity.price price,entryentity.entryresult entryresult,org,entryentity.srcbillid srcbillid,entryentity.srcbilltype srcbilltype,entryentity.unit.id unit,entryentity.protocolentry.purplanid purplan,entryentity.protocolentry.id protocolentry,entryentity.priceeffectdate priceeffectdate,entryentity.priceinvaliddate priceinvaliddate,entryentity.subentryentity.qtyfrom qtyfrom,entryentity.subentryentity.qtyto qtyto,entryentity.subentryentity.ladprice ladprice,entryentity.minorderqty minorderqty,entryentity.leadtime leadtime,creator,createtime,cfmdate,cfm", (QFilter[])new QFilter[]{qFilter});
        log.info("ProdPoolCommandServiceImpl.prodAuditCfm prodAuditDynColl.size():" + prodAuditDynColl.size());
        ArrayList<DynamicObject> noProtocolProdAuditDynList = new ArrayList<DynamicObject>(prodAuditDynColl.size());
        ArrayList<DynamicObject> protocolProdAuditDynList = new ArrayList<DynamicObject>(prodAuditDynColl.size());
        ArrayList<DynamicObject> noProtocolProdDisagreeAuditDynList = new ArrayList<DynamicObject>(prodAuditDynColl.size());
        ArrayList<DynamicObject> protocolProdDisagreeAuditDynList = new ArrayList<DynamicObject>(prodAuditDynColl.size());
        ArrayList<DynamicObject> downloadAgreeAuditDynList = new ArrayList<DynamicObject>(prodAuditDynColl.size());
        for (DynamicObject prodAuditDyn : prodAuditDynColl) {
            long protocolDyn = prodAuditDyn.getLong("protocolid");
            String biztype = prodAuditDyn.getString("biztype");
            String entryresult = prodAuditDyn.getString("entryresult");
            if (protocolDyn == 0L && "1".equals(biztype)) {
                if ("1".equals(entryresult)) {
                    noProtocolProdAuditDynList.add(prodAuditDyn);
                    continue;
                }
                noProtocolProdDisagreeAuditDynList.add(prodAuditDyn);
                continue;
            }
            if (protocolDyn != 0L && "1".equals(biztype)) {
                if ("1".equals(entryresult)) {
                    protocolProdAuditDynList.add(prodAuditDyn);
                    continue;
                }
                protocolProdDisagreeAuditDynList.add(prodAuditDyn);
                continue;
            }
            if (!"1".equals(entryresult)) continue;
            downloadAgreeAuditDynList.add(prodAuditDyn);
        }
        this.dealGoodsRuleLogStatus(prodAuditDynColl);
        if (!noProtocolProdAuditDynList.isEmpty()) {
            this.uploadNoProtocolProd(noProtocolProdAuditDynList);
        }
        if (!protocolProdAuditDynList.isEmpty()) {
            this.uploadProtocolProd(protocolProdAuditDynList);
        }
        if (!noProtocolProdDisagreeAuditDynList.isEmpty()) {
            this.disagreeNoProtocolProd(noProtocolProdDisagreeAuditDynList);
        }
        if (!protocolProdDisagreeAuditDynList.isEmpty()) {
            this.disagreeProtocolProd(protocolProdDisagreeAuditDynList);
        }
        if (!downloadAgreeAuditDynList.isEmpty()) {
            this.downloadAgreeHandle(downloadAgreeAuditDynList);
        }
    }

    private void dealGoodsRuleLogStatus(DynamicObjectCollection prodAuditDynColl) {
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        HashMap<String, String> goodsMap = new HashMap<String, String>(16);
        HashMap<String, String> goodsbizTypeMap = new HashMap<String, String>(16);
        HashSet<Long> goodsRuleLogIds = new HashSet<Long>(16);
        HashSet<Long> goodsRuleLogDownIds = new HashSet<Long>(16);
        for (DynamicObject prodAuditDyn : prodAuditDynColl) {
            String protocolEntry;
            String biztype = prodAuditDyn.getString("biztype");
            String entryresult = prodAuditDyn.getString("entryresult");
            String srcBillId = prodAuditDyn.getString("srcbillid");
            String goodsId = prodAuditDyn.getString("goods");
            String srcBillType = prodAuditDyn.getString("srcbilltype");
            String protocolId = prodAuditDyn.getString("protocolid");
            if (StringUtils.isEmpty((CharSequence)protocolId)) {
                protocolId = "0";
            }
            if (StringUtils.isEmpty((CharSequence)(protocolEntry = prodAuditDyn.getString("protocolentry")))) {
                protocolEntry = "0";
            }
            if (!"1".equals(entryresult)) continue;
            if ("pmm_goodsrulelog".equals(srcBillType) && !StringUtils.isEmpty((CharSequence)srcBillId)) {
                goodsRuleLogIds.add(Long.parseLong(srcBillId));
                if (!"2".equals(biztype)) continue;
                goodsRuleLogDownIds.add(Long.parseLong(srcBillId));
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)goodsId)) continue;
            goodsIds.add(Long.parseLong(goodsId));
            goodsMap.put(goodsId + protocolId + protocolEntry, goodsId);
            goodsbizTypeMap.put(goodsId + protocolId + protocolEntry, biztype);
        }
        this.dealGoodsRulelog(goodsIds, goodsRuleLogIds, goodsRuleLogDownIds, goodsMap, goodsbizTypeMap);
    }

    private void dealGoodsRulelog(Set<Long> goodsIds, Set<Long> goodsRuleLogIds, Set<Long> goodsRuleLogDownIds, Map<String, String> goodsMap, Map<String, String> goodsbizTypeMap) {
        DynamicObject[] pmm_goodsrulelogs;
        QFilter qFilter = new QFilter("goodsid", "in", goodsIds);
        qFilter.or(new QFilter("id", "in", goodsRuleLogIds));
        QFilter dealStatusQFilter = new QFilter("dealstatus", "=", (Object)"A");
        qFilter.and(dealStatusQFilter);
        for (DynamicObject info : pmm_goodsrulelogs = BusinessDataServiceHelper.load((String)"pmm_goodsrulelog", (String)"remark,result,goodsid,dealstatus,id,goodspool.protocol.id,goodspool.protocolentry.id", (QFilter[])qFilter.toArray())) {
            String key;
            String protocolEntry;
            long id = info.getLong("id");
            String goodsid = info.getString("goodsid");
            if (goodsRuleLogIds.contains(id)) {
                info.set("dealstatus", (Object)"B");
                if (!goodsRuleLogDownIds.contains(id)) continue;
                info.set("result", (Object)"2");
                continue;
            }
            String protocolId = info.getString("goodspool.protocol.id");
            if (StringUtils.isEmpty((CharSequence)protocolId)) {
                protocolId = "0";
            }
            if (StringUtils.isEmpty((CharSequence)(protocolEntry = info.getString("goodspool.protocolentry.id")))) {
                protocolEntry = "0";
            }
            if (!goodsMap.containsKey(key = goodsid + protocolId + protocolEntry) || !goodsid.equals(goodsMap.get(key))) continue;
            info.set("dealstatus", (Object)"C");
            String bizType = goodsbizTypeMap.get(key);
            String msg = ResManager.loadKDString((String)"\u56e0\u5546\u57ce\u7aef\u53d1\u8d77\u5546\u54c1\u4e0b\u67b6\uff0c\u4f5c\u5e9f\u76d1\u63a7\u65e5\u5fd7", (String)"ProdPoolCommandServiceImpl_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            if ("1".equals(bizType)) {
                msg = ResManager.loadKDString((String)"\u56e0\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u8c03\u6574\uff0c\u672a\u8fbe\u5230\u9608\u503c/\u751f\u6210\u65b0\u7684\u76d1\u63a7\u65e5\u5fd7\uff0c\u4f5c\u5e9f\u76d1\u63a7\u65e5\u5fd7", (String)"ProdPoolCommandServiceImpl_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            }
            info.set("remark", (Object)msg);
        }
        if (pmm_goodsrulelogs.length > 0) {
            SaveServiceHelper.save((DynamicObject[])pmm_goodsrulelogs);
        }
    }

    private void disagreeNoProtocolProd(List<DynamicObject> prodAuditDynColl) {
        ArrayList prodIds = new ArrayList(prodAuditDynColl.size());
        prodAuditDynColl.forEach(prodAuditDyn -> prodIds.add(prodAuditDyn.getLong("goods")));
        QFilter qFilter = new QFilter("goods", "in", prodIds);
        DynamicObject[] prodPools = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)"mallstatus", (QFilter[])qFilter.toArray());
        QFilter qFilter1 = new QFilter("id", "in", prodIds);
        DynamicObject[] goodsDynArray = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"mallstatus", (QFilter[])qFilter1.toArray());
        for (DynamicObject prodPool : prodPools) {
            prodPool.set("mallstatus", (Object)MallStatusEnum.BACKMODIFY.getVal());
        }
        for (DynamicObject goods : goodsDynArray) {
            goods.set("mallstatus", (Object)MallStatusEnum.BACKMODIFY.getVal());
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodPools);
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])goodsDynArray);
    }

    private void disagreeProtocolProd(List<DynamicObject> prodAuditDynColl) {
        HashSet<Long> prodIdSet = new HashSet<Long>(prodAuditDynColl.size());
        HashSet<Long> protocolIdSet = new HashSet<Long>(prodAuditDynColl.size());
        for (DynamicObject entry : prodAuditDynColl) {
            prodIdSet.add(entry.getLong("goods"));
            protocolIdSet.add(entry.getLong("protocolid"));
        }
        log.info("ProdPoolCommandServiceImpl.prodAuditCfm.disagreeProtocolProd protocolIdSet:" + SerializationUtils.toJsonString(protocolIdSet));
        log.info("ProdPoolCommandServiceImpl.prodAuditCfm.disagreeProtocolProd prodIdSet:" + SerializationUtils.toJsonString(prodIdSet));
        QFilter prodPoolQFilter = new QFilter("goods", "in", prodIdSet);
        prodPoolQFilter.and(new QFilter("protocol", "in", protocolIdSet));
        DynamicObject[] prodPoolDynColl = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)("id,goods," + this.getProperties()), (QFilter[])prodPoolQFilter.toArray());
        HashMap<Long, Set> goodsAndProtocolMap = new HashMap<Long, Set>(prodAuditDynColl.size());
        HashMap<String, DynamicObject> protocolIdAndProdPoolDynMap = new HashMap<String, DynamicObject>(prodPoolDynColl.length);
        ArrayList<DynamicObject> prodPoolDynUpdateList = new ArrayList<DynamicObject>(prodPoolDynColl.length);
        for (DynamicObject prodPoolDyn : prodPoolDynColl) {
            long goodsId = prodPoolDyn.getLong("goods_id");
            protocolIdAndProdPoolDynMap.put(prodPoolDyn.getString("goods_id") + prodPoolDyn.getLong("protocol_id"), prodPoolDyn);
            Set protocolSet = goodsAndProtocolMap.computeIfAbsent(goodsId, s -> new HashSet());
            protocolSet.add(prodPoolDyn.getString("protocol_id") + prodPoolDyn.getString("protocolentry_id"));
        }
        for (DynamicObject entry : prodAuditDynColl) {
            long goods = entry.getLong("goods");
            if (goods == 0L || goodsAndProtocolMap.get(goods) == null || !((Set)goodsAndProtocolMap.get(goods)).contains(entry.getString("protocolid") + entry.getString("protocolentry"))) continue;
            DynamicObject prodPoolDyn = (DynamicObject)protocolIdAndProdPoolDynMap.get(entry.getString("goods") + entry.getString("protocolid"));
            prodPoolDyn.set("mallstatus", (Object)MallStatusEnum.BACKMODIFY.getVal());
            prodPoolDynUpdateList.add(prodPoolDyn);
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodPoolDynUpdateList.toArray(new DynamicObject[0]));
    }

    private void uploadNoProtocolProd(List<DynamicObject> prodAuditDynColl) {
        HashSet<Long> prodIdSet = new HashSet<Long>(prodAuditDynColl.size());
        for (DynamicObject entry : prodAuditDynColl) {
            prodIdSet.add(entry.getLong("goods"));
        }
        this.auditProd(prodIdSet);
        HashMap<Long, ProdPool> prodIdAndProdPoolMap = new HashMap<Long, ProdPool>(prodAuditDynColl.size());
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        for (DynamicObject entry : prodAuditDynColl) {
            goodsIds.add(entry.getLong("goods"));
        }
        QFilter prodQFilter = new QFilter("goods.id", "in", goodsIds);
        DynamicObjectCollection ent_prodpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods.id,id,taxprice,protocol,protocolentry", (QFilter[])prodQFilter.toArray());
        for (DynamicObject entry : prodAuditDynColl) {
            long goods = entry.getLong("goods");
            ProdPool prodPool = null;
            if (null != prodIdAndProdPoolMap.get(goods)) {
                prodPool = (ProdPool)prodIdAndProdPoolMap.get(goods);
            } else {
                prodPool = new ProdPool();
                prodPool.setProductId(entry.getLong("goods"));
                prodPool.setTaxPrice(entry.getBigDecimal("taxprice"));
                prodPool.setPrice(entry.getBigDecimal("price"));
                prodPool.setEffectDate(entry.getDate("priceeffectdate"));
                prodPool.setInvalidDate(entry.getDate("priceinvaliddate"));
            }
            prodPool.setAuditOrgID(entry.getLong("org"));
            if (entry.getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) > 0) {
                LadderPrice ladderPrice = new LadderPrice();
                ladderPrice.setLadprice(entry.getBigDecimal("ladprice"));
                ladderPrice.setQtyfrom(entry.getBigDecimal("qtyfrom"));
                ladderPrice.setQtyto(entry.getBigDecimal("qtyto"));
                if (prodPool.getLadderPrices() == null) {
                    ArrayList<LadderPrice> ladderPrices = new ArrayList<LadderPrice>(1024);
                    ladderPrices.add(ladderPrice);
                    prodPool.setLadderPrices(ladderPrices);
                } else {
                    prodPool.getLadderPrices().add(ladderPrice);
                }
            }
            prodPool.setMinOrderQty(entry.getBigDecimal("minorderqty"));
            prodPool.setLeadtime(entry.getInt("leadtime"));
            prodIdAndProdPoolMap.put(entry.getLong("goods"), prodPool);
        }
        QFilter qFilter = new QFilter("id", "in", prodIdAndProdPoolMap.keySet());
        String prodSelectFields = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
        DynamicObject[] prodDynArray = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)(prodSelectFields + ",protocolentry.prodpool,protocolentry.protocol"), (QFilter[])new QFilter[]{qFilter});
        this.updateNoProtocolProdPool(prodDynArray, prodIdAndProdPoolMap);
    }

    private void uploadProtocolProd(List<DynamicObject> prodAuditDynColl) {
        HashSet<Long> prodIdSet = new HashSet<Long>(prodAuditDynColl.size());
        HashSet<Long> protocolIdSet = new HashSet<Long>(prodAuditDynColl.size());
        for (DynamicObject entry : prodAuditDynColl) {
            prodIdSet.add(entry.getLong("goods"));
            protocolIdSet.add(entry.getLong("protocolid"));
        }
        this.auditProd(prodIdSet);
        QFilter prodPoolQFilter = new QFilter("goods", "in", prodIdSet);
        prodPoolQFilter.and(new QFilter("protocol", "in", protocolIdSet));
        DynamicObject[] prodPoolDynColl = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)this.getProperties(), (QFilter[])prodPoolQFilter.toArray());
        HashMap<Long, Set> goodsAndProtocolMap = new HashMap<Long, Set>(prodAuditDynColl.size());
        HashMap<String, DynamicObject> protocolIdAndProdPoolDynMap = new HashMap<String, DynamicObject>(prodPoolDynColl.length);
        HashMap<String, List<LadderPrice>> protocolId_LadderMap = new HashMap<String, List<LadderPrice>>(prodPoolDynColl.length);
        ArrayList<DynamicObject> prodPoolDynUpdateList = new ArrayList<DynamicObject>(prodPoolDynColl.length);
        for (DynamicObject prodPoolDyn : prodPoolDynColl) {
            long goodsId = prodPoolDyn.getLong("goods_id");
            long protocolId = prodPoolDyn.getLong("protocol_id");
            long protocolentryId = 0L;
            if (null != prodPoolDyn.get("protocolentry")) {
                protocolentryId = prodPoolDyn.getLong("protocolentry_id");
            }
            protocolIdAndProdPoolDynMap.put(prodPoolDyn.getString("goods_id") + prodPoolDyn.getLong("protocol_id") + protocolentryId, prodPoolDyn);
            Set protocolSet = goodsAndProtocolMap.computeIfAbsent(goodsId, s -> new HashSet());
            protocolSet.add(protocolId + "_" + protocolentryId);
        }
        log.info("ProdPoolCommandServiceImpl.prodAuditCfm goodsAndProtocolMap:" + goodsAndProtocolMap.size());
        log.info("ProdPoolCommandServiceImpl.prodAuditCfm protocolIdAndProdPoolDynMap:" + protocolIdAndProdPoolDynMap.size());
        Map<Long, Map<String, Object>> protocolDataMap = this.getProtocolDataMap(protocolIdSet);
        log.info("ProdPoolCommandServiceImpl.prodAuditCfm protocolDataMap:" + SerializationUtils.toJsonString(protocolDataMap));
        HashMap<String, ProdPool> prodIdAndProdPoolMap = new HashMap<String, ProdPool>(prodAuditDynColl.size());
        HashSet<ProdPool> prodPools = new HashSet<ProdPool>(prodAuditDynColl.size());
        HashSet<String> uniqueKeys = new HashSet<String>(1024);
        for (DynamicObject entry : prodAuditDynColl) {
            LadderPrice ladderPrice;
            long goods = entry.getLong("goods");
            long protocolId = entry.getLong("protocolid");
            long protocolentryId = entry.getLong("protocolentry");
            if (goods == 0L) continue;
            ProdPool prodPool = new ProdPool();
            String key = entry.getString("goods") + entry.getString("protocolid") + entry.getString("protocolentry");
            if (goodsAndProtocolMap.get(goods) == null || !((Set)goodsAndProtocolMap.get(goods)).contains(protocolId + "_" + protocolentryId)) {
                Map<String, Object> protocolData = protocolDataMap.get(protocolId);
                prodPool.setMinOrderQty(entry.getBigDecimal("minorderqty"));
                prodPool.setLeadtime(entry.getInt("leadtime"));
                prodPool.setAuditOrgID(entry.getLong("org"));
                if (null != prodIdAndProdPoolMap.get(key)) {
                    prodPool = (ProdPool)prodIdAndProdPoolMap.get(key);
                } else {
                    this.setNoProtococlInfo(entry, protocolData, goods, prodPool, protocolId);
                    prodPools.add(prodPool);
                }
                if (entry.getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) > 0) {
                    ladderPrice = new LadderPrice();
                    ladderPrice.setLadprice(entry.getBigDecimal("ladprice"));
                    ladderPrice.setQtyfrom(entry.getBigDecimal("qtyfrom"));
                    ladderPrice.setQtyto(entry.getBigDecimal("qtyto"));
                    if (prodPool.getLadderPrices() == null) {
                        ArrayList<LadderPrice> ladderPrices = new ArrayList<LadderPrice>(1024);
                        ladderPrices.add(ladderPrice);
                        prodPool.setLadderPrices(ladderPrices);
                    } else {
                        prodPool.getLadderPrices().add(ladderPrice);
                    }
                }
            } else {
                List<LadderPrice> ladderPrices = new ArrayList(1024);
                if (null != protocolId_LadderMap.get(key)) {
                    ladderPrices = (List)protocolId_LadderMap.get(key);
                }
                if (entry.getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) > 0) {
                    ladderPrice = new LadderPrice();
                    ladderPrice.setLadprice(entry.getBigDecimal("ladprice"));
                    ladderPrice.setQtyfrom(entry.getBigDecimal("qtyfrom"));
                    ladderPrice.setQtyto(entry.getBigDecimal("qtyto"));
                    ladderPrices.add(ladderPrice);
                    protocolId_LadderMap.put(key, ladderPrices);
                }
                if (null != prodIdAndProdPoolMap.get(key)) continue;
                DynamicObject prodPoolDyn = (DynamicObject)protocolIdAndProdPoolDynMap.get(key);
                if (uniqueKeys.contains(key)) continue;
                this.setProtocolPoolInfo(prodPoolDyn, entry);
                prodPoolDyn.set("minorderqty", (Object)entry.getBigDecimal("minorderqty"));
                prodPoolDyn.set("leadtime", (Object)entry.getInt("leadtime"));
                prodPoolDyn.set("auditorg_id", (Object)entry.getLong("org"));
                prodPool.setAuditOrgID(entry.getLong("org"));
                prodPool.setInvalidDate(entry.getDate("priceinvaliddate"));
                prodPool.setEffectDate(entry.getDate("priceeffectdate"));
                String statusByEffectDate = prodPool.getStatusByEffectDate();
                prodPoolDyn.set("mallstatus", (Object)statusByEffectDate);
                prodPoolDyn.set("effectstatus", (Object)statusByEffectDate);
                prodPoolDynUpdateList.add(prodPoolDyn);
                uniqueKeys.add(key);
            }
            prodIdAndProdPoolMap.put(key, prodPool);
        }
        log.info("ProdPoolCommandServiceImpl.prodAuditCfm prodPools:" + SerializationUtils.toJsonString(prodPools));
        List<DynamicObject> prodPoolDynList = this.addNewProdPoolByProtocol(prodPools);
        this.auditProdPool(prodPoolDynList);
        this.setProtocolPoolInfoAndLadderPirce(prodPoolDynUpdateList, protocolId_LadderMap, protocolId_LadderMap);
        this.prodPoolSoldOp(prodPoolDynUpdateList.toArray(new DynamicObject[0]));
    }

    private void setProtocolPoolInfoAndLadderPirce(List<DynamicObject> prodPoolDynUpdateList, Map<String, List<LadderPrice>> protocolId_ladderMap, Map<String, List<LadderPrice>> protocolId_LadderMap) {
        for (DynamicObject info : prodPoolDynUpdateList) {
            DynamicObject goods = info.getDynamicObject("goods");
            DynamicObject protocol = info.getDynamicObject("protocol");
            String protocolentryId = "0";
            DynamicObject protocolentry = info.getDynamicObject("protocolentry");
            if (null != protocolentry) {
                protocolentryId = protocolentry.getString("id");
            }
            if (null == goods || null == protocol) continue;
            String key = goods.getString("id") + protocol.getString("id") + protocolentryId;
            if (null != protocolId_LadderMap.get(key)) {
                List<LadderPrice> ladderPrices = protocolId_LadderMap.get(key);
                DynamicObjectCollection priceentry = info.getDynamicObjectCollection("priceentry");
                priceentry.clear();
                if (ladderPrices == null || ladderPrices.size() == 0) {
                    info.set("priceentry", (Object)priceentry);
                    info.set("pricetype", (Object)"A");
                    continue;
                }
                ladderPrices = ladderPrices.stream().sorted(Comparator.comparing(LadderPrice::getQtyfrom)).collect(Collectors.toList());
                for (LadderPrice price : ladderPrices) {
                    DynamicObject priceEntry = priceentry.addNew();
                    priceEntry.set("qtyfrom", (Object)price.getQtyfrom());
                    priceEntry.set("qtyto", (Object)price.getQtyto());
                    priceEntry.set("ladprice", (Object)price.getLadprice());
                }
                info.set("pricetype", (Object)"B");
                continue;
            }
            DynamicObjectCollection priceentry = info.getDynamicObjectCollection("priceentry");
            priceentry.clear();
            info.set("priceentry", (Object)priceentry);
            info.set("pricetype", (Object)"A");
        }
    }

    private void setProtocolPoolInfo(DynamicObject prodPoolDyn, DynamicObject entry) {
        prodPoolDyn.set("taxprice", entry.get("taxprice"));
        prodPoolDyn.set("taxrateid", entry.get("taxrateid"));
        prodPoolDyn.set("taxrate", entry.get("taxrate"));
        prodPoolDyn.set("unit", entry.get("unit"));
        prodPoolDyn.set("price", entry.get("price"));
        prodPoolDyn.set("priceeffectdate", entry.get("priceeffectdate"));
        prodPoolDyn.set("priceinvaliddate", entry.get("priceinvaliddate"));
    }

    private void setNoProtococlInfo(DynamicObject entry, Map<String, Object> protocolData, long goods, ProdPool prodPool, long protocolId) {
        prodPool.setTaxPrice(entry.getBigDecimal("taxprice"));
        prodPool.setTaxRateID(entry.getLong("taxrateid"));
        prodPool.setTaxRate(entry.getBigDecimal("taxrate"));
        prodPool.setPrice(entry.getBigDecimal("price"));
        prodPool.setCreateOrgID((Long)protocolData.get("auditOrgID"));
        prodPool.setAuditOrgID((Long)protocolData.get("auditOrgID"));
        prodPool.setPlatform("1");
        prodPool.setProtocolEntryID(entry.getLong("protocolentry"));
        prodPool.setUnit(entry.getLong("unit"));
        prodPool.setName(entry.getString("goodsname"));
        prodPool.setProductId(goods);
        prodPool.setEffectDate(entry.getDate("priceeffectdate"));
        prodPool.setInvalidDate(entry.getDate("priceinvaliddate"));
        prodPool.setCentralPurType((String)protocolData.get("purMode"));
        prodPool.setIsGoodVisible((Boolean)protocolData.get("isGoodVisible"));
        prodPool.setProtocolId(protocolId);
        prodPool.setPurPlanId(entry.getLong("purplan"));
        if (null != protocolData.get("entryOrg")) {
            Map entryOrgs = (Map)protocolData.get("entryOrg");
            Long protocolEntryId = 0L;
            protocolEntryId = entry.get("protocolentry") instanceof DynamicObject ? Long.valueOf(entry.getDynamicObject("protocolentry").getLong("id")) : Long.valueOf(entry.getLong("protocolentry"));
            if (protocolEntryId != 0L) {
                prodPool.setOrgIdList((List)entryOrgs.get(protocolEntryId));
            }
        } else {
            prodPool.setOrgIdList((List)protocolData.get("orgIdList"));
        }
        prodPool.setProtocolStatus((String)protocolData.get("protocolStatus"));
    }

    private void downloadAgreeHandle(List<DynamicObject> prodAuditDynColl) {
        ArrayList<Long> noProtocolProdIds = new ArrayList<Long>(prodAuditDynColl.size());
        ArrayList<Long> goodsIds = new ArrayList<Long>(prodAuditDynColl.size());
        ArrayList<Long> protocolIds = new ArrayList<Long>(prodAuditDynColl.size());
        HashSet<String> goodsAndProtocolIds = new HashSet<String>(prodAuditDynColl.size());
        for (DynamicObject prodAudit : prodAuditDynColl) {
            goodsIds.add(prodAudit.getLong("goods"));
            protocolIds.add(prodAudit.getLong("protocolid"));
            if (0L == prodAudit.getLong("protocolid")) {
                noProtocolProdIds.add(prodAudit.getLong("goods"));
            }
            long protocolentryId = 0L;
            if (null != prodAudit.get("protocolentry")) {
                protocolentryId = prodAudit.getLong("protocolentry");
            }
            goodsAndProtocolIds.add(prodAudit.getString("goods") + prodAudit.getString("protocolid") + protocolentryId);
        }
        QFilter prodPoolQFilter = new QFilter("goods", "in", goodsIds);
        prodPoolQFilter.and(new QFilter("protocol", "in", protocolIds));
        DynamicObjectCollection prodPoolDynColl = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id,goods,protocol,protocolentry", (QFilter[])prodPoolQFilter.toArray());
        ArrayList<Long> prodPoolIds = new ArrayList<Long>(prodPoolDynColl.size());
        for (DynamicObject prodPool : prodPoolDynColl) {
            if (!goodsAndProtocolIds.contains(prodPool.getString("goods") + prodPool.getString("protocol") + prodPool.getString("protocolentry"))) continue;
            prodPoolIds.add(prodPool.getLong("id"));
        }
        this.downloadProdPool(noProtocolProdIds, prodPoolIds);
    }

    private void downloadProdPool(List<Long> noProtocolProdIds, List<Long> prodPoolIds) {
        OperationResult operationResult1;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("isshowmessage", String.valueOf(false));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"download", (String)"pmm_prodpool", (Object[])prodPoolIds.toArray(new Object[0]), (OperateOption)option);
        if (!operationResult.isSuccess()) {
            CommonUtil.check((OperationResult)operationResult);
        }
        if (!noProtocolProdIds.isEmpty() && !(operationResult1 = OperationServiceHelper.executeOperate((String)"download", (String)"pmm_prodmanage", (Object[])noProtocolProdIds.toArray(new Object[0]), (OperateOption)option)).isSuccess()) {
            CommonUtil.check((OperationResult)operationResult1);
        }
    }

    @Override
    public List<DynamicObject> addNewProdPoolByProtocol(Set<ProdPool> prodPools) {
        ArrayList<DynamicObject> newProdPoolDynList = new ArrayList<DynamicObject>(prodPools.size());
        for (ProdPool prodPool : prodPools) {
            DynamicObject newProdPoolDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodpool");
            newProdPoolDyn.set("name", (Object)prodPool.getName());
            newProdPoolDyn.set("goods_id", (Object)prodPool.getProductId());
            newProdPoolDyn.set("taxprice", (Object)prodPool.getTaxPrice());
            newProdPoolDyn.set("taxrateid_id", (Object)prodPool.getTaxRateID());
            newProdPoolDyn.set("taxrate", (Object)prodPool.getTaxRate());
            newProdPoolDyn.set("price", (Object)prodPool.getPrice());
            newProdPoolDyn.set("unit", (Object)prodPool.getUnit());
            newProdPoolDyn.set("createorg_id", (Object)prodPool.getCreateOrgID());
            newProdPoolDyn.set("auditorg_id", (Object)prodPool.getAuditOrgID());
            newProdPoolDyn.set("purplan_id", (Object)prodPool.getPurPlanId());
            newProdPoolDyn.set("protocolentry_id", (Object)prodPool.getProtocolEntryID());
            newProdPoolDyn.set("platform", (Object)prodPool.getPlatform());
            newProdPoolDyn.set("enable", (Object)"1");
            newProdPoolDyn.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            newProdPoolDyn.set("mallstatus", (Object)prodPool.getStatusByEffectDate());
            if (ProdEffectStatusEnum.INVALID.getVal().equals(prodPool.getStatusByEffectDate())) {
                newProdPoolDyn.set("salestatus", (Object)SaleStatusEnum.HIDE.getVal());
            } else {
                newProdPoolDyn.set("salestatus", (Object)SaleStatusEnum.SALE.getVal());
            }
            newProdPoolDyn.set("effectstatus", (Object)prodPool.getStatusByEffectDate());
            newProdPoolDyn.set("centralpurtype", (Object)prodPool.getCentralPurType());
            newProdPoolDyn.set("isgoodvisible", (Object)prodPool.getIsGoodVisible());
            newProdPoolDyn.set("protocol_id", (Object)prodPool.getProtocolId());
            newProdPoolDyn.set("priceeffectdate", (Object)prodPool.getEffectDate());
            newProdPoolDyn.set("priceinvaliddate", (Object)prodPool.getInvalidDate());
            newProdPoolDyn.set("minorderqty", (Object)prodPool.getMinOrderQty());
            newProdPoolDyn.set("leadtime", (Object)prodPool.getLeadtime());
            DynamicObjectCollection prodPoolEntryEntity = newProdPoolDyn.getDynamicObjectCollection("entryentity");
            List<Long> orgIdList = prodPool.getOrgIdList();
            for (Long orgId : orgIdList) {
                DynamicObject newProdPoolEntryEntity = prodPoolEntryEntity.addNew();
                newProdPoolEntryEntity.set("orgname_id", (Object)orgId);
            }
            List<LadderPrice> ladderPrices = prodPool.getLadderPrices();
            DynamicObjectCollection priceentry = newProdPoolDyn.getDynamicObjectCollection("priceentry");
            priceentry.clear();
            if (ladderPrices == null || ladderPrices.size() == 0) {
                newProdPoolDyn.set("priceentry", (Object)priceentry);
                newProdPoolDyn.set("pricetype", (Object)"A");
            } else {
                ladderPrices = ladderPrices.stream().sorted(Comparator.comparing(LadderPrice::getQtyfrom)).collect(Collectors.toList());
                for (LadderPrice price : ladderPrices) {
                    DynamicObject priceEntry = priceentry.addNew();
                    priceEntry.set("qtyfrom", (Object)price.getQtyfrom());
                    priceEntry.set("qtyto", (Object)price.getQtyto());
                    priceEntry.set("ladprice", (Object)price.getLadprice());
                }
                newProdPoolDyn.set("pricetype", (Object)"B");
            }
            newProdPoolDynList.add(newProdPoolDyn);
        }
        return newProdPoolDynList;
    }

    @Override
    public List<DynamicObject> addNoProtocolProdPool(Set<Long> productIds) {
        String selectProperties = "id,name,taxprice,createorg,taxrateid,taxrate,price,unit,protocolentry.protocol,protocolentry.prodpool";
        DynamicObject[] prodDynArray = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", productIds)});
        ArrayList<DynamicObject> newProdPoolDynList = new ArrayList<DynamicObject>(prodDynArray.length);
        HashMap<Long, DynamicObject> updateProdPoolDynMap = new HashMap<Long, DynamicObject>(prodDynArray.length);
        for (DynamicObject prodDyn : prodDynArray) {
            DynamicObjectCollection protocolEntry = prodDyn.getDynamicObjectCollection("protocolentry");
            if (protocolEntry.isEmpty()) {
                DynamicObject newProdPoolDyn = this.createNewProdPoolDyn(prodDyn);
                newProdPoolDynList.add(newProdPoolDyn);
                continue;
            }
            if (((DynamicObject)protocolEntry.get(0)).get("protocol") != null) continue;
            updateProdPoolDynMap.put(((DynamicObject)protocolEntry.get(0)).getDynamicObject("prodpool").getLong("id"), prodDyn);
        }
        this.updateProdPoolByProd(updateProdPoolDynMap);
        return newProdPoolDynList;
    }

    @Override
    public List<Object> auditProdPool(List<DynamicObject> newProdPoolDynList) {
        if (newProdPoolDynList.isEmpty()) {
            return new ArrayList<Object>();
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        OperationResult saveOpRes = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodpool", (DynamicObject[])newProdPoolDynList.toArray(new DynamicObject[0]), (OperateOption)option);
        if (!saveOpRes.isSuccess()) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1\u6c60\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"PmmProdPoolUtil_0", (String)"scm-pmm-common", (Object[])new Object[0]);
            throw new KDBizException(msg + ExceptionUtil.getErrorInfoDetails((List)saveOpRes.getAllErrorOrValidateInfo()));
        }
        OperationResult submitOpRes = OperationServiceHelper.executeOperate((String)"submit", (String)"pmm_prodpool", (Object[])saveOpRes.getSuccessPkIds().toArray(), (OperateOption)option);
        if (!submitOpRes.isSuccess()) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1\u6c60\u63d0\u4ea4\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"PmmProdPoolUtil_1", (String)"scm-pmm-common", (Object[])new Object[0]);
            throw new KDBizException(msg + ExceptionUtil.getErrorInfoDetails((List)submitOpRes.getAllErrorOrValidateInfo()));
        }
        OperationResult auditOpRes = OperationServiceHelper.executeOperate((String)"audit", (String)"pmm_prodpool", (Object[])submitOpRes.getSuccessPkIds().toArray(), (OperateOption)option);
        if (!auditOpRes.isSuccess()) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1\u6c60\u5ba1\u6838\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"PmmProdPoolUtil_2", (String)"scm-pmm-common", (Object[])new Object[0]);
            throw new KDBizException(msg + ExceptionUtil.getErrorInfoDetails((List)auditOpRes.getAllErrorOrValidateInfo()));
        }
        return auditOpRes.getSuccessPkIds();
    }

    private void updateNoProtocolProdPool(DynamicObject[] prodDynArray, Map<Long, ProdPool> prodIdAndProdPoolMap) {
        DynamicObject[] prodPoolDynArray;
        ArrayList<Long> prodPoolIdList = new ArrayList<Long>(prodDynArray.length);
        for (DynamicObject prodDyn : prodDynArray) {
            ProdPool prodPool = prodIdAndProdPoolMap.get(prodDyn.getLong("id"));
            prodDyn.set("shopprice", (Object)prodPool.getTaxPrice());
            prodDyn.set("taxprice", (Object)prodPool.getTaxPrice());
            prodDyn.set("price", (Object)prodPool.getPrice());
            prodDyn.set("mallstatus", (Object)prodPool.getStatusByEffectDate());
            DynamicObjectCollection protocolEntry = prodDyn.getDynamicObjectCollection("protocolentry");
            for (DynamicObject entry : protocolEntry) {
                prodPoolIdList.add(entry.getDynamicObject("prodpool").getLong("id"));
            }
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodmanage", (DynamicObject[])prodDynArray, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            String errorInfoDetails = ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo());
            throw new KDBizException(errorInfoDetails);
        }
        log.info("ProdPoolCommandServiceImpl.prodAuditCfm prodPoolIdList:" + SerializationUtils.toJsonString(prodPoolIdList));
        QFilter qFilter = new QFilter("id", "in", prodPoolIdList);
        for (DynamicObject prodPoolDyn : prodPoolDynArray = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)this.getProperties(), (QFilter[])new QFilter[]{qFilter})) {
            ProdPool prodPool = prodIdAndProdPoolMap.get(prodPoolDyn.getLong("goods_id"));
            prodPoolDyn.set("taxprice", (Object)prodPool.getTaxPrice());
            prodPoolDyn.set("price", (Object)prodPool.getPrice());
            String statusByEffectDate = prodPool.getStatusByEffectDate();
            prodPoolDyn.set("mallstatus", (Object)statusByEffectDate);
            prodPoolDyn.set("effectstatus", (Object)statusByEffectDate);
            prodPoolDyn.set("priceeffectdate", (Object)prodPool.getEffectDate());
            prodPoolDyn.set("priceinvaliddate", (Object)prodPool.getInvalidDate());
            prodPoolDyn.set("minorderqty", (Object)prodPool.getMinOrderQty());
            prodPoolDyn.set("leadtime", (Object)prodPool.getLeadtime());
            prodPoolDyn.set("auditorg_id", (Object)prodPool.getAuditOrgID());
            List<LadderPrice> ladderPrices = prodPool.getLadderPrices();
            DynamicObjectCollection priceentry = prodPoolDyn.getDynamicObjectCollection("priceentry");
            priceentry.clear();
            if (ladderPrices == null || ladderPrices.size() == 0) {
                prodPoolDyn.set("priceentry", (Object)priceentry);
                prodPoolDyn.set("pricetype", (Object)"A");
                continue;
            }
            ladderPrices = ladderPrices.stream().sorted(Comparator.comparing(LadderPrice::getQtyfrom)).collect(Collectors.toList());
            for (LadderPrice price : ladderPrices) {
                DynamicObject priceEntry = priceentry.addNew();
                priceEntry.set("qtyfrom", (Object)price.getQtyfrom());
                priceEntry.set("qtyto", (Object)price.getQtyto());
                priceEntry.set("ladprice", (Object)price.getLadprice());
            }
            prodPoolDyn.set("pricetype", (Object)"B");
        }
        this.prodPoolSoldOp(prodPoolDynArray);
    }

    private DynamicObject createNewProdPoolDyn(DynamicObject prodDyn) {
        DynamicObject newProdPoolDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodpool");
        newProdPoolDyn.set("name", (Object)prodDyn.getString("name"));
        newProdPoolDyn.set("goods", (Object)prodDyn);
        newProdPoolDyn.set("taxprice", prodDyn.get("taxprice"));
        newProdPoolDyn.set("taxrateid", prodDyn.get("taxrateid"));
        newProdPoolDyn.set("taxrate", prodDyn.get("taxrate"));
        newProdPoolDyn.set("price", prodDyn.get("price"));
        newProdPoolDyn.set("createorg", prodDyn.get("createorg"));
        newProdPoolDyn.set("auditorg", prodDyn.get("createorg"));
        newProdPoolDyn.set("mallstatus", (Object)MallStatusEnum.TEMPSTATUS.getVal());
        newProdPoolDyn.set("salestatus", (Object)SaleStatusEnum.HIDE.getVal());
        newProdPoolDyn.set("unit", prodDyn.get("unit"));
        newProdPoolDyn.set("platform", (Object)"1");
        newProdPoolDyn.set("enable", (Object)"1");
        newProdPoolDyn.set("status", (Object)"A");
        newProdPoolDyn.set("isgoodvisible", (Object)Boolean.TRUE);
        newProdPoolDyn.set("centralpurtype", (Object)"1");
        newProdPoolDyn.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        newProdPoolDyn.set("effectstatus", (Object)ProdEffectStatusEnum.INEFFECTIVE.getVal());
        return newProdPoolDyn;
    }

    private void updateProdPoolByProd(Map<Long, DynamicObject> updateProdPoolDynMap) {
        DynamicObject[] prodPoolArray;
        if (updateProdPoolDynMap.isEmpty()) {
            return;
        }
        for (DynamicObject prodPoolDyn : prodPoolArray = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)("id,name,goods,taxprice,taxrateid,taxrate,price,unit,createorg,auditorg," + this.getProperties()), (QFilter[])new QFilter[]{new QFilter("id", "in", updateProdPoolDynMap.keySet())})) {
            DynamicObject prodDyn = updateProdPoolDynMap.get(prodPoolDyn.getLong("id"));
            prodPoolDyn.set("taxprice", prodDyn.get("taxprice"));
            prodPoolDyn.set("taxrateid", prodDyn.get("taxrateid"));
            prodPoolDyn.set("taxrate", prodDyn.get("taxrate"));
            prodPoolDyn.set("price", prodDyn.get("price"));
            prodPoolDyn.set("unit", prodDyn.get("unit"));
            prodPoolDyn.set("createorg", prodDyn.get("createorg"));
            prodPoolDyn.set("auditorg", prodDyn.get("createorg"));
        }
        if (prodPoolArray.length > 0) {
            SaveServiceHelper.save((DynamicObject[])prodPoolArray);
        }
    }

    private Map<Long, Map<String, Object>> getProtocolDataMap(Set<Long> protocolIdSet) {
        DynamicObject[] protocolDynColl = BusinessDataServiceHelper.load((String)"pmm_protocol", (String)"id,org,protocolstatus,effectdate,invaliddate,purmode,isgoodvisible,entryentity.orgname,differentarea", (QFilter[])new QFilter[]{new QFilter("id", "in", protocolIdSet)});
        HashMap<Long, Map<String, Object>> protocolDataMap = new HashMap<Long, Map<String, Object>>(protocolDynColl.length);
        HashSet<Long> differentProtocolIds = new HashSet<Long>(1024);
        for (DynamicObject protocolDyn : protocolDynColl) {
            if (protocolDyn.getBoolean("differentarea")) {
                differentProtocolIds.add(protocolDyn.getLong("id"));
            }
            Map dataMap = protocolDataMap.computeIfAbsent(protocolDyn.getLong("id"), s -> new HashMap());
            dataMap.put("effectDate", protocolDyn.get("effectdate"));
            dataMap.put("invalidDate", protocolDyn.get("invaliddate"));
            dataMap.put("purMode", protocolDyn.get("purmode"));
            dataMap.put("isGoodVisible", protocolDyn.get("isgoodvisible"));
            dataMap.put("auditOrgID", protocolDyn.getLong("org_id"));
            dataMap.put("protocolStatus", protocolDyn.getString("protocolstatus"));
            DynamicObjectCollection entryEntity = protocolDyn.getDynamicObjectCollection("entryentity");
            ArrayList orgIdList = new ArrayList(entryEntity.size());
            if (!protocolDyn.getBoolean("isgoodvisible")) {
                entryEntity.forEach(entry -> orgIdList.add(entry.getLong("orgname_id")));
            }
            dataMap.put("orgIdList", orgIdList);
        }
        if (differentProtocolIds.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", differentProtocolIds);
            String selectors = "id,effectdate,invaliddate,purmode,entryentity1.id,entryentity1.purplanid,entryentity1.purorg,differentarea";
            DynamicObjectCollection pmmProtocols = QueryServiceHelper.query((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray());
            HashMap purPlanId_OrgsMap = new HashMap(1024);
            HashMap<Long, Long> entryId_purPlanIdMap = new HashMap<Long, Long>(1024);
            HashMap id_EntryIdsMap = new HashMap(1024);
            for (DynamicObject row : pmmProtocols) {
                Long id = row.getLong("id");
                Long entryId = row.getLong("entryentity1.id");
                Long purplanid = row.getLong("entryentity1.purplanid");
                Long purorg = row.getLong("entryentity1.purorg");
                Set<Long> orgIds = new HashSet<Long>(1024);
                if (null != purPlanId_OrgsMap.get(purplanid)) {
                    orgIds = (Set)purPlanId_OrgsMap.get(purplanid);
                }
                orgIds.add(purorg);
                purPlanId_OrgsMap.put(purplanid, orgIds);
                entryId_purPlanIdMap.put(entryId, purplanid);
                List<Long> entryIds = new ArrayList<Long>(1024);
                if (null != id_EntryIdsMap.get(id)) {
                    entryIds = (List)id_EntryIdsMap.get(id);
                }
                entryIds.add(entryId);
                id_EntryIdsMap.put(id, entryIds);
            }
            HashMap id_EntryOrgMap = new HashMap(1024);
            for (Map.Entry map : id_EntryIdsMap.entrySet()) {
                List entryIds = (List)map.getValue();
                HashMap entryId_orgIdsMap = new HashMap(1024);
                for (Long entryId : entryIds) {
                    if (null == entryId_purPlanIdMap.get(entryId)) continue;
                    entryId_orgIdsMap.put(entryId, new ArrayList((Collection)purPlanId_OrgsMap.get(entryId_purPlanIdMap.get(entryId))));
                }
                id_EntryOrgMap.put(map.getKey(), entryId_orgIdsMap);
            }
            for (Map.Entry map : protocolDataMap.entrySet()) {
                if (null == id_EntryOrgMap.get(map.getKey())) continue;
                Map stringObjectMap = (Map)protocolDataMap.get(map.getKey());
                stringObjectMap.put("entryOrg", id_EntryOrgMap.get(map.getKey()));
            }
        }
        return protocolDataMap;
    }

    @Override
    public void deleteProdPoolRelation(Set<Long> productIds) {
        QFilter qFilter = new QFilter("goods", "in", productIds);
        qFilter.and(new QFilter("goods.status", "!=", (Object)BillStatusEnum.AUDIT.getVal()));
        DynamicObject[] prodPools = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)"goods", (QFilter[])qFilter.toArray());
        if (prodPools.length == 0) {
            return;
        }
        for (DynamicObject prodPool : prodPools) {
            prodPool.set("goods", null);
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodPools);
    }

    private void prodPoolSoldOp(DynamicObject[] dynamicObjects) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"sold", (String)"pmm_prodpool", (DynamicObject[])dynamicObjects, (OperateOption)option));
    }

    private void auditProd(Set<Long> prodIdSet) {
        QFilter prodQFilter = new QFilter("id", "in", prodIdSet);
        prodQFilter.and(new QFilter("status", "!=", (Object)BillStatusEnum.AUDIT.getVal()));
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,status", (QFilter[])prodQFilter.toArray());
        if (!prods.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            HashSet<Long> prodIds = new HashSet<Long>(prods.size());
            HashSet<Long> submitProdIds = new HashSet<Long>(prods.size());
            prods.forEach(prod -> prodIds.add(prod.getLong("id")));
            for (DynamicObject prod2 : prods) {
                String status = prod2.getString("status");
                if (BillStatusEnum.SAVE.getVal().equals(status)) {
                    submitProdIds.add(prod2.getLong("id"));
                }
                prodIds.add(prod2.getLong("id"));
            }
            if (!submitProdIds.isEmpty()) {
                CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"submit", (String)"pmm_prodmanage", (Object[])submitProdIds.toArray(), (OperateOption)option));
            }
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"audit", (String)"pmm_prodmanage", (Object[])prodIds.toArray(), (OperateOption)option));
        }
    }

    private String getProperties() {
        return "pricetype,id,goods,taxprice,taxrateid,taxrate,unit,price,effectstatus,priceeffectdate,priceinvaliddate,auditorg,minorderqty,leadtime,salestatus,isgoodvisible,entryentity.orgname,mallstatus,protocol,priceentry.qtyfrom,priceentry.qtyto,priceentry.ladprice,protocolentry";
    }
}

