/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.malcore.domain.LadderPriceInfo;
import kd.scm.malcore.domain.MalProdPool;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.pmm.business.service.ProdPoolQueryService;

public class ProdPoolQueryServiceImpl
implements ProdPoolQueryService {
    private static final Log log = LogFactory.getLog(ProdPoolQueryServiceImpl.class);

    @Override
    public Map<Long, Map<String, Object>> getProdPoolPriceMap(List<Long> goodsIds, long orgId) {
        ArrayList<Long> goodsIdClone = new ArrayList<Long>(goodsIds.size());
        goodsIds.forEach(goodsId -> goodsIdClone.add((Long)goodsId));
        HashMap<Long, Map<String, Object>> prodPoolPriceMap = new HashMap<Long, Map<String, Object>>(goodsIds.size());
        this.getSoldProdPoolPriceInfo(goodsIdClone, prodPoolPriceMap, orgId);
        this.getSoldOutProdPrice(goodsIdClone, prodPoolPriceMap);
        log.info("prodPoolPriceMap=" + SerializationUtils.toJsonString(prodPoolPriceMap));
        return prodPoolPriceMap;
    }

    @Override
    public Map<Long, Map<String, Object>> getProdPoolPriceMap(List<MalProdPool> goodsInfos) {
        ArrayList<Long> goodsIdClone = new ArrayList<Long>(goodsInfos.size());
        goodsInfos.forEach(info -> goodsIdClone.add(info.getGoodsId()));
        long orgId = goodsInfos.get(0).getOrgId();
        HashMap<Long, Map<String, Object>> prodPoolPriceMap = new HashMap<Long, Map<String, Object>>(goodsInfos.size());
        this.getSoldProdPoolPriceInfo(goodsIdClone, prodPoolPriceMap, orgId);
        this.getSoldOutProdPrice(goodsIdClone, prodPoolPriceMap);
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        if (Boolean.parseBoolean(param)) {
            Map<String, Object> ladderPriceAll = this.getLadderPriceAll(goodsInfos, orgId);
            Map ladderPriceMap = (Map)ladderPriceAll.get("goodsId_priceMap");
            Map ladderPriceRange = (Map)ladderPriceAll.get("ladderPriceRange");
            Map goodsId_LadPriceColMap = (Map)ladderPriceAll.get("ladderPriceCol");
            BigDecimal oneHundred = new BigDecimal("100.0");
            BigDecimal one = new BigDecimal("1");
            for (Map.Entry map : prodPoolPriceMap.entrySet()) {
                Long goodsId = (Long)map.getKey();
                Map priceMap = (Map)map.getValue();
                if (null == ladderPriceMap.get(goodsId)) continue;
                BigDecimal ladderPrice = (BigDecimal)ladderPriceMap.get(goodsId);
                BigDecimal taxRate = new BigDecimal(String.valueOf(priceMap.get("taxrate")));
                priceMap.put("taxprice", ladderPrice);
                priceMap.put("shopprice", ladderPrice);
                if (null == priceMap.get("taxrate") || taxRate.compareTo(BigDecimal.ZERO) == 0) {
                    priceMap.put("price", ladderPrice);
                } else {
                    taxRate = taxRate.divide(oneHundred, 2, 4);
                    BigDecimal price = ladderPrice.multiply(one.subtract(taxRate));
                    priceMap.put("price", price);
                }
                priceMap.put("ladderPriceRange", ladderPriceRange.get(goodsId));
                priceMap.put("ladderPriceCol", goodsId_LadPriceColMap.get(goodsId));
            }
        }
        log.info("prodPoolPriceMap=" + SerializationUtils.toJsonString(prodPoolPriceMap));
        return prodPoolPriceMap;
    }

    private Map<String, Object> getLadderPriceAll(List<MalProdPool> goodsInfos, long orgId) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(1024);
        HashMap<Long, BigDecimal> goodsId_QtyMap = new HashMap<Long, BigDecimal>(1024);
        HashMap<Long, BigDecimal> goodsId_priceMap = new HashMap<Long, BigDecimal>(1024);
        LinkedHashMap rangeMap = new LinkedHashMap(32);
        HashMap goodsId_LadPriceColMap = new HashMap(1024);
        HashMap ladderPriceRange = new HashMap(32);
        for (MalProdPool pool2 : goodsInfos) {
            goodsId_QtyMap.put(pool2.getGoodsId(), pool2.getQty());
        }
        QFilter qFilter = this.getProdPoolQFilter(new ArrayList<Long>(goodsId_QtyMap.keySet()), orgId);
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"taxprice,goods.curr,goods,priceentry.qtyfrom,priceentry.qtyto,priceentry.ladprice", (QFilter[])qFilter.toArray(), (String)"priceentry.qtyfrom asc");
        HashMap good_PoolsMap = new HashMap(1024);
        for (int i = 0; i < prodPools.size(); ++i) {
            DynamicObject prod = (DynamicObject)prodPools.get(i);
            long id = prod.getLong("goods");
            List<Object> pools = new ArrayList<DynamicObject>(1024);
            if (null != good_PoolsMap.get(id)) {
                pools = (List)good_PoolsMap.get(id);
            }
            pools.add(prod);
            good_PoolsMap.put(id, pools);
        }
        for (Map.Entry map : good_PoolsMap.entrySet()) {
            List pools;
            ArrayList ladderPriceInfos = new ArrayList(1024);
            Long goodsId = (Long)map.getKey();
            BigDecimal qty = BigDecimal.ZERO;
            if (null != goodsId_QtyMap.get(goodsId)) {
                qty = (BigDecimal)goodsId_QtyMap.get(goodsId);
            }
            if ((pools = (List)map.getValue()).size() < 2) continue;
            for (DynamicObject pool3 : pools) {
                BigDecimal qtyfrom = pool3.getBigDecimal("priceentry.qtyfrom");
                BigDecimal qtyto = pool3.getBigDecimal("priceentry.qtyto");
                BigDecimal ladprice = pool3.getBigDecimal("priceentry.ladprice");
                if (qty.compareTo(qtyfrom) < 0 || qty.compareTo(qtyto) >= 0 && qtyto.compareTo(BigDecimal.ZERO) != 0) continue;
                goodsId_priceMap.put(goodsId, ladprice);
                break;
            }
            if (null == goodsId_priceMap.get(goodsId)) {
                goodsId_priceMap.put(goodsId, ((DynamicObject)pools.get(0)).getBigDecimal("taxprice"));
            }
            pools.forEach(pool -> {
                rangeMap.put(pool.getBigDecimal("priceentry.qtyfrom"), pool.getBigDecimal("priceentry.ladprice"));
                ladderPriceInfos.add(new LadderPriceInfo(pool.getBigDecimal("priceentry.qtyfrom"), pool.getBigDecimal("priceentry.qtyto"), pool.getBigDecimal("priceentry.ladprice"), Long.valueOf(pool.getLong("goods.curr"))));
            });
            ladderPriceRange.put(goodsId, rangeMap);
            List newLadderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
            goodsId_LadPriceColMap.put(goodsId, newLadderPriceInfos);
        }
        resMap.put("goodsId_priceMap", goodsId_priceMap);
        resMap.put("ladderPriceRange", ladderPriceRange);
        resMap.put("ladderPriceCol", goodsId_LadPriceColMap);
        return resMap;
    }

    private Map<Long, BigDecimal> getLadderPrice(List<MalProdPool> goodsInfos, long orgId) {
        return (Map)this.getLadderPriceAll(goodsInfos, orgId).get("goodsId_priceMap");
    }

    private Map<Long, Map<BigDecimal, BigDecimal>> getLadderPriceRange(List<MalProdPool> goodsInfos, long orgId) {
        return (Map)this.getLadderPriceAll(goodsInfos, orgId).get("ladderPriceRange");
    }

    private void getSoldProdPoolPriceInfo(List<Long> goodsIds, Map<Long, Map<String, Object>> prodPoolPriceMap, long orgId) {
        QFilter qFilter = this.getProdPoolQFilter(goodsIds, orgId);
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id,goods,protocol,taxprice,taxrateid,taxrateid.taxrate,taxrate,price,unit", (QFilter[])qFilter.toArray());
        for (DynamicObject prodPool : prodPools) {
            HashMap<String, Number> priceInfo = new HashMap<String, Number>(8);
            priceInfo.put("taxprice", prodPool.getBigDecimal("taxprice"));
            priceInfo.put("taxrateid", prodPool.getLong("taxrateid"));
            priceInfo.put("taxrateid.taxrate", prodPool.getBigDecimal("taxrateid.taxrate"));
            priceInfo.put("taxrate", prodPool.getBigDecimal("taxrate"));
            priceInfo.put("price", prodPool.getBigDecimal("price"));
            priceInfo.put("unit", prodPool.getLong("unit"));
            priceInfo.put("shopprice", prodPool.getBigDecimal("taxprice"));
            prodPoolPriceMap.put(prodPool.getLong("goods"), priceInfo);
            goodsIds.remove(prodPool.getLong("goods"));
        }
    }

    private QFilter getProdPoolQFilter(List<Long> goodsIds, long orgId) {
        if (orgId == 0L) {
            orgId = RequestContext.get().getOrgId();
        }
        QFilter qFilter = new QFilter("goods", "in", goodsIds);
        QFilter orgQFilter = new QFilter("isgoodvisible", "=", (Object)Boolean.TRUE).or(new QFilter("isgoodvisible", "=", (Object)Boolean.FALSE).and(new QFilter("entryentity.orgname", "=", (Object)orgId)));
        qFilter.and(orgQFilter);
        qFilter.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()));
        return qFilter;
    }

    private void getSoldOutProdPrice(List<Long> goodsIds, Map<Long, Map<String, Object>> prodPoolPriceMap) {
        QFilter qFilter = new QFilter("id", "in", goodsIds);
        qFilter.and("source", "=", (Object)"1");
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,taxprice,taxrateid,taxrateid.taxrate,taxrate,price,unit,shopprice", (QFilter[])qFilter.toArray());
        for (DynamicObject prod : prods) {
            HashMap<String, Number> priceInfo = new HashMap<String, Number>(8);
            priceInfo.put("taxprice", prod.getBigDecimal("taxprice"));
            priceInfo.put("taxrateid", prod.getLong("taxrateid"));
            priceInfo.put("taxrateid.taxrate", prod.getBigDecimal("taxrateid.taxrate"));
            priceInfo.put("taxrate", prod.getBigDecimal("taxrate"));
            priceInfo.put("price", prod.getBigDecimal("price"));
            priceInfo.put("unit", prod.getLong("unit"));
            priceInfo.put("shopprice", prod.getBigDecimal("shopprice"));
            prodPoolPriceMap.put(prod.getLong("id"), priceInfo);
        }
    }
}

