/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl.rule;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.DateUtil;
import kd.sdk.scm.pmm.extpoint.IOperateMonitorRuleService;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceParam;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceResult;

public class EcGoodsOverLastUpRateRuleServiceImpl
implements IOperateMonitorRuleService {
    public MonitorRuleServiceResult isMatchMonitorRule(MonitorRuleServiceParam param, BigDecimal val) {
        MonitorRuleServiceResult result = new MonitorRuleServiceResult();
        result.setMatch(Boolean.FALSE.booleanValue());
        if (null == param || EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(param.getPlatform())) {
            result.setMatch(Boolean.FALSE.booleanValue());
            return result;
        }
        if (null == val) {
            result.setMatch(Boolean.FALSE.booleanValue());
            return result;
        }
        List priceLogList = param.getPriceLogList();
        if (null != priceLogList && priceLogList.size() > 0) {
            priceLogList.sort((m1, m2) -> {
                Object srcAdjustdate = m1.get("adjustdate");
                Object tarAdjustdate = m2.get("adjustdate");
                if (null != srcAdjustdate && null != tarAdjustdate) {
                    Date tarDate;
                    Date srcDate = DateUtil.string2date((String)String.valueOf(srcAdjustdate), (String)"yyyy-MM-dd HH:mm:ss");
                    if (srcDate.after(tarDate = DateUtil.string2date((String)String.valueOf(tarAdjustdate), (String)"yyyy-MM-dd HH:mm:ss"))) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            });
            BigDecimal fristPrice = BigDecimal.ZERO;
            BigDecimal taxprice = BigDecimal.ZERO;
            Map priceLogMap = (Map)priceLogList.get(priceLogList.size() - 1);
            if (null != priceLogMap.get("lastprice")) {
                fristPrice = new BigDecimal(String.valueOf(priceLogMap.get("lastprice")));
            }
            if (null != priceLogMap.get("taxprice")) {
                taxprice = new BigDecimal(String.valueOf(priceLogMap.get("taxprice")));
            }
            this.dealResult(param, result, fristPrice, taxprice, val);
        } else {
            QFilter qFilter = new QFilter("mallgoods.id", "=", (Object)param.getGoodsId());
            DynamicObjectCollection malGoodsPriceLogs = QueryServiceHelper.query((String)"pbd_mallgoods_pricelog", (String)"mallgoods.priceinfo.price,price", (QFilter[])qFilter.toArray(), (String)"modifytime asc");
            if (malGoodsPriceLogs.size() > 0) {
                BigDecimal fristPrice = BigDecimal.ZERO;
                BigDecimal taxprice = ((DynamicObject)malGoodsPriceLogs.get(0)).getBigDecimal("mallgoods.priceinfo.price");
                for (DynamicObject row : malGoodsPriceLogs) {
                    fristPrice = row.getBigDecimal("price");
                }
                this.dealResult(param, result, fristPrice, taxprice, val);
            }
        }
        return result;
    }

    private void dealResult(MonitorRuleServiceParam param, MonitorRuleServiceResult result, BigDecimal fristPrice, BigDecimal taxprice, BigDecimal val) {
        BigDecimal divide;
        if (fristPrice.compareTo(BigDecimal.ZERO) > 0 && (divide = taxprice.subtract(fristPrice).divide(fristPrice, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2)).compareTo(val) > 0) {
            result.setMatch(Boolean.TRUE.booleanValue());
            result.setCompareObjId(param.getGoodsId());
            result.setCompareValue(fristPrice);
            result.setActualVal(divide + "%");
            result.setCompareSource("pbd_mallgoods");
        }
    }
}

