/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl.rule;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.es.storage.EsResultVo;
import kd.scm.malcore.domain.GoodsSameRule;
import kd.scm.pmm.business.service.PmmGoodsSameRuleService;
import kd.sdk.scm.pmm.extpoint.IOperateMonitorRuleService;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceParam;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceResult;

public class GoodsSameKindLowerPriceRuleServiceImpl
implements IOperateMonitorRuleService {
    public MonitorRuleServiceResult isMatchMonitorRule(MonitorRuleServiceParam param, BigDecimal val) {
        MonitorRuleServiceResult result = new MonitorRuleServiceResult();
        result.setMatch(Boolean.FALSE.booleanValue());
        if (null == val || val.compareTo(BigDecimal.ZERO) == 0) {
            return result;
        }
        Map sameGoodsMap = param.getSameGoodsMap();
        if (null != sameGoodsMap && sameGoodsMap.size() > 0) {
            this.dealResult(param, result, sameGoodsMap, val);
        } else {
            PmmGoodsSameRuleService service = new PmmGoodsSameRuleService();
            GoodsSameRule goodsSameRule = service.getSameGoodsRuleEsFilterByGoodsId(param.getGoodsId(), param.getPlatform());
            if (null != goodsSameRule.getEsFilterFields() && goodsSameRule.getEsFilterFields().size() > 0) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                paramMap.put("esFilterFields", goodsSameRule.getEsFilterFields());
                paramMap.put("sort", "price_true");
                paramMap.put("pageSize", 1);
                EsResultVo esResultVo = (EsResultVo)DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"IMalSearchService", (String)"search", (Object[])new Object[]{paramMap});
                if (null != esResultVo && esResultVo.getResultData().size() > 0) {
                    Map lowGoodsMap = (Map)esResultVo.getResultData().get(0);
                    this.dealResult(param, result, lowGoodsMap, val);
                }
            }
        }
        return result;
    }

    private void dealResult(MonitorRuleServiceParam param, MonitorRuleServiceResult result, Map<String, Object> sameGoodsMap, BigDecimal val) {
        BigDecimal sub;
        Object priceStr = sameGoodsMap.get("price");
        Object source = sameGoodsMap.get("source");
        String goodsType = "pbd_mallgoods";
        if (source.equals(EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
            goodsType = "pmm_prodmanage";
        }
        long goodsid = 0L;
        if (null != sameGoodsMap.get("goodsid")) {
            goodsid = Long.parseLong(String.valueOf(sameGoodsMap.get("goodsid")));
        }
        BigDecimal minPrice = BigDecimal.ZERO;
        if (null != priceStr) {
            minPrice = new BigDecimal(String.valueOf(priceStr));
        }
        if (minPrice.compareTo(BigDecimal.ZERO) == 0) {
            result.setMatch(Boolean.TRUE.booleanValue());
            result.setCompareObjId(goodsid);
            result.setCompareValue(minPrice);
            result.setCompareSource(goodsType);
            return;
        }
        BigDecimal taxprice = param.getTaxPrice();
        if (null != taxprice && (sub = taxprice.subtract(minPrice)).compareTo(val) > 0) {
            result.setMatch(Boolean.TRUE.booleanValue());
            result.setCompareObjId(goodsid);
            result.setCompareValue(minPrice);
            result.setActualVal(String.valueOf(sub));
            result.setCompareSource(goodsType);
        }
    }
}

