/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.pmm.business.model.protocol.ProtocolInfo;

public class PmmProtocolValidatorService {
    private String KEY_ALL = "A";
    private String KEY_PART = "B";
    private String KEY_AREA = "C";

    public String getKEY_ALL() {
        return this.KEY_ALL;
    }

    public String getKEY_PART() {
        return this.KEY_PART;
    }

    public String getKEY_AREA() {
        return this.KEY_AREA;
    }

    public ArrayList<ProtocolInfo> getProtocolList(QFilter qFilter) {
        return this.getProtocolInfoList(qFilter);
    }

    private ArrayList<ProtocolInfo> getProtocolInfoList(QFilter qFilter) {
        ArrayList<ProtocolInfo> protocolInfoList = new ArrayList<ProtocolInfo>(1024);
        String selector = "differentarea,id,effectdate,billno,invaliddate,entryentity.orgname,entryentity.orgname.name,partyb.id,purmode";
        DynamicObjectCollection entryCol = QueryServiceHelper.query((String)"pmm_protocol", (String)selector, (QFilter[])qFilter.toArray());
        HashMap<Long, ArrayList> orgIdMap = new HashMap<Long, ArrayList>(1024);
        HashMap protocol_orgIdNameMap = new HashMap(1024);
        HashMap<Long, ProtocolInfo> protocolInfoMap = new HashMap<Long, ProtocolInfo>(1024);
        for (DynamicObject row : entryCol) {
            Long protocolId = row.getLong("id");
            if (null == protocolInfoMap.get(row.getLong("id"))) {
                ProtocolInfo info = new ProtocolInfo();
                info.setProtocolBillNo(row.getString("billno"));
                info.setProtocolID(row.getLong("id"));
                if (null != row.getDate("effectdate")) {
                    info.setEffectdate(row.getDate("effectdate"));
                }
                if (null != row.getDate("invaliddate")) {
                    info.setInvaliddate(DateUtil.string2date((String)DateUtil.getFormatEndDate((Date)row.getDate("invaliddate")), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                info.setSupplierId(row.getLong("partyb.id"));
                info.setPurmode(row.getString("purmode"));
                info.setDifferentAreaEntry(row.getString("differentarea"));
                protocolInfoList.add(info);
                protocolInfoMap.put(protocolId, info);
            }
            ArrayList orgIds = new ArrayList(1024);
            if (null != orgIdMap.get(protocolId)) {
                orgIds = (ArrayList)orgIdMap.get(protocolId);
            }
            orgIds.add(row.getLong("entryentity.orgname"));
            orgIdMap.put(protocolId, orgIds);
            Map<Long, String> orgId_NameMap = new HashMap<Long, String>(1024);
            if (null != protocol_orgIdNameMap.get(protocolId)) {
                orgId_NameMap = (Map)protocol_orgIdNameMap.get(protocolId);
            }
            orgId_NameMap.put(row.getLong("entryentity.orgname"), row.getString("entryentity.orgname.name"));
            protocol_orgIdNameMap.put(protocolId, orgId_NameMap);
        }
        HashMap<Long, ArrayList> materialIdMap = new HashMap<Long, ArrayList>(1024);
        HashMap<Long, ArrayList> orgId_materialIdsMap = new HashMap<Long, ArrayList>(1024);
        HashMap purPlanId_materialIdsMap = new HashMap(1024);
        HashMap purPlanId_orgmaterialIdsMap = new HashMap(1024);
        selector = "id,entryentity1.material,entryentity1.material.number,entryentity1.purorg.id,entryentity1.purorg.name,entryentity1.purplanid";
        DynamicObjectCollection entryMaterialCol = QueryServiceHelper.query((String)"pmm_protocol", (String)selector, (QFilter[])qFilter.toArray());
        for (DynamicObject row : entryMaterialCol) {
            if (0L == row.getLong("entryentity1.material")) continue;
            ArrayList materialds = new ArrayList(1024);
            if (null != materialIdMap.get(row.getLong("id"))) {
                materialds = (ArrayList)materialIdMap.get(row.getLong("id"));
            }
            materialds.add(row.getLong("entryentity1.material"));
            materialIdMap.put(row.getLong("id"), materialds);
            ArrayList orgId_materialIds = new ArrayList(1024);
            if (null != orgId_materialIdsMap.get(row.getLong("id"))) {
                orgId_materialIds = (ArrayList)orgId_materialIdsMap.get(row.getLong("id"));
            }
            Map orgMaterialIdsMap = new HashMap(1024);
            if (null != purPlanId_materialIdsMap.get(row.getLong("id"))) {
                orgMaterialIdsMap = (Map)purPlanId_orgmaterialIdsMap.get(row.getLong("id"));
                List<String> orgMaterialIds = new ArrayList<String>(1024);
                if (null != orgMaterialIdsMap.get(row.getLong("entryentity1.purplanid"))) {
                    orgMaterialIds = (List)orgMaterialIdsMap.get(row.getLong("entryentity1.purplanid"));
                }
                orgMaterialIds.add(row.getString("entryentity1.purorg.id") + "_" + row.getString("entryentity1.material"));
                orgMaterialIdsMap.put(row.getLong("entryentity1.purplanid"), orgMaterialIds);
            }
            purPlanId_orgmaterialIdsMap.put(row.getLong("id"), orgMaterialIdsMap);
            Map materialIdsMap = new HashMap(1024);
            if (null != purPlanId_materialIdsMap.get(row.getLong("id"))) {
                materialIdsMap = (Map)purPlanId_materialIdsMap.get(row.getLong("id"));
                List<Long> materialIds = new ArrayList<Long>(1024);
                if (null != materialIdsMap.get(row.getLong("entryentity1.purplanid"))) {
                    materialIds = (List)materialIdsMap.get(row.getLong("entryentity1.purplanid"));
                }
                materialIds.add(row.getLong("entryentity1.material"));
                materialIdsMap.put(row.getLong("entryentity1.purplanid"), materialIds);
            }
            purPlanId_materialIdsMap.put(row.getLong("id"), materialIdsMap);
            orgId_materialIds.add(row.getString("entryentity1.purorg.id") + "_" + row.getString("entryentity1.material"));
            orgId_materialIdsMap.put(row.getLong("id"), orgId_materialIds);
            if (row.getLong("entryentity1.purorg.id") != 0L) {
                Map<Long, String> orgId_NameMap = new HashMap<Long, String>(1024);
                if (null != protocol_orgIdNameMap.get(row.getLong("id"))) {
                    orgId_NameMap = (Map)protocol_orgIdNameMap.get(row.getLong("id"));
                }
                orgId_NameMap.put(row.getLong("entryentity1.purorg.id"), row.getString("entryentity1.purorg.name"));
                protocol_orgIdNameMap.put(row.getLong("id"), orgId_NameMap);
            }
            Map<Long, String> materialId_NameMap = new HashMap<Long, String>(1024);
            if (null != protocol_orgIdNameMap.get(row.getLong("id"))) {
                materialId_NameMap = (Map)protocol_orgIdNameMap.get(row.getLong("id"));
            }
            materialId_NameMap.put(row.getLong("entryentity1.material"), row.getString("entryentity1.material.number"));
            protocol_orgIdNameMap.put(row.getLong("id"), materialId_NameMap);
        }
        for (ProtocolInfo info : protocolInfoList) {
            info.setOrgIds((List)orgIdMap.get(info.getProtocolID()));
            info.setMaterialIds((List)materialIdMap.get(info.getProtocolID()));
            info.setOrgId_materialIds((List)orgId_materialIdsMap.get(info.getProtocolID()));
            info.setOrgId_orgNameMap((Map)protocol_orgIdNameMap.get(info.getProtocolID()));
            info.setPurPlanId_MaterialIdsMap((Map)purPlanId_materialIdsMap.get(info.getProtocolID()));
            info.setPurPlanId_orgId_materialIdsMap((Map)purPlanId_orgmaterialIdsMap.get(info.getProtocolID()));
            info.setMaterialId_materialNumberMap((Map)protocol_orgIdNameMap.get(info.getProtocolID()));
        }
        return protocolInfoList;
    }

    public ArrayList<ProtocolInfo> getProtocolList(Set<Long> supIdSet) {
        QFilter qFilter = new QFilter("partyb", "in", supIdSet);
        QFilter protocolQFilter = new QFilter("protocolstatus", "=", (Object)"A");
        protocolQFilter.or(new QFilter("protocolstatus", "=", (Object)"B"));
        protocolQFilter.or(new QFilter("protocolstatus", "=", (Object)" "));
        qFilter.and(protocolQFilter);
        qFilter.and(new QFilter("effectdate", "is not null", null));
        qFilter.and(new QFilter("invaliddate", "is not null", null));
        qFilter.and(new QFilter("confirmstatus", "!=", (Object)"D"));
        return this.getProtocolList(qFilter);
    }

    public ArrayList<ProtocolInfo> filterProtocol(ArrayList<ProtocolInfo> protocolInfos, DynamicObject dynamicObject) {
        ArrayList<ProtocolInfo> protocols = new ArrayList<ProtocolInfo>(1024);
        if (null == protocolInfos || protocolInfos.size() == 0) {
            return protocols;
        }
        Date effectdate = dynamicObject.getDate("effectdate");
        Date invaliddate = dynamicObject.getDate("invaliddate");
        Long partyb = dynamicObject.getLong("partyb_id");
        String billno = dynamicObject.getString("billno");
        for (ProtocolInfo info : protocolInfos) {
            if (info.getProtocolBillNo().equals(billno) || null == effectdate || null == invaliddate || !info.getSupplierId().equals(partyb) || null != info.getInvaliddate() && effectdate.after(info.getInvaliddate()) || null != invaliddate && invaliddate.before(info.getEffectdate())) continue;
            protocols.add(info);
        }
        return protocols;
    }

    public Map<String, ArrayList<ProtocolInfo>> getProtocolGroupInfosByPurMode(List<ProtocolInfo> protocolInfoList) {
        HashMap<String, ArrayList<ProtocolInfo>> protocolGroupInfos = new HashMap<String, ArrayList<ProtocolInfo>>(1024);
        for (ProtocolInfo info : protocolInfoList) {
            ArrayList protocolInfos = new ArrayList(1024);
            String key = "";
            key = info.getPurmode().equals("1") ? this.KEY_ALL : (info.getPurmode().equals("2") && Boolean.parseBoolean(info.getDifferentAreaEntry()) ? this.KEY_AREA : this.KEY_PART);
            if (null != protocolGroupInfos.get(key)) {
                protocolInfos = (ArrayList)protocolGroupInfos.get(key);
            }
            protocolInfos.add(info);
            protocolGroupInfos.put(key, protocolInfos);
        }
        return protocolGroupInfos;
    }
}

