/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.malcore.domain.GoodsPriceHistoryRecord;
import kd.scm.pmm.business.model.prodpool.LadderPrice;
import kd.scm.pmm.business.service.impl.PmmGoodsPriceServiceImpl;

public class PmmPriceAuditcfm
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(PmmPriceAuditcfm.class);
    private static final String KEY_CONFIRM = "confirm";
    private static final String BILLSTATUS = "billstatus";
    private static final String SUPPLIERNAME = "suppliername";
    private static final String SUPPLIERID = "supplierid";
    private static final String BIZTYPE = "biztype";
    private static final String RESULT = "result";
    private static final String NAME = "name";
    private static final String BILLID = "billid";
    private static final String CFMSTATUS = "cfmstatus";
    private static final String CONFIRMEND = "confirmend";
    private static final String SHOPPRICE = "shopprice";
    private static final String ENTRYENTITY = "entryentity";
    private static final String GOODS = "goods";
    private static final String BILLIDLIST = "billidlist";
    private static final String MODE = "mode";
    private static final String SOURCE_SHARING = "1";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.getModel().setValue("auditor", (Object)RequestContext.get().getUserId());
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String selectcol = (String)showParameter.getCustomParam(BILLIDLIST);
        String auditMode = (String)showParameter.getCustomParam(MODE);
        if (null != auditMode && auditMode.equalsIgnoreCase("batch")) {
            IPageCache cache = this.getPageCache();
            cache.put("select", selectcol);
            log.info("$$$$82" + this.getPageCache().get("select"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        ArrayList allBillid = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
        ArrayList billIds = new ArrayList();
        allBillid.forEach(id -> billIds.add(Long.valueOf(id)));
        StringBuilder sb = new StringBuilder();
        QFilter filter = new QFilter("id", "in", billIds);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"pmm_priceaudit", (String)"id,org,billno,cfmstatus", (QFilter[])filters);
        for (DynamicObject obj : objs) {
            String cfmstatus = obj.getString(CFMSTATUS);
            if ("A".equals(cfmstatus)) continue;
            String msg = ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u53f7\u7b49\u4e8e{0}\u7684\u8c03\u4ef7\u7533\u8bf7\u5355\u4e0d\u662f\u5f85\u5ba1\u6279\u7684\u72b6\u6001\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002", (String)"PmmPriceAuditcfm_0", (String)"scm-pmm-formplugin", (Object[])new Object[]{obj.getString("billno")});
            sb.append(msg).append('\n');
            this.getView().showMessage(String.valueOf(sb));
            return;
        }
        switch (operateKey) {
            case "confirm": {
                this.confirm();
                break;
            }
        }
    }

    private void confirm() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Date currDate = TimeServiceHelper.now();
        this.updatePrice(model, view, currDate);
        view.close();
    }

    private void updatePrice(IDataModel model, IFormView view, Date currDate) {
        OperationResult submitResult;
        HashMap<String, DynamicObject> prodAuditMap = new HashMap<String, DynamicObject>();
        ArrayList<Long> prodPoolList = new ArrayList<Long>();
        HashMap<Long, DynamicObject> prodIdAndEntryMap = new HashMap<Long, DynamicObject>();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String selectcol = (String)showParameter.getCustomParam(BILLIDLIST);
        log.info("$$$$225" + selectcol);
        ArrayList allBillid = StringConversionUtil.conversion((String)selectcol);
        log.info("$$$$227" + this.getPageCache().get("select"));
        ArrayList billIds = new ArrayList();
        allBillid.forEach(id -> billIds.add(Long.valueOf(id)));
        QFilter billidFilter = new QFilter("id", "in", billIds);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmm_priceaudit", (String)"creator,createtime,origin,id,billno,org,cfmdate,billstatus,suggestion,cfmstatus,cfmdate,cfm,entryentity.goods,entryentity.note,entryentity.class,entryentity.shopprice,entryentity.taxprice,entryentity.price,entryentity.taxrate,entryentity.taxrateid,entryentity.prodpool,entryentity.prodpool.protocol,entryentity.prodpool.protocolentry,entryentity.unit,entryentity.taxprice_old", (QFilter[])new QFilter[]{billidFilter});
        HashSet<String> prodNumbers = new HashSet<String>(bills.length);
        ArrayList<GoodsPriceHistoryRecord> goodsPriceHistoryRecords = new ArrayList<GoodsPriceHistoryRecord>(16);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(ENTRYENTITY);
            bill.set("suggestion", model.getValue("opinion"));
            bill.set("cfm", (Object)RequestContext.get().getUserId());
            bill.set("cfmdate", (Object)currDate);
            bill.set(CFMSTATUS, model.getValue(RESULT));
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                DynamicObject goods = entry.getDynamicObject(GOODS);
                DynamicObject prodpool = entry.getDynamicObject("prodpool");
                prodPoolList.add(prodpool.getLong("id"));
                prodAuditMap.put(prodpool.getString("id"), entry);
                prodIdAndEntryMap.put(goods.getLong("id"), entry);
                prodNumbers.add(goods.getString("number"));
                GoodsPriceHistoryRecord goodsPriceHistoryRecord = new GoodsPriceHistoryRecord();
                goodsPriceHistoryRecord.setLastPrice(entry.getBigDecimal("taxprice_old"));
                goodsPriceHistoryRecord.setGoodsId(goods.getLong("id"));
                goodsPriceHistoryRecord.setGoodsId(goods.getLong("id"));
                goodsPriceHistoryRecord.setGoodsPoolId(prodpool.getLong("id"));
                goodsPriceHistoryRecord.setProtocolId(prodpool.getLong("protocol.id"));
                goodsPriceHistoryRecord.setProtocolEntryId(prodpool.getLong("protocolentry.id"));
                goodsPriceHistoryRecord.setAuditorg(bill.getLong("org.id"));
                goodsPriceHistoryRecord.setAdjustdate(bill.getDate("cfmdate"));
                goodsPriceHistoryRecord.setNote(entry.getString("note"));
                goodsPriceHistoryRecord.setSrcBillType("pmm_priceaudit");
                goodsPriceHistoryRecord.setSrcBillNo(bill.getString("billno"));
                goodsPriceHistoryRecord.setSrcBillId(bill.getString("id"));
                goodsPriceHistoryRecord.setOrigin(bill.getString("origin"));
                goodsPriceHistoryRecord.setCreateDate(bill.getDate("createtime"));
                goodsPriceHistoryRecord.setCreatorId(bill.getLong("creator.id"));
                goodsPriceHistoryRecord.setAuditDate(bill.getDate("cfmdate"));
                goodsPriceHistoryRecord.setAuditorId(bill.getLong("cfm"));
                goodsPriceHistoryRecords.add(goodsPriceHistoryRecord);
            }
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        if ("B".equals(String.valueOf(model.getValue(RESULT))) && this.checkHasSameNumber(prodNumbers)) {
            return;
        }
        if ("B".equals(String.valueOf(model.getValue(RESULT)))) {
            QFilter qFilter = new QFilter("id", "in", billIds);
            DynamicObjectCollection pricerequests = QueryServiceHelper.query((String)"ent_pricerequest", (String)"entryentity.prodpool,entryentity.subentryentity.qtyfrom qtyfrom,entryentity.subentryentity.qtyto qtyto,entryentity.subentryentity.ladprice ladprice", (QFilter[])qFilter.toArray());
            HashMap pool_pricesMap = new HashMap(1024);
            for (DynamicObject row : pricerequests) {
                Long id2 = row.getLong("entryentity.prodpool");
                List<LadderPrice> price = new ArrayList(1024);
                if (null != pool_pricesMap.get(id2)) {
                    price = (List)pool_pricesMap.get(id2);
                }
                LadderPrice ladderPrice = new LadderPrice();
                BigDecimal qtyfrom = row.getBigDecimal("qtyfrom");
                BigDecimal qtyto = row.getBigDecimal("qtyto");
                if (null != qtyfrom && qtyfrom.compareTo(BigDecimal.ZERO) <= 0 && null != qtyto && qtyto.compareTo(BigDecimal.ZERO) <= 0) continue;
                ladderPrice.setLadprice(row.getBigDecimal("ladprice"));
                ladderPrice.setQtyfrom(row.getBigDecimal("qtyfrom"));
                ladderPrice.setQtyto(row.getBigDecimal("qtyto"));
                price.add(ladderPrice);
                pool_pricesMap.put(id2, price);
            }
            String selectFields = "pricetype,id,taxprice,taxrateid,taxrate,price,unit,salestatus,isgoodvisible,entryentity.orgname,mallstatus,protocol,priceentry.qtyfrom,priceentry.qtyto,priceentry.ladprice";
            QFilter fileter = new QFilter("id", "in", prodPoolList);
            QFilter[] filters = new QFilter[]{fileter};
            DynamicObject[] prodPoolDynArray = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)selectFields, (QFilter[])filters);
            String prodSelectFields = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
            DynamicObject[] prodDynArray = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)prodSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", prodIdAndEntryMap.keySet())});
            if (prodPoolDynArray.length < 1) {
                view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u5546\u54c1\u3002", (String)"PmmPriceAuditcfm_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject prodPool : prodPoolDynArray) {
                String prodPoolId = prodPool.getString("id");
                prodPool.set("taxprice", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("taxprice"));
                prodPool.set("price", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("price"));
                prodPool.set("taxrate", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("taxrate"));
                prodPool.set("taxrateid", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("taxrateid"));
                prodPool.set("unit", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("unit"));
                DynamicObjectCollection priceentry = prodPool.getDynamicObjectCollection("priceentry");
                priceentry.clear();
                if (null != pool_pricesMap.get(Long.parseLong(prodPoolId))) {
                    List ladderPrices = (List)pool_pricesMap.get(Long.parseLong(prodPoolId));
                    if (ladderPrices.size() > 1) {
                        ladderPrices = ladderPrices.stream().sorted(Comparator.comparing(LadderPrice::getQtyfrom)).collect(Collectors.toList());
                        for (LadderPrice price : ladderPrices) {
                            DynamicObject priceEntry = priceentry.addNew();
                            priceEntry.set("qtyfrom", (Object)price.getQtyfrom());
                            priceEntry.set("qtyto", (Object)price.getQtyto());
                            priceEntry.set("ladprice", (Object)price.getLadprice());
                        }
                        prodPool.set("pricetype", (Object)"B");
                        continue;
                    }
                    prodPool.set("priceentry", (Object)priceentry);
                    prodPool.set("pricetype", (Object)"A");
                    continue;
                }
                prodPool.set("priceentry", (Object)priceentry);
                prodPool.set("pricetype", (Object)"A");
            }
            for (DynamicObject prod : prodDynArray) {
                prod.set("adjustdate", (Object)currDate);
                DynamicObject entry = (DynamicObject)prodIdAndEntryMap.get(prod.getLong("id"));
                if (entry.getDynamicObject("prodpool").getDynamicObject("protocol") != null) continue;
                prod.set("taxprice", entry.get("taxprice"));
                prod.set(SHOPPRICE, entry.get("taxprice"));
                prod.set("price", entry.get("price"));
                prod.set("taxrate", entry.get("taxrate"));
                prod.set("taxrateid", entry.get("taxrateid"));
                prod.set("unit", entry.get("unit"));
            }
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodmanage", (DynamicObject[])prodDynArray, (OperateOption)option));
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"soldpublish", (String)"pmm_prodpool", (DynamicObject[])prodPoolDynArray, (OperateOption)option));
        }
        if ((submitResult = SaveServiceHelper.saveOperate((String)"save", (String)"pmm_priceaudit", (DynamicObject[])bills, (OperateOption)option)).isSuccess()) {
            if ("D".equals(String.valueOf(model.getValue(RESULT)))) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"PmmPriceAuditcfm_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u5df2\u66f4\u65b0\u5546\u54c1\u4ef7\u683c\u3002", (String)"PmmPriceAuditcfm_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        }
        PmmGoodsPriceServiceImpl pmmGoodsPriceService = new PmmGoodsPriceServiceImpl();
        pmmGoodsPriceService.addGoodsPriceHistoryRecords(goodsPriceHistoryRecords);
    }

    private boolean checkHasSameNumber(Set<String> numbers) {
        QFilter qFilter = new QFilter("number", "in", numbers);
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number", (QFilter[])qFilter.toArray());
        HashSet<String> numberAccount = new HashSet<String>(prods.size());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject prod : prods) {
            if (numberAccount.contains(prod.getString("number"))) {
                String message = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5728\u5546\u54c1\u7ba1\u7406\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PmmPriceAuditcfm_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                if (MalOrderUtil.getDefaultMalVersion()) {
                    message = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5728\u5546\u54c1\u6c60\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PmmPriceAuditcfm_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                }
                sb.append(String.format(message, prod.getString("number")));
                continue;
            }
            numberAccount.add(prod.getString("number"));
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5ba1\u6279\u5931\u8d25", (String)"PmmPriceAuditcfm_8", (String)"scm-pmm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRMEND.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.confirm();
        }
    }
}

