/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.pmm.business.model.product.ProdMatMapping;
import kd.scm.pmm.business.service.impl.ProdMatMappingServiceImpl;
import kd.scm.pmm.business.service.impl.ProdPoolCommandServiceImpl;

public class PmmProdAuditcfm
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(PmmProdAuditcfm.class);
    private static final String KEY_CONFIRM = "confirm";
    private static final String CONFIRMEND = "confirmend";
    private static final String ENTRYENTITY = "entryentity";
    private static final String GOOD_CLASS = "class";
    private static final String BILLIDLIST = "billidlist";
    private static final String MODE = "mode";

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("auditor", (Object)RequestContext.get().getUserId());
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String selectcol = (String)showParameter.getCustomParam(BILLIDLIST);
        String auditMode = (String)showParameter.getCustomParam(MODE);
        String biztype = (String)showParameter.getCustomParam("biztype");
        if (null != auditMode && auditMode.equalsIgnoreCase("batch")) {
            IPageCache cache = this.getPageCache();
            cache.put("select", selectcol);
            this.getModel().setValue("biztype", (Object)biztype);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        ArrayList allBillid = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
        StringBuilder sb = new StringBuilder();
        ArrayList<Long> idList = new ArrayList<Long>(allBillid.size());
        for (String str : allBillid) {
            idList.add(Long.parseLong(str));
        }
        QFilter filter = new QFilter("id", "in", idList);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"pmm_prodaudit", (String)"id,org,billno,cfmstatus", (QFilter[])filters);
        for (DynamicObject obj : objs) {
            String cfmstatus = obj.getString("cfmstatus");
            if ("A".equals(cfmstatus)) continue;
            String msg = ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u53f7\u7b49\u4e8e{0}\u7684\u4e0a\u67b6\u7533\u8bf7\u5355\u4e0d\u662f\u5f85\u5ba1\u6279\u7684\u72b6\u6001\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002", (String)"PmmProdAuditcfm_0", (String)"scm-pmm-formplugin", (Object[])new Object[]{obj.getString("billno")});
            this.getView().showMessage(msg);
            return;
        }
        if (KEY_CONFIRM.equals(operateKey)) {
            this.confirm();
        }
    }

    private void confirm() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Date currDate = TimeServiceHelper.now();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String mode = (String)showParameter.getCustomParam(MODE);
        if (null != mode && mode.equalsIgnoreCase("batch")) {
            this.batchUpdateBillAndProd(model, view, currDate);
        }
        view.close();
    }

    private void batchUpdateBillAndProd(IDataModel model, IFormView view, Date currDate) {
        ArrayList<Long> prodList = new ArrayList<Long>();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map param = showParameter.getCustomParams();
        Map classMap = (Map)param.get(GOOD_CLASS);
        Map entryNoteMap = (Map)param.get("entryNote");
        ArrayList allBillid = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
        ArrayList<Long> idList = new ArrayList<Long>(allBillid.size());
        for (String str : allBillid) {
            idList.add(Long.parseLong(str));
        }
        QFilter billidFilter = new QFilter("id", "in", idList);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmm_prodaudit", (String)"id,billno,billstatus,cfmstatus,cfm,biztype,cfmdate,suggestion,entryentity.goods,entryentity.barcode,entryentity.material,entryentity.class,entryentity.shopprice,entryentity.taxprice,entryentity.price,entryentity.entryresult,entryentity.note", (QFilter[])new QFilter[]{billidFilter});
        ArrayList<Long> uploadProdList = new ArrayList<Long>();
        ArrayList<DynamicObject> uploadBills = new ArrayList<DynamicObject>(bills.length);
        StringBuilder logString = new StringBuilder();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(ENTRYENTITY);
            bill.set("suggestion", model.getValue("opinion"));
            bill.set("cfm", (Object)RequestContext.get().getUserId());
            bill.set("cfmdate", (Object)currDate);
            bill.set("cfmstatus", this.getModel().getValue("result"));
            String biztype = bill.getString("biztype");
            if ("1".equals(biztype)) {
                uploadBills.add(bill);
            }
            for (DynamicObject entry : entries) {
                logString.append("entryId:").append(entry.getPkValue()).append("\n");
                if (entry.getDynamicObject("goods") == null) {
                    logString.append("goods:").append("null").append("\n");
                    if (!"D".equals(this.getModel().getValue("result"))) continue;
                    entry.set("entryresult", (Object)"0");
                    continue;
                }
                String goodid = entry.getDynamicObject("goods").getPkValue().toString();
                logString.append("goodid:").append(goodid).append("\n");
                prodList.add(Long.parseLong(goodid));
                if ("1".equals(biztype)) {
                    uploadProdList.add(Long.parseLong(goodid));
                }
                logString.append("goods.number:").append(entry.getDynamicObject("goods").getString("number")).append("\n");
                if (null != classMap && null != classMap.get(goodid)) {
                    entry.set(GOOD_CLASS, classMap.get(goodid));
                    logString.append("class:").append((String)classMap.get(goodid)).append("\n");
                }
                if ("D".equals(this.getModel().getValue("result"))) {
                    entry.set("entryresult", (Object)"0");
                    logString.append("entryresult:").append("0").append("\n");
                }
                if ("B".equals(this.getModel().getValue("result"))) {
                    entry.set("entryresult", (Object)"1");
                    logString.append("entryresult:").append("1").append("\n");
                }
                if (null == entryNoteMap) continue;
                entry.set("note", entryNoteMap.get(entry.getPkValue()));
                logString.append("note:").append((String)entryNoteMap.get(entry.getPkValue())).append("\n");
            }
        }
        log.info(logString.toString());
        QFilter fileter = new QFilter("id", "in", prodList);
        QFilter[] filters = new QFilter[]{fileter};
        DynamicObjectCollection goodObjs = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number", (QFilter[])filters);
        if (goodObjs.size() < 1) {
            view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u5546\u54c1\u3002", (String)"PmmProdAuditcfm_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkHasSameNumber(goodObjs)) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])bills);
        if ("B".equals(this.getModel().getValue("result")) && !uploadBills.isEmpty()) {
            this.updateProdInfo(uploadBills.toArray(new DynamicObject[0]), uploadProdList);
        }
        ProdPoolCommandServiceImpl prodPoolCommandService = new ProdPoolCommandServiceImpl();
        prodPoolCommandService.prodAuditCfm(idList);
        if ("B".equals(this.getModel().getValue("result"))) {
            view.showMessage(ResManager.loadKDString((String)"\u5ba1\u6279\u6210\u529f", (String)"PmmProdAuditcfm_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkHasSameNumber(DynamicObjectCollection goodObjs) {
        Set numbers = goodObjs.stream().map(goodObj -> goodObj.getString("number")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("number", "in", numbers);
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number", (QFilter[])qFilter.toArray());
        HashSet<String> numberAccount = new HashSet<String>(prods.size());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject prod : prods) {
            if (numberAccount.contains(prod.getString("number"))) {
                String message = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5728\u5546\u54c1\u7ba1\u7406\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PmmProdAuditcfm_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                if (MalOrderUtil.getDefaultMalVersion()) {
                    message = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5728\u5546\u54c1\u6c60\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PmmProdAuditcfm_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                }
                sb.append(String.format(message, prod.getString("number")));
                continue;
            }
            numberAccount.add(prod.getString("number"));
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5ba1\u6279\u5931\u8d25", (String)"PmmProdAuditcfm_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRMEND.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.confirm();
        }
    }

    private void updateProdInfo(DynamicObject[] bills, List<Long> prodList) {
        HashMap<Long, Long> prodIdAndCategoryIdMap = new HashMap<Long, Long>();
        HashMap<Long, Long> prodIdAndMaterialIdMap = new HashMap<Long, Long>();
        HashSet<ProdMatMapping> newProdMatMappingSet = new HashSet<ProdMatMapping>();
        HashMap<Long, String> goodsId_BarcodeMap = new HashMap<Long, String>(1024);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject entry : entryEntity) {
                DynamicObject goods = entry.getDynamicObject("goods");
                if (goods == null) continue;
                String barcode = entry.getString("barcode");
                if (!StringUtils.isEmpty((CharSequence)barcode)) {
                    goodsId_BarcodeMap.put(goods.getLong("id"), barcode);
                }
                prodIdAndCategoryIdMap.put(goods.getLong("id"), entry.getDynamicObject(GOOD_CLASS).getLong("id"));
                if (entry.getDynamicObject("material") == null) continue;
                prodIdAndMaterialIdMap.put(goods.getLong("id"), entry.getDynamicObject("material").getLong("id"));
                newProdMatMappingSet.add(new ProdMatMapping(Long.valueOf(goods.getLong("id")), Long.valueOf(entry.getDynamicObject("material").getLong("id"))));
            }
        }
        ProdMatMappingServiceImpl prodMatMappingService = new ProdMatMappingServiceImpl();
        Set prodMatMappings = prodMatMappingService.queryProdsByMatId(prodIdAndCategoryIdMap.keySet());
        newProdMatMappingSet.removeAll(prodMatMappings);
        prodMatMappingService.saveProdMatMapping(newProdMatMappingSet);
        this.updateProdCategory(prodIdAndCategoryIdMap, prodList, prodIdAndMaterialIdMap, goodsId_BarcodeMap);
    }

    private void updateProdCategory(Map<Long, Long> prodIdAndCategoryIdMap, List<Long> prodList, Map<Long, Long> prodIdAndMaterialIdMap, Map<Long, String> goodsId_BarcodeMap) {
        DynamicObject[] goodObjs;
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
        QFilter fileter = new QFilter("id", "in", prodList);
        QFilter[] filters = new QFilter[]{fileter};
        for (DynamicObject prod : goodObjs = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)selectFields, (QFilter[])filters)) {
            Long id = prod.getLong("id");
            prod.set("category", (Object)prodIdAndCategoryIdMap.get(id));
            if (prodIdAndMaterialIdMap.get(id) != null) {
                prod.set("materiel", (Object)prodIdAndMaterialIdMap.get(id));
            }
            if (goodsId_BarcodeMap.get(id) == null) continue;
            prod.set("barcode", (Object)goodsId_BarcodeMap.get(id));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodmanage", (DynamicObject[])goodObjs, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            String errorInfoDetails = ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo());
            throw new KDBizException(errorInfoDetails);
        }
    }
}

