/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.MalOrderUtil;

public class EcadmitEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String TENANTID = "tenantid";
    private static final String PLAYTFORM = "platform";
    private static final String ENTRY_MALLACCOUNT = "mallaccount";
    private static final String ENTRY_MALL_MA = "mallpwd";
    private static final String ENTRY_DATE = "uneffectualdate";
    private static final String ENTRY_TOKEN = "token";
    private static final String ENTRY_COMPANYORG = "companyorg";
    private static final String ENTRY_INVOICEORG = "invoiceorg";
    private static final String MALSUPPLIER = "malsupplier";
    private static final String ISC_DATABASE_LINK = "isc_database_link";
    private static Log log = LogFactory.getLog(EcadmitEdit.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            this.setAccoutEditMustInput();
            this.setKeyEditMustInput();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pl_config"});
        } else {
            this.setMustInput(Parser.toString((Object)this.getModel().getValue(PLAYTFORM)));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"proxy", "saveproxy", "clearproxy"});
        }
    }

    private void setAccoutEditMustInput() {
        FieldEdit accountField = (FieldEdit)this.getView().getControl(ENTRY_MALLACCOUNT);
        accountField.setMustInput(true);
        FieldEdit pwdField = (FieldEdit)this.getView().getControl(ENTRY_MALL_MA);
        pwdField.setMustInput(true);
    }

    private void setKeyEditMustInput() {
        FieldEdit clientIdField = (FieldEdit)this.getView().getControl(CLIENT_ID);
        clientIdField.setMustInput(true);
        FieldEdit secretField = (FieldEdit)this.getView().getControl(CLIENT_SECRET);
        secretField.setMustInput(true);
    }

    private void setMustInput(String platform) {
        FieldEdit invoicetypeField = (FieldEdit)this.getView().getControl("invoicetype");
        invoicetypeField.setMustInput(true);
        FieldEdit malsupplierField = (FieldEdit)this.getView().getControl(MALSUPPLIER);
        malsupplierField.setMustInput(true);
        FieldEdit paytypeField = (FieldEdit)this.getView().getControl("paytype");
        paytypeField.setMustInput(true);
        FieldEdit mesureunitsField = (FieldEdit)this.getView().getControl("mesureunits");
        mesureunitsField.setMustInput(true);
        switch (platform) {
            case "6": {
                this.setAccoutEditMustInput();
                break;
            }
            case "4": 
            case "5": {
                this.setAccoutEditMustInput();
                this.setKeyEditMustInput();
                break;
            }
            case "3": 
            case "8": {
                this.setKeyEditMustInput();
                break;
            }
            case "2": 
            case "7": {
                this.setAccoutEditMustInput();
                this.setKeyEditMustInput();
                FieldEdit invoiceOrgField = (FieldEdit)this.getView().getControl("invoiceorgcode");
                invoiceOrgField.setMustInput(true);
                break;
            }
            case "9": {
                this.setAccoutEditMustInput();
                this.setKeyEditMustInput();
                FieldEdit pwdField = (FieldEdit)this.getView().getControl(ENTRY_MALL_MA);
                pwdField.setMustInput(false);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        IDataModel model = this.getModel();
        if (ENTRY_COMPANYORG.equals(property)) {
            for (ChangeData data : changedData) {
                if (null == data.getNewValue() || data.getNewValue().equals(data.getOldValue())) continue;
                DynamicObject entry = model.getEntryRowEntity(ENTRY_ENTITY, data.getRowIndex());
                entry.set(ENTRY_INVOICEORG, ((DynamicObject)data.getNewValue()).get("name"));
            }
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            return;
        }
        switch (key) {
            case "updatetoken": {
                OperationResult operationResult = this.getView().invokeOperation("save");
                if (operationResult.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u66f4\u65b0\u6210\u529f\u3002", (String)"EcadmitEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"EcadmitEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"saveproxy", (CharSequence)opKey)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u4ee3\u7406\u914d\u7f6e\u6210\u529f\u3002", (String)"EcadmitEdit_10", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)"clearproxy", (CharSequence)opKey)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u4ee3\u7406\u914d\u7f6e\u6210\u529f\u3002", (String)"EcadmitEdit_11", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        final IDataModel model = this.getModel();
        BasedataEdit company = (BasedataEdit)this.getView().getControl(ENTRY_COMPANYORG);
        BasedataEdit invoiceTypeEdit = (BasedataEdit)this.getControl("invoicetype");
        BasedataEdit paytypeEdit = (BasedataEdit)this.getControl("paytype");
        BasedataEdit malSupplier = (BasedataEdit)this.getControl(MALSUPPLIER);
        invoiceTypeEdit.addBeforeF7SelectListener(this::beforeF7Select);
        paytypeEdit.addBeforeF7SelectListener(this::beforeF7Select);
        malSupplier.addBeforeF7SelectListener(this::beforeF7Select);
        company.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent arg0) {
                ListShowParameter formShowParameter = (ListShowParameter)arg0.getFormShowParameter();
                QFilter companyfilter = new QFilter("id", "not in", (Object)EcadmitEdit.this.getExistCompany(model));
                formShowParameter.getListFilterParameter().getQFilters().add(companyfilter);
            }
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        Object emalType = this.getModel().getValue(PLAYTFORM);
        if (name.equals("invoicetype")) {
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("emaltype", "=", (Object)emalType.toString()));
        }
        if (name.equals("paytype")) {
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("entryentity.emalpaytypenumber.emaltype", "=", (Object)emalType.toString()));
            QueryServiceHelper.query((String)"pbd_paytype", (String)"entryentity.emalpaytypenumber", null);
        }
        if (name.equals(MALSUPPLIER)) {
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("mallstatus", "=", (Object)Character.valueOf('B')));
        }
    }

    private ArrayList<Long> getExistCompany(IDataModel model) {
        ArrayList<Long> companyId = new ArrayList<Long>();
        DynamicObjectCollection entries = model.getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            DynamicObject company = entry.getDynamicObject(ENTRY_COMPANYORG);
            if (null == company) continue;
            companyId.add(Long.valueOf(company.getPkValue().toString()));
        }
        return companyId;
    }

    @Deprecated
    public void updateIscDatabaseLink(String platform) {
    }

    @Deprecated
    public void checkBeforeSave(IDataModel model, IFormView view, int entrySize, BeforeDoOperationEventArgs args) {
    }

    @Deprecated
    public void getJDToken(IDataModel model, IFormView view, int entrySize, BeforeDoOperationEventArgs args) {
    }
}

